#include <stdio.h>

#include <avs/avs.h>
#include <avs/field.h>

#include "vinclude.h"
#include "proto.h"

#include "avskhoros.h"

/* *****************************************/
/*  Module Descriptions                    */
/* *****************************************/

int dacorr_desc ()
{
   int in_port, out_port, param;
   extern int dacorr_compute();

   AVSset_module_name("dacorr",MODULE_FILTER);

   AVScreate_input_port("Input File ","field 2D",REQUIRED);
   AVScreate_output_port("Output File","field 2D");
   AVSadd_parameter("points","integer",0,0,0);
   AVSadd_parameter("type","choice","biased","biased,unbiased,FFT",",");
   AVSadd_parameter("math","choice","scalar","scalar,complex",",");
   AVSadd_parameter("direction","choice","down vectors","down vectors,across bands",",");

   AVSset_compute_proc(dacorr_compute);
   return(1);
}

int dconvo_desc ()
{
   int in_port, out_port, param;
   extern int dconvo_compute();

   AVSset_module_name("dconvo",MODULE_FILTER);

   AVScreate_input_port("Input File 1","field 2D",REQUIRED);
   AVScreate_input_port("Input File 2","field 2D",REQUIRED);
   AVScreate_output_port("Output file ","field 2D");
   AVSadd_parameter("type","choice","time domain","time domain,FFT",",");
   AVSadd_parameter("math","choice","scalar","scalar,complex",",");
   AVSadd_parameter("direction","choice","down vectors","down vectors,across bands",",");

   AVSset_compute_proc(dconvo_compute);
   return(1);
}

int dxcorr_desc ()
{
   int in_port, out_port, param;
   extern int dxcorr_compute();

   AVSset_module_name("dxcorr",MODULE_FILTER);

   AVScreate_input_port("Input File 1","field 2D",REQUIRED);
   AVScreate_input_port("Input File 2","field 2D",REQUIRED);
   AVScreate_output_port("Output File ","field 2D");
   AVSadd_parameter("points","integer",0,0,0);
   AVSadd_parameter("type","choice","biased","biased,unbiased,FFT",",");
   AVSadd_parameter("math","choice","scalar","scalar,complex",",");
   AVSadd_parameter("direction","choice","down vectors","down vectors,across bands",",");

   AVSset_compute_proc(dxcorr_compute);
   return(1);
}

/* *****************************************/
/* Module Compute Routines                 */
/* *****************************************/

int dacorr_compute (AVSfield *i1,AVSfield **o1,int param1,char *param2,char *param3,char *param4)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)ldacorr(ki1,AVSchoice_number("math"),AVSchoice_number("type"),param1,AVSchoice_number("direction"));
   ko1=ki1;
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int dconvo_compute (AVSfield *i1,AVSfield *i2,AVSfield **o1,char *param1,char *param2,char *param3)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ki2;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);
   if (i2)
      if ((ki2=(struct xvimage *)field_to_viff(i2))==NULL) return(0);

   value=(int)ldconvo(ki1,ki2,AVSchoice_number("math"),AVSchoice_number("type"),AVSchoice_number("direction"));
   ko1=ki1;
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int dxcorr_compute (AVSfield *i1,AVSfield *i2,AVSfield **o1,int param1,char *param2,char *param3,char *param4)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ki2;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);
   if (i2)
      if ((ki2=(struct xvimage *)field_to_viff(i2))==NULL) return(0);

   value=(int)ldxcorr(ki1,ki2,AVSchoice_number("math"),AVSchoice_number("type"),param1,AVSchoice_number("direction"));
   ko1=ki1;
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
int ((*mod_list[])()) = {
   dacorr_desc,
   dconvo_desc,
   dxcorr_desc,
};

#define NMODS (sizeof(mod_list) / sizeof(char *))

AVSinit_modules()
{
        AVSinit_from_module_list(mod_list, NMODS);
}

