#include <stdio.h>

#include <avs/avs.h>
#include <avs/field.h>

#include "vinclude.h"
#include "proto.h"

#include "avskhoros.h"

/* *****************************************/
/*  Module Descriptions                    */
/* *****************************************/

int vdith45_desc ()
{
   int in_port, out_port, param;
   extern int vdith45_compute();

   AVSset_module_name("vdith45",MODULE_FILTER);

   AVScreate_input_port("Input Image ","field 2D",REQUIRED);
   AVScreate_output_port("Output Image","field 2D");

   AVSset_compute_proc(vdith45_compute);
   return(1);
}

int vdither_desc ()
{
   int in_port, out_port, param;
   extern int vdither_compute();

   AVSset_module_name("vdither",MODULE_FILTER);

   AVScreate_input_port("Input Image ","field 2D",REQUIRED);
   AVScreate_output_port("Output Image","field 2D");
   AVSadd_parameter("Dither Matrix","choice","Star","Star,Box",",");

   AVSset_compute_proc(vdither_compute);
   return(1);
}

int verrdif_desc ()
{
   int in_port, out_port, param;
   extern int verrdif_compute();

   AVSset_module_name("verrdif",MODULE_FILTER);

   AVScreate_input_port("Input Image ","field 2D",REQUIRED);
   AVScreate_output_port("Output Image","field 2D");

   AVSset_compute_proc(verrdif_compute);
   return(1);
}

/* *****************************************/
/* Module Compute Routines                 */
/* *****************************************/

int vdith45_compute (AVSfield *i1,AVSfield **o1)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
   char *program="vdith45";
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   (void) proper_num_images(program,ki1,1,TRUE); 
   (void) proper_num_bands(program,ki1,1,TRUE); 
   (void) propertype(program,ki1,VFF_TYP_1_BYTE,TRUE); 
   (void) proper_map_enable(program,ki1,VFF_MAP_OPTIONAL,TRUE);

   value=(int)lvdith45(ki1);
 
   ko1=ki1;

   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int vdither_compute (AVSfield *i1,AVSfield **o1,int param1)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)lvdither(ki1,AVSchoice_number("Dither Matrix"));
 
   ko1=ki1;

   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int verrdif_compute (AVSfield *i1,AVSfield **o1)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)lverrdif(ki1);
 
   ko1=ki1;

   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
int ((*mod_list[])()) = {
   vdith45_desc,
   vdither_desc,
   verrdif_desc,
};

#define NMODS (sizeof(mod_list) / sizeof(char *))

AVSinit_modules()
{
        AVSinit_from_module_list(mod_list, NMODS);
}

