

#include <avs/avs.h>
#include <avs/field.h>

#include "vinclude.h"
#include "proto.h"
#include "avskhoros.h"

/* *****************************************/
/*  Module Descriptions                    */
/* *****************************************/

int darpsd_desc ()
{
   int in_port, out_port, param;
   extern int darpsd_compute();

   AVSset_module_name("darpsd",MODULE_FILTER);

   AVScreate_input_port("Input File  ","field 2D",REQUIRED);
   AVScreate_output_port("Output File ","field 2D");
   AVSadd_parameter("num points","integer",1,1,512);
   AVSadd_parameter("coef","choice","TAPPED","TAPPED,LATTICE",",");
   AVSadd_parameter("spectra","choice","PHASE","PHASE,PSD",",");
   AVSadd_parameter("norm","choice","normalize","no normalize,normalize",",");
   AVSadd_parameter("direction","choice","down vectors","down vectors,across bands",",");

   AVSset_compute_proc(darpsd_compute);
   return(1);
}

int dminorm_desc ()
{
   int in_port, out_port, param;
   extern int dminorm_compute();

   AVSset_module_name("dminorm",MODULE_FILTER);

   AVScreate_input_port("Input File  ","field 2D",REQUIRED);
   AVScreate_output_port("Output File ","field 2D");
   AVSadd_parameter("model order","integer",1,1,512);
   AVSadd_parameter("spectral values","integer",1,1,512);
   AVSadd_parameter("autocorrelation","choice","biased estimate","biased estimate,unbiased est,FFT estimate",",");
   AVSadd_parameter("criterion","choice","AIC","AIC,MDL",",");
   AVSadd_parameter("noise dim","integer",1,1,512);
   AVSadd_parameter("PSD","choice","not centered","not centered,centered",",");
   AVSadd_parameter("complex","choice","scalar","scalar,complex",",");
   AVSadd_parameter("direction","choice","down vectors","down vectors,across bands",",");

   AVSset_compute_proc(dminorm_compute);
   return(1);
}

int dmusic_desc ()
{
   int in_port, out_port, param;
   extern int dmusic_compute();

   AVSset_module_name("dmusic",MODULE_FILTER);

   AVScreate_input_port("Input File  ","field 2D",REQUIRED);
   AVScreate_output_port("Output File ","field 2D");
   AVSadd_parameter("model order","integer",1,1,512);
   AVSadd_parameter("spectral values","integer",1,1,512);
   AVSadd_parameter("autocorrelation","choice","biased estimate","biased estimate,unbiased est,FFT estimate",",");
   AVSadd_parameter("criterion","choice","AIC","AIC,MDL",",");
   AVSadd_parameter("noise dim","integer",1,1,512);
   AVSadd_parameter("PSD","choice","not centered","not centered,centered",",");
   AVSadd_parameter("math","choice","scalar","scalar,vector",",");
   AVSadd_parameter("direction","choice","down vectors","down vectors,across bands",",");

   AVSset_compute_proc(dmusic_compute);
   return(1);
}

/* *****************************************/
/* Module Compute Routines                 */
/* *****************************************/

int darpsd_compute (AVSfield *i1,AVSfield **o1,int param1,char *param2,char *param3,char *param4,char *param5)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)ldarpsd(ki1,param1,AVSchoice_number("coef"),AVSchoice_number("spectra"),AVSchoice_number("norm"),AVSchoice_number("direction"));
   ko1=ki1;
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int dminorm_compute (AVSfield *i1,AVSfield **o1,int param1,int param2,char *param3,char *param4,int param5,char *param6,char *param7,char *param8)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

/* NB!! char *param4 not used at present !! */
 
   value=(int)ldminorm(ki1,param1,param2,param5,AVSchoice_number("autocorrelation"),AVSchoice_number("complex"),AVSchoice_number("PSD"),AVSchoice_number("direction"));
   ko1=ki1;
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int dmusic_compute (AVSfield *i1,AVSfield **o1,int param1,int param2,char *param3,char *param4,int param5,char *param6,char *param7,char *param8)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;

   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

/* NB!! char *param4 not used at present !! */


   value=(int)ldmusic(ki1,param1,param2,param5,AVSchoice_number("autocorrelation"),AVSchoice_number("math"),AVSchoice_number("PSD"),AVSchoice_number("direction"));

   ko1=ki1;

   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
int ((*mod_list[])()) = {
   darpsd_desc,
   dminorm_desc,
   dmusic_desc,
};

#define NMODS (sizeof(mod_list) / sizeof(char *))

AVSinit_modules()
{
        AVSinit_from_module_list(mod_list, NMODS);
}

