#include <stdio.h>

#include <avs/avs.h>
#include <avs/field.h>

#include "vinclude.h"

#include "proto.h"

#include "avskhoros.h"

/* *****************************************/
/*  Module Descriptions                    */
/* *****************************************/

int vextcent_desc ()
{
   int in_port, out_port, param;
   extern int vextcent_compute();

   AVSset_module_name("vextcent",MODULE_FILTER);

   AVScreate_input_port("Input Image    ","field 2D",REQUIRED);
   AVScreate_output_port("Output Subimage","field 2D");
   AVSadd_parameter("subimage wdth","integer",1,1,512);
   AVSadd_parameter("subimage ht","integer",1,1,512);
   AVSadd_parameter("sub x offset","integer",1,1,512);
   AVSadd_parameter("sub y offset","integer",1,1,512);
   AVSadd_parameter("copy map","choice","copy","no copy",",");

   AVSset_compute_proc(vextcent_compute);
   return(1);
}

int vextract_desc ()
{
   int in_port, out_port, param;
   extern int vextract_compute();

   AVSset_module_name("vextract",MODULE_FILTER);

   AVScreate_input_port("Input Image    ","field 2D",REQUIRED);
   AVScreate_output_port("Output Subimage","field 2D");
/* at present, i see no use of this port in library call! */
   AVScreate_input_port("Input Coordinate Image","field 2D",OPTIONAL);
/* srm 92.9.20 */
   AVSadd_parameter("upper left x","integer",1,1,512);
   AVSadd_parameter("upper left y","integer",1,1,512);
   AVSadd_parameter("subimage wdth","integer",1,1,512);
   AVSadd_parameter("subimage ht","integer",1,1,512);
   AVSadd_parameter("copy map","choice","copy","no copy",",");

   AVSset_compute_proc(vextract_compute);
   return(1);
}

int vinsert_desc ()
{
   int in_port, out_port, param;
   extern int vinsert_compute();

   AVSset_module_name("vinsert",MODULE_FILTER);

   AVScreate_input_port("Input Image   ","field 2D",REQUIRED);
   AVScreate_input_port("Input Subimage","field 2D",REQUIRED);
   AVScreate_output_port("Output Image  ","field 2D");
   AVSadd_parameter("upper left x","integer",1,1,512);
   AVSadd_parameter("upper left y","integer",1,1,512);
   AVSadd_float_parameter("real pad",0.00,FLOAT_UNBOUND,FLOAT_UNBOUND);
   AVSadd_float_parameter("imaginary pad",0.00,FLOAT_UNBOUND,FLOAT_UNBOUND);

   AVSset_compute_proc(vinsert_compute);
   return(1);
}

int vpad_desc ()
{
   int in_port, out_port, param;
   extern int vpad_compute();

   AVSset_module_name("vpad",MODULE_FILTER);

   AVScreate_input_port("Input file ","field 2D",REQUIRED);
   AVScreate_output_port("Output file","field 2D");
   AVSadd_parameter("row size","integer",1,1,512);
   AVSadd_parameter("column size","integer",1,1,512);
   AVSadd_parameter("row offset","integer",1,1,512);
   AVSadd_parameter("column offset","integer",1,1,512);
   AVSadd_float_parameter("real pad",0.0,FLOAT_UNBOUND,FLOAT_UNBOUND);
   AVSadd_float_parameter("imaginary pad",0.0,FLOAT_UNBOUND,FLOAT_UNBOUND);
   AVSadd_parameter("data type","choice","char","short","int","float","complex","double","dcomplex",",");
   AVSadd_parameter("bands","integer",1,1,512);

   AVSset_compute_proc(vpad_compute);
   return(1);
}

int vsamp_desc ()
{
   int in_port, out_port, param;
   extern int vsamp_compute();

   AVSset_module_name("vsamp",MODULE_FILTER);

   AVScreate_input_port("Input image ","field 2D",REQUIRED);
   AVScreate_output_port("Output image","field 2D");
   AVSadd_parameter("start x","integer",1,1,512);
   AVSadd_parameter("end x","integer",1,1,512);
   AVSadd_parameter("start y","integer",1,1,512);
   AVSadd_parameter("end y","integer",1,1,512);
   AVSadd_parameter("num samples","integer",1,1,512);

   AVSset_compute_proc(vsamp_compute);
   return(1);
}

/* *****************************************/
/* Module Compute Routines                 */
/* *****************************************/

int vextcent_compute (AVSfield *i1,AVSfield **o1,int param1,int param2,int param3,int param4,char *param5)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)lvextract(ki1,ko1,param1,param2,param3,param4,AVSchoice_number("copy map"));
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int vextract_compute (AVSfield *i1,AVSfield *i2,AVSfield **o1,int param1,int param2,int param3,int param4,char *param5)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
   struct xvimage *ki2;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);
   if (i2)
      if ((ki2=(struct xvimage *)field_to_viff(i2))==NULL) return(0);

   value=(int)lvextract(ki1,ko1,param1,param2,param3,param4,AVSchoice_number("copy map"));
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int vinsert_compute (AVSfield *i1,AVSfield *i2,AVSfield **o1,int param1,int param2,float *param3,float *param4)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ki2;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);
   if (i2)
      if ((ki2=(struct xvimage *)field_to_viff(i2))==NULL) return(0);

   value=(int)lvinsert(ki1,ki2,param1,param2,*param3,*param4);
   ko1=ki1;
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int vpad_compute (AVSfield *i1,AVSfield **o1,int param1,int param2,int param3,int param4,float *param5,float *param6,char *param7,int param8)
{
   int value;
   struct xvimage *ki1;
   struct xvimage **ktmp;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

/* Unsure to this series of calls. Requires some **xvimage for intermediate?? */

   value=(int)lvgconst(ktmp,param1,param2,AVSchoice_number("data type"),*param5,*param6,param8);
   value=(int)lvinsert(ki1,*ktmp,param3,param4,*param5,*param6);
   ko1=ki1;
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int vsamp_compute (AVSfield *i1,AVSfield **o1,int param1,int param2,int param3,int param4,int param5)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)lvsamp(ki1,&ko1,param1,param2,param3,param4,param5);
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
int ((*mod_list[])()) = {
   vextcent_desc,
   vextract_desc,
   vinsert_desc,
   vpad_desc,
   vsamp_desc,
};

#define NMODS (sizeof(mod_list) / sizeof(char *))

AVSinit_modules()
{
        AVSinit_from_module_list(mod_list, NMODS);
}

