#include <stdio.h>

#include <avs/avs.h>
#include <avs/field.h>

#include "vinclude.h"

#include "proto.h"

#include "avskhoros.h"

/* *****************************************/
/*  Module Descriptions                    */
/* *****************************************/

int vcost_desc ()
{
   int in_port, out_port, param;
   extern int vcost_compute();

   AVSset_module_name("vcost",MODULE_FILTER);

   AVScreate_input_port("Input Image    ","field 2D",REQUIRED);
   AVScreate_input_port("Mask Image  ","field 2D",OPTIONAL);
   AVScreate_output_port("Output Image   ","field 2D");
   AVSadd_parameter("X reference","integer",0,INT_UNBOUND,INT_UNBOUND);
   AVSadd_parameter("Y reference","integer",0,INT_UNBOUND,INT_UNBOUND);

   AVSset_compute_proc(vcost_compute);
   return(1);
}

int vdetilt_desc ()
{
   int in_port, out_port, param;
   extern int vdetilt_compute();

   AVSset_module_name("vdetilt",MODULE_FILTER);

   AVScreate_input_port("Input Image   ","field 2D",REQUIRED);
   AVScreate_output_port("Output Image  ","field 2D");
   AVScreate_input_port("Masking Image ","field 2D",OPTIONAL);
   AVSadd_parameter("Remove Mean","remove mean","remove mean,keep mean",",");

   AVSset_compute_proc(vdetilt_compute);
   return(1);
}

int vgettilt_desc ()
{
   int in_port, out_port, param;
   extern int vgettilt_compute();

   AVSset_module_name("vgettilt",MODULE_FILTER);

   AVScreate_input_port("Input Image     ","field 2D",REQUIRED);
   AVScreate_input_port("Masking Image","field 2D",OPTIONAL);

   param=AVSadd_parameter("a","string",NULL,NULL,NULL);
   AVSconnect_widget(param,"string_block");
   param=AVSadd_parameter("b","string",NULL,NULL,NULL);
   AVSconnect_widget(param,"string_block");
   param=AVSadd_parameter("c","string",NULL,NULL,NULL);
   AVSconnect_widget(param,"string_block");

   AVSset_compute_proc(vgettilt_compute);
   return(1);
}

/* XVROUTINE - REQUIRES CO-ROUTINE IMPLEMENTATION */
/*
int viewimage_desc ()
{
   int in_port, out_port, param;
   extern int viewimage_compute();

   AVSset_module_name("Viewimage",MODULE_FILTER);

   AVScreate_input_port("Input Image       ","field 2D",REQUIRED);
   AVScreate_input_port("Elevation Image","field 2D",OPTIONAL);
   AVScreate_input_port("Colormap Image ","field 2D",OPTIONAL);
   AVSadd_parameter("x upper-left","integer",0,INT_UNBOUND,INT_UNBOUND);
   AVSadd_parameter("y upper-left","integer",0,INT_UNBOUND,INT_UNBOUND);
   AVSadd_float_parameter("init update time",2.000000,FLOAT_UNBOUND,FLOAT_UNBOUND);
   AVSadd_parameter("colormap","choice","use colormap","use colormap|dont use",",");
   AVSadd_parameter("plotting","choice","proportional","not proportional|proportional","|");
   AVSadd_parameter("DISPLAY","string","unix:0",NULL,NULL);

   AVSset_compute_proc(viewimage_compute);
   return(1);
}
*/

int vslope_desc ()
{
   int in_port, out_port, param;
   extern int vslope_compute();

   AVSset_module_name("vslope",MODULE_FILTER);

   AVScreate_input_port("Input Image ","field 2D",REQUIRED);
   AVScreate_output_port("Slope Image ","field 2D");
   AVScreate_output_port("Aspect Image","field 2D");
   AVSadd_parameter("slope options","choice","degrees","degrees,radians,percent rise",",");
   AVSadd_parameter("aspect options","choice","degrees","degrees,radians,quadrants",",");
   AVSadd_float_parameter("flat value",0.000000,FLOAT_UNBOUND,FLOAT_UNBOUND);

   AVSset_compute_proc(vslope_compute);
   return(1);
}

int vsurf_desc ()
{
   int in_port, out_port, param;
   extern int vsurf_compute();

   AVSset_module_name("vsurf",MODULE_FILTER);

   AVScreate_input_port("Input Image","field 2D",REQUIRED);
   AVScreate_output_port("Normals Image","field 2D");
   AVScreate_output_port("Angles Image ","field 2D");

   AVSset_compute_proc(vsurf_compute);
   return(1);
}

int vtilt_desc ()
{
   int in_port, out_port, param;
   extern int vtilt_compute();

   AVSset_module_name("vtilt",MODULE_FILTER);

   AVScreate_input_port("Input Image   ","field 2D",REQUIRED);
   AVScreate_output_port("Output Image  ","field 2D");
   AVScreate_input_port("Masking Image ","field 2D",OPTIONAL);
   AVSadd_float_parameter("X slope",0.000000,FLOAT_UNBOUND,FLOAT_UNBOUND);
   AVSadd_float_parameter("Y slope",0.000000,FLOAT_UNBOUND,FLOAT_UNBOUND);

   AVSset_compute_proc(vtilt_compute);
   return(1);
}

/* *****************************************/
/* Module Compute Routines                 */
/* *****************************************/

int vcost_compute (AVSfield *i1,AVSfield *i2,AVSfield **o1,int param1,int param2)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ki2;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);
   if (i2)
      if ((ki2=(struct xvimage *)field_to_viff(i2))==NULL) return(0);

   value=(int)lvcost(ki1,ki2,param1,param2);
 
   ko1=ki1;

   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int vdetilt_compute (AVSfield *i1,AVSfield *i2,AVSfield **o1,char *param1)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
   struct xvimage *ki2;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);
   if (i2)
      if ((ki2=(struct xvimage *)field_to_viff(i2))==NULL) return(0);

   value=(int)lvdetilt(ki1,ki2,MAP(ki2),AVSchoice_number("Remove Mean"));
 
   ko1=ki1;

   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
int vgettilt_compute (AVSfield *i1,AVSfield *i2,char *param1,char *param2,char *param3)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
   struct xvimage *ki2;
   double a,b,c;
   char string[15];

   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);
   if (i2)
      if ((ki2=(struct xvimage *)field_to_viff(i2))==NULL) return(0);

   value=(int)lvgettilt(ki1,ki2,MAP(ki2),&a,&b,&c);
 
   sprintf(string,"%f",(float)a);
   AVSmodify_parameter("a",AVS_VALUE,string,NULL,NULL);
   sprintf(string,"%f",(float)b);
   AVSmodify_parameter("b",AVS_VALUE,string,NULL,NULL);
   sprintf(string,"%f",(float)c);
   AVSmodify_parameter("c",AVS_VALUE,string,NULL,NULL);
 
   return (value);
}
 
/*
int viewimage_compute (AVSfield *i1,AVSfield *i2,AVSfield *i3,int param1,int param2,float *param3,int param4,int param5)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ki2;
   struct xvimage *ki3;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);
   if (i2)
      if ((ki2=(struct xvimage *)field_to_viff(i2))==NULL) return(0);
   if (i3)
      if ((ki3=(struct xvimage *)field_to_viff(i3))==NULL) return(0);

   value=(int)lviewimage(ki1,ki2,ki3,param1,param2,param3,param4,param5);
 
   return (value);
}
*/
 
int vslope_compute (AVSfield *i1,AVSfield **o1,AVSfield **o2,char *param1,char *param2,float *param3)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
   struct xvimage *ko2;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)lvslope(ki1,1,AVSchoice_number("slope options"),1,
			AVSchoice_number("aspect options"),*param3,&ko1,&ko2);
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
   if (((*o2)=(AVSfield *)viff_to_field(ko2))==NULL) return (0);
 
   return (value);
}
 
int vsurf_compute (AVSfield *i1,AVSfield **o1,AVSfield **o2)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
   struct xvimage *ko2;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)lvsurf(ki1,&ko1,&ko2);
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
   if (((*o2)=(AVSfield *)viff_to_field(ko2))==NULL) return (0);
 
   return (value);
}
 
int vtilt_compute (AVSfield *i1,AVSfield *i2,AVSfield **o1,float *param1,float *param2)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
   struct xvimage *ki2;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);
   if (i2)
      if ((ki2=(struct xvimage *)field_to_viff(i2))==NULL) return(0);

   value=(int)lvtilt(ki1,ki2,MAP(ki2),*param1,*param2);
 
   ko1=ki1;

   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
int ((*mod_list[])()) = {
   vcost_desc,
   vdetilt_desc,
   vgettilt_desc,
/*
   viewimage_desc,
*/
   vslope_desc,
   vsurf_desc,
   vtilt_desc,
};

#define NMODS (sizeof(mod_list) / sizeof(char *))

AVSinit_modules()
{
        AVSinit_from_module_list(mod_list, NMODS);
}

