#include <stdio.h>

#include <avs/avs.h>
#include <avs/field.h>

#include "vinclude.h"

#include "proto.h"

#include "avskhoros.h"

/* *****************************************/
/*  Module Descriptions                    */
/* *****************************************/

/* ONLY WORKS WITH BIT IMAGES */
/*
int vlayer_desc ()
{
   int in_port, out_port, param;
   extern int vlayer_compute();

   AVSset_module_name("Vlayer",MODULE_FILTER);

   AVScreate_input_port("Input Image ","field 2D",REQUIRED);
   AVScreate_output_port("Output Image","field 2D");

   AVSset_compute_proc(vlayer_compute);
   return(1);
}
*/

int vmapdlg_desc ()
{
   int in_port, out_port, param;
   extern int vmapdlg_compute();

   AVSset_module_name("vmapdlg",MODULE_FILTER);

   AVScreate_input_port("Input Image ","field 2D",REQUIRED);
   AVScreate_output_port("Output Image","field 2D");

   AVSset_compute_proc(vmapdlg_compute);
   return(1);
}

/* *****************************************/
/* Module Compute Routines                 */
/* *****************************************/

/*
int vlayer_compute (AVSfield *i1,AVSfield **o1)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)lvlayer(ki1,ko1);
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
*/
 
int vmapdlg_compute (AVSfield *i1,AVSfield **o1)
{
   int value;
   struct xvimage *ki1;
   struct xvimage *ko1;
 
   if (i1)
      if ((ki1=(struct xvimage *)field_to_viff(i1))==NULL) return(0);

   value=(int)lvmapdlg(&ki1);

   ko1=ki1;
 
   if (((*o1)=(AVSfield *)viff_to_field(ko1))==NULL) return (0);
 
   return (value);
}
 
/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
int ((*mod_list[])()) = {
/*
   vlayer_desc,
*/
   vmapdlg_desc,
};

#define NMODS (sizeof(mod_list) / sizeof(char *))

AVSinit_modules()
{
        AVSinit_from_module_list(mod_list, NMODS);
}

