/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/* mod_gen Version 1                                                     */
/* Module Name: "Field Math" (Filter) (Coroutine)                        */
/* Author: Krzysztof Nowinski                                            */
/* Date Created: Mon Aug 16 12:47:22 1993                                */
#include <string.h>
#include <stdio.h>
#include <avs/avs.h>
#include <avs/port.h>
#include <avs/field.h>
#include <avs/avs_math.h>

#include "field_math.h" 
#include "y.tab.h"


extern long   	ndimens, count, skip[], rowlen[];   
extern float  *row, *rrow;                               

extern ptitem push_constant();
extern ptitem push_new_var();
extern ptitem pop_exe_stack();
extern ptitem named_item();
extern void free_item();
extern void clear_all();

extern double   cos(/* double x */);	/* IAC CODE ADDITION */
extern double   exp(/* double x */);	/* IAC CODE ADDITION */
extern double   log10(/* double x */);	/* IAC CODE ADDITION */
extern double   log(/* double x */);	/* IAC CODE ADDITION */
extern double   sin(/* double x */);	/* IAC CODE ADDITION */
extern double   sqrt(/* double x */);	/* IAC CODE ADDITION */
extern double   tan(/* double x */);	/* IAC CODE ADDITION */
extern double   atan(/* double x */);	/* IAC CODE ADDITION */
extern double   fabs(/* double x */);	/* IAC CODE ADDITION */



double minus(arg)
float arg;
{
return (-((double)arg));
}

double sqr(arg)
float arg;
{
return ((double)arg*arg);
}
/*
double abs(arg)
float arg;
{
return ((double)(arg<0?-arg:arg));
}
*/
float field_max(arg_item)
ptitem arg_item;
{
int index;
float t,u;
float *arg;
u = -1e10;
switch (arg_item->type)
	{
    case VAR:
        arg = arg_item->content.ptr;
        for (index=0;index<count;index++,arg+=arg_item->mult)
          if (u<*arg) u=(*arg);
	return (u);
    case MODVAR:
        arg = arg_item->content.ptr;
        for (index=0;index<count;index++)
	  {
	  t=*(arg+(index/(arg_item->mult))%(arg_item->modulo));
	  if (u<t) u=t;
	  }
	return(u);
    case CONST:
	return(arg_item->content.val);
	}
}

float field_min(arg_item)
ptitem arg_item;
{
int index;
float t,u;
float *arg;
u = 1e10;
switch (arg_item->type)
	{
    case VAR:
        arg = arg_item->content.ptr;
        for (index=0;index<count;index++,arg+=arg_item->mult)
          if (u>*arg) u=(*arg);
	return (u);
    case MODVAR:
        arg = arg_item->content.ptr;
        for (index=0;index<count;index++)
	  {
	  t=*(arg+(index/(arg_item->mult))%(arg_item->modulo));
	  if (u>t) u=t;
	  }
	return(u);
    case CONST:
	return(arg_item->content.val);
	}
}

float field_avg(arg_item)
ptitem arg_item;
{
int index;
float t,u;
float *arg;

u=0.;
switch (arg_item->type)
	{
    case VAR:
        arg = arg_item->content.ptr;
        for (index=0;index<count;index++,arg+=arg_item->mult)
          u+=(*arg);
	return (u/count);
    case MODVAR:
        arg = arg_item->content.ptr;
        for (index=0;index<count;index++)
	  {
	  u+=(*(arg+(index/(arg_item->mult))%(arg_item->modulo)));
	  }
	return(u/count);
    case CONST:
	return(arg_item->content.val);
	}
}



int fold_unary(op,result_name)
char *op;
char *result_name;
{
float (*oper)();
ptitem arg_item;
ptitem result;
float *arg, *res, fres;
long  index ;

  if( strcmp( op, "FMAX" ) == 0 )
    oper = field_max ;
  else if( strcmp( op, "FMIN" ) == 0 )
    oper = field_min ;
  else if( strcmp( op, "AVG" ) == 0 )
    oper = field_avg ;
  else
    return( 0 ) ;

  arg_item = pop_exe_stack();
    fres = oper(arg_item);

    if (result_name==NULL)
        result = push_constant(&fres);
    else
	{
	result=named_item(result_name,CONST);
	result->used=NEWNAMED;
	if ((result->type) == CONST)
	    result->content.val=fres;
	else
	    {
            res = result->content.ptr;
            for (index=0;index<count;index++,res+=result->mult)
	        *res=fres;
	    }
	}
    free_item(arg_item);
}

double drandom()
{
return ((double)random()/(double)439804651104.);
}

int noarg(op,result_name)
char *op;
char *result_name;
{
double (*oper)();
ptitem result;
float *res, fres;
long  index ;

  if( strcmp( op, "RND" ) == 0 )
    oper = drandom ;
  else
    return( 0 ) ;


    if (result_name==NULL)
        result = push_new_var();
    else
	{
	result=named_item(result_name,CONST);
	result->used=NEWNAMED;
 	}
    if ((result->type) == CONST)
	result->content.val=oper();
    else
	{
        res = result->content.ptr;
        for (index=0;index<count;index++,res+=result->mult)
	        *res=oper();
	}
}

int unary(op,result_name)
char *op;
char *result_name;
{
double (*oper)();
ptitem arg_item;
ptitem result;
float *arg, *res, fres;
long  index ;

  if( strcmp( op, "m" ) == 0 )
    oper = minus ;
  else if( strcmp( op, "COS" ) == 0 )
    oper = cos ;
  else if( strcmp( op, "EXP" ) == 0 )
    oper = exp ;
  else if( strcmp( op, "LOG" ) == 0 )
    oper = log10 ;
  else if( strcmp( op, "LN" ) == 0 )
    oper = log ;
  else if( strcmp( op, "SIN" ) == 0 )
    oper = sin ;
  else if( strcmp( op, "SQRT" ) == 0 )
    oper = sqrt ;
  else if( strcmp( op, "SQR" ) == 0 )
    oper = sqr ;
  else if( strcmp( op, "TAN" ) == 0 )
    oper = tan ;
  else if( strcmp( op, "ATAN" ) == 0 )
    oper = atan ;
  else if( strcmp( op, "ABS" ) == 0 )
    oper = fabs ;
  else if( strcmp( op, "DIF" ) == 0 )
    return (dif(result_name)) ;
  else if( strcmp( op, "CNV" ) == 0 )
    return (convolution(result_name)) ;
  else if( strcmp( op, "PMAX" ) == 0 )
    return (binary('%',result_name)) ;
  else if( strcmp( op, "PMIN" ) == 0 )
    return (binary('@',result_name)) ;
  else
    return( 0 ) ;
  arg_item = pop_exe_stack();
  if ((arg_item->type) == CONST)
    {
    fres = oper((double)(arg_item->content.val));
    if (result_name==NULL)
        result = push_constant(&fres);
    else
	{
	result=named_item(result_name,CONST);
	result->used=NEWNAMED;
	if ((result->type) == CONST)
	    result->content.val=fres;
	else
	    {
            res = result->content.ptr;
            for (index=0;index<count;index++,res+=result->mult)
	        *res=fres;
	    }
	}
    }
  else
    {
    if (result_name==NULL)
       result = push_new_var();
    else
	{	
        result=named_item(result_name,VAR);
        if (result==NULL) return (0);
        result->used=NEWNAMED;
	}

    arg = arg_item->content.ptr;
    res = result->content.ptr;

    if ((arg_item->type) == VAR)
        for (index=0;index<count;index++,res+=result->mult,arg+=arg_item->mult)
          *res = oper((double)*arg);
    else
        for (index=0;index<count;index++,res+=result->mult)
          *res = oper((double)*(arg+(index/(arg_item->mult))%(arg_item->modulo)));
    }
    free_item(arg_item);
    return( 1 ) ;
}


int dif(result_name)
char *result_name;
{
ptitem result;
ptitem oper1;
ptitem oper2;
ptitem res_item;
float *op1, *res;
int i, i1, j, j1, m1,m,s1,s,mr,varno;

  oper2 = pop_exe_stack();
  if ((oper2->type)==CONST)
    {
    varno = (oper2->content.val)+0;
    if ((varno<0)||(varno>=ndimens))
    	{
    	AVSerror("Variable number must be positive and < %d", ndimens);
    	clear_all();
    	return(0);
    	}
    }
  else
    {
    AVSerror("Variable number must be constant");
    clear_all();
    return(0);
    }
  oper1 = pop_exe_stack();
  if ((oper1->type)==CONST)
    {
    AVSerror("Why differentiate constant?");
    clear_all();
    return(0);
    }
  
  if ((oper1->type)==MODVAR)
    {
    AVSerror("Differentiation of index type vars not implemented yet");
    clear_all();
    return(0);
    }
  
    
  op1 = oper1->content.ptr;
  s1 = oper1->mult;
  m1 = oper1->modulo;
    
  if (result_name==NULL)
       result = push_new_var();
  else
	{
       	result=named_item(result_name,VAR);
       	result->used=NEWNAMED;
	}
  if (result==NULL) return (0);

  res = result->content.ptr;
  mr  = result->mult;
  for (i=0;i<count;i+=skip[varno+1])
     for (i1=0;i1<skip[varno];i1++)
	{
	for (j=0,j1=i+i1;j<rowlen[varno];j++,j1+=skip[varno])
	    row[j]=*(op1+s1*j1);
/* printf ("%d %d\n",i,i1);*/
	rrow[0]=row[1]-row[0];
	rrow[rowlen[varno]-1]=row[rowlen[varno]-1]-row[rowlen[varno]-2];
	for (j=1;j<rowlen[varno]-1;j++)
	    rrow[j]=0.5*(row[j+1]-row[j-1]);
	for (j=0,j1=i+i1;j<rowlen[varno];j++,j1+=skip[varno])
	    *(res+mr*j1)=rrow[j];
  	}

    free_item(oper1);free_item(oper2);
    return (1);

}

/* Binary math function */
int binary( op ,result_name)
char op;
char *result_name;
{
ptitem result;
ptitem oper1;
ptitem oper2;
ptitem res_item;
float *op1, *op2, fres, *res;
int i, m1,m2,s1,s2,mr;
char ope[2];
ope[0] = ope[1] = '\0';
  ope[0]=op;

  oper2 = pop_exe_stack();
  if ((oper2->type)==CONST)
    {
    op2 = &(oper2->content.val);
    s2=0;
    }
  else
    {
    op2 = oper2->content.ptr;
    s2 = oper2->mult;
    m2 = oper2->modulo;
    }
  oper1 = pop_exe_stack();
  if ((oper1->type)==CONST)
    {
    op1 = &(oper1->content.val);
    s1=0;
    }
  else
    {
    op1 = oper1->content.ptr;
    s1 = oper1->mult;
    m1 = oper1->modulo;
    }

  if (((oper1->type)==CONST)&&((oper2->type)==CONST))
    {
    switch( op )
      {

      case '+' :        /* Addition */

        fres = *op1 + *op2 ;
        break ;

      case '-' :        /* Subtraction */

        fres = *op1 - *op2 ;
        break ;

      case '*' :        /* Multiplication */

        fres = *op1 * *op2 ;
        break ;

      case '/' :        /* Division */

        fres = *op1 / *op2 ;
        break ;

      case '^' :        /* Raise to a power */

        fres = pow( *op1, *op2 ) ;
        break ;

      case '%' :        /* Division */

        fres = ((*op1)<(*op2)?(*op2):(*op1)) ;
        break ;

      case '@' :        /* Division */

        fres =  ((*op1)>(*op2)?(*op2):(*op1));
        break ;

      default :
        free_item(oper1);free_item(oper2);

        return( 0 ) ;

      } /* End of switch( op ) */

    if (result_name==NULL)
        result = push_constant(&fres);
    else
	{
	result=named_item(result_name,CONST);
        result->used=NEWNAMED;
	if ((result->type) == CONST)
	    result->content.val=fres;
	else
	    {
            res = result->content.ptr;
            for (i=0;i<count;i++,res+=result->mult)
	        *res=fres;
	    }
	}

    free_item(oper1);free_item(oper2);
    return (1);
    }

    if (result_name==NULL)
       result = push_new_var();
    else
	{
       	result=named_item(result_name,VAR);
       	result->used=NEWNAMED;
	}
    if (result==NULL) return (0);

    res = result->content.ptr;
    mr  = result->mult;

    if (((oper1->type)!=MODVAR)&&((oper2->type)!=MODVAR))
    {
    switch( op )
      {

      case '+' :        /* Addition */
      for (i=0; i<count; i++,res+=mr,op1+=s1,op2+=s2)
        *res = *op1 + *op2 ;
        break ;

      case '-' :        /* Subtraction */
      for (i=0; i<count; i++,res+=mr,op1+=s1,op2+=s2)
        *res = *op1 - *op2 ;
        break ;

      case '*' :        /* Multiplication */
      for (i=0; i<count; i++,res+=mr,op1+=s1,op2+=s2)
        *res = *op1 * *op2 ;
        break ;

      case '/' :        /* Division */
      for (i=0; i<count; i++,res+=mr,op1+=s1,op2+=s2)
        *res = *op1 / *op2 ;
        break ;

      case '^' :        /* Raise to a power */
      for (i=0; i<count; i++,res+=mr,op1+=s1,op2+=s2)
        *res = pow( *op1, *op2 ) ;
        break ;

      case '%' :        /* Division */
      for (i=0; i<count; i++,res+=mr,op1+=s1,op2+=s2)
        *res =  ((*op1)<(*op2)?(*op2):(*op1));
        break ;

      case '@' :        /* Division */
      for (i=0; i<count; i++,res+=mr,op1+=s1,op2+=s2)
        *res =  ((*op1)>(*op2)?(*op2):(*op1));
        break ;

      default :
        free_item(oper1);free_item(oper2);
        return( 0 ) ;

      } /* End of switch( op ) */
    free_item(oper1);free_item(oper2);
    return (1);
    }
    if (((oper1->type)==MODVAR)&&((oper2->type)!=MODVAR))
    {
    switch( op )
      {

      case '+' :        /* Addition */
      for (i=0; i<count; i++,res+=mr,op2+=s2)
        *res = *(op1+(i/s1)%m1) + *op2 ;
        break ;

      case '-' :        /* Subtraction */
      for (i=0; i<count; i++,res+=mr,op2+=s2)
        *res = *(op1+(i/s1)%m1) - *op2 ;
        break ;

      case '*' :        /* Multiplication */
      for (i=0; i<count; i++,res+=mr,op2+=s2)
        *res = *(op1+(i/s1)%m1) * *op2 ;
        break ;

      case '/' :        /* Division */
      for (i=0; i<count; i++,res+=mr,op2+=s2)
        *res = *(op1+(i/s1)%m1) / *op2 ;
        break ;

      case '^' :        /* Raise to a power */
      for (i=0; i<count; i++,res+=mr,op2+=s2)
        *res = pow( *(op1+(i/s1)%m1), *op2 ) ;
        break ;

      case '%' :        /* Division */
      for (i=0; i<count; i++,res+=mr,op2+=s2)
        *res =  ((*(op1+(i/s1)%m1))<(*op2)?(*op2):(*(op1+(i/s1)%m1)));
        break ;

      case '@' :        /* Division */
      for (i=0; i<count; i++,res+=mr,op2+=s2)
        *res =  ((*(op1+(i/s1)%m1))>(*op2)?(*op2):(*(op1+(i/s1)%m1)));
        break ;

      default :

        free_item(oper1);free_item(oper2);
        return( 0 ) ;

      } /* End of switch( op ) */
    free_item(oper1);free_item(oper2);
    return (1);
    }




    if (((oper1->type)!=MODVAR)&&((oper2->type)==MODVAR))
    {
    switch( op )
      {

      case '+' :        /* Addition */
      for (i=0; i<count; i++,res+=mr,op1+=s1)
        *res = *op1 + *(op2+(i/s2)%m2) ;
        break ;

      case '-' :        /* Subtraction */
      for (i=0; i<count; i++,res+=mr,op1+=s1)
        *res = *op1 - *(op2+(i/s2)%m2) ;
        break ;

      case '*' :        /* Multiplication */
      for (i=0; i<count; i++,res+=mr,op1+=s1)
        *res = *op1 * *(op2+(i/s2)%m2) ;
        break ;

      case '/' :        /* Division */
      for (i=0; i<count; i++,res+=mr,op1+=s1)
        *res = *op1 / *(op2+(i/s2)%m2) ;
        break ;

      case '^' :        /* Raise to a power */
      for (i=0; i<count; i++,res+=mr,op1+=s1)
        *res = pow( *op1, *(op2+(i/s2)%m2) ) ;
        break ;

      case '%' :        /* Division */
      for (i=0; i<count; i++,res+=mr,op1+=s1)
        *res =  ((*op1)<(*(op2+(i/s2)%m2))?(*(op2+(i/s2)%m2)):(*op1));
        break ;

      case '@' :        /* Division */
      for (i=0; i<count; i++,res+=mr,op1+=s1)
        *res =  ((*op1)>(*(op2+(i/s2)%m2))?(*(op2+(i/s2)%m2)):(*op1));
        break ;

      default :

        free_item(oper1);free_item(oper2);
        return( 0 ) ;

      } /* End of switch( op ) */
    free_item(oper1);free_item(oper2);
    return (1);
    }


    if (((oper1->type)==MODVAR)&&((oper2->type)==MODVAR))
    {
    switch( op )
      {

      case '+' :        /* Addition */
      for (i=0; i<count; i++,res+=mr)
        *res = *(op1+(i/s1)%m1) + *(op2+(i/s2)%m2) ;
        break ;

      case '-' :        /* Subtraction */
      for (i=0; i<count; i++,res+=mr)
        *res = *(op1+(i/s1)%m1) - *(op2+(i/s2)%m2) ;
        break ;

      case '*' :        /* Multiplication */
      for (i=0; i<count; i++,res+=mr)
        *res = *(op1+(i/s1)%m1) * *(op2+(i/s2)%m2) ;
        break ;

      case '/' :        /* Division */
      for (i=0; i<count; i++,res+=mr)
        *res = *(op1+(i/s1)%m1) / *(op2+(i/s2)%m2) ;
        break ;

      case '^' :        /* Raise to a power */
      for (i=0; i<count; i++,res+=mr)
        *res = pow( *(op1+(i/s1)%m1), *(op2+(i/s2)%m2) ) ;
        break ;

      case '%' :        /* Division */
      for (i=0; i<count; i++,res+=mr)
        *res =  ((*(op1+(i/s1)%m1))<(*(op2+(i/s2)%m2))?(*(op2+(i/s1)%m1)):(*(op1+(i/s2)%m2)));
        break ;

      case '@' :        /* Division */
      for (i=0; i<count; i++,res+=mr)
        *res =  ((*(op1+(i/s1)%m1))>(*(op2+(i/s2)%m2))?(*(op2+(i/s2)%m2)):(*(op1+(i/s1)%m1)));
        break ;

      default :

        free_item(oper1);free_item(oper2);
        return( 0 ) ;

      } /* End of switch( op ) */
    free_item(oper1);free_item(oper2);
    return (1);
    }


  return( 0 ) ;

}

