/*
 * sblibry.h
 *
 * Spaceball Library Include File
 *
 * Version: L4.05
 * Release Date:	       29 August  1989
 * Latest modification:        13 May	  1989
 *
 * Written by John Hilton, Spatial Systems Inc, May 1988
 *
 * Copyright (C) 1988 Spatial Systems Inc. All Rights Reserved.
 * Spaceball is a registered trademark of Spatial Systems Inc.
 *
 * Refer to the Spaceball Application Developer's Reference (Document
 * Number D1005) for more information on the following code.
 *
 * RESTRICTIONS
 *
 * The following code is licensed for use and distribution provided the
 * code is used exclusively in conjunction with a Spaceball.  No portion
 * may be used for other purposes without prior written permission from
 * Spatial Systems Inc.  This notice must accompany any full or partial
 * copies.
 *
 * PURPOSE
 *
 * This file provides the definitions and declarations required to
 * use the Spaceball Library and should be included in each program
 * utilizing the library.
 */

#ifndef Sb_SBLIBRY_H	    /* have we been here before? */
#define Sb_SBLIBRY_H

#include    "sbcustom.h"    /* platform configuration definitions */


#ifndef P
#if !Sb_CHECK_ARGS
#define    	P( args )		()
#else
#define    	P( args )		args
#endif
#endif

/*============================== TYPEDEFS ===================================*/

typedef char
  SbBoolean;
typedef unsigned char
  SbUchar;
typedef short
  SbInt16;
typedef unsigned short
  SbUint16;
typedef SbReal
  SbMatrixType[ Sb_ROWS ][ Sb_COLUMNS ];
typedef struct {
    int
	(*absolute)  	P(( SbMatrixType		  )),
	(*ballatrest)	P(( void			  )),
	(*ballmode)  	P(( char * 		  )),
	(*beeper)    	P(( char * 		  )),
	(*delta)     	P(( SbMatrixType		  )),
	(*echo)      	P(( char * 		  )),
	(*error)     	P(( char * 		  )),
	(*invalid)   	P(( char *, int		  )),
#if irix4
	(*irotate)   	(),
	(*itranslate)	(),
#else
	(*irotate)   	P(( SbUint16, SbInt16 [ 3 ]  )),
	(*itranslate)	P(( SbUint16, SbInt16 [ 3 ]  )),
#endif
	(*other)     	P(( char *, int		  )),
#if irix4
	(*released)  	(),
	(*pressed)   	(),
#else /* some weird cc bug results in "illegal class" error */
	(*released)  	P(( SbUint16		  )),
	(*pressed)   	P(( SbUint16		  )),
#endif
	(*reset)     	P(( char * 		  )),
	(*rotate)    	P(( SbUint16, SbReal [ 3 ]   )),
	(*translate) 	P(( SbUint16, SbReal [ 3 ]   ));
}
  SbFunctionsType;

/*========================== CONSTANT DEFINITIONS ===========================*/

#ifndef FALSE
#define     FALSE			0
#endif
#ifndef TRUE
#define     TRUE			1
#endif

#define     Sb_MAXPACKET		100	/* maximum number of characters
						 * allowed in a single packet
						 */
#define     Sb_NUM_SETTINGS		11
#define     Sb_SETTINGS_LENGTH		20

/*============================ MACRO DEFINITIONS ============================*/

#define     SbBeep( s ) \
    (SbPutChar( 'B' ), SbPutStr( s ), SbPutChar( '\r' ))
#define     SbPollBall()		SbRequestBallData()   /* early name */
#define     SbRequestBallData() \
    (SbPutStr( "d\r" ), SbBallDataPending = TRUE)
#define     SbPollBeeper()		SbRequestBeeperData() /* early name */
#define     SbRequestBeeperData()	SbPutStr( "b\r" )
#define     SbRezero()			SbPutStr( "Z\r" )
#define     SbSendSync()		SbPutStr( "%sync\r" )
#define     SbSetUserGetPacket( f )	(SbUserGetPacket = (f))

/* All Spaceball specific variables are contained within a structure
 * but are referenced in programs by the following names.
 */

#define     SbInBuffer			Sb->InBuffer
#define     SbOutBuffer 		Sb->OutBuffer
#define     SbSettings			Sb->Settings
#define     SbNullRegion		Sb->NullRegion
#define     SbRS232Mode 		Sb->RS232Mode
#define     SbOutBitBuffer		Sb->OutBitBuffer
#define     SbBallMode			Sb->BallMode
#define     SbRotationMode		Sb->RotationMode
#define     SbTranslationMode		Sb->TranslationMode
#define     SbInIndex			Sb->InIndex
#define     SbOutIndex			Sb->OutIndex
#define     SbBallDataLength		Sb->BallDataLength
#define     SbNumchars			Sb->Numchars
#define     SbVersionMajor		Sb->VersionMajor
#define     SbVersionMinor		Sb->VersionMinor
#define     SbOutBitShift		Sb->OutBitShift
#define     SbUserGetPacket		Sb->UserGetPacket
#define     SbFirstTime 		Sb->FirstTime
#define     SbBallAtRest		Sb->BallAtRest
#define     SbBallDataHasPeriod 	Sb->BallDataHasPeriod
#define     SbOverflowed		Sb->Overflowed
#define     SbWatchingReset		Sb->WatchingReset
#define     SbPacking			Sb->Packing
#define     SbBallDataPending		Sb->BallDataPending
#define     SbBallModePending		Sb->BallModePending
#define     SbKeys			Sb->Keys
#define     SbTranslationFeel		Sb->TranslationFeel
#define     SbRotationFeel		Sb->RotationFeel
#define     SbPulse			Sb->Pulse
#define     SbZero			Sb->Zero
#define     SbAveragePeriod		Sb->AveragePeriod
#define     SbSpinRate			Sb->SpinRate
#define     SbTranslationFreedom	Sb->TranslationFreedom
#define     SbRotationFreedom		Sb->RotationFreedom
#define     SbXYZScalings		Sb->XYZScalings
#define     SbAbsolute			Sb->Absolute
#define     SbOrientation		Sb->Orientation
#define     SbFunctions 		Sb->Functions
#define     SbEnvironment		Sb->Environment

/*========================== GLOBAL VARIABLES ===============================*/
#ifndef vms
#define     EXTERN			extern
#else
#define     EXTERN			globalref
#endif

#ifdef Sb_DEBUG
EXTERN int Sb_debug;
#endif

EXTERN SbMatrixType
  SbIdentityMatrix;

/* The following structure is used to allow efficient code generation for a
 * single Spaceball yet provide the flexibility to use the library with
 * several Spaceball's through pointer lookup.
 */

EXTERN struct SbArrayStruct {

    char
      InBuffer[ Sb_MAXPACKET ],
      OutBuffer[ Sb_MAXPACKET ],
      Settings[ Sb_NUM_SETTINGS ][ Sb_SETTINGS_LENGTH ],
      NullRegion,
      RS232Mode[ 3 ],
      OutBitBuffer,
      BallMode[ 6 ],
      RotationMode[ 4 ],
      TranslationMode[ 4 ];

    int
      InIndex,
      OutIndex,
      BallDataLength,
      Numchars,
      VersionMajor,
      VersionMinor,
      OutBitShift,
      (*UserGetPacket)	P(( char * ));
			/* allow user to intercept packets */

    SbBoolean
      FirstTime,
      BallAtRest,
      BallDataHasPeriod,
      Overflowed,
      WatchingReset,
      Packing,
      BallDataPending,
      BallModePending;

    SbUint16
      Keys,		/* current state of keys */
      TranslationFeel,
      RotationFeel,
      Pulse[ 2 ],
      Zero[ 6 ],
      AveragePeriod;

    SbReal
      SpinRate, 	  /* rate of spin */
      TranslationFreedom[ 3 ],
      RotationFreedom[ 3 ],
      XYZScalings[ 3 ];

    SbMatrixType
      Absolute,
      Orientation;

    SbFunctionsType
      Functions;

    SbEnvironmentType
      Environment;	/* contains machine environment specific information */
}
#if Sb_NUMBER_OF_SPACEBALLS == 1
  Sb[ 1 ];	    /* Sb-><variable name> is a run time absolute address */
#else
  SbArray[ Sb_NUMBER_OF_SPACEBALLS ],
  *Sb;              /* Sb-><variable name> is a run time pointer dereference */
#define     SbCurrentSpaceball		(Sb - SbArray)
#endif

/*========================== GLOBAL FUNCTIONS ===============================*/

extern SbInt16
  SbMilliseconds	P(( void				));

extern int
  SbOpen		P(( char *				)),
  SbClose		P(( void				)),
  SbInput		P(( char *, int, SbInt16		)),
  SbOutput		P(( char *, int			)),

  SbCheckSpaceball	P(( void				)),
  SbConvertMatrix	P(( SbUint16, SbMatrixType		)),
  SbGetPacket		P(( char *				)),
  SbMatricize		P(( SbReal, SbReal[ 3 ], SbMatrixType	)),
  SbMatrix3x3Multiply	P(( SbMatrixType, SbMatrixType,
				     SbMatrixType			)),
  SbNullFunction(							 ),
  SbPacketReady		P(( void				)),
  SbPackVector		P(( SbReal[ 3 ], SbInt16[ 3 ]		)),
  SbPackMatrix		P(( SbMatrixType, SbInt16[ 3 ] 	)),
  SbProcessEcho		P(( char *				)),
  SbProcessError	P(( char *				)),
  SbProcessInvalid	P(( char *, int			)),
  SbProcessIRotate	P(( SbUint16, SbInt16 [ 3 ]		)),
  SbProcessITranslate	P(( SbUint16, SbInt16 [ 3 ]		)),
  SbProcessOther	P(( char *, int			)),
  SbProcessPacket	P(( char *, int			)),
  SbProcessReset	P(( char *				)),
  SbPutBytes		P(( char *, int			)),
  SbPutChar		P(( char				)),
  SbPutStr		P(( char *				)),
  SbPutWords		P(( SbUint16 *, int			)),
  SbRequestSettings	P(( void				)),
  SbReset		P(( int				)),
  SbRotateAbout		P(( SbReal, SbReal[ 3 ], SbMatrixType	)),
  SbSetAbsolute		P(( SbMatrixType			)),
  SbSetBallMode		P(( char *				)),
  SbSetRS232Mode	P(( char *				)),
#if Sb_NUMBER_OF_SPACEBALLS > 1
  SbSetCurrentSpaceball	P(( int				)),
#endif
  SbSetNullRegion	P(( char				)),
  SbSetOrientation	P(( SbMatrixType			)),
  SbSetPulse		P(( SbUint16 [ 2 ]			)),
  SbSetRotationFeel	P(( char				)),
  SbSetRotationFreedom	P(( SbReal [ 3 ]			)),
  SbSetRotationMode	P(( char [ 3 ] 			)),
  SbSetSpinRate		P(( SbReal				)),
  SbSetTranslationFeel	P(( char				)),
  SbSetTranslationFreedom	P(( SbReal [ 3 ]			)),
  SbSetTranslationMode	P(( char [ 3 ] 			)),
  SbSetXYZScalings	P(( SbReal [ 3 ]			)),
  SbSetZero		P(( SbUint16[ 6 ]			)),
  SbSynchronize		P(( void				)),
  SbUnpackMatrix	P(( char [ 6 ], SbMatrixType		)),
  SbUnpackVector	P(( char [ 6 ], SbReal [ 3 ]		)),
  SbWaitForPacket	P(( SbInt16				)),
  SbWaitForSync		P(( SbInt16				)),
  SbWatchForReset	P(( SbInt16				));

#endif	/* Sb_SBLIBRY_H */
