/****************************************************************************
                          INTERNATIONAL AVS CENTRE
           (This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Centre, University of Manchester, the AVS Consortium and
the individual  submitting the module and files associated with said module
provide absolutely NO WARRANTY OF ANY KIND with respect to this software.  The
entire risk as to the quality and performance of this software is with the
user.  IN NO EVENT WILL The International AVS Centre, University of Manchester,
the AVS Consortium and the individual submitting the module and files
associated with said module BE LIABLE TO ANYONE FOR ANY DAMAGES ARISING FROM
THE USE OF THIS SOFTWARE, INCLUDING, WITHOUT LIMITATION, DAMAGES RESULTING FROM
LOST DATA OR LOST PROFITS, OR ANY SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@iavsc.org.

Please send AVS module bug reports to avs@iavsc.org.

***************************************************************************/
/*********************************************************************

Copyright (C) 1995, Lawrence Berkeley Laboratory.  All Rights
Reserved.  Permission to copy and modify this software and its
documentation (if any) is hereby granted, provided that this notice
is retained thereon and on all copies.  

This software is provided as a professional academic contribution
for joint exchange.   Thus it is experimental and scientific
in nature, undergoing development, and is provided "as is" with
no warranties of any kind whatsoever, no support, promise of
updates or printed documentation.

This work is supported by the U. S. Department of Energy under 
contract number DE-AC03-76SF00098 between the U. S. Department 
of Energy and the University of California.


	Author: Wes Bethel
		Lawrence Berkeley Laboratory
		Berkeley, California

  "this software is 100% hand-crafted by a human being in the USA"

*********************************************************************/

/**
**/

#include <stdio.h>
#include <string.h>

#include <avs/avs.h>
#include <avs/field.h>

#include "vr_util.h"

AVSinit_modules()
{
    int ddevice();
    AVSmodule_from_desc(ddevice);
}

int
ddevice()
{
    int p,ddevice_compute();
    
    AVSset_module_name("VR dummy device",MODULE_DATA);
    AVScreate_output_port("output xform",VR_FIELD_STRING); 
    
    p = AVSadd_parameter("dummy1","string","Module Fire Control","","");
    AVSconnect_widget(p,"text");
    AVSadd_parameter_prop(p,"width","integer",4);
    p=AVSadd_parameter("PushMe","boolean",0,0,1);
    AVSconnect_widget(p,"toggle");

    p = AVSadd_parameter("dummy2","string","Rotation Values","","");
    AVSconnect_widget(p,"text");
    AVSadd_parameter_prop(p,"width","integer",4);
    p = AVSadd_float_parameter("X Axis Rotation",0.,-1.,1.);
    AVSconnect_widget(p,"slider");
    p = AVSadd_float_parameter("Y Axis Rotation",0.,-1.,1.);
    AVSconnect_widget(p,"slider");
    p = AVSadd_float_parameter("Z Axis Rotation",0.,-1.,1.);
    AVSconnect_widget(p,"slider");
    
    p = AVSadd_parameter("dummy3","string","Translation Values","","");
    AVSconnect_widget(p,"text");
    AVSadd_parameter_prop(p,"width","integer",4);
    p = AVSadd_float_parameter("X Axis Translation",0.,-1.,1.);
    AVSconnect_widget(p,"slider");
    p = AVSadd_float_parameter("Y Axis Translation",0.,-1.,1.);
    AVSconnect_widget(p,"slider");
    p = AVSadd_float_parameter("Z Axis Translation",0.,-1.,1.);
    AVSconnect_widget(p,"slider");

    p = AVSadd_parameter("dummy4","string","Fun with Buttons","","");
    AVSconnect_widget(p,"text");
    AVSadd_parameter_prop(p,"width","integer",4);

    p = AVSadd_parameter("buttons","choice","No Event","No Event!Button 1!Button 2!Button 3!Button 4!Button 5!Button 6!Button 7!Button 8","!");
    AVSconnect_widget(p,"radio_buttons");
    
    AVSset_compute_proc(ddevice_compute);
}

int
ddevice_compute(outf,dummy1,fire,dummy2,rx,ry,rz,dummy3,tx,ty,tz,
		dummy4,button_choice_string)
AVSfield **outf;
char *dummy1;
int fire;
char *dummy2;
float *rx,*ry,*rz;
char *dummy3;
float *tx,*ty,*tz;
char *dummy4;
char *button_choice_string;
{
    AVSfield template;
    int status = 0;
    int button_choice_int = AVSchoice_number("buttons",button_choice_string) - 1;
    
    if (fire)
    {
	if (*outf)
	    AVSfield_free(*outf);

	memset((char *)&template,0,sizeof(AVSfield));
	MAKE_VR_AVS_FIELD_TEMPLATE(&template);
	*outf = (AVSfield *)AVSfield_alloc(&template,VR_field_dims);
					   
	/* gather and send data, then reset parm back to zero */
	VR_SET_ROT_VECTOR(*rx,*ry,*rz,(*outf));
	VR_SET_TRANS_VECTOR(*tx,*ty,*tz,(*outf));

	/* deal with buttons */
	do_buttons(button_choice_int,*outf);
	
	AVSmodify_parameter("PushMe",AVS_VALUE,0,0,0);
	status = 1;
    }
    return(status);
}

do_buttons(button,outf)
int button;
AVSfield *outf;
{
    /* this routine deals exclusively with buttons */

    /* first, set the flag indicating whether or not there are
       any button events at all */

    if (button == 0)
	/* this says there's no buttons to worry
	   about in the field.  we're done...*/
	SET_BUTTONS_FLAG(0,outf)

    else
    {
	SET_BUTTONS_FLAG(1,outf); /* this says that there are buttons to
				   worry about.  */

	/* clear out all button masks*/
	VR_SET_BUTTON((VR_BUTTON1_MASK | VR_BUTTON2_MASK |
		       VR_BUTTON3_MASK | VR_BUTTON4_MASK |
		       VR_BUTTON5_MASK | VR_BUTTON6_MASK |
		       VR_BUTTON7_MASK | VR_BUTTON8_MASK),
		      0,outf);

	/* figure out which button was pressed and set it's mask */

	switch(button)
	{
	case 1:
	    VR_SET_BUTTON(VR_BUTTON1_MASK,1,outf);
	    break;
	case 2:
	    VR_SET_BUTTON(VR_BUTTON2_MASK,2,outf);
	    break;
	case 3:
	    VR_SET_BUTTON(VR_BUTTON3_MASK,3,outf);
	    break;
	case 4:
	    VR_SET_BUTTON(VR_BUTTON4_MASK,4,outf);
	    break;
	case 5:
	    VR_SET_BUTTON(VR_BUTTON5_MASK,5,outf);
	    break;
	case 6:
	    VR_SET_BUTTON(VR_BUTTON6_MASK,6,outf);
	    break;
	case 7:
	    VR_SET_BUTTON(VR_BUTTON7_MASK,7,outf);
	    break;
	case 8:
	    VR_SET_BUTTON(VR_BUTTON8_MASK,8,outf);
	    break;
	default:
	    break;
	}
    }
}


