/****************************************************************************
                          INTERNATIONAL AVS CENTRE
           (This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Centre, University of Manchester, the AVS Consortium and
the individual  submitting the module and files associated with said module
provide absolutely NO WARRANTY OF ANY KIND with respect to this software.  The
entire risk as to the quality and performance of this software is with the
user.  IN NO EVENT WILL The International AVS Centre, University of Manchester,
the AVS Consortium and the individual submitting the module and files
associated with said module BE LIABLE TO ANYONE FOR ANY DAMAGES ARISING FROM
THE USE OF THIS SOFTWARE, INCLUDING, WITHOUT LIMITATION, DAMAGES RESULTING FROM
LOST DATA OR LOST PROFITS, OR ANY SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@iavsc.org.

Please send AVS module bug reports to avs@iavsc.org.

***************************************************************************/
/*********************************************************************

Copyright (C) 1995, Lawrence Berkeley Laboratory.  All Rights
Reserved.  Permission to copy and modify this software and its
documentation (if any) is hereby granted, provided that this notice
is retained thereon and on all copies.  

This software is provided as a professional academic contribution
for joint exchange.   Thus it is experimental and scientific
in nature, undergoing development, and is provided "as is" with
no warranties of any kind whatsoever, no support, promise of
updates or printed documentation.

This work is supported by the U. S. Department of Energy under 
contract number DE-AC03-76SF00098 between the U. S. Department 
of Energy and the University of California.


	Author: Wes Bethel
		Lawrence Berkeley Laboratory
                Berkeley, California 

  "this software is 100% hand-crafted by a human being in the USA"

*********************************************************************/
#include <stdio.h>
#include "matrix.h"

matrix_4copy(a,b)  /* copy a into b */
matrix4x4 *a,*b;
{
    memcpy((char *)b,(char *)a,sizeof(matrix4x4));
}

row_copy_to_vec(v,m,row)
vector4 *v;
matrix4x4 *m;
int row;
{
    int i;
    for (i=0;i<4;i++)
	v->v[i] = m->m[row][i];
}

vec_copy_to_row(v,m,row)
vector4 *v;
matrix4x4 *m;
int row;
{
    int i;
    for (i=0;i<4;i++)
	m->m[row][i] = v->v[i];
}

identity_4x4(m)
matrix4x4 *m;
{
    int i,j;
    for (i=0;i<4;i++)
	for (j=0;j<4;j++)
	    m->m[i][j] = ((i==j) ? 1. : 0.);
}

transpose_4x4(m,d)
matrix4x4 *m,*d;
{
    matrix4x4 tmp;
    int i,j;
    for (j=0;j<4;j++)
	for (i=0;i<4;i++)
	    tmp.m[j][i] = m->m[i][j];

    memcpy((char *)d,(char *)&tmp,sizeof(matrix4x4));
}

clear_4x4(m)
matrix4x4 *m;
{
    int i,j;
    for (i=0;i<4;i++)
	for (j=0;j<4;j++)
	    m->m[i][j] = 0.;
}

vector_4_dot(v1,v2,d)
vector4 *v1,*v2;
double *d;
{
    double t=0;
    int i;

    for (i=0;i<4;i++)
	t += v1->v[i]*v2->v[i];
    *d = t;
}

mmul_4x4(a,b)
matrix4x4 *a,*b;  /* take product of a and b, put result in a */
{
    matrix4x4 tmp;
    int row,col;

    clear_4x4(&tmp);

    for (row=0;row<4;row++)
    {
	for (col=0;col<4;col++)
	    tmp.m[row][col] = a->m[row][0]*b->m[0][col] +
		a->m[row][1]*b->m[1][col] + a->m[row][2]*b->m[2][col] +
		    a->m[row][3]*b->m[3][col];
    }
    for (row=0;row<4;row++)
	for (col=0;col<4;col++)
	    a->m[row][col] = tmp.m[row][col];
}

mmul_4x4_alt(a,b,c)
matrix4x4 *a,*b,*c;  /* take product of a and b, put result in c */
{
    matrix4x4 tmp;
    int row,col;

    clear_4x4(&tmp);

    for (row=0;row<4;row++)
    {
	for (col=0;col<4;col++)
	    tmp.m[row][col] = a->m[row][0]*b->m[0][col] +
		a->m[row][1]*b->m[1][col] + a->m[row][2]*b->m[2][col] +
		    a->m[row][3]*b->m[3][col];
    }
    memcpy((char *)c,(char *)&tmp,sizeof(matrix4x4));
}


vector_matrix_mult_4(v,m,result)
vector4 *v,*result;
matrix4x4 *m;
{
    int i,j;

    for (j=0;j<4;j++)
    {
	result->v[j] = 0.;
	for (i=0;i<4;i++)
	    result->v[j] += v->v[i] * m->m[i][j];
    }
}
matrix_vector_mult_3(m,v,result)
avs_vertex *v,*result;
matrix4x4 *m;
{
    int i,j;

    for (j=0;j<3;j++)
    {
	result->v[j] = 0.;
	for (i=0;i<3;i++)
	    result->v[j] += v->v[i] * m->m[j][i];
    }
}

powervec_4(v,t)
vector4 *v;
double *t;
{ /* returns u^3 u^2 u 1. in a 4-vector. */
    double f;
    f = *t;
    v->v[3] = 1.;
    v->v[2] = f;
    f = f*f;
    v->v[1] = f;
    v->v[0] = f* *t;
}

print_matrix_4x4(m)
matrix4x4 *m;
{
    int i,j;
    
    for(i=0;i<4;i++)
    {
	for (j=0;j<4;j++)
	    fprintf(stderr," %lf ",m->m[i][j]);
	fprintf(stderr,"\n");
    }
    fprintf(stderr,"\n");

}

print_vector_4(v)
vector4 *v;
{
    int i;
    for (i=0;i<4;i++)
	fprintf(stderr," %lf ",v->v[i]);
    fprintf(stderr,"\n");
}

vec4_copy(dest,src)
vector4 *dest,*src;
{
    int i;
    for (i=0;i<4;i++)
	dest->v[i] = src->v[i];
}

vec_matrix_mult_positionwise(v,m)
vector4 *v;
matrix4x4 *m;
{
    int i,j;
    
    for(j=0;j<4;j++) /* do each column */
    {
	for (i=0;i<4;i++)
	    m->m[i][j] = m->m[i][j] * v->v[i];
    }
}
matrix_matrix_mult_positionwise(m1,m2)
matrix4x4 *m1,*m2;
{
    int i,j;
    for (j=0;j<4;j++)
	for (i=0;i<4;i++)
	    m1->m[i][j] = m1->m[i][j] * m2->m[i][j];
}
vec3dot(a,b,dot)
vector3 *a,*b;
double *dot;
{
    int i;
    *dot = 0.;
    for (i=0;i<3;i++)
	*dot += a->v[i]*b->v[i];
}

vec3norm(a,b)
vector3 *a,*b;
{
    extern double sqrt();
    double mag;
    int i;

    mag = 0.;
    for (i=0;i<3;i++)
	mag += a->v[i]*a->v[i];
    mag = sqrt(mag);
    for (i=0;i<3;i++)
	b->v[i] = a->v[i]/mag;
}

vert3norm(a,b)
avs_vertex *a,*b;
{
    extern double sqrt();
    double mag;
    int i;

    mag = 0.;
    for (i=0;i<3;i++)
	mag += a->v[i]*a->v[i];
    mag = sqrt(mag);
    for (i=0;i<3;i++)
	b->v[i] = a->v[i]/mag;
}

vert3mag(a,m)
avs_vertex *a;
double *m;
{
    extern double sqrt();
    double mag;
    int i;
    
    mag = 0.;
    for (i=0;i<3;i++)
	mag += a->v[i]*a->v[i];
    mag = sqrt(mag);
    *m = mag;
}

vert3diff(a,b,c)
avs_vertex *a,*b,*c;
{
    int i;

    for (i=0;i<3;i++)
	c->v[i] = a->v[i] - b->v[i];
}

vert3cross(p,r,c)
avs_vertex *p,*r,*c;
{
    /* take cross product of p and r, put into c */

    c->v[0] = p->v[1] * r->v[2] - p->v[2] * r->v[1];
    c->v[1] = p->v[2] * r->v[0] - p->v[0] * r->v[2];
    c->v[2] = p->v[0] * r->v[1] - p->v[1] * r->v[0];
}

invert_4x4matrix(a,b)
matrix4x4 *a,*b;  /* invert a, put into b */
{
    float m[4][4];
    int lda,n,ipvt[4],info,job;
    float work[4*2],det[4][2];
    float newv[3];

    memcpy((char *)m,(char *)a,sizeof(matrix4x4));
    job = 1;
    lda = 4;
    n = 4;

    sgefa(m,&lda,&n,ipvt,&info);
    sgedi(m,&lda,&n,ipvt,det,work,&job);
    
    memcpy((char *)b,(char *)m,sizeof(matrix4x4));
}
