/****************************************************************************
                          INTERNATIONAL AVS CENTRE
           (This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Centre, University of Manchester, the AVS Consortium and
the individual  submitting the module and files associated with said module
provide absolutely NO WARRANTY OF ANY KIND with respect to this software.  The
entire risk as to the quality and performance of this software is with the
user.  IN NO EVENT WILL The International AVS Centre, University of Manchester,
the AVS Consortium and the individual submitting the module and files
associated with said module BE LIABLE TO ANYONE FOR ANY DAMAGES ARISING FROM
THE USE OF THIS SOFTWARE, INCLUDING, WITHOUT LIMITATION, DAMAGES RESULTING FROM
LOST DATA OR LOST PROFITS, OR ANY SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@iavsc.org.

Please send AVS module bug reports to avs@iavsc.org.

***************************************************************************/

/**********************************************************************

Copyright (C) 1995, 1996  E. O. Lawrence Berkeley National Laboratory.  
All Rights Reserved.  Permission to copy and modify this software and 
its documentation (if any) is hereby granted, provided that this notice
is retained thereon and on all copies.  

This software is provided as a professional academic contribution for 
joint exchange.   Thus it is experimental and scientific in nature, 
undergoing development, and is provided "as is" with no warranties of 
any kind whatsoever, no support, promise of updates or printed 
documentation.

This work is supported by the U. S. Department of Energy under contract 
number DE-AC03-76SF00098 between the U. S. Department of Energy and the 
University of California.


	Author: Wes Bethel
		Lawrence Berkeley Laboratory
                Berkeley, California 

  "this software is 100% hand-crafted by a human being in the USA"


//\/\\//\\//\\/\//\\/\\//\\//\\/\\/\//\\//\\//\\//\\//\\//\/\\//\\//\\

Mon Nov 13 12:45:49 PST 1995


*********************************************************************/


#include <stdio.h>
#include <string.h>
#include <avs/avs.h>
#include <avs/field.h>
#include <avs/geomdata.h>
#include <avs/udata.h>
#include "matrix.h"
#include "vr_util.h"

#define CHILL 1
#define WHACKED 0


static char DEVICE_INPUT_NAME[] = {"input_device_event_field"};   

typedef struct ui_state
{
    int have_input_device_data;
} ui_state;


AVSinit_modules()
{
    int vr_event_scale();
    AVSmodule_from_desc(vr_event_scale);
}

int
vr_event_scale()
{
    int vr_event_scale_func();
    int p;

    AVSset_module_name("event scale",MODULE_MAPPER);

    AVScreate_input_port(DEVICE_INPUT_NAME,VR_FIELD_STRING,REQUIRED);
    AVScreate_output_port("outputfield",VR_FIELD_STRING);

    p=AVSadd_parameter("dummy1","string","Translation Scale","","");
    AVSconnect_widget(p,"text");
    AVSadd_parameter_prop(p,"width","integer",4);

    p = AVSadd_parameter("tscale",1.0,FLOAT_UNBOUND,FLOAT_UNBOUND);

    p=AVSadd_parameter("dummy2","string","Rotation Scale","","");
    AVSconnect_widget(p,"text");
    AVSadd_parameter_prop(p,"width","integer",4);
    
    p = AVSadd_parameter("rscale",1.0,FLOAT_UNBOUND,FLOAT_UNBOUND);
    
    AVSset_compute_proc(vr_event_scale_func);
}

int
vr_event_scale_func(inf,outf,d1,tscale,d2,rscale)
AVSfield *inf,**outf;
char *d1,*d2;
float *tscale,*rscale;
{
    AVSfield template;
    int dims[1];
    int status;
    int have_button_event;
    int button1,button2,button3,button4,button5;
    int button_status_mask;
    ui_state new_state;
    float w[3];
    
    memset((char *)&template,0,sizeof(AVSfield));
    MAKE_VR_AVS_FIELD_TEMPLATE(&template);
    if (*outf)
	AVSfield_free(*outf);
    *outf = (AVSfield *)AVSfield_alloc(&template,VR_field_dims);
    memset((char *)((*outf)->field_union.field_data_float_u),0,
	   sizeof(float)*VR_field_dims[0]); /* clear all memory */

    
    VR_COPY_ALL_DATA((*outf),inf); /* this gets all buttons and any extra
				    crap that's floating around*/

    /* do the translational events */
    VR_GET_TRANS_VECTOR(w[0],w[1],w[2],inf);

    for (i=0;i<3;i++)
	w[i] *= *tscale;

    VR_SET_TRANS_VECTOR(w[0],w[1],w[2],(*outf));

    /* do the rotational events */
    VR_GET_ROT_VECTOR(w[0],w[1],w[2],inf);

    for (i=0;i<3;i++)
	w[i] *= *rscale;

    VR_SET_ROT_VECTOR(w[0],w[1],w[2],(*outf));


    return(1);
}


