/****************************************************************************
                          INTERNATIONAL AVS CENTRE
           (This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Centre, University of Manchester, the AVS Consortium and
the individual  submitting the module and files associated with said module
provide absolutely NO WARRANTY OF ANY KIND with respect to this software.  The
entire risk as to the quality and performance of this software is with the
user.  IN NO EVENT WILL The International AVS Centre, University of Manchester,
the AVS Consortium and the individual submitting the module and files
associated with said module BE LIABLE TO ANYONE FOR ANY DAMAGES ARISING FROM
THE USE OF THIS SOFTWARE, INCLUDING, WITHOUT LIMITATION, DAMAGES RESULTING FROM
LOST DATA OR LOST PROFITS, OR ANY SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@iavsc.org.

Please send AVS module bug reports to avs@iavsc.org.

***************************************************************************//**********************************************************************

Copyright (C) 1995, 1996  E. O. Lawrence Berkeley National Laboratory.  
All Rights Reserved.  Permission to copy and modify this software and 
its documentation (if any) is hereby granted, provided that this notice
is retained thereon and on all copies.  

This software is provided as a professional academic contribution for 
joint exchange.   Thus it is experimental and scientific in nature, 
undergoing development, and is provided "as is" with no warranties of 
any kind whatsoever, no support, promise of updates or printed 
documentation.

This work is supported by the U. S. Department of Energy under contract 
number DE-AC03-76SF00098 between the U. S. Department of Energy and the 
University of California.


	Author: Wes Bethel
		Lawrence Berkeley Laboratory
                Berkeley, California 

  "this software is 100% hand-crafted by a human being in the USA"


  Tue Nov 14 16:27:06 PST 1995
  vr_stereo_cam module: use eye, at, up, separation parms and generate
  two geometry streams to control left and right cameras.

*********************************************************************/
#include <stdio.h>
#include <string.h>
#include <avs/avs.h>
#include <avs/field.h>
#include <avs/geom.h>
#include "matrix.h"

/* macro to copy from b into a */
#define VCOPY(a,b) (memcpy((char *)(a),(char *)(b),sizeof(avs_vertex)))

#include "vr_util.h"

#define TWOPI 6.2831853
#ifndef M_PI
#define M_PI 3.14159
#endif
#define DEGREES_TO_RADIANS(a) (M_PI*(a)/180.0)

#define DOMINANT_MODE_INIT_VALUE 0

/* static stuff for the camera model */

static avs_vertex eye,at,up;

/**
  * NOTE: the initialization for the following static variables
  * occurs in the lines of code that create the widgets for AVS.
  * when the module executes the first time, if the module is part
  * of a network, then there may be existing values for these
  * parameters and thus they will be honored, otherwise, default
  * values are used.
  *
  * (implication, the following assignments are ignored, and are
  * a leftover from earier revisions of the code.)
**/
static avs_vertex look_at_vector = {0.,0.,1.},
    orig_look_at_vector = {0.,0.,1.};
static avs_vertex up_vector = {0.,1.,0.},
    orig_up_vector = {0., 1., 0.};
static avs_vertex where_am_i = {0., 0., 12.},
    orig_where_am_i = {0., 0., 12.};
static float scale=1.0;

static char eye_string_buffer[64],at_string_buffer[64],up_string_buffer[64];

int
AVSinit_modules()
{
    int vr_stereo_cam();

    AVSmodule_from_desc(vr_stereo_cam);
}

int
vr_stereo_cam()
{
    int p;
    int vr_stereo_cam_compute();
    
    AVSset_module_name("VR Stereo Camera",MODULE_MAPPER);
    AVScreate_input_port("input field",VR_FIELD_STRING,REQUIRED);

    AVScreate_output_port("camera control","geom");

    p = AVSadd_parameter("dummy4","string","Misc View Parms","","");
    AVSconnect_widget(p,"text");
    AVSadd_parameter_prop(p,"width","integer",4);
    p=AVSadd_float_parameter("Focal Length",12.0,0.001,1000.);
    p=AVSadd_float_parameter("Window Width",1.0,0.001,1000.);
    p=AVSadd_float_parameter("Eye Separation (degrees)",7.5,1.,30.);

    p = AVSadd_parameter("dummy5","string","Reality Check","","");
    AVSconnect_widget(p,"text");
    AVSadd_parameter_prop(p,"width","integer",4);
    p = AVSadd_parameter("Eye","string"," 0.0 0.0 12.0 ",NULL,NULL);
    p = AVSadd_parameter("At","string"," 0.0 0.0 0.0",NULL,NULL);
    p = AVSadd_parameter("Up","string"," 0.0 1.0 0.0",NULL,NULL);

    p = AVSadd_parameter("dummy6","string","Which Camera?","","");
    AVSconnect_widget(p,"text");
    AVSadd_parameter_prop(p,"width","integer",4);
    p = AVSadd_parameter("Camera","string","%camera1",NULL,NULL);

    p = AVSadd_parameter("dummy7","string","Reset Camera Button","","");
    AVSconnect_widget(p,"text");
    AVSadd_parameter_prop(p,"width","integer",4);
    p = AVSadd_parameter("Reset","boolean",0,0,1);
    
    AVSset_compute_proc(vr_stereo_cam_compute);
}

static matrix4x4 cum_matrix;
static int deja_vu=0;

#define NOT(a) ((a) == 0 ? 1 : 0)

vr_stereo_cam_compute(inf,
                      cam,
		      dummy4,focal_length,window_width,eye_sep,
		      dummy5,eye_string,at_string,up_string,
		      dummy6,named_camera,
		      dummy7,reset_toggle)

AVSfield *inf;
GEOMedit_list *cam;
float *focal_length,*window_width,*eye_sep;
char *dummy4,*dummy5,*dummy6,*dummy7;
char *eye_string;
char *at_string;
char *up_string;
char *named_camera;
int reset_toggle;
{
    
    int status;
    int i;
    float sb[7];
    float *tv;
    int have_button_event, have_button1_event;
    avs_vertex l_eye,r_eye;

    if (deja_vu == 0)
    {
	parse_3tuple(eye_string,&eye);
	parse_3tuple(at_string,&at);
	parse_3tuple(up_string,&up);

	build_xform_matrix(&eye,&at,&up,&cum_matrix);
	deja_vu = 1;
    }
    else
    {
	/**
	  * the user may ask for a camera reset by either pressing the
	  * "reset" button in the GUI, or by pressing button #1 on the
	  * device.
	**/

	TEST_BUTTONS_FLAG(have_button_event,inf);
	if (have_button_event)
	    VR_TEST_BUTTON(VR_BUTTON1_MASK,have_button1_event,inf);

	if ((reset_toggle == 1) ||
	    ((have_button_event) && (have_button1_event))) 
	{
	    look_at_vector = at = orig_look_at_vector;
	    up_vector = up = orig_up_vector;
	    where_am_i = eye = orig_where_am_i;
	    build_xform_matrix(&eye,&at,&up,&cum_matrix);
	    
	    AVSmodify_parameter("Reset",AVS_VALUE,0,0,0);  /* turn the toggle off */
	    fprintf(stderr," doing a reset. \n");
	}
	else
        {
	    tv = inf->field_union.field_data_float_u;
	    VR_GET_TRANS_VECTOR(sb[0],sb[1],sb[2],inf);
	    VR_GET_ROT_VECTOR(sb[3],sb[4],sb[5],inf);
	    
	    build_new_positions(&eye,&at,&up,sb,focal_length);
	}
	
	sprintf(at_string_buffer,"%.3g %.3g %.3g",at.v[0],at.v[1],at.v[2]);
	AVSmodify_parameter("At",AVS_VALUE,at_string_buffer,NULL,NULL);
	
	sprintf(eye_string_buffer,"%.3g %.3g %.3g",eye.v[0],eye.v[1],eye.v[2]);
	AVSmodify_parameter("Eye",AVS_VALUE,eye_string_buffer,NULL,NULL);
		
	sprintf(up_string_buffer,"%.3g %.3g %.3g",up.v[0],up.v[1],up.v[2]);
	AVSmodify_parameter("Up",AVS_VALUE,up_string_buffer,NULL,NULL);
    }

    compute_stereo_views(&eye,&at,&up,&l_eye,&r_eye,eye_sep);

    *cam = GEOMinit_edit_list(*cam);
    GEOMedit_camera_orient(*cam,"%camera2",GEOM_CAMERA_ALL,
			   *window_width,&(at.v[0]),&(up.v[0]),&(r_eye.v[0]));

    GEOMedit_camera_orient(*cam,"%camera1",GEOM_CAMERA_ALL,
			   *window_width,&(at.v[0]),&(up.v[0]),&(l_eye.v[0]));

#if 0
    fprintf(stderr," left eye: %g %g %g \n",l_eye.v[0],l_eye.v[1],l_eye.v[2]);
    fprintf(stderr," right eye: %g %g %g \n",r_eye.v[0],r_eye.v[1],r_eye.v[2]);
#endif
    return(1);
}
	    



/* really should use cli to hit the "current" camera... but there's no
 CLI command to get the "current" camera, you always gotta provide a name*/
static char xform_name[] = {"%camera1"};

build_new_positions(eye,at,up,sb,focal_length)
avs_vertex *eye,*at,*up;
float *sb;
float *focal_length;
{
    int i;
    double ctheta,stheta,cbeta,sbeta,cgamma,sgamma,t;
    extern double cos(),sin();
    matrix4x4 rz,ry,rx,composite;

    t = sb[5] * -1.;  /* left or right handed? */
    if (t > TWOPI)
	t = t-TWOPI;
    else if (t < -TWOPI)
	t = t+TWOPI;
    ctheta = cos(t);
    stheta = sin(t);

    identity_4x4(&rz);
    rz.m[0][0] = rz.m[1][1] = ctheta;
    rz.m[0][1] = stheta;
    rz.m[1][0] = -1. * stheta;

    t = sb[4];
    if (t > TWOPI)
	t = t-TWOPI;
    else if (t < -TWOPI)
	t = t+TWOPI;
    
    cbeta = cos(t);
    sbeta = sin(t);

    identity_4x4(&ry);
    ry.m[0][0] = ry.m[2][2] = cbeta;
    ry.m[0][2] = -1. * sbeta;
    ry.m[2][0] = sbeta;

    t = sb[3];
    if (t > TWOPI)
	t = t-TWOPI;
    else if (t < -TWOPI)
	t = t+TWOPI;
    
    cgamma = cos(t);
    sgamma = sin(t);

    identity_4x4(&rx);
    rx.m[1][1] = rx.m[2][2] = cgamma;
    rx.m[1][2] = sgamma;
    rx.m[2][1] = -1. * sgamma;

    identity_4x4(&composite);

    mmul_4x4(&composite,&rz);
    mmul_4x4(&composite,&ry);
    mmul_4x4(&composite,&rx);

    /* concatenate current rotations onto end of accumulated
       transformations */

    mmul_4x4(&composite,&cum_matrix);
    memcpy((char *)&cum_matrix,(char *)&composite,sizeof(matrix4x4));
    
    /* the xdisp,ydisp,zdisp simply filter out displacement
       events.  these cause motion along the current, transformed
       coordinate system.  thus, an event on any of the 3 ball
       displacement axes can result in a change in any one of
       x,y or z.  */

    for (i=0;i<3;i++)
	where_am_i.v[i] += sb[0] * composite.m[0][i];

    for (i=0;i<3;i++)
	where_am_i.v[i] += sb[1] * composite.m[1][i];

    for (i=0;i<3;i++)
	where_am_i.v[i] += sb[2] * composite.m[2][i] * -1.;

    for (i=0;i<3;i++)
	eye->v[i] = where_am_i.v[i];  /* plus translation component */

    /**
      * the "at" vector is a function of the current eye point, plus
      * the Z axis of the current rotation matrix.
    **/
    for (i=0;i<3;i++)
	at->v[i] = eye->v[i] - cum_matrix.m[2][i] * *focal_length;

    /**
      * while the up vector is simply the Y axis of the new
      * rotation matrix.
    **/
    for (i=0;i<3;i++)
	up->v[i] = cum_matrix.m[1][i];
}


reset_all(eye,at,up,sb,focal_length)
avs_vertex *eye,*at,*up;
float *focal_length;
float *sb;
{
    int i;

    identity_4x4(&cum_matrix);

/*    memcpy((char *)&where_am_i,(char *)&orig_where_am_i,sizeof(avs_vertex)); */
    VCOPY(&where_am_i,&orig_where_am_i);
    
    build_new_positions(eye,at,up,sb,focal_length);
    
}

dominant_filter(sb,n)
float *sb;
int n;
{
    float maxval= 0.;
    int index= -1,i;
    double t;
    extern double fabs();

    for (i=0;i<n;i++)
    {
	t = sb[i];
	if (t != 0.)
	{
	    if (fabs(t) > maxval)
	    {
		maxval = fabs(t);
		index = i;
	    }
	}
    }
    if (index != -1)
    {
	for (i=0;i<n;i++)
	{
	    if (i != index)
		sb[i] = 0.;
	}
    }
}

int
parse_3tuple(s,v)
char *s;
avs_vertex *v;
{
    extern double strtod();
    double t;
    char *p;

    t = strtod(s,&p);
    v->v[0] = t;

    s = p;
    t = strtod(s,&p);
    v->v[1] = t;

    s = p;
    t = strtod(s,&p);
    v->v[2] = t;
}

build_xform_matrix(eye,at,up,m)
avs_vertex *eye,*at,*up;
matrix4x4 *m;
{
    avs_vertex v_y,v_z,v_x;
    int i;
    
    identity_4x4(m);

    /**
      * while the up vector is simply the Y axis of the 
      * rotation matrix.
    **/
    vert3norm(up,&v_y);
    for (i=0;i<3;i++)
	m->m[1][i] = v_y.v[i];

    /**
      * the Z axis is the eye-at vector.
    **/
    vert3diff(eye,at,&v_z);
    vert3norm(&v_z,&v_z);
    for (i=0;i<3;i++)
	m->m[2][i] = v_z.v[i];
    
    /**
      * the X axis is the cross product of the eye-at vector with the
      * up vector.
    **/
    vert3cross(&v_y,&v_z,&v_x);
    for (i=0;i<3;i++)
	m->m[0][i] = v_x.v[i];

}

int
compute_stereo_views(eye,at,up,l_eye,r_eye,eye_sep)
avs_vertex *eye,*at,*up,*l_eye,*r_eye;
float *eye_sep;
{
    avs_vertex v,p,r;
    double mag,t;
    extern double sin();
    int i;

    /* vector from eye point to look-at point */
    vert3diff(at,eye,&p);
    vert3mag(&p,&mag);		/* magnitude of that vector */
    vec3norm(&p,&p);

    /* grab and normalize up vector */
    VCOPY(&r,up);
    vec3norm(&r,&r);

    /* take cross product of (at-eye) x (up)  */
    vert3cross(&p,&r,&v);

    /* take sin() of eye_separation, scale by magnitude of (at-eye) */
    t = *eye_sep;
    t = DEGREES_TO_RADIANS(t);
    t = sin(t);
    t *= mag;

    /* compute left and right eye positions */
    for (i=0;i<3;i++)
	r_eye->v[i] = eye->v[i] + t*v.v[i];
    
    for (i=0;i<3;i++)
	l_eye->v[i] = eye->v[i] - t*v.v[i];
}

