
/* Generate an ASCII file containing 3D volumetric data */

#include "stdio.h"
#include "math.h"

#define XSIZE 10
#define YSIZE XSIZE
#define ZSIZE XSIZE
#define FILENAME "mydata"

int main()
{
  int x,y,z;
  FILE *outfile;
  float t;

  outfile= fopen(FILENAME, "w");

  fprintf(outfile, "%d %d %d\n", XSIZE, YSIZE, ZSIZE);

  for (z= 0; z<ZSIZE; z++) {

    for (y= 0; y<YSIZE; y++) {

      for (x= 0; x<XSIZE; x++) {

	t = (float)sqrt((float)(x*x + y*y + z*z));

	fprintf(outfile, "%f ", t );

      }
    }
      fprintf(outfile, "\n");
  }

  fclose(outfile);

  return 0;

}
