/*

                              DISCLAIMER
                              ==========

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.   

    If the software is modified by someone else and passed on, we, the authors
    want its recipients to know that what they have is not the original, so
    that any problems introduced by others will not reflect on the original
    authors' reputations.
*/                                            

/*
** Test program for transforms module.
** W.T. Hewitt.
*/

#include "nurbh.h"

#define LINE printf("*************************************\n")

PR_nurb c1, c2, c3;

main()
{
  printf("Testing NURBS\n");

  nrb_clear(&c1);

  LINE;
  printf("The Vase\n");
  nrb_vase(&c1);
  nrb_dump(stdout,&c1);

  LINE;
  printf("\n\nThe unit circle\n");
  nrb_clear(&c2);

  nrb_circle(&c2);
  nrb_dump(stdout,&c2);

  LINE;
  printf("\n\nTest NRB_Copy\n");
  nrb_clear(&c3);

  nrb_copy(&c2,&c3);
  nrb_dump(stdout,&c3);

  LINE;
  printf("\n\nTest NRB_Transpose\n");
  nrb_transpose(&c3);
  nrb_dump(stdout,&c3);

  LINE;
  printf("\n\nThe statistics\n");
  nrb_stats(stdout);
  
  LINE;
  printf("End of NURBs test.\n");
  return 0;
}

/* End. */
