/* This is file include/tranfns.h created by Extract */
/* Date: */

/*-------------------------------*/
/*  Including from:source/library/tran.c  */

extern ptkboolean ptk_equal ARGS((  Pfloat  one,   Pfloat  two));

extern Ppoint ptk_point ARGS((  Pfloat  x,   Pfloat  y));

extern Ppoint3 ptk_point3 ARGS((  Pfloat  x,   Pfloat  y,   Pfloat  z));

extern Ppoint4 ptk_point4 ARGS((  Pfloat  x,   Pfloat  y,   Pfloat z, Pfloat w));

extern Pvec ptk_vector ARGS((  Pfloat  x,   Pfloat  y));

extern Pvec3 ptk_vector3 ARGS((  Pfloat  x,   Pfloat  y,   Pfloat  z));

extern Plimit ptk_limit ARGS((  Pfloat  xmin,   Pfloat  xmax,   Pfloat  ymin,
                          Pfloat  ymax));

extern Plimit3 ptk_limit3 ARGS((  Pfloat  xmin,   Pfloat  xmax,   Pfloat  ymin,
                            Pfloat  ymax,   Pfloat  zmin,   Pfloat  zmax));

extern Ppoint3 ptk_vec3topt3 ARGS((  Pvec3 *  vec));

extern Pvec3 ptk_pt3tovec3 ARGS((  Ppoint3 *  pt));

extern Pfloat ptk_dotv3 ARGS((  Ppoint3 *  v1,   Ppoint3 *  v2));

extern Pfloat ptk_dotv ARGS((  Ppoint *  v1,   Ppoint *  v2));

extern Ppoint3 ptk_crossv3 ARGS((  Ppoint3 *  v1,   Ppoint3 *  v2));

extern ptkboolean ptk_nullv3 ARGS((  Ppoint3 *  vec));

extern ptkboolean ptk_nullv ARGS((  Ppoint *  vec));

extern Pfloat ptk_modv3 ARGS((  Ppoint3 *  vec));

extern Pfloat ptk_modv ARGS((  Ppoint *  vec));

extern Ppoint3 ptk_unitv3 ARGS((  Ppoint3 *  vec));

extern Ppoint ptk_unitv ARGS((  Ppoint *  vec));

extern Ppoint3 ptk_scalev3 ARGS((  Ppoint3 *  vec,   Pfloat  scale));

extern Ppoint ptk_scalev ARGS((  Ppoint *  vec,   Pfloat  scale));

extern Ppoint3 ptk_subv3 ARGS((  Ppoint3 *  p1,   Ppoint3 *  p2));

extern Ppoint ptk_subv ARGS((  Ppoint *  p1,   Ppoint *  p2));

extern Ppoint3 ptk_addv3 ARGS((  Ppoint3 *  v1,   Ppoint3 *  v2));

extern Ppoint ptk_addv ARGS((  Ppoint *  v1,   Ppoint *  v2));

extern void ptk_unitmatrix ARGS((  Pmatrix  matrix));

extern void ptk_unitmatrix3 ARGS((  Pmatrix3  matrix));

extern void ptk_transposematrix3 ARGS((  Pmatrix3  matrix,   Pmatrix3  result));

extern void ptk_transposematrix ARGS((  Pmatrix  matrix,   Pmatrix  result));

extern void ptk_multiplymatrix3 ARGS((  Pmatrix3  matrix1,   Pmatrix3  matrix2,
                            Pmatrix3  result));

extern void ptk_multiplymatrix ARGS((  Pmatrix  matrix1,   Pmatrix  matrix2,
                            Pmatrix  result));

extern void ptk_concatenatematrix3 ARGS((  Pcompose_type  operation,
              Pmatrix3  matrix1,   Pmatrix3  matrix2,   Pmatrix3  result));

extern void ptk_concatenatematrix ARGS((  Pcompose_type  operation,
              Pmatrix  matrix1,   Pmatrix  matrix2,   Pmatrix  result));

extern void ptk_shift3 ARGS((  Ppoint3 *  shift,   Pcompose_type  operation,
                         Pmatrix3  matrix));

extern void ptk_shift ARGS((  Ppoint *  shift,   Pcompose_type  operation,
                         Pmatrix  matrix));

extern void ptk_scale3 ARGS((  Ppoint3 *  scale,   Pcompose_type  operation,
                         Pmatrix3  matrix));

extern void ptk_scale ARGS((  Ppoint *  scale,   Pcompose_type  operation,
                         Pmatrix  matrix));

extern void ptk_rotatecs3 ARGS((  Pfloat  costheta,   Pfloat  sinetheta,
                            ptkeaxistype  axis,   Pcompose_type  operation,
                            Pmatrix3  matrix));

extern void ptk_rotatecs ARGS((  Pfloat  costheta,   Pfloat  sinetheta,
                            ptkeaxistype  axis,   Pcompose_type  operation,
                            Pmatrix  matrix));

extern void ptk_rotate3 ARGS((  Pfloat  rotation,   ptkeaxistype  axis,
                          Pcompose_type  operation,   Pmatrix3  matrix));

extern void ptk_rotate ARGS((  Pfloat  rotation,   ptkeaxistype  axis,
                          Pcompose_type  operation,   Pmatrix  matrix));

extern void ptk_shear3 ARGS((  ptkeaxistype  shearaxis,   ptkeaxistype  sheardir,
                         Pfloat  shearfactor,   Pcompose_type  operation,
                         Pmatrix3  matrix));

extern void ptk_shear ARGS((  ptkeaxistype  shearaxis,   ptkeaxistype  sheardir,
                         Pfloat  shearfactor,   Pcompose_type  operation,
                         Pmatrix  matrix));

extern void ptk_rotatevv3 ARGS((  Ppoint3 *  v1,   Ppoint3 *  v2,
                            Pcompose_type  operation,
                            Pmatrix3  matrix,   Pint * error));

extern void ptk_rotatevv ARGS((  Ppoint *  v1,   Ppoint *  v2,
                            Pcompose_type  operation,
                            Pmatrix  matrix,   Pint * error));

extern void ptk_rotateline3 ARGS((  Ppoint3 *  p1,   Ppoint3 *  p2,
                              Pfloat  theta,   Pcompose_type  operation,
                              Pmatrix3  matrix,   Pint * error));

extern void ptk_rotateline ARGS((  Ppoint *  p1,   Ppoint *  p2,
                              Pfloat  theta,   Pcompose_type  operation,
                              Pmatrix  matrix,   Pint * error));

extern Ppoint4 ptk_pt3topt4 ARGS((  Ppoint3 *  point));

extern Ppoint3 ptk_pt4topt3 ARGS((  Ppoint4 *  point));

extern Ppoint4 ptk_transform4 ARGS((  Pmatrix3  matrix,   Ppoint4 *  point));

extern Ppoint3 ptk_transform3 ARGS((  Pmatrix3  matrix,   Ppoint3 *  point));

extern Ppoint ptk_transform ARGS((  Pmatrix  matrix,   Ppoint *  point));

extern void ptk_matrixtomatrix3 ARGS((  Pmatrix  mat,   Pmatrix3  mat3));

extern void ptk_outputmatrix3 ARGS((  FILE *  fileptr,   Pmatrix3  matrix,
                                char *  string));

extern void ptk_box3tobox3 ARGS((  Plimit3 *  box1,   Plimit3 *  box2,
                             ptkboolean  preserve,   Pcompose_type  operation,
                             Pmatrix3  matrix,   Pint * error));

extern void ptk_boxtobox ARGS((  Plimit *  box1,   Plimit *  box2,
                             ptkboolean  preserve,   Pcompose_type  operation,
                             Pmatrix  matrix,   Pint * error));

extern void ptk_accumulatetran3 ARGS((  Ppoint3 *  fixed,   Ppoint3 *  shift,
                                  Pfloat  rotx,   Pfloat  roty,
                                  Pfloat  rotz,   Ppoint3 *  scale,
                                  Pcompose_type  operation,
                                  Pmatrix3  matrix));

extern void ptk_accumulatetran ARGS((  Ppoint *  fixed,   Ppoint *  shift,
                                  Pfloat  rot,   Ppoint *  scale,
                                  Pcompose_type  operation,
                                  Pmatrix  matrix));

extern void ptk_evalvieworientation3 ARGS((  Ppoint3 *  viewrefpoint,
                                      Ppoint3 *  viewplanenormal,
				      Ppoint3 *  viewupvector,
                                      Pcompose_type  operation,
                                      Pmatrix3  matrix,   Pint * error));

extern void ptk_evalvieworientation ARGS((  Ppoint *  viewrefpoint,
				      Ppoint *  viewupvector,
                                      Pcompose_type  operation,
                                      Pmatrix  matrix,   Pint * error));

extern void ptk_evalviewmapping3 ARGS((  Plimit3 *  wlimits,   Plimit3 *  vlimits,
                                  Pproj_type  viewtype,
                                  Ppoint3 *  refpoint,   Pfloat  vplanedist,
                                  Pcompose_type  operation,   Pmatrix3  matrix,
                                  Pint * error));

extern void ptk_evalviewmapping ARGS((  Plimit *  wlimits,   Plimit *  vlimits,
                                  Pcompose_type  operation,   Pmatrix  matrix,
                                  Pint * error));

extern void ptk_stackmatrix3 ARGS((  Pmatrix3  matrix));

extern void ptk_stackmatrix ARGS((  Pmatrix  matrix));

extern void ptk_unstackmatrix3 ARGS((  Pmatrix3  matrix));

extern void ptk_unstackmatrix ARGS((  Pmatrix  matrix));

extern void ptk_examinestackmatrix3 ARGS((  Pmatrix3  matrix));

extern void ptk_examinestackmatrix ARGS((  Pmatrix  matrix));

extern void ptk_3ptto3pt ARGS((  Ppoint3 *  p1,   Ppoint3 *  p2,   Ppoint3 *  p3,
                           Ppoint3 *  q1,   Ppoint3 *  q2,   Ppoint3 *  q3,
                           Pcompose_type  operation,   Pmatrix3  matrix,
                           Pint * error));

extern void ptk_0to3pt ARGS((  Ppoint3 *  origin,   Ppoint3 *  xdirn,
                Ppoint3 *  ydirn,   Pcompose_type  operation,   Pmatrix3  matrix));

extern void ptk_oto3pt ARGS((  Ppoint3 *  origin,   Ppoint3 *  xdirn,
               Ppoint3 *  ydirn,   Pcompose_type  operation,   Pmatrix3  matrix));

extern void ptk_invertmatrix3 ARGS((  Pmatrix3  mat,   Pmatrix3  invmat,
                                Pint * error));

extern void ptk_invertmatrix ARGS((  Pmatrix  mat,   Pmatrix  invmat,
                                Pint *  error));

extern Plimit3 ptk_transformlimits3 ARGS((Pmatrix3 mat, Plimit3 *lims));

extern Plimit ptk_transformlimits ARGS((Pmatrix mat, Plimit *lims));

extern Plimit3 ptk_shiftlimits3 ARGS((Ppoint3 *shift, Plimit3 *lims));

extern Plimit ptk_shiftlimits ARGS((Ppoint *shift, Plimit *lims));

extern Plimit3 ptk_scalelimits3 ARGS((Ppoint3 *scale, Plimit3 *lims));

extern Plimit ptk_scalelimits ARGS((Ppoint *scale, Plimit *lims));
