/*

                              DISCLAIMER
                              ==========

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.   

    If the software is modified by someone else and passed on, we, the authors
    want its recipients to know that what they have is not the original, so
    that any problems introduced by others will not reflect on the original
    authors' reputations.
*/                                            

#include "nurbh.h"

/*---------------------------------------------------------------------------*/
extern void nrb_phigsplus(C(PR_nurb *)nrb_in)
PreANSI(PR_nurb *nrb_in)
{
#ifdef VMS

#include <phigs.h>

  /*
    Create a structure element in PHIGS PLUS using info in NURB
  */
  Pint tempx, tempy;
  PPsurftrimdef NoTrim;
  Pfloatlst uknots, vknots;
  PPpointgrid34 cont_grid;
  PPpointlst34 ppts;
  PR_dir *tdir;
/*****
   printf("NRB_PHIGSPLUS\n");
   nrb_dump(stdout,nrb_in);
*****/
  if (nrb_in->pf_v.pf_n <= 1) {   /*Its a curve!*/
    tdir = &nrb_in->pf_u;
    uknots.number= tdir->pf_nt;
    uknots.floats = &tdir->pf_kk->knots;

    ppts.type = PPRATIONAL;
    ppts.number = tdir->pf_n;
    ppts.pts34.pt4d  = nrb_in->pf_ppp->pts;

    ppnunibspcurv(tdir->pf_k, &uknots, &ppts, tdir->pf_kk->knots[0],
	       tdir->pf_kk->knots[( tdir->pf_nt ) - 1]);
    return;
  }

  NoTrim.number = 0;
  NoTrim.loop = NULL;

  uknots.number = nrb_in->pf_u.pf_nt;
  uknots.floats = &nrb_in->pf_u.pf_kk->knots;

  vknots.number = nrb_in->pf_v.pf_nt;
  vknots.floats = &nrb_in->pf_v.pf_kk->knots;

  cont_grid.type = PPRATIONAL;
  cont_grid.u_num = nrb_in->pf_u.pf_n;
  cont_grid.v_num = nrb_in->pf_v.pf_n;

  cont_grid.pts34.pt4d = nrb_in->pf_ppp->pts;

  ppnunibspsurf(nrb_in->pf_u.pf_k, nrb_in->pf_v.pf_k, &uknots, &vknots,
	       &cont_grid, nrb_in->pf_u.pf_kk->knots[0],
	       nrb_in->pf_u.pf_kk->knots[ nrb_in->pf_u.pf_nt - 1],
	       nrb_in->pf_v.pf_kk->knots[0],
	       nrb_in->pf_v.pf_kk->knots[ nrb_in->pf_v.pf_nt - 1], &NoTrim);

#endif

/***** The port to HP-PHIGS *******/

#ifdef HP

  /*
    Create a structure element in PHIGS PLUS using info in NURB
  */
  PR_dir *tdir;
  int i;

  float *contx_pts, *conty_pts, *contz_pts, *contw_pts;

  if (nrb_in->pf_v.pf_n <= 1) {   /*Its a curve!*/

    tdir = &nrb_in->pf_u;

    /* Convert the Control Point List to single lists
    */
    contx_pts=(float*) malloc(tdir->pf_n*sizeof(float));
    conty_pts=(float*) malloc(tdir->pf_n*sizeof(float));
    contz_pts=(float*) malloc(tdir->pf_n*sizeof(float));
    contw_pts=(float*) malloc(tdir->pf_n*sizeof(float));

    for(i=0;i<tdir->pf_n;i++)
    {
      contx_pts[i]=nrb_in->pf_ppp->pts[i].x;
      conty_pts[i]=nrb_in->pf_ppp->pts[i].y;
      contz_pts[i]=nrb_in->pf_ppp->pts[i].z;
      contw_pts[i]=nrb_in->pf_ppp->pts[i].w;
    }

    pnubsc(tdir->pf_k, tdir->pf_n, tdir->pf_nt, tdir->pf_kk->knots, PRAT,
	   contx_pts, conty_pts, contz_pts, contw_pts, 
	   tdir->pf_kk->knots[0],
	   tdir->pf_kk->knots[( tdir->pf_nt ) - 1]);

    free(contx_pts);
    free(conty_pts);
    free(contz_pts);
    free(contw_pts);

    return;
  }

  /* Convert the Control Point List to single lists
   */
  contx_pts=(float*) malloc(nrb_in->pf_u.pf_n*nrb_in->pf_v.pf_n*sizeof(float));
  conty_pts=(float*) malloc(nrb_in->pf_u.pf_n*nrb_in->pf_v.pf_n*sizeof(float));
  contz_pts=(float*) malloc(nrb_in->pf_u.pf_n*nrb_in->pf_v.pf_n*sizeof(float));
  contw_pts=(float*) malloc(nrb_in->pf_u.pf_n*nrb_in->pf_v.pf_n*sizeof(float));

  for(i=0;i<nrb_in->pf_u.pf_n*nrb_in->pf_v.pf_n;i++)
  {
    contx_pts[i] = nrb_in->pf_ppp->pts[i].x;
    conty_pts[i] = nrb_in->pf_ppp->pts[i].y;
    contz_pts[i] = nrb_in->pf_ppp->pts[i].z;
    contw_pts[i] = nrb_in->pf_ppp->pts[i].w;
  }	


  pnubss(nrb_in->pf_u.pf_k, nrb_in->pf_v.pf_k,                 /* Order      */
	 nrb_in->pf_u.pf_n, nrb_in->pf_v.pf_n,                 /* Control    */
	 nrb_in->pf_u.pf_nt, nrb_in->pf_v.pf_nt,               /* Knots      */
	 nrb_in->pf_u.pf_kk->knots, nrb_in->pf_v.pf_kk->knots, /* Knots vals */
	 PRAT,
	 contx_pts,conty_pts,contz_pts,contw_pts,              /* Control val*/
	 nrb_in->pf_u.pf_kk->knots[0],                         /* umin       */
	 nrb_in->pf_u.pf_kk->knots[ nrb_in->pf_u.pf_nt - 1],   /* umax       */
	 nrb_in->pf_v.pf_kk->knots[0],                         /* vmin       */
	 nrb_in->pf_v.pf_kk->knots[ nrb_in->pf_v.pf_nt - 1],   /* vmax       */
	 0, 0);

  return;

#endif
}

