/*

                              DISCLAIMER
                              ==========

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.   

    If the software is modified by someone else and passed on, we, the authors
    want its recipients to know that what they have is not the original, so
    that any problems introduced by others will not reflect on the original
    authors' reputations.
*/                                            

#include "nurbh.h"

/*---------------------------------------------------------------------------*/
extern void nrb_starbase(C(int) fildes,C(PR_nurb *)nrb_in)
PreANSI(int fildes)
PreANSI(PR_nurb *nrb_in)
{
  /* This function posts a Manchester NURBS structure into an HP Starbase
     window.

     Martin Preston, Manchester  20/5/94 */

  /* First set the way we want to see the surface approximated by
     polygons */

  curve_resolution(fildes, 
		   STEP_SIZE, 
		   (1.0 / 20),
		   (1.0 / 20),
		   (1.0 / 20),
		   (1.0 / 20));
  
  u_knot_vector(fildes,
		nrb_in->pf_u.pf_kk->knots,
		nrb_in->pf_u.pf_nt);
  
  v_knot_vector(fildes,
		nrb_in->pf_v.pf_kk->knots,
		nrb_in->pf_v.pf_nt);
  
  spline_surface(fildes,
		 (float *) nrbin->pf_ppp->pts,
		 nrb_in->pf_u.pf_n,
		 nrb_in->pf_v.pf_n,
		 nrb_in->pf_u.pf_k,
		 nrb_in->pf_v.pf_k,
		 RATIONAL);
}

