/* ***********************************************************************
   *        SKINNING MODULE                                              *
   *   Started : 18/11/91                                                *
   *********************************************************************** */
/* Have changed :
   Updated ptk_? calls to use new version of library
   Changed pf_x & pf_v to pf_u & pf_v
         11/11/92 
   Added function skin_2to3_ordern() to allow better control
     of skinning!
         14/09/93
*/
/* #include <stdlib.h> */
/*#include <malloc.h>*/  /* Change made when trying to compile after AFS! */
#define TRUE 1
#define FALSE 0
#define NIL 0

/* MJE: I've replaced 'normalise' with 'normalise2' because a normalise() is
   used in my other code 
*/
/* Following includes by Marc Evers 19/8/96 */
#include "blending.h"
#include "skinning.h"

/* Hacks to fix for this new version of ptk
typedef PR_nurb PR_nurb4;*/

/*
Ppoint4 ptk_point4(float x, float y, float z, float w)
{
  Ppoint4 tmp;

  tmp.x = x;
  tmp.y = y;
  tmp.z = z;
  tmp.w = w;

  return(tmp);
}
*/

Pvec3 ptk_subp(Ppoint3* first,Ppoint3* second)
{
	/* Complete Hack to do part of ptk library */
/* 	Pvec3 firstv,secondv; */
	Pvec3 temp;
	Ppoint3 tmpp;

	tmpp = ptk_subv3(first,second);
	temp = ptk_pt3tovec3(&tmpp);
	return(temp);
}

void ptk_absv3(Ppoint3* input)
{
	/* Another function in the popular 'make ptk work' series */
	/* This calculates the absolute/positive value of vector */
	input->x = (input->x < 0) ? (input->x * -1) : input->x;
	input->y = (input->y < 0) ? (input->y * -1) : input->y;
	input->z = (input->z < 0) ? (input->z * -1) : input->z;
}

void CreateNewSection(SectionRecord *the_list, 
		 PR_nurb *the_nurb, 
		 float the_t)
{
	/* This function adds a NURB onto the end of a section list */
	SectionRecord *current;

	current = the_list;
	while((current->next != NIL) && (current->t != -1))
		current = current->next;

	if((current->next == NIL) && (current->t != -1))
	{
         
#ifdef __cplusplus
		current->next = new SectionRecord;
#else
		current->next = (SectionRecord *) malloc(sizeof(SectionRecord)); /* Marc Evers 19/8/96 */
#endif
		current = current->next;	
	}
	nrb_copy(the_nurb,&current->nurb);
	current->t = the_t;
	current->next = NIL;
}

void CreateSectionList(SectionRecord **the_list)
{
	/* This function creates a section list */
/* MJE 19/8/96 */
#ifdef __cplusplus
	*the_list = new SectionRecord;
#else
	*the_list = (SectionRecord *) malloc(sizeof(SectionRecord));
#endif
	nrb_clear(&(*the_list)->nurb);
	(*the_list)->t = -1;
	(*the_list)->next = NIL;
}

int knot_ind(int num, int order)
{
	/* This simple function calculates an index into the knot record of
	   a particular knot */
	return((order-1)+num);
}

void normalise2(SectionRecord *sections,int direction,int num_sections,int *max_order,
	  int *max_pts,int *end_numpts,PR_nurb* temp_nurb2)
{
	/* This procedure normalises a section list,ie it ensures everything is 
    elevated to the correct order,and all sections have the correct 
    number of control points .

    If called with direction = TRUE it normalises everything in the x
    direction,and in the y if direction = FALSE. */

	int current_section,i; 
	PR_nurb temp_nurb,knot_nurb;
	SectionRecord *list;

	*max_order = *max_pts = *end_numpts = 0;
	list = sections;

	nrb_clear(&temp_nurb);

	if(direction)
	{
		/* Necessary to tranpose everything */
		for(current_section=1; current_section<=num_sections;current_section++)
		{
			nrb_transpose(&list->nurb);
			list = list->next;
		}
	}
	list = sections;
	for(current_section=1; current_section<=num_sections; current_section++)
	{
		if(list->nurb.pf_u.pf_k > *max_order)
			*max_order = list->nurb.pf_u.pf_k;
		list = list->next;	
	}

	list = sections;
	/* Now change required parts */
	for(current_section=1; current_section<=num_sections;current_section++)
	{
		while(list->nurb.pf_u.pf_k < *max_order)
		{
			nrb_clear(&temp_nurb);
			nrb_elevate(FALSE,&list->nurb,&temp_nurb);
			nrb_copy(&temp_nurb,&list->nurb);
		}
		if(list->nurb.pf_u.pf_n > *max_pts)
		{
			*max_pts = list->nurb.pf_u.pf_n;
			*end_numpts += list->nurb.pf_u.pf_n;
		}
		list = list->next;

	}
	list = sections;
	
	/* Now initialise */
	temp_nurb2->pf_u.pf_k = *max_order;
	temp_nurb2->pf_u.pf_n = list->nurb.pf_u.pf_n;
	temp_nurb2->pf_u.pf_nt = temp_nurb2->pf_u.pf_n + temp_nurb2->pf_u.pf_k;
	temp_nurb2->pf_u.pf_kk = NIL;

	temp_nurb2->pf_v.pf_k = list->nurb.pf_v.pf_k;
	temp_nurb2->pf_v.pf_n = list->nurb.pf_v.pf_n;
	temp_nurb2->pf_v.pf_nt = temp_nurb2->pf_v.pf_n + temp_nurb2->pf_v.pf_k;
	temp_nurb2->pf_v.pf_kk = NIL;

	temp_nurb2->pf_ppp = NIL;

	temp_nurb.pf_u.pf_k = *max_order;
	temp_nurb.pf_u.pf_n = list->nurb.pf_u.pf_n;
	temp_nurb.pf_u.pf_nt = temp_nurb2->pf_u.pf_n + temp_nurb2->pf_u.pf_k;
	temp_nurb.pf_u.pf_kk = NIL;

	temp_nurb.pf_v.pf_k = list->nurb.pf_v.pf_k;
	temp_nurb.pf_v.pf_n = list->nurb.pf_v.pf_n;
	temp_nurb.pf_v.pf_nt = temp_nurb2->pf_v.pf_n + temp_nurb2->pf_v.pf_k;
	temp_nurb.pf_v.pf_kk = NIL;

	temp_nurb.pf_ppp = NIL;

	nrb_allocateknots(&temp_nurb2->pf_u);
	nrb_allocateknots(&temp_nurb2->pf_v);
	nrb_allocateknots(&temp_nurb.pf_u);
	nrb_allocateknots(&temp_nurb.pf_v);
	nrb_allocatepts((temp_nurb2->pf_u.pf_nt*temp_nurb2->pf_v.pf_nt)*2,
                  &temp_nurb2->pf_ppp);
	nrb_allocatepts((temp_nurb.pf_u.pf_nt*temp_nurb.pf_v.pf_nt)*2,
                  &temp_nurb.pf_ppp);
	for(i=0; i< (temp_nurb2->pf_u.pf_nt*temp_nurb2->pf_v.pf_nt*2); i++)
	{
		temp_nurb.pf_ppp->pts[i] = ptk_point4(0.0,0.0,0.0,0.0);
		temp_nurb2->pf_ppp->pts[i] = ptk_point4(0.0,0.0,0.0,0.0);
	}
	for(i=0; i<list->nurb.pf_u.pf_nt; i++)
		temp_nurb2->pf_u.pf_kk->knots[i] =
			list->nurb.pf_u.pf_kk->knots[i];
	for(i=0; i<list->nurb.pf_v.pf_nt; i++)
		temp_nurb2->pf_v.pf_kk->knots[i] =
			list->nurb.pf_v.pf_kk->knots[i];
	nrb_copy(temp_nurb2,&knot_nurb);

	list = sections;
	for(current_section=1; current_section<=num_sections; current_section++)
	{
		nrb_unionknots(&list->nurb.pf_u,&temp_nurb2->pf_u,&knot_nurb.pf_u);
		nrb_copyknots(&knot_nurb.pf_u,&temp_nurb2->pf_u);
		list = list->next;
	}

	list = sections;
	for(current_section=1; current_section<=num_sections; current_section++)
	{
		/* Perform Oslo algorithm to increase pts */
		nrb_copyknots(&list->nurb.pf_v,&temp_nurb2->pf_v);
		nrb_copy(temp_nurb2,&temp_nurb);
/*		nrb_osloc(&list->nurb,temp_nurb2);
		nrb_transpose(temp_nurb2);*/
/* MJE 20/8/96: added the nrb_allocatepts, needed for RefineSurface.
   The memory management is a bit messy at the moment...
*/
    nrb_allocatepts( 2*(temp_nurb2->pf_u.pf_nt - temp_nurb2->pf_u.pf_k) * 
		     (temp_nurb2->pf_v.pf_nt - temp_nurb2->pf_v.pf_k),
		     &temp_nurb2->pf_ppp );

	    RefineSurface( &list->nurb, temp_nurb2, TRUE );

		nrb_clear(&list->nurb);	
		nrb_copy(temp_nurb2,&list->nurb);
		nrb_copy(&temp_nurb,temp_nurb2);
		list = list->next;
	}
	list = sections;

	if(direction)
	{
		/* Necessary to tranpose everything */
		for(current_section=1; current_section<=num_sections;
		    current_section++)
		{
			nrb_transpose(&list->nurb);
			list = list->next;
		}
	}
}

void skin_2to3(SectionRecord *sections,PR_nurb *spine,int translate,
	  PR_nurb *out)
{
	int current_section,num_sections,current_knot,end_numpts;
	int max_order,max_pts;
	Pmatrix3 current_matrix;
	PR_nurb temp_nurb, temp_nurb2;
	SectionRecord *list;
	Ppoint3 q1;
	Ppoint3 current_point,next_point,last_point;
	Ppoint3 normal, q2,q3, tempv;
	Ppoint3 dir1, dir2, direction, orientation;
	int pt,i;

	max_order = max_pts = end_numpts = 0;
	current_knot = 1;
	list = sections;

	num_sections = spine->pf_u.pf_n;
	/* Traverse list to determine settings */
	normalise2(list,FALSE,num_sections,&max_order,&max_pts,&end_numpts,&temp_nurb2);
	/* Initialise the output */
	nrb_clear(out);
	nrb_clear(&temp_nurb);

	/* Fill in the output NURB */
	out->pf_u.pf_k = max_order;
	out->pf_u.pf_n = end_numpts;
	out->pf_u.pf_nt = max_order + end_numpts;
		/* The unioned knots should already have been filled in */
	out->pf_v.pf_n = spine->pf_u.pf_n;
	out->pf_v.pf_k = spine->pf_u.pf_k;
	out->pf_v.pf_nt = spine->pf_u.pf_n + spine->pf_u.pf_k;

	nrb_allocateknots(&out->pf_u);
	nrb_allocateknots(&out->pf_v);
	nrb_allocatepts((out->pf_u.pf_n)*(out->pf_v.pf_n),&out->pf_ppp);
	
	/* Now copy x knots from so_far into x knots of output */
	for(i=0; i<temp_nurb2.pf_u.pf_nt; i++)
		out->pf_u.pf_kk->knots[i] = list->nurb.pf_u.pf_kk->knots[i];
	/* Now copy x knots from spine into y knots of output */
	for(i=0; i<(out->pf_v.pf_nt); i++)
		out->pf_v.pf_kk->knots[i] = spine->pf_u.pf_kk->knots[i];
	list = sections;

	for(current_section=1; current_section<=num_sections; current_section++)
	{
	  if(translate)
		{
			/* Calculate current position */
			current_point =ptk_pt4topt3(&spine->pf_ppp->pts[current_section]);
			if(current_section==num_sections)
				next_point=ptk_pt4topt3(&spine->pf_ppp->pts[1]);
			else
				next_point=ptk_pt4topt3(&spine->pf_ppp->pts[current_section+1]);
			if(current_section==1)
				last_point=ptk_pt4topt3(&spine->pf_ppp->pts[num_sections]);
			else
				last_point=ptk_pt4topt3(&spine->pf_ppp->pts[current_section-1]);
			/* Place section at correct point by ... */
			dir1 = ptk_subv3(&next_point,&current_point);
			dir2 = ptk_subv3(&current_point,&last_point);
		        dir1 = ptk_addv3(&dir2,&dir1);
			direction = ptk_scalev3(&dir1,0.5);

			/* Calculate normal */
			dir2 = ptk_point3(0.0,0.0,1.0);
			dir1 = ptk_crossv3(&direction,&dir2);   /* Temporary normal */
			orientation = ptk_point3(0.0,0.0,1.0);
			ptk_absv3(&dir1);

			/* Calculate translations */

			q1 = current_point;
			tempv = q1;
			q2 = ptk_addv3(&dir1,&tempv);
			q3 = ptk_addv3(&direction,&tempv);
			normal = ptk_unitv3(&dir1);

			tempv = current_point;
			dir1 = ptk_addv3(&dir2,&tempv);
			dir2 = ptk_addv3(&normal,&tempv);

			ptk_0to3pt(&current_point,&dir1
				,&dir2
				,PTYPE_REPLACE,current_matrix);
			nrb_xform(&list->nurb,current_matrix);
		}
		/* Add to NURB structure */

		for(pt=1; pt<=max_pts; pt++)
		{
			out->pf_ppp->pts[nrb_index(pt,current_section,max_pts)-1]
			  = list->nurb.pf_ppp->pts[nrb_index(pt,1,max_pts)-1];
		}
		list = list->next;
	}
}

void skin_2to3_ordern(SectionRecord *sections,
		      int num_slices,
		      int order,
		      PR_nurb *out)
{
  /* the num slices determines the number of items in the sections list */

  int current_section,num_sections,current_knot,end_numpts;
  int max_order,max_pts;
  PR_nurb temp_nurb, temp_nurb2;
  PR_nurb *spine;
  SectionRecord *list;

  int pt,i;
  
  max_order = max_pts = end_numpts = 0;
  current_knot = 1;
  list = sections;

  /* Traverse list to determine settings */

  normalise2(list,FALSE,num_slices,&max_order,&max_pts,&end_numpts,&temp_nurb2);

  /* Initialise the output */

  nrb_clear(out);
  nrb_clear(&temp_nurb);
  nrb_allocatenurb(&spine);

  spine->pf_u.pf_k = order;
  spine->pf_u.pf_n = num_slices;
  spine->pf_u.pf_nt = order + num_slices;

  /* Fill in the output NURB */

  out->pf_u.pf_k = max_order;
  out->pf_u.pf_n = end_numpts;
  out->pf_u.pf_nt = max_order + end_numpts;

  /* The unioned knots should already have been filled in */

  out->pf_v.pf_n = spine->pf_u.pf_n;
  out->pf_v.pf_k = spine->pf_u.pf_k;
  out->pf_v.pf_nt = spine->pf_u.pf_n + spine->pf_u.pf_k;
  
  /* Now generate the knots. First generate the spine knots, which are order = 2 */
  nrb_allocateknots(&spine->pf_u);

  nrb_allocateknots(&out->pf_u);
  nrb_allocateknots(&out->pf_v);
  nrb_allocatepts((out->pf_u.pf_n)*(out->pf_v.pf_n),&out->pf_ppp);
  
  /* Now copy x knots from so_far into x knots of output */

  for(i=0; i<temp_nurb2.pf_u.pf_nt; i++)
    out->pf_u.pf_kk->knots[i] = list->nurb.pf_u.pf_kk->knots[i];

  /* Now copy x knots from spine into y knots of output */

  for(i=0; i<(out->pf_v.pf_nt); i++)
    out->pf_v.pf_kk->knots[i] = spine->pf_u.pf_kk->knots[i];
  list = sections;
  
  for(current_section=1; current_section<=num_slices; current_section++)
  {
    /* Add to NURB structure */
    
    for(pt=1; pt<=max_pts; pt++)
    {
      out->pf_ppp->pts[nrb_index(pt,current_section,max_pts)-1]
	= list->nurb.pf_ppp->pts[nrb_index(pt,1,max_pts)-1];
    }
    list = list->next;
  }
}

void skin_3to4(SectionRecord *sections,PR_nurb4 *out)
{
	/* This function takes several 3D sections and creates a 4D NURB */
	PR_nurb temp_nurb, spine;
	SectionRecord *xlist, *list;
	int num_sections,max_order,max_pts,end_numpts, position;
	int i,ind, num_slices;
	PR_nurb *nurb_list;
	
	/* Hack to fool HP C++ */

	Pfloat nought = 0.0;
	Pfloat one = 1.0;

	nrb_clear(out);
	nrb_clear(&temp_nurb);
	list = sections;
	nrb_clear(&spine);
	num_sections = position = num_slices = 0;
	
	while(list != NIL)
	  {
	    num_sections++;
	    list = list->next;
	  }

	list = sections;
	normalise2(list,FALSE,num_sections,&max_order,&max_pts,&end_numpts,&temp_nurb);
	nrb_clear(&temp_nurb);
	list=sections;
	normalise2(list,TRUE,num_sections,&max_order,&max_pts,&end_numpts,&temp_nurb);

	nrb_clear(&temp_nurb);
	list=sections;
	
	nrb_copy(&list->nurb,out);
	/*	nrb_copyknots(&list->nurb.pf_u,&out->pf_u);
		nrb_copyknots(&list->nurb.pf_v,&out->pf_v);  */
	out->pf_next = 0;
	out->pf_ppp = 0;
	nrb_allocatepts((out->pf_u.pf_n)*(out->pf_v.pf_n),&out->pf_ppp);
	nrb_allocatenurb(&out->pf_next);    /* Make space for next 3D slice */
	nurb_list = out->pf_next;
	num_slices = list->nurb.pf_u.pf_n;
	
	for(i=1; i<= num_slices; i++)
	  {
	    /* create section lists */
	    xlist = 0;
	    CreateSectionList(&xlist);
	    list = sections;
	    while(list != NIL)
	      {
		nrb_clear(&temp_nurb);
		nrb_copyknots(&list->nurb.pf_v,&temp_nurb.pf_u);
		temp_nurb.pf_v.pf_n = 1;
		temp_nurb.pf_v.pf_k = 0;
		temp_nurb.pf_v.pf_nt = 1;
		temp_nurb.pf_v.pf_kk = NIL;

		nrb_allocateknots(&temp_nurb.pf_v);
		nrb_allocatepts(temp_nurb.pf_u.pf_n*temp_nurb.pf_v.pf_n,&temp_nurb.pf_ppp);

		for(ind=1; ind <= temp_nurb.pf_u.pf_n; ind++)
		  temp_nurb.pf_ppp->pts[nrb_index(ind,1,temp_nurb.pf_u.pf_n)-1]
		    =list->nurb.pf_ppp->pts[nrb_index(i,ind,list->nurb.pf_u.pf_n)-1];

		CreateNewSection(xlist,&temp_nurb,0.0);
		list = list->next;
	      }
	    nrb_clear(&spine);
	    spine.pf_u.pf_k = num_sections;
	    spine.pf_u.pf_n = num_sections;
	    spine.pf_u.pf_nt = spine.pf_u.pf_n + spine.pf_u.pf_k;
	    spine.pf_u.pf_kk = NIL;
	    spine.pf_v.pf_n = 1;
	    spine.pf_v.pf_k = 0;
	    spine.pf_v.pf_nt = 1;
	    spine.pf_v.pf_kk = NIL;
	    
	    nrb_allocateknots(&spine.pf_u);
	    nrb_allocateknots(&spine.pf_v);
	    nrb_makeknots(nought,one,&(spine.pf_u)); 
	    nrb_allocatepts((spine.pf_u.pf_n)*(spine.pf_v.pf_n),&spine.pf_ppp);

	    skin_2to3(xlist,&spine,FALSE,nurb_list);

	    nrb_allocatenurb(&nurb_list->pf_next);
	    nurb_list = nurb_list->pf_next;
	    nurb_list->pf_next = 0;
	  }
      }

void sskin_3to4(SectionRecord *sections,PR_nurb *spine,PR_nurb4 *out)
{
  /* This function creates a 4D NURB from multiple 3D sections,
     however this version of the routine requires you to pass it a spine
     for use in creating the 4D */
  PR_nurb temp_nurb;
  SectionRecord *xlist, *list;
  int num_sections,max_order,max_pts,end_numpts, position;
  int i,ind;
  PR_nurb *nurb_list;

  int num_times; /* moved to here, MJE 19/8/96 */ 

  nrb_clear(out);
  nrb_clear(&temp_nurb);

  list = sections;
  nurb_list = NIL;
  num_sections = position = 0;
  while(list)
    {

      num_sections++;
      list = list->next;
    }

  list=sections;
  normalise2(list,FALSE,num_sections,&max_order,&max_pts,&end_numpts,&temp_nurb);
  nrb_clear(&temp_nurb);
  list=sections;
  normalise2(list,TRUE,num_sections,&max_order,&max_pts,&end_numpts,&temp_nurb);
  nrb_clear(&temp_nurb);

  list=sections;
  nrb_copyknots(&list->nurb.pf_u,&out->pf_u);
  nrb_copyknots(&list->nurb.pf_v,&out->pf_v);
  nrb_allocatepts((out->pf_u.pf_n)*(out->pf_v.pf_n),&out->pf_ppp); 
  nrb_allocatenurb(&out->pf_next);   
  nurb_list = out->pf_next;

      /* Code added to fix a 3 year old bug! */
/*  int num_times = list->nurb.pf_u.pf_n; */
  num_times = list->nurb.pf_u.pf_n; /* Marc Evers 19/8/96 */

  for(i=1; i<=num_times; i++)
    {
      /* Need to create lists */
      xlist = 0;
      CreateSectionList(&xlist);
      list = sections;
      while(list != NIL)
	{
	  nrb_clear(&temp_nurb);
	  nrb_copyknots(&list->nurb.pf_v,&temp_nurb.pf_u);

	  temp_nurb.pf_v.pf_n = 1;
	  temp_nurb.pf_v.pf_k = 0;
	  temp_nurb.pf_v.pf_nt = 1;
	  temp_nurb.pf_v.pf_kk = NIL;
	  nrb_allocateknots(&temp_nurb.pf_v);
	  nrb_allocatepts((temp_nurb.pf_u.pf_n)*(temp_nurb.pf_v.pf_n),
			  &temp_nurb.pf_ppp); 

	  for(ind=1; ind<=temp_nurb.pf_u.pf_n; ind++)
	    temp_nurb.pf_ppp->pts[nrb_index(ind,1,temp_nurb.pf_u.pf_n)-1]
	      =list->nurb.pf_ppp->pts[nrb_index(i,ind,list->nurb.pf_u.pf_n)-1];

	  CreateNewSection(xlist,&temp_nurb,0.0);
	  list = list->next;
	}
      /* This used to say &xlist, have changed! */

      skin_2to3(xlist,spine,FALSE,nurb_list);
printf("Created one of the slices of the hyper-surface\n");
      nrb_allocatenurb(&nurb_list->pf_next);
      nurb_list = nurb_list->pf_next;
      nurb_list->pf_next = NIL;
    }
}

void evaluate_4to3(PR_nurb4 *the_nurb,float t,PR_nurb *out)
{
  /* This function evaluates a 4D NURB at a particular point int time to
     produce a 3D nurb surface */
  PR_nurb temp_nurb,temp_nurb2;
  int i,xval;
  PR_nurb *current;

/*   SectionRecord *the_list; */
  
  nrb_clear(out);
  nrb_clear(&temp_nurb);
  nrb_clear(&temp_nurb2);

  nrb_copy(the_nurb,out);

  if(out->pf_ppp)   /* If necessary free the space */
    nrb_deallocatepts(&(out->pf_ppp));

  out->pf_ppp = 0;
  out->pf_next = 0;

  nrb_allocatepts((out->pf_u.pf_n)*(out->pf_v.pf_n),&out->pf_ppp);
  current = the_nurb->pf_next;
  
  /* Now we need to copy the points across */

  for(xval=1; xval <= (out->pf_u.pf_n); xval++)
  {
    nrb_clear(&temp_nurb2);
    nrb_copy(current,&temp_nurb); /* Make a copy */
/*nrb_dump(stdout, &temp_nurb);*/
    nrb_transpose(&temp_nurb);
/*nrb_dump(stdout, &temp_nurb);*/
    nrb_evaluate(&temp_nurb,t,&temp_nurb2);
/*nrb_dump(stdout, &temp_nurb2);*/

    for(i=1; i<=temp_nurb2.pf_u.pf_n; i++)
      out->pf_ppp->pts[nrb_index(xval,i,out->pf_u.pf_n)-1]
        =temp_nurb2.pf_ppp->pts[nrb_index(i,1,temp_nurb2.pf_u.pf_n)-1];


    current = current->pf_next;

    /* Now need to clear up space taken by NURBS */

    nrb_deallocatepts(&temp_nurb2.pf_ppp);
    nrb_deallocateknots(&temp_nurb2.pf_u);
    nrb_deallocateknots(&temp_nurb2.pf_v);
    nrb_deallocatepts(&temp_nurb.pf_ppp);
    nrb_deallocateknots(&temp_nurb.pf_u);
    nrb_deallocateknots(&temp_nurb.pf_v);
  }

}

/* End of Skinning module */







