/* Skinning.h : Header file for skinning routines */

/*
** Modified by Marc Evers, 22/8/96
**  I've put in the ifndef/define just in case this
**  header file is included multiple times
*/

#ifndef __SKINNING_H__
#define __SKINNING_H__

typedef struct SectionRecord 
{
	PR_nurb nurb;
	float t;
	struct SectionRecord *next;
}SectionRecord;

typedef PR_nurb PR_nurb4;

/* Ppoint4 ptk_point4(float x, float y, float z, float w); */
Pvec3 ptk_subp(Ppoint3* first, Ppoint3 * second);
void ptk_absv3(Ppoint3* input);
void CreateNewSection(SectionRecord *the_list, 
		 PR_nurb *the_nurb, 
		 float the_t);
void CreateSectionList(SectionRecord **the_list);
void skin_2to3(SectionRecord *sections,PR_nurb *spine,int translate,
	  PR_nurb *out);
void skin_2to3_ordern(
		      SectionRecord *sections,
		      int num_slices,
		      int order,
		      PR_nurb *out);
void skin_3to4(SectionRecord *sections,PR_nurb4 *out);
void sskin_3to4(SectionRecord *sections,PR_nurb *spine,PR_nurb4 *out);
void evaluate_4to3(PR_nurb4 *the_nurb,float t,PR_nurb *out);


#endif

