c make figures 2 and 3 of the paper on dust lanes
c
      character fich*100, device*100, string*100
      integer ndimx, ndimy
      real ptime
      real arho (1000, 1000) 
c
      common/rhomap/ rho(52164) 
      common/header/ dx, dy, nx, ny,ttime, dtlim, nxp1, nyp1, nxp2, nyp2
      common/header/ nstep, l1d, nsame, nrho, nvelo, xcen, ycen, a, ainv
      common/header/ asq, omega, domega, nprtyp, nprdmp, nbclas 
      common/header/ nbprint(4), name(20)
      logical lend
      data lend/.false./, ndump/99999/
 
      print *,'file name?'
      read '(a)', fich
      iunit = 1
      open (unit = iunit, file = fich, status = 'old', 
     &      form = 'unformatted')
      print *,' ndump = ?'
      read *, ndump
      npen=1
      inpic=1 
      iold=1
      indump = ndump            !- nread
      call reader (indump, lend, nread)
      close (iunit)
      print *, nx, ny
      ndimx = max (nx, ny)
      ndimy = ndimx
c
      print *, ndimx, ndimy
      print *,'number of frames accross (=nx) and down (=ny)'
      print *, 'device for plots?'
      read '(a)', device
      print '(a)', device
      call pgbegin(0, device, 1, 1)
      call pgadvance

c      print *,' do you want the scaling to be done'
c      print *,' from the values of the density :'
c      print *,' within the square grid ===> 1'
c      print *,' within the largest circle within that square ===> 2'
c      print *,' from the outer parts only (r>6.) ===> 3'
c      read *, ibound
      ibound = 1
      iunit = 1
c      print *,' number of pixels to be plotted in x and in y'
c      read *, ncx, ncy
      ncx = 160
      ncy = 160

      open (unit = iunit, file = fich, status = 'old', 
     &      form = 'unformatted')


      call pgvport (0.25, 0.49, 0.51, 0.85)
      call pgsch (0.7)
      print '(a)', fich
      call grdick (fich, ndump, ibound, ncx, ncy, 
     $     ndimx, ndimy, arho, ptime)
      call pgbox('bcnts',0.0,0,'bcnts',0.0,0)
      call pglabel('x (kpc)','y (kpc)',' ')
      call pgsch (1.0)
c      call pgsci(5)
c      call pgmtext('t',1.0,0.0,0.0, fich)
c      call pgnumb (int (ptime * 100.), -2, 1, string, nc)
c      call pgmtext('t',1.0, 0.8, 0.0, string( 1 : nc))
c      call pgsci(1)
 
c
      rewind iunit
      call pgvport (0.51, 0.75, 0.51, 0.85)
      call pgsch (0.7)
      call vect (fich, ndump)
      call pglabel('x (kpc)',' ',' ')
      call pgsch (1.0)



      call pgend

      stop
      end
c-----------------------------------------------------------------------
      subroutine reader(nodump, lend, nold)
c-----------------------------------------------------------------------
c-----------------------------------------------------------------------
      common/header/ dx, dy, nx, ny, time, dtlim, nxp1, nyp1, nxp2, nyp2
      common/header/ nstep, l1d, nsame, nrho, nvelo, xcen, ycen, a, ainv
      common/header/ asq, omega, domega, nprtyp, nprdmp, nbclas
      common/header/ nbtype(4), name(20)
      logical lend
c
c  reader reads the nodump-th dump after the current dump.
c  if the desired dump number cannot be found, the program crashes.
c
   15 nread = nodump
      nodump = 0
      do 1 i = 1, nread
         call rddmp(lread, ierr)
         nodump = nodump + lread
         if (lread .eq. 0) go to 10
         if (ierr .gt. 0) go to 20
    1    continue
      go to 2
   10 write(6, 602)
      lend = (nodump .eq. 0)
      go to 2
   20 write(6, 603)
      if (nodump .eq. 0) stop
      rewind 1
      nodump = nold + nodump
      nold = 0
      write(6, 605)
  605 format(' rewound input file, attempting to use last good dump')
      go to 15
    2 write(6, 604) time,nstep,nx,dx,ny,dy,nprtyp
      nold = nold + nodump
      nsame = nold
      return
  602 format('0end of input file encountered')
  603 format('0read error on input file.')
  604 format('0desired dump now in core.'/
     1   ' time =',f11.6,' , nstep =',i5,' , size =',i4,' * ',f8.5,
     2   ' pc by',i4,' * ',f8.5,' pc . type =',a10)
      end

c-----------------------------------------------------------------------
      subroutine vect (fich, ndump)
c-----------------------------------------------------------------------
c-----------------------------------------------------------------------

      character fich*100

      common/bonval/ redfac(4), nleft(160), nright(160), nup(160)
      common/bonval/ nlow(160), rleft(160), rright(160), rup(160)
      common/bonval/ rlow(160), uleft(160), uright(160), uup(160)
      common/bonval/ ulow(160), vleft(160), vright(160), vup(160)
      common/bonval/ vlow(160)
      common/rhomap/ rho(17000)
      common/velmap/ vx(34000)
      common/header/ dx, dy, nx, ny, time, dtlim, nxp1, nyp1, nxp2, nyp2
      common/header/ nstep, l1d, nsame, nrho, nvelo, xcen, ycen, a, ainv
      common/header/ asq, omega, domega, nprtyp, nprdmp, nbclas
      common/header/ nbtype(4), name(20)
      common/reals/ xll,yll,xur,yur,xsca,ysca,dcon(60),ddash(60),
     1              vcon(40),vdash(40),x0l,y0l,dxl,dyl,glev(7),
     2              anmax,scvx,scvy,random,dxi,dyi,x,y,ux,uy,xpl,ypl,
     3              old1,old2,off,oldxsc,oldysc,xllm,yllm,xurm,yurm,
     4              xpc,ypc,da,db,randx,randy,posan,xtxt,
     5              rcon(40),rdash(40),tcon(40),tdash(40)
      common/fixed/ npen,ndcont,nvcont,nlines,nplin,inx,iny,npic,nprint,
     1              nrcont,ntcont
      common/logics/ lrando,lcen,lbtype
      logical lrando,lcen,lbtype
      logical lend
      character*4 key,key1,key2,key3,key4,key5,key6,key7,key8,key9
      character fich1*5
      character cname*80
      equivalence (cname,name)
      data lend/.false./, key6/'radi'/, key7/'tang'/
      data  nread/0/
c open the files
      open(unit=10,file='scr01.dat',status='scratch',disp='delete')
      open(unit=11,file='scr02.dat',status='scratch',disp='delete')
      open(unit=16,file='gaspgplt.prt')

c
 8888 npen = 2
      p2 = 0.
      npen = max0(1, min0(4, npen))
c                                      start a new frame ?
      npic = 0
c                                      read a new dump.
      nread = 0
      ndunp = 999
      indump = ndump - nread
      write (16, *) 'read dump # ', ndump
      call reader(indump, lend, nread)
      if (lend) go to 9999
      write(16, 667) name
  667 format('0problem name =====',20a4,'=====')
c                                      plot flow lines.
      call deflow
      nlines = p2
      call setsca
      call flows
c
c                                      velocity vector plot
      npen = 1
      call defect
      call setsca
      call vector
 9999 continue
      return
      end
c----------------------------------------------------------------------------
      subroutine grdick (fich, ndump, ibound, ncx, ncy, 
     &                   ndimx, ndimy, arho, ptime)
c----------------------------------------------------------------------------
c----------------------------------------------------------------------------
c  program to make grey scale plots of the density maps
c for ibound = 3 the inner parts (r<6) will be set equal to a mean value, to 
c give a better chance to the outer parts
c 
      integer ndimx, ndimy
      character fich*100
      real ptime
      real arho (ndimx, ndimy)
c
      integer ncx, ncy, nx1, nx2, ny1, ny2, na
      real length
      real  tr (6)
c 
      common/rhomap/ rho(52164) 
      common/header/ dx, dy, nx, ny,ttime, dtlim, nxp1, nyp1, nxp2, nyp2
      common/header/ nstep, l1d, nsame, nrho, nvelo, xcen, ycen, a, ainv
      common/header/ asq, omega, domega, nprtyp, nprdmp, nbclas 
      common/header/ nbprint(4), name(20)
      logical lend
      data lend/.false./
c 
         open(unit=10,file='scr01.dat',status='scratch')
         open(unit=11,file='scr02.dat',status='scratch')
         int10 = 10
         npen=1
         inpic=1 
         iold=1
         indump = ndump     !- nread
         write(16, 602) ndump
  602    format('0read dump #',i4) 
         call reader (indump, lend, nread)
         print *,' time = ', ttime
         ptime= ttime
c         if (ndimx .eq. 160) call reader (indump, lend, nread)
c         if (ndimx .eq. 320) call readerb (indump, lend, nread)
         write(16, 667) name 
  667    format(' =====', 21a4, '=====')
10       continue
c
         close(unit=10)
         close(unit=11)
c
         nxp2=nx+2 
         rhomx=0.
         rhomn=10000.
         do i=1,ny
            do j=1,nx
               n=(nx+2)*(i-1)+j+nx+2
               arho(j+nx,i)=rho(n)
               r=sqrt((float(j)-xcen)**2+(float(i)-ycen)**2)
               rm = max (xcen, ycen)
               if ((ibound .eq. 1) .or.
     &              ((ibound .eq. 2) .and. (r .lt. 0.95 * rm)) .or.
     &              ((ibound. eq. 3) .and. (r .gt. 6. * rm / 16.) .and.
     &                                 (r .lt. 0.95 * rm))) then 
                  if(rho(n).gt.rhomx) then
                     rhomx=rho(n)
                     ismax=i
                     jsmax=j
                  end if
                  if(rho(n).lt. rhomn) then
                     rhomn=rho(n)
                     ismin=i
                     jsmin=j
                  end if
               end if
            end do
         end do
         if (rhomn .le. 1.e-8) rhomn = 1.e-8        
         do i=1,ny
            do j=1,nx
               arho(j,i)=arho(2*nx-j+1,ny-i+1) 
            end do
         end do
         print *, nx, ny
         nnxy=max(nx,ny)
         if(nnxy.gt.min(ndimx, ndimy)) stop 'too small dimensions'
         do i=1,nnxy
            do j=1,nnxy
               if( arho(j,i).le.0.0) arho(j,i)=1.e-8
               arho(j,i)= alog10( arho(j,i))
            end do
         end do
         rhomn=alog10(rhomn)
         rhomx=alog10(rhomx)
         fmin=rhomn
         fmax=rhomx
c
c clear the screen. set up window and viewport.
c
         length = 0.5 * nnxy * max (dx, dy)
         call pgwnad(-length, length, -length, length)
c
c
c draw the map.  
c
         na = (nnxy - ncx) / 2
         nx1 = na + 1
         nx2 = na + ncx
         na = (nnxy - ncy) / 2
         ny1 = na + 1
         ny2 = na + ncy
c         tr (2) = float (ndimx) / float (ncx)
c         tr (3) = 0.0
c         tr (1) = - tr (2) * nx1

c         tr (5) = 0.0
c         tr (6) = float (ndimy) / float (ncy)
c         tr (4) = - tr (6) * ny1

         tr(1) = - length - 0.5 * dx
         tr(2) = dx
         tr(3) = 0.0

         tr(4) = - length - 0.5 * dy
         tr(5) = 0.0
         tr(6) = dy
         black=fmin
         white=fmax
         call pggray (arho, ndimx, ndimy, nx1, nx2, ny1, ny2, 
     &                black, white, tr)

      return
      end

c-----------------------------------------------------------------------
      subroutine rddmp(lread,ierr)
c-----------------------------------------------------------------------
c-----------------------------------------------------------------------
c
c  rddmp attempts to read a dump from the input file 1.
c   it can be called from either read10, or read11.
c   if an end-of-file is encountered before any data have been
c   overwritten an ierr of -1 will be returned.
c    if an eof or an error is found in the middle of the dump
c   an ierr .ge. 1 is returned.  if the dump has been read
c   succesfully ierr is set to 0.
c
      common/saver/ sdx, sdy, nix, niy, ncomp
c
c  sdx,sdy,nix and niy should be zero initially
c
      common/header/ dx(49)
      common/bonval/ redfac(5124)
      common/spec02/ len2(2)
      common/rhomap/ rho(52164)
      common/velmap/ vxy(104328)
      dimension text(22)
      common/dumpid/ mtype, ltype, ilen, iseq, istep, istart, xdattim(6)
        character*24 dattim
        equivalence (dattim(1:1),xdattim(1))
        real atype(12)
        equivalence (atype(1),mtype)
      equivalence (nprdmp, dx(24)),(nx, dx(3)),(ny, dx(4))
      ierr = 0
      lread = 0
        int10=12
   10 call buffin(1,atype, 12,ierr)
       write(6, 1234)mtype,ltype,ilen,iseq,istep,istart,dattim
 1234   format(1h ,i2,1x,a,1x,4i6,1x,a24)
      i = ierr-1
      if (i) 1, 2, 3
    3 ierr = -2
      return
    2 ierr = -1
      return
    1 go to (100, 200, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6),mtype
    6 ierr = mtype + 10
      return
  100 call buffin (1,text,ilen,ierr)
      i = ierr-1
      write(6, 601) istep,(text(j), j = 1, ilen)
  601 format(' history record, step #',i5,' - ',22a4)
      if (i) 10, 2, 3
  200 call buffin(1,dx,ilen,ierr)
      if (ierr-1) 210, 2, 4
    4 ierr = 2
      return
  210 call buffin(1,atype, 12,ierr)
      if (ierr-1) 300, 5, 4
    5 ierr = 1
      return
  300 if (mtype .ne. 3) go to 6
      ilen = min0 (52164, ilen)
      call buffin(1,rho,ilen,ierr)
      if (ierr-1) 310, 5, 4
  310 call buffin(1,atype,12,ierr)
      if (ierr-1) 400, 5, 4
  400 if (mtype .ne. 4) go to 6
      ilen = min0(104328, ilen)
      call buffin(1,vxy,ilen,ierr)
      if (ierr-1) 410, 5, 4
  410 lread =  1
      if ((dx(1) .ne. sdx).or.(dx(2) .ne. sdy).or.(nx .ne. nix).or.
     1    (ny .ne. niy)) then
         rewind 10
         nrho = (nx + 2) * (ny + 2)
         call bufout(10,rho, nrho,ierr)
         nix = nx
         niy = ny
         sdx = dx(1)
         sdy = dx(2)
         nvelo = nrho + nrho
         call bufout(10,vxy, nvelo,ierr)
         write(6, 602) istep
  602    format(' ----------> save a dump for comparison',
     1          ' <---------, step  =',i6)
         ncomp = istep
         endif
      if (nprdmp .le. 0) return
      call buffin(1,atype,12,ierr)
      if (ierr-1) 600, 5, 4
  600 if (mtype .ne. 6) go to 6
      call buffin(1,redfac,ilen,ierr)
      nprdmp = nprdmp - 1
      if (ierr-1) 610, 5, 4
  610 if (nprdmp .le. 0) return
      call buffin(1,atype,int10,ierr)
      if (ierr-1) 700, 2, 3
  700 call buffin(1,text,int10,ierr)
      nprdmp = nprdmp - 1
      if (ierr-1) 610, 2, 3
      end


      subroutine setsca
      common/header/ dx, dy, nx, ny, time, dtlim, nxp1, nyp1, nxp2, nyp2
      common/header/ nstep, l1d, nsame, nrho, nvelo, xcen, ycen, a, ainv
      common/header/ asq, omega, domega, nprtyp, nprdmp, nbclas
      common/header/ nbtype(4), name(20)
      common/reals/ xll,yll,xur,yur,xsca,ysca,dcon(60),ddash(60),
     1              vcon(40),vdash(40),x0l,y0l,dxl,dyl,glev(7),
     2              anmax,scvx,scvy,random,dxi,dyi,x,y,ux,uy,xpl,ypl,
     3              old1,old2,off,oldxsc,oldysc,xllm,yllm,xurm,yurm,
     4              xpc,ypc,da,db,randx,randy,posan,xtxt,
     5              rcon(40),rdash(40),tcon(40),tdash(40)
      common/fixed/ npen,ndcont,nvcont,nlines,nplin,inx,iny,npic,nprint,
     1              nrcont,ntcont
      common/logics/ lrando,lcen,lbtype
      logical lrando,lcen,lbtype
      character cname*80
      equivalence (cname,name)

c
c  this subroutine finds the scales for a plot.  if it is not the
c     first display in a certain frame, the old scales and
c     maximum sizes are imposed.  otherwise the specified scales
c     are checked.
c
      if (npic .eq. 0) go to 1
      npic = npic + 1
      xsca = oldxsc
      ysca = oldysc
      xll = amax1(xll, xllm)
      yll = amax1(yll, yllm)
      xur = amin1(xur, xurm)
      yur = amin1(yur, yurm)
c
c  first plot in a certain position must be the biggest
c
      return
    1 xmax = (nx - xcen) * dx
      xmin = xmax - (nx - 1) * dx
      ymax = (ny - ycen) * dy
      ymin = ymax - (ny - 1) * dy
      lbtype = (6 .eq. nbtype(1))
      if (lbtype) xmin = - xmax
      xll = amax1(xll, xmin)
      yll = amax1(yll, ymin)
      xur = amin1(xur, xmax)
      yur = amin1(yur, ymax)
      ysc = amin1(6.0 / (yur - yll), ysca)
      ysc = amax1(1.5 / (yur - yll), ysc)
      xsca = xsca * ysc / ysca
      ysca = ysc
      ypc = - ysca * yll
      xpc = - xsca * xll
      npic = 1
c
c  now that the scales and the plotsize are known we can plot the
c     annotation.
c
      write(16, 601) xll, yll, xur, yur, xsca, ysca

      call border

  601 format('0plot a new frame, xll =',f10.5,' , yll =',f10.5,
     1       ' , xur =',f10.5,' , yur =',f10.5/
     2       ' xsca =',f10.5,' , ysca =',f10.5)
      xllm = xll
      yllm = yll
      xurm = xur
      yurm = yur
      oldxsc = xsca
      oldysc = ysca
      return
      end

c-----------------------------------------------------------------------------
      subroutine flows
c-----------------------------------------------------------------------------
c-----------------------------------------------------------------------------
      character*80 textje
      real smirk(10)
      common/velmap/ vx(34000)
      common/header/ dx, dy, nx, ny, time, dtlim, nxp1, nyp1, nxp2, nyp2
      common/header/ nstep, l1d, nsame, nrho, nvelo, xcen, ycen, a, ainv
      common/header/ asq, omega, domega, nprtyp, nprdmp, nbclas
      common/header/ nbtype(4), name(20)
      common/reals/ xll,yll,xur,yur,xsca,ysca,dcon(60),ddash(60),
     1              vcon(40),vdash(40),x0l,y0l,dxl,dyl,glev(7),
     2              anmax,scvx,scvy,random,dxi,dyi,x,y,ux,uy,xpl,ypl,
     3              old1,old2,off,oldxsc,oldysc,xllm,yllm,xurm,yurm,
     4              xpc,ypc,da,db,randx,randy,posan,xtxt,
     5              rcon(40),rdash(40),tcon(40),tdash(40)
      common/fixed/ npen,ndcont,nvcont,nlines,nplin,inx,iny,npic,nprint,
     1              nrcont,ntcont
      common/logics/ lrando,lcen,lbtype
      logical lrando,lcen,lbtype
      common/bonval/ redfac(4), nleft(160), nright(160), nup(160)
      common/bonval/ nlow(160), rleft(160), rright(160), rup(160)
      common/bonval/ rlow(160), uleft(160), uright(160), uup(160)
      common/bonval/ ulow(160), vleft(160), vright(160), vup(160)
      common/bonval/ vlow(160)
      character cname*80
      equivalence (cname,name)

c
c  this subroutine is part of the gasdynamics restart dump plotting
c     package.  it will draw a number of flowlines, i.e. lines
c     tracing the instantaneous direction of the flow relative to
c     a coordinate system rotating with an arbitrary velocity relative
c     to the grid.  this could e.g. be the rotating frame of the
c     pattern, or the rest frame.
c
      write(16,601)
  601 format(' produce flow-lines')

c
c  lower-lefthand corner of array is at (1, 1)
c
      nsmirk = 0
      xmax = xur - 0.01 * dx
      xmin = xll + 0.01 * dx
      ymax = yur - 0.01 * dy
      ymin = yll + 0.01 * dy
      dxi = 1.0 / dx
      dyi = 1.0 / dy
c x/dx + xcen converts a certain x into a position in the array.
c calculate 20 (or specified number of) flow-lines starting at
c (x0, y0) + n * (x1, y1) with defaults y0 = y1 = ymax / (nlines + 1) ,
c x0 = x1 = xmax / (nlines + 1)
c find nplin points per flow-line, or until the flow-line
c crosses out of the model area, or substends more than anmax in angle.
c flows also marks time-intervals on the flowlines.
c calculate x, y, (r, theta), vx, vy, (vr, vtheta)
      if (nlines .gt. 0) go to 10
      nlines = 20
      nplin = 8 * (nx + ny + 1)
      anmax = 6.28
      x0l = xmax / (nlines + 1)
      sign= 1.                       !!!!!!!!!!!!!!!!!!!!!!!!!!
      y0l = sign*ymax / (nlines + 1) !!!!!!!!!!!!!!!!!!!!!!!!!!
      dxl = x0l
      dyl =y0l
   10 nprint = max0(nprint, nplin / 40)
      write(16, 603)domega, xcen, ycen, nlines, nplin, x0l, y0l, dxl,
     1   dyl, anmax, nprint
  603 format('0domega =',f10.5,' , xcen =',f10.5,' , ycen =',f10.5,
     2       ' (in increments)'/' plot ',i4,', flow-lines of up to ',i4,
     3       ' points each'/' start at (',f10.5,' , ',f10.5,'),',
     4       ' increment by (',f10.5,' , ',f10.5,'). maximum angle =',
     5       f10.5,' radians.'/' print every ',i4,'-th point.')
      x0 = x0l
      y0 = y0l
      do 101 i = 1, nlines
c
c  tijd is used to find the time required for the gas to flow from
c     the first point on the flow line to the current point.
c
      tijd= 0.
      j = 0
      x = amax1(xmin, amin1(xmax, x0))
      ix = x * dxi + xcen + 1000
      ix = ix - 1000
      if (ix) 201, 202, 203
  201 ix = - ix
      iyl = min0(nup(ix), nup(ix + 1)) / nxp2
      iyh = max0(nlow(ix), nlow(ix + 1)) / nxp2
      yl = dy * (ycen - iyl + 0.01)
      yh = dy * (ycen - iyh - 0.01)
      go to 210
  202 yl = ymin
      yh = ymax
      go to 210
  203 iyl = max0(nlow(ix), nlow(ix + 1)) / nxp2
      iyh = min0(nup(ix), nup(ix + 1)) / nxp2
      yl = dy * (0.01 + iyl - ycen)
      yh = dy * (iyh - ycen - 0.01)
  210 y = amax1(yl, amin1(yh, y0))
      y = amax1(ymin, amin1(ymax, y))
      write(16, 641) i, x, y
  641 format('0flow-line #',i5,' starting at (',f10.5,' ,',f10.5,
     1       ') kpc from galaxy center')
      san = 0.
      dan = 0.
c
c now we can get down to work on this flow-line
c
      call find
      tmark = 0.0
      xmrk1 = 9999.0
      ymrk1 = 9999.0
      xmrk2 = 8888.0
      ymrk2 = 8888.0
c
c  xmrk and ymrk will be used to see if the plot position changes
c     significantly between two marked positions.
c
      uu = sqrt(ux * ux + uy * uy)
c
c  plot a mark approx every two centimeters.
c
      dtmark = 3.0 / (uu * xsca)
c
c  convert dtmark to a decent number.
c
      ll = 100.0 + alog10(dtmark)
      uu = 10.0 ** (ll - 100)
      dt = dtmark / uu
      if (dt .lt. 2.0) then
         dt = 1.0
         else
         if (dt .lt. 4.0) then
            dt = 2.0
            else
            if (dt .lt. 5.0) then
               dt = 4.0
               else
               dt = 5.0
               endif
            endif
         endif
      dtmark = dt * uu
      write(16, 610) dtmark
  610 format(' mark flowline every ',1g12.2,' gyr')
      nsmirk = nsmirk + 1
      smirk(nsmirk) = dtmark
      if (nsmirk .ge. 10) then
         nsmirk = 0
         endif
c
c pass ux, uy, x, y, xcen, ycen, dxi, dyi etc etc in a common
c
      xp = xpc + xsca * x
      yp = ypc + ysca * y
      call pgmove(xp,yp)
  103 xold = x
      yold = y
      rr = sqrt(x * x + y * y) + 1.0e-36
      san = san + asin(dan / rr)
      if (abs(san) .ge. anmax) go to 102
      ca = x / rr
      sa = y / rr
      ut = sa * ux - ca * uy
      ur = ca * ux + sa * uy
      an = -atan2(y , x + 1.0e-36)
      if (mod(j, nprint) .eq. 0) write(16,671)j, tijd, x, y, ux, uy,
     1                            rr, an, ur, ut
      j = j + 1
  671 format(i5,9f14.6)
      if (j .ge. nplin) go to 102
c
c now find new x & y
c
      dt = 0.25 / amax1(abs(ux * dxi), abs(uy * dyi))
      k = 0
      uxold = ux
      uyold = uy
      x = x + ux * dt
      y = y + uy * dt
      red = 0.40
c
c  find returns the velocities ux and uy, given the position (x, y)
c
  109 call find
      if (ux .lt. -1.0e15) go to 102
      uxa = 0.5 * (ux + uxold)
c
c  find the mean velocity components on this part of the flow line.
c
      uya = 0.5 * (uy + uyold)
      dt = amin1(dt, red /  amax1(abs(uxa * dxi), abs(uya * dyi)))
      if (k .gt. 10) red = 0.1
      xn = xold + dt * uxa
      yn = yold + dt * uya
      delta = abs(dxi * (xn - x)) + abs(dyi * (yn - y))
      k = k + 1
      x = xn
      y = yn
      if ((k .lt. 20) .and. (delta .ge. 0.033)) go to 109
      tijd = tijd + dt
      dan = dt * (uxa * yold - uya * xold) / rr
      if (tijd .ge. tmark) then
  300    delta = tmark - tijd
         xn = x + delta * uxa
         yn = y + delta * uya
         xp = xpc + xn * xsca
         yp = ypc + yn * ysca
         call pgdraw(xp,yp)

         uu = 0.04 / sqrt(uxa * uxa + uya * uya)
         dxp = (uya - uxa) * uu
         dyp = (uxa + uya) * uu
         call pgdraw(xp + dxp,yp - dyp)
         call pgmove(xp - dyp,yp - dxp)
         call pgdraw(xp,yp)

         tmark = tmark + dtmark
         if (tijd .ge. tmark) go to 300
         dxp = abs(xp - xmrk1) + abs(xp - xmrk2)
         dyp = abs(yp - ymrk1) + abs(yp - ymrk2)
         if ((dxp + dyp) .lt. 0.1) go to 102
         xmrk2 = xmrk1
         ymrk2 = ymrk1
         xmrk1 = xp
         ymrk1 = yp
         endif
      xp = xpc + x * xsca
      yp = ypc + y * ysca
      call pgdraw(xp,yp)

      if (dt .gt. 5.0 * dtmark) go to 102
      go to 103
  102 write(16, 673) san, tijd
  673 format(' end of this flow-line; angle extended =',f14.6,
     1       ' , flow time =',1g14.5)
      x0 = x0 + dxl
      y0 = y0 + dyl
  101 continue
      return
      end

c-----------------------------------------------------------------------
      subroutine deflow
c-----------------------------------------------------------------------
c-----------------------------------------------------------------------
      common/header/ dx, dy, nx, ny, time, dtlim, nxp1, nyp1, nxp2, nyp2
      common/header/ nstep, l1d, nsame, nrho, nvelo, xcen, ycen, a, ainv
      common/header/ asq, omega, domega, nprtyp, nprdmp, nbclas
      common/header/ nbtype(4), name(20)
      common/reals/ xll,yll,xur,yur,xsca,ysca,dcon(60),ddash(60),
     1              vcon(40),vdash(40),x0l,y0l,dxl,dyl,glev(7),
     2              anmax,scvx,scvy,random,dxi,dyi,x,y,ux,uy,xpl,ypl,
     3              old1,old2,off,oldxsc,oldysc,xllm,yllm,xurm,yurm,
     4              xpc,ypc,da,db,randx,randy,posan,xtxt,
     5              rcon(40),rdash(40),tcon(40),tdash(40)
      common/fixed/ npen,ndcont,nvcont,nlines,nplin,inx,iny,npic,nprint,
     1              nrcont,ntcont
c
c  deflow sets the default values for the flow line plots
c  1)  the entire field is plotted.
c  2)  the plot is made as large as possible.
c  3)  domega = 0  =>  the pattern is assumed to be stationary relative
c      to the grid
c  4)  the flow lines are not printed.
c  5)  otherwise defaults is subroutine flows are used.
c
      xll = - nx * dx
      yll = - ny * dy
      xur =  nx * dx
      yur =  ny * dy
      xsca = 1.0e9
      ysca = 1.0e9
      nlines = 0
      nprint = 1000
      return
      end

c-----------------------------------------------------------------------------
      subroutine vector
c-----------------------------------------------------------------------------
c-----------------------------------------------------------------------------
      character*80 textje
      common/bonval/ redfac(4), nleft(160), nright(160), nup(160)
      common/bonval/ nlow(160), rleft(160), rright(160), rup(160)
      common/bonval/ rlow(160), uleft(160), uright(160), uup(160)
      common/bonval/ ulow(160), vleft(160), vright(160), vup(160)
      common/bonval/ vlow(160)
      common/velmap/ vx(34000)
      common/header/ dx, dy, nx, ny, time, dtlim, nxp1, nyp1, nxp2, nyp2
      common/header/ nstep, l1d, nsame, nrho, nvelo, xcen, ycen, a, ainv
      common/header/ asq, omega, domega, nprtyp, nprdmp, nbclas
      common/header/ nbtype(4), name(20)
      common/reals/ xll,yll,xur,yur,xsca,ysca,dcon(60),ddash(60),
     1              vcon(40),vdash(40),x0l,y0l,dxl,dyl,glev(7),
     2              anmax,scvx,scvy,random,dxi,dyi,x,y,ux,uy,xpl,ypl,
     3              old1,old2,off,oldxsc,oldysc,xllm,yllm,xurm,yurm,
     4              xpc,ypc,da,db,randx,randy,posan,xtxt,
     5              rcon(40),rdash(40),tcon(40),tdash(40)
      common/fixed/ npen,ndcont,nvcont,nlines,nplin,inx,iny,npic,nprint,
     1              nrcont,ntcont
      common/logics/ lrando,lcen,lbtype
      logical lrando,lcen,lbtype
      character cname*80
      equivalence (cname,name)

c
c  this subroutine is part of the general gasdynamics plotting package.
c     it draws velocity vectors.
c
      write(16,601)
  601 format('0produce a velocity vector plot')
c
c  velocity vectors need not be drawn at every grid point.  limit
c     increments to reasonabl;e values, and find coordinates of
c     first point to be drawn.
c
      inx = max0(1, min0(inx, ifix((xur - xll)/dx)))
      nxb = inx * (ifix(1000. + (xll/(inx * dx)) + xcen/inx) - 999)
      nxe = xcen + (xur/dx)
      nyb = ycen + (yll/dy) + 1
      nye = ycen + (yur/dy)
      iny = max0(1, min0(iny, nye - nyb))
c
c  the velocity vectors can be parallel shifted by a random amount
c     to remove confusing systematic grid effects.
c
      random = amin1(1., abs(random))
      lrando = random .ge. 0.1
      if (lcen) write(16, 678)
  678 format('0the arrows in the plot are centered')
      write(16, 603)domega, scvx, scvy, random, nxb, nxe, inx, nyb,
     1      nye, iny, xcen, ycen
  603 format('0domega =',f10.5,' , scvx =',f10.5,' , scvy =',f10.5,
     *       ' , random =',f7.3/
     1       ' nxb =',i5,' , nxe =',i5,' , inx =',i5,' , nyb =', i5,
     2       ' , nye =',i5,' , iny =',i5/' xcen =',f10.5,' , ycen =',
     3       f10.5,' (in increments)')
c
c  domega is in principle (pattern speed - grid speed), so that the
c     velocity vectors can be plotted relative to the pattern.
c
      vrx = -dy * domega * iny
      vry = dx * domega * inx
      scy = iny * dy * xsca
      scx = inx * dx * ysca
      randx = scx * random
      randy = scy * random
      iny2 = iny + iny
c
c  the program cycles through the gridd in such a way that a minimum
c     amount of time is used going from the one vector to the next,
c     and from the one line to the next.
c
      if (nxb .ge. 1) go to 1000
      dvx = (ycen - nyb) * domega * dy
      dvy = (nxb - xcen) * domega * dx
      xpl = xpc + scx * ((nxb - xcen) / inx)
      ypl = ypc + scy * ((nyb - ycen) / iny)
      nxh = min0(0, nxe)
      mpr = (nyp1 - nyb) * nxp2 + 1 - nxb
      do 1100 i = nyb, nye, iny2
         jy = nyp1 - i
         nx2 = nright(jy)
         do 1200 j = nxb, nxh, inx
            da = (dvx - vx(mpr)) * scvx
            db = (dvy - vx(mpr + nrho)) * scvy
            if (mpr .le. nx2) call arrow
            xpl = xpl + scx
            dvy = dvy + vry
 1200       mpr = mpr - inx
         if ((i + iny) .gt. nye) go to 1400
         jy = jy - iny
         nx2 = nright(jy)
         mpr = mpr - nxp2 * iny
         dvx = dvx + vrx
         ypl = ypl + scy
         do 1300 j = nxb, nxh, inx
            xpl = xpl - scx
            dvy = dvy - vry
            mpr = mpr + inx
            da = (dvx - vx(mpr)) * scvx
            db = (dvy - vx(mpr + nrho)) * scvy
            if (mpr .le. nx2) call arrow
 1300       continue
         mpr = mpr - nxp2 * iny
         dvx = dvx + vrx
         ypl = ypl + scy
 1100    continue
 1400 if (nxe .lt. 1) return
 1000 dvx = (ycen - nyb) * domega * dy
      nxl = max0(nxb, inx)
      dvy = (nxl - xcen) * domega * dx
      xpl = xpc + (nxl - xcen) * scx / inx
      ypl = ypc + (nyb - ycen) * scy / iny
      mpr = nyb * nxp2 + nxl
      do 100 i = nyb, nye, iny2
         nx1 = nleft(i)
         nx2 = nright(i)
         do 200 j = nxl, nxe, inx
            da = (vx(mpr) + dvx) * scvx
            db = (vx(mpr + nrho) + dvy) * scvy
            if ((mpr .ge. nx1) .and. (mpr .le. nx2)) call arrow
            mpr = mpr + inx
            xpl = xpl + scx
            dvy = dvy + vry
  200       continue
         if ((i + iny) .gt. nye) return
         nx1 = nleft(i + iny)
         nx2 = nright(i + iny)
         mpr = mpr + nxp2 * iny
         dvx = dvx + vrx
         ypl = ypl + scy
         do 300 j = nxl, nxe, inx
            mpr = mpr - inx
            xpl = xpl - scx
            dvy = dvy - vry
            da = (vx(mpr) + dvx) * scvx
            db = (vx(mpr + nrho) + dvy) * scvy
            if ((mpr .ge. nx1) .and. (mpr .le. nx2)) call arrow
  300       continue
         mpr = mpr + nxp2 * iny
         dvx = dvx + vrx
         ypl = ypl + scy
  100    continue
      return
      end

c-----------------------------------------------------------------------------
      subroutine defect
c-----------------------------------------------------------------------------
c-----------------------------------------------------------------------------
      common/bonval/ redfac(4), nleft(160), nright(160), nup(160)
      common/bonval/ nlow(160), rleft(160), rright(160), rup(160)
      common/bonval/ rlow(160), uleft(160), uright(160), uup(160)
      common/bonval/ ulow(160), vleft(160), vright(160), vup(160)
      common/bonval/ vlow(160)
      common/header/ dx, dy, nx, ny, time, dtlim, nxp1, nyp1, nxp2, nyp2
      common/header/ nstep, l1d, nsame, nrho, nvelo, xcen, ycen, a, ainv
      common/header/ asq, omega, domega, nprtyp, nprdmp, nbclas
      common/header/ nbtype(4), name(20)
      common/reals/ xll,yll,xur,yur,xsca,ysca,dcon(60),ddash(60),
     1              vcon(40),vdash(40),x0l,y0l,dxl,dyl,glev(7),
     2              anmax,scvx,scvy,random,dxi,dyi,x,y,ux,uy,xpl,ypl,
     3              old1,old2,off,oldxsc,oldysc,xllm,yllm,xurm,yurm,
     4              xpc,ypc,da,db,randx,randy,posan,xtxt,
     5              rcon(40),rdash(40),tcon(40),tdash(40)
      common/fixed/ npen,ndcont,nvcont,nlines,nplin,inx,iny,npic,nprint,
     1              nrcont,ntcont
      common/logics/ lrando,lcen,lbtype
      logical lrando,lcen,lbtype
      common/velmap/ vx(34000)
      character cname*80
      equivalence (cname,name)

c
c  subroutine defect sets the default values for the velocity vector
c     plots.
c  1)  the entire field is plotted.
c  2)  the plot is made as large as possible.
c  3)  the velocities in the frame of the grid are used (domega = 0.0)
c  4)  the longest vector is 1.5 cm long
c  5)  the vectors are space approximately 1.0 cm apart.
c  6)  the vectors are centered on the grid cells.
c
      xll = - nx * dx
      yll = - ny * dy
      xur =  nx * dx
      yur =  ny * dy
      xsca = 1.0e9
      ysca = 1.0e9
      rmin = 1.0e37
      rmax = -1.0e37
      random = 0.0
      y = - ycen * dy
      do 1 i = 1, ny
         y = y + dy
         x = - xcen * dx
         nn1 = nleft(i)
         nn2 = nright(i)
         do 1 nn = nn1, nn2
            x = x + dx
            uvel = vx(nn) - y * domega
            vvel = vx(nn + nrho) + x * domega
            vel = uvel * uvel + vvel * vvel
            if (vel .gt. rmax) rmax = vel
            if (vel .lt. rmin) rmin = vel
    1       continue
      vel = sqrt(amax1(rmax, -rmin))
      scvx = 0.6 / vel       ! was 1.5
      scvy = 0.6 / vel       ! was 1.5
      iny = 1.0 + ny / 28.0
      inx = 1.0 + (dy * ny) / (dx * 28.0)
      lcen = .true.
      return
      end

c-----------------------------------------------------------------------------
      subroutine arrow
c-----------------------------------------------------------------------------
c-----------------------------------------------------------------------------
      common/reals/ xll,yll,xur,yur,xsca,ysca,dcon(60),ddash(60),
     1              vcon(40),vdash(40),x0l,y0l,dxl,dyl,glev(7),
     2              anmax,scvx,scvy,random,dxi,dyi,x,y,ux,uy,xpl,ypl,
     3              old1,old2,off,oldxsc,oldysc,xllm,yllm,xurm,yurm,
     4              xpc,ypc,da,db,randx,randy,posan,xtxt,
     5              rcon(40),rdash(40),tcon(40),tdash(40)
      common/fixed/ npen,ndcont,nvcont,nlines,nplin,inx,iny,npic,nprint,
     1              nrcont,ntcont
      common/logics/ lrando,lcen,lbtype
      logical lrando,lcen,lbtype
      data vcm/0.6/,f/-0.1/,vcm2/6.0/      ! vcm was 1.5, vcm2 6.0
c
c  arrow plots a velocity vector at a specified position with the
c     following options:
c  1)  the arrow can either start at the specified position, or
c      be centered on it.
c  2)  the arrow can be randomly offset by a certain amount.
c
c  plotting of an arrow start either at the head, or at the tail,
c     wichever is closest to the current pen position.
c
      r1 = da * da + db * db
      ff = f
      pos1 = xpl
      pos2 = ypl
      if (.not. lrando) go to 33
      off = amod(333.111 * off + da , 1.)
      pos1 = pos1 + randx * (off - 0.5)
      off = amod(1111.333 * off + db, 1.)
      pos2 = pos2 + randy * (0.5 - off)
   33 continue
      if (.not. lcen) go to 34
      pos1 = pos1 - 0.5 * da
      pos2 = pos2 - 0.5 * db
   34 continue
      if (r1 .le. vcm2) go to 100
      r1 = vcm / sqrt(r1)
      da = da * r1
      db = db * r1
      ff = 3.0 * f
  100 d1 = old1 - pos1
      d2 = old2 - pos2
      r1 = amax1(abs(d1), abs(d2))
      r2 = amax1(abs(d1 - da), abs(d2 - db))
      d1 = pos1 + da
      d2 = pos2 + db
      old1 = ff * (da - db)
      old2 = ff * (da + db)
      if (r1 .gt. r2) go to 200
      call pgmove(pos1,pos2)

      call pgdraw(d1,d2)

      call pgdraw(d1 + old2,d2 - old1)

      call pgdraw(d1 + old1,d2 + old2)

      call pgdraw(d1,d2)

      old1 = d1
      old2 = d2
      return
  200 call pgmove(d1,d2)

      call pgdraw(d1 + old2,d2 - old1)

      call pgdraw(d1 + old1,d2 + old2)

      call pgdraw(d1,d2)
      call pgdraw(pos1,pos2)
      old1 = pos1
      old2 = pos2
      return
      end

c-------------------------------------------------------------------
	subroutine bufout(nfile,start,length,ierr)
c-------------------------------------------------------------------
c-------------------------------------------------------------------		
	real start(length)
	write(nfile,err=200) start
	ierr=0
	return
200	ierr=3
	write(16,*) 'write error on unit ',nfile
	return
	end

c-----------------------------------------------------------------------
      subroutine border
c-----------------------------------------------------------------------
c-----------------------------------------------------------------------
      common/reals/ xll,yll,xur,yur,xsca,ysca,dcon(60),ddash(60),
     1              vcon(40),vdash(40),x0l,y0l,dxl,dyl,glev(7),
     2              anmax,scvx,scvy,random,dxi,dyi,x,y,ux,uy,xpl,ypl,
     3              old1,old2,off,oldxsc,oldysc,xllm,yllm,xurm,yurm,
     4              xpc,ypc,da,db,randx,randy,posan,xtxt,
     5              rcon(40),rdash(40),tcon(40),tdash(40)
      common/fixed/ npen,ndcont,nvcont,nlines,nplin,inx,iny,npic,nprint,
     1              nrcont,ntcont
      common/logics/ lrando,lcen,lbtype
c
c  plot the border around a frame.
c
      xh = (xur - xll) * xsca
      yh = (yur - yll) * ysca
      xtxt = xh + 1.6
      dx = 1. / xsca
      dy = 1. / ysca
      call pgwnad( 0., 6., 0., 6.)
      call pgbox('bc', 0., 0, 'bc', 0., 0)
      call pgpoint(1,xpc,ypc,ichar('*'))
      return
      end

c-----------------------------------------------------------------
	subroutine buffin(nfile,start,length,ierr)
c-----------------------------------------------------------------
c-----------------------------------------------------------------
	real start(length)
	integer ierrno,n
	read (nfile,end=100,err=200) (start(k),k=1,length)
	ierr=0
	return
100	ierr=1
	print *, 'end-of-file on unit ',nfile
	return
200	ierr=2
	n = ierrno()
	print *, 'read error on unit ',nfile
	print *, 'error code :', n
	return
	end

c-----------------------------------------------------------------------
      subroutine find
c-----------------------------------------------------------------------
c-----------------------------------------------------------------------
      common/velmap/ vx(34000)
      common/header/ dx, dy, nx, ny, time, dtlim, nxp1, nyp1, nxp2, nyp2
      common/header/ nstep, l1d, nsame, nrho, nvelo, xcen, ycen, a, ainv
      common/header/ asq, omega, domega, nprtyp, nprdmp, nbclas
      common/header/ nbtype(4), name(20)
      common/reals/ xll,yll,xur,yur,xsca,ysca,dcon(60),ddash(60),
     1              vcon(40),vdash(40),x0l,y0l,dxl,dyl,glev(7),
     2              anmax,scvx,scvy,random,dxi,dyi,x,y,ux,uy,xpl,ypl,
     3              old1,old2,off,oldxsc,oldysc,xllm,yllm,xurm,yurm,
     4              xpc,ypc,da,db,randx,randy,posan,xtxt,
     5              rcon(40),rdash(40),tcon(40),tdash(40)
      common/bonval/ redfac(4), nleft(160), nright(160), nup(160)
      common/bonval/ nlow(160), rleft(160), rright(160), rup(160)
      common/bonval/ rlow(160), uleft(160), uright(160), uup(160)
      common/bonval/ ulow(160), vleft(160), vright(160), vup(160)
      common/bonval/ vlow(160)
      common/fixed/ npen,ndcont,nvcont,nlines,nplin,inx,iny,npic,nprint,
     1              nrcont,ntcont
      common/logics/ lrando,lcen,lbtype
      logical lrando,lcen,lbtype
c
c  find calculates the velocity components at position (x, y) in the
c     galaxy, and adds to those components a contribution for the
c     rotation of the grid relative to the desired frame of reference.
c
      if ((x .gt. xur) .or. (x .lt. xll) .or. (y .gt. yur) .or.
     1    (y .lt. yll)) go to 110
      ix = x * dxi + xcen + 1000
      iy = y * dyi + ycen + 1000
      ix = ix - 1000
      iy = iy - 1000
      ox = x * dxi + xcen - ix
      oy = y * dyi + ycen - iy
      if (ix) 105, 106, 107
  105 ind1 = (nyp1 - iy) * nxp2 + 1 - ix
      ind2 = ind1 - nxp2
      ind3 = ind1 - 1
      ind4 = ind2 - 1
      jx = 1 - ix
      if ((ind1 .gt. nup(jx)) .or. (ind2 .lt. nlow(jx))) go to 110
      s1 = -1.0
      s2 = -1.0
      go to 104
  106 ind1 = (nyp1 - iy) * nxp2 + 1
      ind2 = ind1 - nxp2
      ind3 = iy * nxp2 + 1
      ind4 = ind3 + nxp2
      s1 = -1.0
      s2 = 1.0
      go to 104
  107 ind1 = iy * nxp2 + ix
      ind2 = ind1 + nxp2
      ind3 = ind1 + 1
      ind4 = ind3 + nxp2
      if ((ind2 .gt. nup(ix)) .or. (ind4 .gt. nup(ix + 1)) .or.
     1    (ind1 .lt. nlow(ix)) .or. (ind3 .lt. nlow(ix + 1)))
     2    go to 110
      s1 = 1.0
      s2 = 1.0
  104 ux = s1 * (1. - ox) * (vx(ind1) * (1. - oy) + vx(ind2) * oy) +
     1     s2 * ox * (vx(ind3) * (1. - oy) + vx(ind4) * oy) - y * domega
      ind1 = ind1 + nrho
      ind2 = ind2 + nrho
      ind3 = ind3 + nrho
      ind4 = ind4 + nrho
      uy = s1 * (1. - ox) * (vx(ind1) * (1. - oy) + vx(ind2) * oy) +
     1     s2 * ox * (vx(ind3) * (1. - oy) + vx(ind4) * oy) + x * domega
      return
  110 ux = -1.0e20
      return
      end
