//
//  --- PNG-Balloons ---
//
//  Scene file for POV-Ray 2.2
//  Copyright (c) 1995 by Oliver Fromme -- All Rights Reserved
//
//  Oliver Fromme, Leibnizstr. 18-61, 38678 Clausthal, Germany
//  Internet/Usenet email:  fromme@rz.tu-clausthal.de
//  WWW:  http://www.rz.tu-clausthal.de/~inof/
//
//  This scene may be used freely for any non-commercial purpose.
//  Please let me know if you make any worthwhile improvements.
//

#version 2.2

//
//  This scene can be used as a great logo for T-shirts.
//  Therefore we use a plain white background suitable for
//  plain white T-shirts.  :)
//

background {color rgb <1, 1, 1>}

camera {
   direction <0, 0, 1.5>
   location <0, 0, -18>
   look_at <0, 0.25, 0>
   rotate x*15
}

light_source {<15, 30, -15> color rgb <0.9, 0.9, 0.9>}
light_source {<15, 15, -30> color rgb <0.4, 0.4, 0.4>}

//
//  To create a generic balloon:
//
//     sphere {<0,   0, 0>, r1}      // upper sphere
//     sphere {<0, -y2, 0>, r2}      // lower sphere (y2 > 0 and r2 < r1)
//     angle = arcsin ((r1-r2) / y2)
//     cone {<0,    -sin(angle)*r1, 0>, cos(angle)*r1,
//           <0, -y2-sin(angle)*r2, 0>, cos(angle)*r2}
//
//  If desired, the balloon can be bounded by a sphere like this:
//
//     bounded_by {sphere {<0, -((r1+r2+y2)/2-r1), 0>, (r1+r2+y2)/2}}
//
//  Then scale/rotate/translate the balloon as necessary.
//  For a "standard" balloon, r2 should be about 0.5*r1,
//  and y2 should be approximately equal to r1.
//  For our balloons:  r1 = 0.8, r2 = 0.4, y2 = 0.8 (see below).
//
//  Note:  In POV-Ray 2.2 you have to calculate the arcsin, cos and sin
//  manually (using a calculator) and insert the values into the scene's
//  source file.  POV-Ray 3.0 has built-in trigonometric functions, so
//  you can indeed declare a real generic balloon function!
//

#declare Balloon =
   merge {
      sphere {<0,    0, 0>, 0.8}
      sphere {<0, -0.8, 0>, 0.4}
      // angle = arcsin(0.5) = 30
      cone {<0, -0.4, 0>, 0.69282, <0, -1, 0>, 0.34641}
      texture {
         pigment {color rgb <1, 0, 0>}
         finish {
            diffuse 0.8
            ambient 0.2
            specular 0.25
            roughness 0.1
         }
      }
      bounded_by {sphere {<0, -0.2, 0>, 1.0}}
   }

//
//  The base plate.
//

union {
   box {<4.5, -2, 4.5>, <-4.5, -3, -4.5>}
   //
   //  Place spheres and cylinders at the corners and edges
   //  to make the box look "round"
   //
   sphere {<-4.5, -2.5,  4.5>, 0.5}
   sphere {< 4.5, -2.5,  4.5>, 0.5}
   sphere {<-4.5, -2.5, -4.5>, 0.5}
   sphere {< 4.5, -2.5, -4.5>, 0.5}
   cylinder {<-4.5, -2.5,  4.5>, < 4.5, -2.5,  4.5>, 0.5}
   cylinder {<-4.5, -2.5, -4.5>, < 4.5, -2.5, -4.5>, 0.5}
   cylinder {<-4.5, -2.5,  4.5>, <-4.5, -2.5, -4.5>, 0.5}
   cylinder {< 4.5, -2.5,  4.5>, < 4.5, -2.5, -4.5>, 0.5}
   //
   //  Nice marble texture -- I really like this one!
   //
   texture {
      pigment {
         granite
         turbulence 0.0
         color_map {
            [0.00 color rgb <0.3, 0.3, 0.5>]
            [0.25 color rgb <0.3, 0.3, 0.5>]
            [0.35 color rgb <0.0, 0.0, 0.2>]
            [0.40 color rgb <0.0, 0.0, 0.2>]
            [0.50 color rgb <0.3, 0.3, 0.5>]
            [0.65 color rgb <0.3, 0.3, 0.5>]
            [0.80 color rgb <0.8, 0.8, 1.0>]
            [1.00 color rgb <0.8, 0.8, 1.0>]
         }
         scale 5
         rotate <35, 45, 55>
         translate <6, 7, 8>
      }
      finish {
         diffuse 0.8
         ambient 0.2
         reflection 0.25
         specular 0.5
         roughness 0.01
      }
   }
}

//
//  Radius of the ropes (i.e. 0.5 * thickness).
//  Looks ugly if too thick, but shouldn't be too small either,
//  otherwise the ropes of the more distant balloons become
//  partially invisible.
//

#declare RopeR = 0.01

//
//  Texture of the ropes.
//  This is a simple gray color.
//

#declare RopeTex =
   texture {
      pigment {color rgb <0.75, 0.75, 0.75>}
   }

//
//  The height of the balloons, according to the seven passes of
//  PNG's progressive display (also known as "Adam7" interlacing).
//

#declare Pass1h = 5.00
#declare Pass2h = 4.25
#declare Pass3h = 3.50
#declare Pass4h = 2.75
#declare Pass5h = 2.00
#declare Pass6h = 1.25
#declare Pass7h = 0.50

//
//  Scale factors of the balloons.
//

#declare Pass1s = 0.75
#declare Pass2s = 0.65
#declare Pass3s = 0.60
#declare Pass4s = 0.55
#declare Pass5s = 0.50
#declare Pass6s = 0.45
#declare Pass7s = 0.40

//
//  Colors of the balloons.
//

#declare Pass1c = color rgb <1.00, 0.00, 0.0>
#declare Pass2c = color rgb <1.00, 0.25, 0.0>
#declare Pass3c = color rgb <1.00, 0.45, 0.0>
#declare Pass4c = color rgb <1.00, 0.60, 0.0>
#declare Pass5c = color rgb <1.00, 0.80, 0.0>
#declare Pass6c = color rgb <0.80, 1.00, 0.0>
#declare Pass7c = color rgb <0.00, 0.90, 0.0>

//
//  First we declare some rows, each of them consisting of 8 balloons
//  and their ropes (which are simple cylinders).
//  Hopefully POV-Ray 3.0 will have a for-loop.
//

#declare Pass7 =
   union {
      object {Balloon pigment {Pass7c} scale Pass7s translate <-3.5, Pass7h, 0>}
      object {Balloon pigment {Pass7c} scale Pass7s translate <-2.5, Pass7h, 0>}
      object {Balloon pigment {Pass7c} scale Pass7s translate <-1.5, Pass7h, 0>}
      object {Balloon pigment {Pass7c} scale Pass7s translate <-0.5, Pass7h, 0>}
      object {Balloon pigment {Pass7c} scale Pass7s translate < 0.5, Pass7h, 0>}
      object {Balloon pigment {Pass7c} scale Pass7s translate < 1.5, Pass7h, 0>}
      object {Balloon pigment {Pass7c} scale Pass7s translate < 2.5, Pass7h, 0>}
      object {Balloon pigment {Pass7c} scale Pass7s translate < 3.5, Pass7h, 0>}
      cylinder {<-3.5, Pass7h, 0>, <-3.5, -2, 0>, RopeR texture {RopeTex}}
      cylinder {<-2.5, Pass7h, 0>, <-2.5, -2, 0>, RopeR texture {RopeTex}}
      cylinder {<-1.5, Pass7h, 0>, <-1.5, -2, 0>, RopeR texture {RopeTex}}
      cylinder {<-0.5, Pass7h, 0>, <-0.5, -2, 0>, RopeR texture {RopeTex}}
      cylinder {< 0.5, Pass7h, 0>, < 0.5, -2, 0>, RopeR texture {RopeTex}}
      cylinder {< 1.5, Pass7h, 0>, < 1.5, -2, 0>, RopeR texture {RopeTex}}
      cylinder {< 2.5, Pass7h, 0>, < 2.5, -2, 0>, RopeR texture {RopeTex}}
      cylinder {< 3.5, Pass7h, 0>, < 3.5, -2, 0>, RopeR texture {RopeTex}}
   }

#declare Pass5n6 =
   union {
      object {Balloon pigment {Pass5c} scale Pass5s translate <-3.5, Pass5h, 0>}
      object {Balloon pigment {Pass6c} scale Pass6s translate <-2.5, Pass6h, 0>}
      object {Balloon pigment {Pass5c} scale Pass5s translate <-1.5, Pass5h, 0>}
      object {Balloon pigment {Pass6c} scale Pass6s translate <-0.5, Pass6h, 0>}
      object {Balloon pigment {Pass5c} scale Pass5s translate < 0.5, Pass5h, 0>}
      object {Balloon pigment {Pass6c} scale Pass6s translate < 1.5, Pass6h, 0>}
      object {Balloon pigment {Pass5c} scale Pass5s translate < 2.5, Pass5h, 0>}
      object {Balloon pigment {Pass6c} scale Pass6s translate < 3.5, Pass6h, 0>}
      cylinder {<-3.5, Pass5h, 0>, <-3.5, -2, 0>, RopeR texture {RopeTex}}
      cylinder {<-2.5, Pass6h, 0>, <-2.5, -2, 0>, RopeR texture {RopeTex}}
      cylinder {<-1.5, Pass5h, 0>, <-1.5, -2, 0>, RopeR texture {RopeTex}}
      cylinder {<-0.5, Pass6h, 0>, <-0.5, -2, 0>, RopeR texture {RopeTex}}
      cylinder {< 0.5, Pass5h, 0>, < 0.5, -2, 0>, RopeR texture {RopeTex}}
      cylinder {< 1.5, Pass6h, 0>, < 1.5, -2, 0>, RopeR texture {RopeTex}}
      cylinder {< 2.5, Pass5h, 0>, < 2.5, -2, 0>, RopeR texture {RopeTex}}
      cylinder {< 3.5, Pass6h, 0>, < 3.5, -2, 0>, RopeR texture {RopeTex}}
   }

#declare Pass1ff =
   union {
      object {Balloon pigment {Pass1c} scale Pass1s translate <-3.5, Pass1h, 0>}
      object {Balloon pigment {Pass6c} scale Pass6s translate <-2.5, Pass6h, 0>}
      object {Balloon pigment {Pass4c} scale Pass4s translate <-1.5, Pass4h, 0>}
      object {Balloon pigment {Pass6c} scale Pass6s translate <-0.5, Pass6h, 0>}
      object {Balloon pigment {Pass2c} scale Pass2s translate < 0.5, Pass2h, 0>}
      object {Balloon pigment {Pass6c} scale Pass6s translate < 1.5, Pass6h, 0>}
      object {Balloon pigment {Pass4c} scale Pass4s translate < 2.5, Pass4h, 0>}
      object {Balloon pigment {Pass6c} scale Pass6s translate < 3.5, Pass6h, 0>}
      cylinder {<-3.5, Pass1h, 0>, <-3.5, -2, 0>, RopeR texture {RopeTex}}
      cylinder {<-2.5, Pass6h, 0>, <-2.5, -2, 0>, RopeR texture {RopeTex}}
      cylinder {<-1.5, Pass4h, 0>, <-1.5, -2, 0>, RopeR texture {RopeTex}}
      cylinder {<-0.5, Pass6h, 0>, <-0.5, -2, 0>, RopeR texture {RopeTex}}
      cylinder {< 0.5, Pass2h, 0>, < 0.5, -2, 0>, RopeR texture {RopeTex}}
      cylinder {< 1.5, Pass6h, 0>, < 1.5, -2, 0>, RopeR texture {RopeTex}}
      cylinder {< 2.5, Pass4h, 0>, < 2.5, -2, 0>, RopeR texture {RopeTex}}
      cylinder {< 3.5, Pass6h, 0>, < 3.5, -2, 0>, RopeR texture {RopeTex}}
   }

#declare Pass3ff =
   union {
      object {Balloon pigment {Pass3c} scale Pass3s translate <-3.5, Pass3h, 0>}
      object {Balloon pigment {Pass6c} scale Pass6s translate <-2.5, Pass6h, 0>}
      object {Balloon pigment {Pass4c} scale Pass4s translate <-1.5, Pass4h, 0>}
      object {Balloon pigment {Pass6c} scale Pass6s translate <-0.5, Pass6h, 0>}
      object {Balloon pigment {Pass3c} scale Pass3s translate < 0.5, Pass3h, 0>}
      object {Balloon pigment {Pass6c} scale Pass6s translate < 1.5, Pass6h, 0>}
      object {Balloon pigment {Pass4c} scale Pass4s translate < 2.5, Pass4h, 0>}
      object {Balloon pigment {Pass6c} scale Pass6s translate < 3.5, Pass6h, 0>}
      cylinder {<-3.5, Pass3h, 0>, <-3.5, -2, 0>, RopeR texture {RopeTex}}
      cylinder {<-2.5, Pass6h, 0>, <-2.5, -2, 0>, RopeR texture {RopeTex}}
      cylinder {<-1.5, Pass4h, 0>, <-1.5, -2, 0>, RopeR texture {RopeTex}}
      cylinder {<-0.5, Pass6h, 0>, <-0.5, -2, 0>, RopeR texture {RopeTex}}
      cylinder {< 0.5, Pass3h, 0>, < 0.5, -2, 0>, RopeR texture {RopeTex}}
      cylinder {< 1.5, Pass6h, 0>, < 1.5, -2, 0>, RopeR texture {RopeTex}}
      cylinder {< 2.5, Pass4h, 0>, < 2.5, -2, 0>, RopeR texture {RopeTex}}
      cylinder {< 3.5, Pass6h, 0>, < 3.5, -2, 0>, RopeR texture {RopeTex}}
   }

//
//  Now we can place the 8 rows of balloons in the scene.
//

object {Pass1ff translate <0, 0,  3.5>}
object {Pass7   translate <0, 0,  2.5>}
object {Pass5n6 translate <0, 0,  1.5>}
object {Pass7   translate <0, 0,  0.5>}
object {Pass3ff translate <0, 0, -0.5>}
object {Pass7   translate <0, 0, -1.5>}
object {Pass5n6 translate <0, 0, -2.5>}
object {Pass7   translate <0, 0, -3.5>}

//
//  Fastenings of the balloons.
//

#declare FastenR = 0.05

#declare FastenRow =
   union {
      sphere {<-3.5, -2, 0>, FastenR}
      sphere {<-2.5, -2, 0>, FastenR}
      sphere {<-1.5, -2, 0>, FastenR}
      sphere {<-0.5, -2, 0>, FastenR}
      sphere {< 0.5, -2, 0>, FastenR}
      sphere {< 1.5, -2, 0>, FastenR}
      sphere {< 2.5, -2, 0>, FastenR}
      sphere {< 3.5, -2, 0>, FastenR}
      texture {
         pigment {color rgb <0, 0, 0>}
         finish {
            specular 0.3
            roughness 0.05
         }
      }
   }

object {FastenRow translate <0, 0,  3.5>}
object {FastenRow translate <0, 0,  2.5>}
object {FastenRow translate <0, 0,  1.5>}
object {FastenRow translate <0, 0,  0.5>}
object {FastenRow translate <0, 0, -0.5>}
object {FastenRow translate <0, 0, -1.5>}
object {FastenRow translate <0, 0, -2.5>}
object {FastenRow translate <0, 0, -3.5>}

// --- END ---
