%module test

%{
  int fac(int i) {
    if(i<3)
      return i;
    else return i * fac(i-1);
  }
 
  int add(int i, int j, int *result) {
    *result = i+j;
    return *result;
  }

  void long_array_test(int size, long b[]) {
    int i;
    for(i=0; i<size; i++)
	b[i] = i;
  }

  void int_array_test(int size, int b[]) {
    int i;
    for(i=0; i<size; i++)
	b[i] = i;
  }

  void short_array_test(int size, short b[]) {
    int i;
    for(i=0; i<size; i++)
	b[i] = i;
  }

  char *hello(char *who) {
    static char buf[50];
    sprintf(buf, "hello %s", who);
    return buf;
  }

  typedef struct _WINDOW {
    int x;
    int y;
    int w;
    int h;
  } WINDOW;

  WINDOW *newwin() {
    WINDOW *w = (WINDOW *) malloc(sizeof(WINDOW));
    w->x = 1;
    w->y = 2;
    w->w = 3;
    w->h = 4;

    return w;
  }

  void print_win(WINDOW win) {
    printf("x=%d; y=%d; w=%d; y=%d\n", win.x, win.y, win.w, win.h);
  }

  void print_wins(int size, WINDOW **wins) {
    int i;
    for(i=0; i<size; i++)
       printf("x=%d; y=%d; w=%d; y=%d\n", wins[i]->x, wins[i]->y, wins[i]->w, wins[i]->h);
  }
%}

#define X "hello world"
const double PI = 3.1415;

int fac(int i);
int add(int i, int j, int *result);
void long_array_test(int size, long b[]);
void int_array_test(int size, int b[]);
void short_array_test(int size, short b[]);
char *hello(char *s);

%name(Window) typedef struct {
    int x;
    int y;
    int w;
    int h;

  %addmethods {
     WINDOW() {
       return newwin();
     }

     void print() {
       print_win(*self);
     }
  }
} WINDOW;

WINDOW *newwin();
void print_win(WINDOW win);
void print_wins(int size, WINDOW **wins);
