//
// SWIG Typemap library
// for Java

%typemap(java,jtype) char *STRING {String}
%typemap(java,in) char *STRING {
  $target = (char *)(*jenv)->GetStringUTFChars(jenv, $source, 0);
}

%typemap(java,argout) char *STRING {
  (*jenv)->ReleaseStringUTFChars(jenv, $source, $target);
}

%typemap(java,ret) char *STRING {
  $target = (jarray) (*jenv)->NewStringUTF(jenv, $source);
}

%typemap(java,jni) char *BYTE {jbyteArray}
%typemap(java,jtype) char *BYTE {byte[]}
%typemap(java,in) char *BYTE {
  $target = (char *) (*jenv)->GetByteArrayElements(jenv, $source, 0);
}

%typemap(java,argout) char *BYTE {
  (*jenv)->ReleaseByteArrayElements(jenv, $source, $target, 0);
}
