/*              @(#)worksp.v	1.9 AVS 95/04/13     */
/*
			Copyright (c) 1993 by
			Advanced Visual Systems Inc.
			All Rights Reserved
	
	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.
	
	This file is under sccs control at AVS in:
	/src1/sccs/xp_demo/v/s.worksp.v
*/
//
// ========= Workspace Usage Definition for IAC Demo Project ============
//
// Define the compile process target for all the modules used here.
// They should either be in "user" or in "express".
// Set the following symbol to the desired value:
// If you want the "user" process build, comment out the following line

#define SINGLE_PROC

//
// set the process attribute
//
#ifdef SINGLE_PROC
    #define DEMO_PROC_TARGET "express"
#else
    #define DEMO_PROC_TARGET "user"
#endif


// [ 1 ]
// This workspace contains the low-level "module" objects.  these are
// all compiled.  all objects in this work space inherit the process
// and the build_dir property so we don't have to set them individually.
//
WORKSPACE_1 <process=DEMO_PROC_TARGET,
	     build_dir="mods"> {

    $include vec_lab.v

};
//
// [ 2 ]
// This workspace just defines macros.
// It doesn't want to set the process or build_dir properties.
// These are components of applications
//
WORKSPACE_2 {

    $include vec_mac.v

};

//
// [ 3 ]
// This workspace defines Applications.
// These are complete applications, each
// one is stand-alone, using pieces from
// sections 1 and 2, above.
//
WORKSPACE_3 {

    $include vec_app.v

};

