/* mod_gen Version 1                                                     */
/* Module Name: "AFS extract" (Input) (Subroutine)                       */
/* Author: Jeff Wang,NCSC,248-9242                                       */
/* Date Created: Thu Jun 24 10:41:36 1993                                */
/*                                                                       */
/* This file is automatically generated by the Module Generator (mod_gen)*/
/* Please do not modify or move the contents of this comment block as    */
/* mod_gen needs it in order to read module sources back in.             */
/*                                                                       */
/* End of Module Description Comments                                    */

#include <stdio.h>
#include <math.h>
#include <avs/field.h>
#include <avs/avs.h>
#include <avs/port.h>
#include <avs/geom.h>
#include "draw_usmap.h"
 
/* ---. START OF USER-SUPPLIED CODE SECTION #1 (INCLUDE FILES, GLOBAL VARIABLES)*/

#define   RECLENGTH            242 
#define   NUMBEROFFIELD        37
#define   MAXFIELD             80

typedef char FIPSstring[6];
typedef char PODstring[6];
typedef char SICstring[5];
typedef char SCCstring[11];


typedef struct  {
int begin_col;
int end_col;
char *type;
} data_format;

typedef struct  {
char data_type[1];         /* Inventory Type (optional) */
int prj_year;              /* Projection Year (optional) */
int base_year;             /* Inventory Base Year (optional) */
char emiss_type[2];        /* Emission Type */
char FIPS_code[6];         /* FIPS state/county code */
char City_FIPS[5];         /* Subregion code (city FIPS) (optional) */
char SIC_code[5];          /* Standard Industrial Classification Code */
char SCC_code[11];         /* Source Classification Code */
char Plant_ID[5];          /* Plant Indentification Code */
int stack_number;          /* Stack Number */
char emiss_ID[3];          /* Emission Point Identifier (optional) */
int segment_no;            /* Segment Number (optional) */
char period[2];            /* Period */
int begin_date;           /* Beginning period interval date/time;in YYMMDDHH */
int end_date;              /* Ending period interval date/time;in YYMMDDHH */
float xloc;                /* Latitude (decimal degrees) or UTM Easting 
                              coordinate (km) to define location of plant */
float yloc;                /* Longitude (decimal degrees) or UTM Northing 
                              coordinate (km) to define location of plant */
int utmzone;               /* UTM zone associated with UTM coordinates 
                              given for a plant (optional if location is 
                              lat/long)  */
float stack_hight;         /* Stack Height (m) */
float stack_diameter;      /* Stach Diameter (m) */
float stack_exit_temp;     /* Stack Exit Gas Temperature (Kelvin) */
float stack_exit_velo;     /* Stack Exit Gas Velocity (m/s) */
int thput_winter;          /* Annual Throughput (%) for Dec-Feb */
int thput_spring;          /* Annual Throughput (%) for Mar-May */
int thput_summer;          /* Annual Throughput (%) for Jun-Aug */
int thput_fall;            /* Annual Throughput (%) for Sep-Nov */
int hr_per_day;            /* Hours per day operating (optional) */
int start_hr;              /* Starting hour (optional) */
int day_per_week;          /* Days per week operating (optional) */
int hrs_per_year;          /* Hours per year operating (optional */
char pollutant_code[6];    /* Pollutant code */
float emission;            /* Emissions of specified pollutant (tons) */
int PCE_code;              /* Primary control equipment code for specified
                              pollutant (optional) */
float CCEffect;            /* Combined control effectiveness (percent)
                              for specified pollutant (optional) */
float RuleEffect;          /* Rule effectiveness (percent) of specified
                              pollutant (optional) */
float RulePen;             /* Rule penetration (percent) of specified
                              pollutant (100% default for point sources)
                              (optional) */
char plant_name[41];       /* Plant Name (optional) */
} AFSrecord;

data_format df[] = {
      1,   1, "A",
      3,   4, "I",
      6,   7, "I",
      9,  10, "A",
     12,  16, "A",
     18,  22, "A",
     24,  27, "A",
     29,  38, "A",
     40,  44, "A",
     46,  48, "I",
     50,  52, "A",
     54,  55, "I",
     57,  58, "A",
     60,  67, "I",
     69,  76, "I",
     78,  87, "R",
     89,  98, "R",
    100, 101, "I",
    103, 107, "R",
    109, 113, "R",
    115, 119, "R",
    121, 125, "R",
    127, 129, "I",
    131, 133, "I",
    135, 137, "I",
    139, 141, "I",
    143, 144, "I",
    146, 147, "I",
    149, 149, "I",
    151, 154, "I",
    156, 160, "A",
    162, 171, "R",
    173, 175, "I",
    177, 182, "R",
    184, 189, "R",
    191, 196, "R",
    200, 240, "A"
};

static char c, selected_file[132], print_file[132];
static char oldfips[6], oldpod[6], oldsic[5], oldscc[11];
static char selected_fips[6], selected_pod[6], selected_sic[5],
            selected_scc[11], selected_site[42];
static float pxloc[10000], pyloc[10000];
static int ii, ij, ji;

/* <---- END OF USER-SUPPLIED CODE SECTION #1                            */
 
/* *****************************************/
/*  Module Description                     */
/* *****************************************/
int AFS_extract_desc()
{

	int in_port, out_port, param;
	extern int AFS_extract_compute();

	AVSset_module_name("AFS extract", MODULE_DATA);

	/* Input Port Specifications               */
	in_port = AVScreate_input_port("in_data", "string", OPTIONAL);

	/* Output Port Specifications              */
        out_port = AVScreate_output_port("outfield",
                "field 1D 3-space 1-vector irregular float");

	/* Parameter Specifications                */
	param = AVSadd_parameter("Select AFS File", "string", " ", " ", ":");
	AVSconnect_widget(param, "browser");
	param = AVSadd_parameter("Select County By FIPS", "choice", " ", 
                " ", "\n");
	AVSconnect_widget(param, "choice_browser");
        param = AVSadd_parameter("Plot By Pollutant Code", "choice", " ",
                " ", "\n");
        AVSconnect_widget(param, "choice_browser");
        param = AVSadd_parameter("Plot By SIC Code", "choice", " ",
                " ", "\n");
        AVSconnect_widget(param, "choice_browser");
        param = AVSadd_parameter("Plot By SCC Code", "choice", " ",
                " ", "\n");
        AVSconnect_widget(param, "choice_browser");
        param = AVSadd_parameter("View Data", "oneshot", 0, 0, 1);
        AVSconnect_widget(param, "oneshot");
        param = AVSadd_parameter("Auto View", "boolean", 0, 0, 1);
        AVSconnect_widget(param, "toggle");
        param = AVSadd_parameter("Print Records", "oneshot", 0, 0, 1);
        AVSconnect_widget(param, "oneshot");
        param = AVSadd_parameter("map utm zone", "integer", 0, 0, 100000);
        AVSconnect_widget(param, "typein_integer");
        param = AVSadd_parameter("Coordinate Type", "choice",
                "UTM Coodinate Type", "UTM Coodinate Type:Lat/Lon Type", ":");
        AVSconnect_widget(param, "radio_buttons");
        AVSadd_parameter_prop(param, "width", "integer", 4);
	param = AVSadd_parameter("Print To File", "string", " ", " ", ":");
	AVSconnect_widget(param, "browser");
        param = AVSadd_parameter("Print One Record PerSite", "boolean", 
                0, 0, 1);
        AVSconnect_widget(param, "toggle");
        AVSadd_parameter_prop(param, "width", "integer", 4);

	AVSset_compute_proc(AFS_extract_compute);
/* ---. START OF USER-SUPPLIED CODE SECTION #2 (ADDITIONAL SPECIFICATION INFO)*/
/* <---- END OF USER-SUPPLIED CODE SECTION #2                            */
	return(1);
}
 
/* *****************************************/
/* Module Compute Routine                  */
/* *****************************************/
int AFS_extract_compute( 
in_data, 
outfield,
Select_AFS_File,
Select_County_By_FIPS,
Plot_By_Pollutant_Code,
Plot_By_SIC_Code,
Plot_By_SCC_Code,
View_Data,
Auto_View,
Print_Records,
map_utm_zone,
Coordinate_Type,
Print_To_File,
single
)
	char *in_data;
        AVSfield_float **outfield;
	char *Select_AFS_File;
        char *Select_County_By_FIPS;
        char *Plot_By_Pollutant_Code;
        char *Plot_By_SIC_Code;
        char *Plot_By_SCC_Code;
        int View_Data;
        int Auto_View;
        int Print_Records;
        int map_utm_zone;
        char *Coordinate_Type;
	char *Print_To_File;
        int single;
{
/*  THIS IS A 'HINTS' AREA - YOU MAY CUT AND PASTE AT WILL FROM IT       */
int dims0[1];
static int index, i, j, jj, count, current_field;
static int ichoice, utmornot=1;
static int view_all, print_all, found, pass, update;
static int fipscount, podcount, siccount, scccount;
char *tmp1, *tmp2, *tmp3, *tmp4;
AFSrecord     *afs;
FIPSstring *tmpfips, minfips; 
PODstring  *tmppod, minpod;
SICstring  *tmpsic, minsic;
SCCstring  *tmpscc, minscc;
static float tempx, tempy, tempz, tempx_end, tempy_end;

if (AVSparameter_changed("Coordinate Type"))
{
   ichoice = AVSchoice_number("Coordinate Type", Coordinate_Type);
   switch (ichoice)
   {
      case 1:
            utmornot = 1;
            break;
      case 2:
            utmornot = 0;
            break;
   }
}

if ((tmp1 = (char *)malloc(RECLENGTH*sizeof(char))) == NULL)
{
   fprintf(stderr, "No enough space for tmp1!!\n");
}

if ((tmp2 = (char *)malloc(RECLENGTH*sizeof(char))) == NULL)
{
   fprintf(stderr, "No enough space for tmp2!!\n");
}

if ((tmp4 = (char *)malloc(RECLENGTH*sizeof(char))) == NULL)
{
   fprintf(stderr, "No enough space for tmp4!!\n");
}

if ((tmpfips = (FIPSstring *)calloc(500, sizeof(FIPSstring)))==NULL)
{
   fprintf(stderr, "No enough space for tmpfips!!\n");
}

if ((tmppod = (PODstring *)calloc(500, sizeof(FIPSstring)))==NULL)
{
   fprintf(stderr, "No enough space for tmppod!!\n");
}

if ((tmpsic = (SICstring *)calloc(500, sizeof(SICstring)))==NULL)
{
   fprintf(stderr, "No enough space for tmpsic!!\n");
}

if ((tmpscc = (SCCstring *)calloc(500, sizeof(SCCstring)))==NULL)
{
   fprintf(stderr, "No enough space for tmpscc!!\n");
}

/* ---. START OF USER-SUPPLIED CODE SECTION #3 (COMPUTE ROUTINE BODY)   */
if (AVSparameter_changed("Print To File"))
{
   sprintf(print_file, "%s\0", Print_To_File);
}

if (AVSparameter_changed("Select AFS File"))
{
   FILE *afsfile, *fipsfile;
   FILE *podfile, *sicfile, *sccfile;
   char *podstr, *liststr, *sicstr, *sccstr;
 
   sprintf(selected_fips, " \0");
   AVSmodify_parameter("Select County By FIPS", AVS_VALUE, "", 
                       Select_County_By_FIPS, "\n");
   sprintf(selected_pod, " \0");
   AVSmodify_parameter("Plot By Pollutant Code", AVS_VALUE, "",
                       Plot_By_Pollutant_Code, "\n");
   sprintf(selected_sic, " \0");
   AVSmodify_parameter("Plot By SIC Code", AVS_VALUE, "",
                       Plot_By_SIC_Code, "\n");
   sprintf(selected_scc, " \0");
   AVSmodify_parameter("Plot By SCC Code", AVS_VALUE, "",
                       Plot_By_SCC_Code, "\n");
 
   sprintf(selected_file, "%s\0", Select_AFS_File);
   fipsfile = fopen("afsfips.txt","w");
   sprintf(oldfips, " ");
   podfile = fopen("afspod.txt","w");
   sprintf(oldpod, " ");
   sicfile = fopen("afssic.txt","w");
   sprintf(oldsic, " ");
   sccfile = fopen("afsscc.txt","w");
   sprintf(oldscc, " ");
   if ((afsfile = fopen(selected_file, "r")) != NULL)
   {
      index = 0;
      fipscount = 0;
      podcount = 0;
      siccount = 0;
      scccount = 0;
      while (fgets(tmp1, RECLENGTH, afsfile) != NULL)
      {
         index++;
         sprintf(tmp2, "%s\0", tmp1);
         afs = (AFSrecord *)malloc(1*sizeof(AFSrecord));
         for (i=0; i<NUMBEROFFIELD; i++)
         {
             current_field = i;
             count = 0;
             tmp3 = (char *)malloc(MAXFIELD*sizeof(char));
             for (j=df[i].begin_col-1; 
                  j<=df[i].end_col-1; j++)
             {
                tmp3[count] = tmp2[j];
                count++;
             }
             tmp3[count] = '\0';
             switch (current_field) {
                case 0:
                      sprintf(afs->data_type, "%s", tmp3);
                      break; 
                case 1:
                      afs->prj_year = atoi(tmp3);
                      break;
                case 2:
                      afs->base_year = atoi(tmp3);
                      break;
                case 3:
                      sprintf(afs->emiss_type, "%s", tmp3);
                      break;
                case 4:
                      sprintf(afs->FIPS_code, "%s", tmp3);
                      break;
                case 6:
                      sprintf(afs->SIC_code, "%s", tmp3);
                      break;
                case 7:
                      sprintf(afs->SCC_code, "%s", tmp3);
                      break;
                case 15:
                      afs->xloc = atof(tmp3);
                      break;
                case 16:
                      afs->yloc = atof(tmp3);
                      break;
                case 17:
                      afs->utmzone = atoi(tmp3);
                      break;
                case 30:
                      sprintf(afs->pollutant_code, "%s", tmp3);
                      break;
                case 31: 
                      afs->emission = atof(tmp3);
                      break;
                case 36:
                      sprintf(afs->plant_name, "%s", tmp3);
                      break;
             }
             free((char *)tmp3);
         }

         /* For FIPS code */
         if (fipscount == 0)
         {
            sprintf(tmpfips[fipscount], "%s\0", afs->FIPS_code);
            fipscount++;
         }

         else if (strcmp(afs->FIPS_code, oldfips) != NULL)
         {
            found = 0;
            j = 0;
            while (!found && j<fipscount)
            {
               if (strcmp(tmpfips[j], afs->FIPS_code) == NULL)
               {
                  found = 1;
               }
               j++;
            }
            if (!found)
            {
               strcpy(tmpfips[fipscount], afs->FIPS_code);
               fipscount++;
            }
         }
         sprintf(oldfips, "%s", afs->FIPS_code);

         /* For pollutant ID */
         if (podcount == 0)
         {
            sprintf(tmppod[podcount], "%s\0", afs->pollutant_code);
            podcount++;
         }

         else if (strcmp(afs->pollutant_code, oldpod) != NULL)
         {
            found = 0;
            j = 0;
            while (!found && j<podcount)
            {
               if (strcmp(tmppod[j], afs->pollutant_code) == NULL)
               {
                  found = 1;
               }
               j++;
            }
            if (!found)
            {
               strcpy(tmppod[podcount], afs->pollutant_code);
               podcount++;
            }
         }
         sprintf(oldpod, "%s", afs->pollutant_code);

         /* For SIC code */
         if (siccount == 0)
         {
            sprintf(tmpsic[siccount], "%s\0", afs->SIC_code);
            siccount++;
         }

         else if (strcmp(afs->SIC_code, oldsic) != NULL)
         {
            found = 0;
            j = 0;
            while (!found && j<siccount)
            {
               if (strcmp(tmpsic[j], afs->SIC_code) == NULL)
               {
                  found = 1;
               }
               j++;
            }
            if (!found)
            {
               strcpy(tmpsic[siccount], afs->SIC_code);
               siccount++;
            }
         }
         sprintf(oldsic, "%s", afs->SIC_code);

         /* For SCC Code */
         if (scccount == 0)
         {
            sprintf(tmpscc[scccount], "%s\0", afs->SCC_code);
            scccount++;
         }

         else if (strcmp(afs->SCC_code, oldscc) != NULL)
         {
            found = 0;
            j = 0;
            while (!found && j<scccount)
            {
               if (strcmp(tmpscc[j], afs->SCC_code) == NULL)
               {
                  found = 1;
               }
               j++;
            }
            if (!found)
            {
               strcpy(tmpscc[scccount], afs->SCC_code);
               scccount++;
            }
         }
         sprintf(oldscc, "%s", afs->SCC_code);
         /* free the memory for next record */
         free((AFSrecord *)afs);
      }
   }
   else 
   {
      fprintf(stderr, "Can't open file %s.\n", afsfile);
   }
   fclose(afsfile);

   /* For fips array */
   fipscount = fipscount -1;
   /* Sort the value */
   for (i=0; i<fipscount; i++)
   { 
       sprintf(minfips, "%s", tmpfips[i]);
       jj = i;
       found = 0;
       for (j=i+1; j<=fipscount; j++)
       {
           if (strcmp(minfips, tmpfips[j]) > 0)
           {
              sprintf(minfips, "%s", tmpfips[j]);
              jj = j;
              found = 1;
           }
       }
       if (found)
       {
           sprintf(tmpfips[jj], "%s", tmpfips[i]);
           sprintf(tmpfips[i], "%s", minfips);
       }
   }
   /* Write out the data */
   for (j=0; j<=fipscount; j++)
   {
       fprintf(fipsfile, "%s\n", tmpfips[j]);
   }
   fclose(fipsfile);

   /* For pod array */
   podcount = podcount -1;
   /* Sort the value */
   for (i=0; i<podcount; i++)
   { 
       sprintf(minpod, "%s", tmppod[i]);
       jj = i;
       found = 0;
       for (j=i+1; j<=podcount; j++)
       {
           if (strcmp(minpod, tmppod[j]) > 0)
           {
              sprintf(minpod, "%s", tmppod[j]);
              jj = j;
              found = 1;
           }
       }
       if (found)
       {
           sprintf(tmppod[jj], "%s", tmppod[i]);
           sprintf(tmppod[i], "%s", minpod);
       }
   }
   /* Write out the data */
   for (j=0; j<=podcount; j++)
   {
       fprintf(podfile, "%s\n", tmppod[j]);
   }
   fclose(podfile);

   /* For sic array */
   siccount = siccount -1;
   /* Sort the value */
   for (i=0; i<siccount; i++)
   { 
       sprintf(minsic, "%s", tmpsic[i]);
       jj = i;
       found = 0;
       for (j=i+1; j<=siccount; j++)
       {
           if (strcmp(minsic, tmpsic[j]) > 0)
           {
              sprintf(minsic, "%s", tmpsic[j]);
              jj = j;
              found = 1;
           }
       }
       if (found)
       {
           sprintf(tmpsic[jj], "%s", tmpsic[i]);
           sprintf(tmpsic[i], "%s", minsic);
       }
   }
   /* Write out the data */
   for (j=0; j<=siccount; j++)
   {
       fprintf(sicfile, "%s\n", tmpsic[j]);
   }
   fclose(sicfile);

   /* For scc array */
   scccount = scccount -1;
   /* Sort the value */
   for (i=0; i<scccount; i++)
   { 
       sprintf(minscc, "%s", tmpscc[i]);
       jj = i;
       found = 0;
       for (j=i+1; j<=scccount; j++)
       {
           if (strcmp(minscc, tmpscc[j]) > 0)
           {
              sprintf(minscc, "%s", tmpscc[j]);
              jj = j;
              found = 1;
           }
       }
       if (found)
       {
           sprintf(tmpscc[jj], "%s", tmpscc[i]);
           sprintf(tmpscc[i], "%s", minscc);
       }
   }
   /* Write out the data */
   for (j=0; j<=scccount; j++)
   {
       fprintf(sccfile, "%s\n", tmpscc[j]);
   }
   fclose(sccfile);
   liststr = (char *)list_file_browser("afsfips.txt");
   AVSmodify_parameter("Select County By FIPS", AVS_MINVAL,
                       "", (char *)liststr, "\n");
   podstr = (char *)list_file_browser("afspod.txt");
   AVSmodify_parameter("Plot By Pollutant Code", AVS_MINVAL,
                       "", (char *)podstr, "\n");
   sicstr = (char *)list_file_browser("afssic.txt");
   AVSmodify_parameter("Plot By SIC Code", AVS_MINVAL,
                       "", (char *)sicstr, "\n");
   sccstr = (char *)list_file_browser("afsscc.txt");
   AVSmodify_parameter("Plot By SCC Code", AVS_MINVAL,
                       "", (char *)sccstr, "\n");
}

if (AVSparameter_changed("Select County By FIPS"))
{
   FILE *afsfile;
 
   sprintf(selected_fips, "%s\0", Select_County_By_FIPS);
}

if (AVSparameter_changed("Plot By Pollutant Code"))
{
   sprintf(selected_pod, "%s\0", Plot_By_Pollutant_Code);
}

if (AVSparameter_changed("Plot By SIC Code"))
{
   sprintf(selected_sic, "%s\0", Plot_By_SIC_Code);
}

if (AVSparameter_changed("Plot By SCC Code"))
{
   sprintf(selected_scc, "%s\0", Plot_By_SCC_Code);
}

if (Print_Records)
{
   FILE *afsfile;
   FILE *prtfile;

   Print_Records = 0;
   if ((prtfile = fopen(print_file,"w")) == NULL)
   {
      AVSwarning("Can't open %s to write\n", print_file);
      return(0);
   }

   if (strcmp(selected_fips," ") == NULL &&
       strcmp(selected_pod," ") == NULL &&
       strcmp(selected_sic," ") == NULL &&
       strcmp(selected_scc," ") == NULL )
   {
      print_all = 1;
   }
   else
   {
      print_all = 0;
   }

   if ((afsfile = fopen(selected_file, "r"))!=NULL)
   {
      index = 0; ii =0; 
      while (fgets(tmp1, RECLENGTH, afsfile)!= NULL)
      {
         index++;
         sprintf(tmp2, "%s\0", tmp1);
         afs = (AFSrecord *)malloc(1*sizeof(AFSrecord));
         for (i=0; i<NUMBEROFFIELD; i++)
         {
             current_field = i;
             count = 0;
             tmp3 = (char *)malloc(MAXFIELD*sizeof(char));
             for (j=df[i].begin_col-1; 
                  j<=df[i].end_col-1; j++)
             {
                tmp3[count] = tmp2[j];
                count++;
             }
             tmp3[count] = '\0';
             switch (current_field) {
                case 0:
                      sprintf(afs->data_type, "%s", tmp3);
                      break; 
                case 1:
                      afs->prj_year = atoi(tmp3);
                      break;
                case 2:
                      afs->base_year = atoi(tmp3);
                      break;
                case 3:
                      sprintf(afs->emiss_type, "%s", tmp3);
                      break;
                case 4:
                      sprintf(afs->FIPS_code, "%s", tmp3);
                      break;
                case 6:
                      sprintf(afs->SIC_code, "%s", tmp3);
                      break;
                case 7:
                      sprintf(afs->SCC_code, "%s", tmp3);
                      break;
                case 15:
                      afs->xloc = atof(tmp3);
                      break;
                case 16:
                      afs->yloc = atof(tmp3);
                      break;
                case 17:
                      afs->utmzone = atoi(tmp3);
                      break;
                case 30:
                      sprintf(afs->pollutant_code, "%s", tmp3);
                      break;
                case 31: 
                      afs->emission = atof(tmp3);
                      break;
                case 36:
                      sprintf(afs->plant_name, "%s", tmp3);
                      break;
             }
             free((char *)tmp3);
         }
         if (print_all ||  
             /* first logical check */
             (strcmp(selected_fips, afs->FIPS_code) == NULL  &&
              strcmp(selected_pod," ") == NULL &&
              strcmp(selected_sic," ") == NULL &&
              strcmp(selected_scc," ") == NULL) ||
             (strcmp(selected_fips, " ") == NULL  &&
              strcmp(selected_pod, afs->pollutant_code) == NULL &&
              strcmp(selected_sic," ") == NULL &&
              strcmp(selected_scc," ") == NULL) ||
             (strcmp(selected_fips, " ") == NULL  &&
              strcmp(selected_pod," ") == NULL &&
              strcmp(selected_sic, afs->SIC_code) == NULL &&
              strcmp(selected_scc," ") == NULL) ||
             (strcmp(selected_fips, " ") == NULL  &&
              strcmp(selected_pod," ") == NULL &&
              strcmp(selected_sic," ") == NULL &&
              strcmp(selected_scc,afs->SCC_code) == NULL) ||
             /* second logical check */
             (strcmp(selected_fips, afs->FIPS_code) == NULL  &&
              strcmp(selected_pod, afs->pollutant_code) == NULL &&
              strcmp(selected_sic," ") == NULL &&
              strcmp(selected_scc," ") == NULL) ||
             (strcmp(selected_fips, afs->FIPS_code) == NULL  &&
              strcmp(selected_pod," ") == NULL &&
              strcmp(selected_sic, afs->SIC_code) == NULL &&
              strcmp(selected_scc," ") == NULL) ||
             (strcmp(selected_fips, afs->FIPS_code) == NULL  &&
              strcmp(selected_pod," ") == NULL &&
              strcmp(selected_sic," ") == NULL &&
              strcmp(selected_scc,afs->SCC_code) == NULL) ||
             (strcmp(selected_fips, " ") == NULL  &&
              strcmp(selected_pod, afs->pollutant_code) == NULL &&
              strcmp(selected_sic, afs->SIC_code) == NULL &&
              strcmp(selected_scc," ") == NULL) ||
             (strcmp(selected_fips, " ") == NULL  &&
              strcmp(selected_pod, afs->pollutant_code) == NULL &&
              strcmp(selected_sic," ") == NULL &&
              strcmp(selected_scc,afs->SCC_code) == NULL) ||
             (strcmp(selected_fips, " ") == NULL  &&
              strcmp(selected_pod," ") == NULL &&
              strcmp(selected_sic, afs->SIC_code) == NULL &&
              strcmp(selected_scc,afs->SCC_code) == NULL) ||
              /* third logical check */
             (strcmp(selected_fips, afs->FIPS_code) == NULL  &&
              strcmp(selected_pod, afs->pollutant_code) == NULL &&
              strcmp(selected_sic, afs->SIC_code) == NULL &&
              strcmp(selected_scc," ") == NULL) ||
             (strcmp(selected_fips, afs->FIPS_code) == NULL  &&
              strcmp(selected_pod, afs->pollutant_code) == NULL &&
              strcmp(selected_sic," ") == NULL &&
              strcmp(selected_scc,afs->SCC_code) == NULL) ||
             (strcmp(selected_fips, afs->FIPS_code) == NULL  &&
              strcmp(selected_pod," ") == NULL &&
              strcmp(selected_sic, afs->SIC_code) == NULL &&
              strcmp(selected_scc,afs->SCC_code) == NULL) ||
             (strcmp(selected_fips, " ") == NULL  &&
              strcmp(selected_pod, afs->pollutant_code) == NULL &&
              strcmp(selected_sic, afs->SIC_code) == NULL &&
              strcmp(selected_scc,afs->SCC_code) == NULL) ||
             /* fourth logical check */
             (strcmp(selected_fips, afs->FIPS_code) == NULL  &&
              strcmp(selected_pod, afs->pollutant_code) == NULL &&
              strcmp(selected_sic, afs->SIC_code) == NULL  &&
              strcmp(selected_scc, afs->SCC_code) == NULL)
             )
         {
            if (single)
            {
               if (ii == 0)
               {
                  fprintf(prtfile, "%s", tmp2);
                  pxloc[ii] = afs->xloc;
                  pyloc[ii] = afs->yloc;
                  ii++;
               }
               else
               {
                  ji = 0;
                  for(ij=0; ij<ii; ij++)
                  {
                     if (afs->xloc == pxloc[ij] &&
                         afs->yloc == pyloc[ij] )
                     {
                        ji = 1;
                     }
                  }
                  if (ji == 0)
                  {
                     fprintf(prtfile, "%s", tmp2);
                     pxloc[ii] = afs->xloc;
                     pyloc[ii] = afs->yloc;
                     ii++;
                  }
               }
            }
            else
            {
               fprintf(prtfile, "%s", tmp2);
            }
/*
            fprintf(stderr, "Data type: %s\n", afs->data_type);
            fprintf(stderr, "Projection year: %d\n", afs->prj_year);
            fprintf(stderr, "Inventory base year: %d\n", afs->base_year);
            fprintf(stderr, "Emission type: %s\n", afs->emiss_type);
            fprintf(stderr, "FIPS code: %s\n", afs->FIPS_code);
            fprintf(stderr, "X location(UTM coord.): %f\n", afs->xloc);
            fprintf(stderr, "Y location(UTM coord.): %f\n", afs->yloc);
            fprintf(stderr, "UTM zone: %d\n", afs->utmzone);
            fprintf(stderr, "Pollutant code: %d\n", afs->pollutant_code);
            fprintf(stderr, "Emission: %f(tons)\n", afs->emission);
            fprintf(stderr, "Plant Name: %s\n", afs->plant_name);
            fprintf(stderr, "\nThis is the end of record %d.\n", index);
*/
         }
         free((AFSrecord *)afs);
      }
   }
   else 
   {
      fprintf(stderr, "Can't open file %s.\n", afsfile);
   }
   fclose(afsfile);
}

if (View_Data || Auto_View)
{
   FILE *afsfile, *objfile;
   int ivert;
   UTMcoordinate temputm;
   GEScoordinate tempges;
   static AVSfield_float *tmpfield;
   int dims0[1];

/* Free old field data                                                   */
   if (*outfield) AVSfield_free(*outfield);
/*                                                                       */
/* THIS IS THE END OF THE 'HINTS' AREA. ADD YOUR OWN CODE BETWEEN THE    */
/* FOLLOWING COMMENTS. THE CODE YOU SUPPLY WILL NOT BE OVERWRITTEN.      */
   if (strcmp(selected_fips," ") == NULL &&
       strcmp(selected_pod," ") == NULL &&
       strcmp(selected_sic," ") == NULL &&
       strcmp(selected_scc," ") == NULL )
   {
      view_all = 1;
      AVSwarning("Please select FIPS, POD, SIC or SCC Code!!");
      return(0);
   }
   else
   {
      view_all = 0;
   }

   if ((afsfile = fopen(selected_file, "r"))!=NULL)
   {
      index = 0;
      jj = 0;
      objfile = fopen("tmppnt.txt","w");
      while (fgets(tmp1, RECLENGTH, afsfile)!= NULL)
      {
         index++;
         sprintf(tmp2, "%s\0", tmp1);
         afs = (AFSrecord *)malloc(1*sizeof(AFSrecord));
         for (i=0; i<NUMBEROFFIELD; i++)
         {
             current_field = i;
             count = 0;
             tmp3 = (char *)malloc(MAXFIELD*sizeof(char));
             for (j=df[i].begin_col-1; 
                  j<=df[i].end_col-1; j++)
             {
                tmp3[count] = tmp2[j];
                count++;
             }
             tmp3[count] = '\0';
             switch (current_field) {
                case 4:
                      sprintf(afs->FIPS_code, "%s", tmp3);
                      break;
                case 6:
                      sprintf(afs->SIC_code, "%s", tmp3);
                      break;
                case 7:
                      sprintf(afs->SCC_code, "%s", tmp3);
                      break;
                case 30:
                      sprintf(afs->pollutant_code, "%s", tmp3);
                      break;
                case 36:
                      sprintf(afs->plant_name, "%s", tmp3);
                      break;
             }
             free((char *)tmp3);
         }
          
         if ( 
             /* first logical check */
             (strcmp(selected_fips, afs->FIPS_code) == NULL  &&
              strcmp(selected_pod," ") == NULL &&
              strcmp(selected_sic," ") == NULL &&
              strcmp(selected_scc," ") == NULL) ||
             (strcmp(selected_fips, " ") == NULL  &&
              strcmp(selected_pod, afs->pollutant_code) == NULL &&
              strcmp(selected_sic," ") == NULL &&
              strcmp(selected_scc," ") == NULL) ||
             (strcmp(selected_fips, " ") == NULL  &&
              strcmp(selected_pod," ") == NULL &&
              strcmp(selected_sic, afs->SIC_code) == NULL &&
              strcmp(selected_scc," ") == NULL) ||
             (strcmp(selected_fips, " ") == NULL  &&
              strcmp(selected_pod," ") == NULL &&
              strcmp(selected_sic," ") == NULL &&
              strcmp(selected_scc,afs->SCC_code) == NULL) ||
             /* second logical check */
             (strcmp(selected_fips, afs->FIPS_code) == NULL  &&
              strcmp(selected_pod, afs->pollutant_code) == NULL &&
              strcmp(selected_sic," ") == NULL &&
              strcmp(selected_scc," ") == NULL) ||
             (strcmp(selected_fips, afs->FIPS_code) == NULL  &&
              strcmp(selected_pod," ") == NULL &&
              strcmp(selected_sic, afs->SIC_code) == NULL &&
              strcmp(selected_scc," ") == NULL) ||
             (strcmp(selected_fips, afs->FIPS_code) == NULL  &&
              strcmp(selected_pod," ") == NULL &&
              strcmp(selected_sic," ") == NULL &&
              strcmp(selected_scc,afs->SCC_code) == NULL) ||
             (strcmp(selected_fips, " ") == NULL  &&
              strcmp(selected_pod, afs->pollutant_code) == NULL &&
              strcmp(selected_sic, afs->SIC_code) == NULL &&
              strcmp(selected_scc," ") == NULL) ||
             (strcmp(selected_fips, " ") == NULL  &&
              strcmp(selected_pod, afs->pollutant_code) == NULL &&
              strcmp(selected_sic," ") == NULL &&
              strcmp(selected_scc,afs->SCC_code) == NULL) ||
             (strcmp(selected_fips, " ") == NULL  &&
              strcmp(selected_pod," ") == NULL &&
              strcmp(selected_sic, afs->SIC_code) == NULL &&
              strcmp(selected_scc,afs->SCC_code) == NULL) ||
              /* third logical check */
             (strcmp(selected_fips, afs->FIPS_code) == NULL  &&
              strcmp(selected_pod, afs->pollutant_code) == NULL &&
              strcmp(selected_sic, afs->SIC_code) == NULL &&
              strcmp(selected_scc," ") == NULL) ||
             (strcmp(selected_fips, afs->FIPS_code) == NULL  &&
              strcmp(selected_pod, afs->pollutant_code) == NULL &&
              strcmp(selected_sic," ") == NULL &&
              strcmp(selected_scc,afs->SCC_code) == NULL) ||
             (strcmp(selected_fips, afs->FIPS_code) == NULL  &&
              strcmp(selected_pod," ") == NULL &&
              strcmp(selected_sic, afs->SIC_code) == NULL &&
              strcmp(selected_scc,afs->SCC_code) == NULL) ||
             (strcmp(selected_fips, " ") == NULL  &&
              strcmp(selected_pod, afs->pollutant_code) == NULL &&
              strcmp(selected_sic, afs->SIC_code) == NULL &&
              strcmp(selected_scc,afs->SCC_code) == NULL) ||
             /* fourth logical check */
             (strcmp(selected_fips, afs->FIPS_code) == NULL  &&
              strcmp(selected_pod, afs->pollutant_code) == NULL &&
              strcmp(selected_sic, afs->SIC_code) == NULL  &&
              strcmp(selected_scc, afs->SCC_code) == NULL)
             )
         {
            fprintf(objfile,"%s", tmp1);
            jj++;
         }
         free((AFSrecord *)afs);
    }
    fclose(objfile);

    if (jj < 1) return(0);
    /* Free old temp field data                                */
    if (tmpfield) AVSfield_free(tmpfield);

    /* Allocate space for new field output                          */
    dims0[0] = jj;
    tmpfield = (AVSfield_float *) AVSdata_alloc(
          "field 1D 3-space 1-vector irregular float", dims0);
    if (tmpfield == NULL) {
       AVSerror("Allocation of output field failed.");
       return(0);
    }
    /* FILL IN THE OUTPUT FIELD  Here!                                */
   if ((objfile = fopen("tmppnt.txt", "r"))!=NULL)
   {
      ivert = 0;
      while (fgets(tmp1, RECLENGTH, objfile)!= NULL)
      {
         index++;
         sprintf(tmp2, "%s\0", tmp1);
         afs = (AFSrecord *)malloc(1*sizeof(AFSrecord));
         for (i=0; i<NUMBEROFFIELD; i++)
         {
             current_field = i;
             count = 0;
             tmp3 = (char *)malloc(MAXFIELD*sizeof(char));
             for (j=df[i].begin_col-1;
                  j<=df[i].end_col-1; j++)
             {
                tmp3[count] = tmp2[j];
                count++;
             }
             tmp3[count] = '\0';
             switch (current_field) {
                case 15:
                      afs->xloc = atof(tmp3);
                      break;
                case 16:
                      afs->yloc = atof(tmp3);
                      break;
                case 17:
                      afs->utmzone = atoi(tmp3);
                      break;
                case 31:
                      afs->emission = atof(tmp3);
                      break;
             }
             free((char *)tmp3);
         }

         if (utmornot)
         {
            tempges = map_utm_to_latlon(afs->xloc,
                      afs->yloc,afs->utmzone);
         }
         else
         {
            tempges.lat = afs->xloc;
            tempges.lon = afs->yloc;
            if (afs->utmzone <= 30 && tempges.lon >0.0)
                tempges.lon = -tempges.lon;
         }
         temputm = map_latlon_to_utm(tempges.lon, tempges.lat, map_utm_zone);
         tempx = temputm.x;
         tempy = temputm.y;
         tempz = 1.0;
         tmpfield->points[3*ivert] = tempx;
         tmpfield->points[3*ivert+1] = tempy;
         tmpfield->points[3*ivert+2] = tempz;
         tmpfield->data[ivert] = afs->emission;
         ivert++;
         free((AFSrecord *)afs);
      }
      fclose(objfile);

      /* output field data */
      *outfield = tmpfield;
   }
   }
   else 
   {
      fprintf(stderr, "Can't open file %s.\n", afsfile);
   }
   fclose(afsfile);
}

free((char *)tmp1);
free((char *)tmp2);
free((char *)tmp4);
free((FIPSstring *)tmpfips);
free((FIPSstring *)tmppod);
free((SICstring *)tmpsic);
free((SCCstring *)tmpscc);

/* <---- END OF USER-SUPPLIED CODE SECTION #3                            */
	return(1);
}
 
/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
int ((*mod_list[])()) = {
	AFS_extract_desc,
};
#define NMODS (sizeof(mod_list) / sizeof(char *))

AVSinit_modules()
{
	AVSinit_from_module_list(mod_list, NMODS);
}
 
/* ---. START OF USER-SUPPLIED CODE SECTION #4 (SUBROUTINES, FUNCTIONS, UTILITY ROUTINES)*/
/* <---- END OF USER-SUPPLIED CODE SECTION #4                            */
