/* mod_gen Version 1                                                     */
/* Module Name: "AMS extract" (Input) (Subroutine)                       */
/* Author: Jeff Wang,NCSC,248-9242                                       */
/* Date Created: Thu Jun 24 10:41:36 1993                                */
/*                                                                       */
/* This file is automatically generated by the Module Generator (mod_gen)*/
/* Please do not modify or move the contents of this comment block as    */
/* mod_gen needs it in order to read module sources back in.             */
/*                                                                       */
/* End of Module Description Comments                                    */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <avs/avs.h>
#include <avs/field.h>
#include <avs/port.h>
#include <avs/geom.h>
#include "draw_usmap.h"
 
/* ---. START OF USER-SUPPLIED CODE SECTION #1 (INCLUDE FILES, GLOBAL VARIABLES)*/

#define   RECLENGTH            292 
#define   NUMBEROFFIELD        27
#define   MAXFIELD             145

typedef char FIPSstring[6];
typedef char PODstring[6];
typedef char SICstring[5];
typedef char ASCstring[11];

typedef struct  {
int begin_col;
int end_col;
char *type;
} data_format;

typedef struct  {
char data_type[1];         /* Inventory Type (optional) */
int prj_year;              /* Projection Year (optional) */
int base_year;             /* Inventory Base Year (optional) */
char emiss_type[2];        /* Emission Type */
char FIPS_code[5];         /* FIPS state/county code */
char City_FIPS[5];         /* Subregion code (city FIPS) (optional) */
char SIC_code[4];          /* Standard Industrial Classification Code */
char ASC_code[10];         /* Source Classification Code */
char period[2];            /* Period */
int begin_date;            /* Beginning period interval date/time;in YYMMDDHH */
int end_date;              /* Ending period interval date/time;in YYMMDDHH */
char pollutant_code[5];    /* Pollutant code */
float emission;            /* Emissions of specified pollutant (tons) */
int PCE_code;              /* Primary control equipment code for specified
                              pollutant (optional) */
float CCEffect;            /* Combined control effectiveness (percent)
                              for specified pollutant (optional) */
float RuleEffect;          /* Rule effectiveness (percent) of specified
                              pollutant (optional) */
float RulePen;             /* Rule penetration (percent) of specified
                              pollutant (100% default for point sources)
                              (optional) */
int day_per_week;          /* Days per week operating (optional) */
int week_per_year;         /* Week per year operating (optional) */
char thput_hourly[144];    /* Hourly throughput (%) (24F5.0,1x) (optional) */
float thput_peiod;         /* Period throughput (%) (optional) */
float wekday_factor;       /* Weekday ajustment factor (optional) */
float satday_factor;       /* Saturday ajustment factor (optional) */
float sunday_factor;       /* Sunday ajustment factor (optional) */
float activity_level;      /* Activity Level (optional) */
char act_unit[3];          /* Activity Level Units (optional) */
int act_process_code;      /* Activity process (optional) */
} AMSrecord;

data_format df[] = {
      1,   1, "A",
      2,   3, "I",
      5,   6, "I",
      7,   8, "A",
      9,  13, "A",
     15,  19, "A",
     21,  24, "A",
     26,  35, "A",
     37,  38, "A",
     40,  47, "I",
     49,  56, "I",
     58,  62, "A",
     64,  73, "R",
     75,  77, "I",
     79,  84, "R",
     86,  91, "R",
     93,  97, "R",
     99,  99, "I",
    101, 103, "I",
    105, 248, "R",
    250, 254, "R",
    256, 260, "R",
    262, 266, "R",
    268, 272, "R",
    274, 283, "R",
    285, 287, "A",
    289, 290, "I"
};

static char  c, selected_file[132]; 
static char  oldfips[5], oldpod[5], oldsic[4], oldasc[10]; 
static char  selected_fips[5], selected_pod[5], selected_sic[4], 
             selected_asc[10];
static float xdraw22, ydraw22, zdraw22;
static float verts[1200], color[1200];
static int update, inumber, utmornot=0;
static float tempx, tempy, tempx_end, tempy_end;
static AVSfield_float *tmpfield;

float x_cut();
float y_cut();
/* <---- END OF USER-SUPPLIED CODE SECTION #1                            */
 
/* *****************************************/
/*  Module Description                     */
/* *****************************************/
int AMS_extract_desc()
{

	int in_port, out_port, param;
	extern int AMS_extract_compute();

	AVSset_module_name("AMS extract", MODULE_DATA);

	/* Input Port Specifications               */
	in_port = AVScreate_input_port("in_data", "string", OPTIONAL);

	/* Output Port Specifications              */
        out_port = AVScreate_output_port("outfield",
                "field 1D 4-space 1-vector irregular float");

	/* Parameter Specifications                */
	param = AVSadd_parameter("Select AMS File", "string", " ", " ", ":");
	AVSconnect_widget(param, "browser");
	param = AVSadd_parameter("Select County By FIPS", "choice", " ", 
                " ", "\n");
	AVSconnect_widget(param, "choice_browser");
	param = AVSadd_parameter("Plot By Pollutant Code", "choice", " ", 
                " ", "\n");
	AVSconnect_widget(param, "choice_browser");
        param = AVSadd_parameter("Plot By ASC Code", "choice", " ",
                " ", "\n");
	AVSconnect_widget(param, "choice_browser");
        param = AVSadd_parameter("county files", "string", " ", " ", ":");
        AVSconnect_widget(param, "browser");
        param = AVSadd_parameter("View Data", "oneshot", 0, 0, 1);
        AVSconnect_widget(param, "oneshot");
        param = AVSadd_parameter("Auto View", "boolean", 0, 0, 1);
        AVSconnect_widget(param, "toggle");
        param = AVSadd_parameter("Print Records", "oneshot", 0, 0, 1);
        AVSconnect_widget(param, "oneshot");
        param = AVSadd_parameter("map utm zone", "integer", 0, 0, 100000);
        AVSconnect_widget(param, "typein_integer");
        param = AVSadd_parameter("Coordinate Type", "choice",
                "Lat/Lon Type", "UTM Coodinate Type:Lat/Lon Type", ":");
        AVSconnect_widget(param, "radio_buttons");
        AVSadd_parameter_prop(param, "width", "integer", 4);

	AVSset_compute_proc(AMS_extract_compute);
/* ---. START OF USER-SUPPLIED CODE SECTION #2 (ADDITIONAL SPECIFICATION INFO)*/
/* <---- END OF USER-SUPPLIED CODE SECTION #2                            */
	return(1);
}
 
/* *****************************************/
/* Module Compute Routine                  */
/* *****************************************/
int AMS_extract_compute( 
in_data, 
outfield,
Select_AMS_File,
Select_County_By_FIPS,
Plot_By_Pollutant_Code,
Plot_By_ASC_Code,
county_files,
View_Data,
Auto_View,
Print_Records,
map_utm_zone,
Coordinate_Type
)
	char *in_data;
        AVSfield_float **outfield;
	char *Select_AMS_File;
        char *Select_County_By_FIPS;
        char *Plot_By_Pollutant_Code;
        char *Plot_By_ASC_Code;
        char *county_files;
        int View_Data;
        int Auto_View;
        int Print_Records;
        int map_utm_zone;
        char *Coordinate_Type;
{
/*  THIS IS A 'HINTS' AREA - YOU MAY CUT AND PASTE AT WILL FROM IT       */
int dims0[1];
static int index, i, j, jj, count, current_field;
static int my_choice, ichoice;
static int view_all, print_all, found;
static int fipscount, podcount, siccount, asccount;
char *tmp1, *tmp2, *tmp3, *tmp4;
AMSrecord  *ams;
FIPSstring *tmpfips, minfips; 
PODstring  *tmppod, minpod;
SICstring  *tmpsic;
ASCstring  *tmpasc, minasc;
float x0, y0;
float x, y;
char      line[LINESIZE],fileName[LINESIZE];
static char      countyfile[LINESIZE];
int       k, n, bWrite, pass;
WordType  word1, word2, Pname, Wname, Sname;
FilePtr   fpin1, fpin2;
FilePtr   fpout4;
int ivert;

if (AVSparameter_changed("Coordinate Type"))
{
   ichoice = AVSchoice_number("Coordinate Type", Coordinate_Type);
   switch (ichoice)
   {
      case 1:
            utmornot = 1;
            break;
      case 2:
            utmornot = 0;
            break;
   }
}

if ((tmp1 = (char *)malloc(RECLENGTH*sizeof(char))) == NULL)
{
   fprintf(stderr, "No enough space for tmp1!!\n");
}

if ((tmp2 = (char *)malloc(RECLENGTH*sizeof(char))) == NULL)
{
   fprintf(stderr, "No enough space for tmp2!!\n");
}

if ((tmp4 = (char *)malloc(RECLENGTH*sizeof(char))) == NULL)
{
   fprintf(stderr, "No enough space for tmp4!!\n");
}

if ((tmpfips = (FIPSstring *)calloc(500, sizeof(FIPSstring)))==NULL)
{
   fprintf(stderr, "No enough space for tmpfips!!\n");
}

if ((tmppod = (FIPSstring *)calloc(500, sizeof(FIPSstring)))==NULL)
{
   fprintf(stderr, "No enough space for tmppod!!\n");
}

if ((tmpasc = (ASCstring *)calloc(500, sizeof(ASCstring)))==NULL)
{
   fprintf(stderr, "No enough space for tmpasc!!\n");
}

/* ---. START OF USER-SUPPLIED CODE SECTION #3 (COMPUTE ROUTINE BODY)   */

if (AVSparameter_changed("county files"))
{
   sprintf(countyfile, "%s\0", county_files);
}


if (AVSparameter_changed("Select AMS File"))
{
   FILE *amsfile, *fipsfile;
   FILE *podfile, *sicfile, *ascfile;
   char *podstr, *liststr, *sicstr, *ascstr;
 
   sprintf(selected_fips, " \0");
   AVSmodify_parameter("Select County By FIPS", AVS_VALUE, "", 
                       Select_County_By_FIPS, "\n");
   sprintf(selected_pod, " \0");
   AVSmodify_parameter("Plot By Pollutant Code", AVS_VALUE, "", 
                       Plot_By_Pollutant_Code, "\n");
   /* this is neccessary */
   sprintf(selected_sic, " \0");
   sprintf(selected_asc, " \0");
   AVSmodify_parameter("Plot By ASC Code", AVS_VALUE, "", 
                       Plot_By_ASC_Code, "\n");
   sprintf(selected_file, "%s\0", Select_AMS_File);
   fipsfile = fopen("amsfips.txt","w");
   sprintf(oldfips, " ");
   podfile = fopen("amspod.txt","w");
   sprintf(oldpod, " ");
   sicfile = fopen("amssic.txt","w");
   sprintf(oldsic, " ");
   ascfile = fopen("amsasc.txt","w");
   sprintf(oldasc, " ");
   if ((amsfile = fopen(selected_file, "r")) != NULL)
   {
      index = 0;
      fipscount = 0;
      podcount = 0;
      siccount = 0;
      asccount = 0;
      while (fgets(tmp1, RECLENGTH, amsfile) != NULL)
      {
         index++;
         sprintf(tmp2, "%s\0", tmp1);
         ams = (AMSrecord *)malloc(1*sizeof(AMSrecord));
         for (i=0; i<NUMBEROFFIELD; i++)
         {
             current_field = i;
             count = 0;
             tmp3 = (char *)malloc(MAXFIELD*sizeof(char));
             for (j=df[i].begin_col-1; 
                  j<=df[i].end_col-1; j++)
             {
                tmp3[count] = tmp2[j];
                count++;
             }
             tmp3[count] = '\0';
             switch (current_field) {
                case 0:
                      sprintf(ams->data_type, "%s", tmp3);
                      break; 
                case 1:
                      ams->prj_year = atoi(tmp3);
                      break;
                case 2:
                      ams->base_year = atoi(tmp3);
                      break;
                case 3:
                      sprintf(ams->emiss_type, "%s", tmp3);
                      break;
                case 4:
                      sprintf(ams->FIPS_code, "%s", tmp3);
                      break;
                case 6:
                      sprintf(ams->SIC_code, "%s", tmp3);
                      break;
                case 7:
                      sprintf(ams->ASC_code, "%s", tmp3);
                      break;
                case 11:
                      sprintf(ams->pollutant_code, "%s", tmp3);
                      break;
                case 12: 
                      ams->emission = atof(tmp3);
                      break;
             }
             free((char *)tmp3);
         }

         /* For FIPS code */
         if (fipscount == 0)
         {
            sprintf(tmpfips[fipscount], "%s\0", ams->FIPS_code);
            fipscount++;
         }

         else if (strcmp(ams->FIPS_code, oldfips) != NULL)
         {
            found = 0;
            j = 0;
            while (!found && j<fipscount)
            {
               if (strcmp(tmpfips[j], ams->FIPS_code) == NULL)
               {
                  found = 1;
               }
               j++;
            }
            if (!found)
            {
               strcpy(tmpfips[fipscount], ams->FIPS_code);
               fipscount++;
            }
         }
         sprintf(oldfips, "%s", ams->FIPS_code);

         /* For pollutant ID */
         if (podcount == 0)
         {
            sprintf(tmppod[podcount], "%s\0", ams->pollutant_code);
            podcount++;
         }

         else if (strcmp(ams->pollutant_code, oldpod) != NULL)
         {
            found = 0;
            j = 0;
            while (!found && j<podcount)
            {
               if (strcmp(tmppod[j], ams->pollutant_code) == NULL)
               {
                  found = 1;
               }
               j++;
            }
            if (!found)
            {
               strcpy(tmppod[podcount], ams->pollutant_code);
               podcount++;
            }
         }
         sprintf(oldpod, "%s", ams->pollutant_code);

         /* For ASC Code */
         if (asccount == 0)
         {
            sprintf(tmpasc[asccount], "%s\0", ams->ASC_code);
            asccount++;
         }

         else if (strcmp(ams->ASC_code, oldasc) != NULL)
         {
            found = 0;
            j = 0;
            while (!found && j<asccount)
            {
               if (strcmp(tmpasc[j], ams->ASC_code) == NULL)
               {
                  found = 1;
               }
               j++;
            }
            if (!found)
            {
               strcpy(tmpasc[asccount], ams->ASC_code);
               asccount++;
            }
         }
         sprintf(oldasc, "%s", ams->ASC_code);
         /* free the memory for next record */
         free((AMSrecord *)ams);
      }
   }
   else 
   {
      fprintf(stderr, "Can't open file %s.\n", amsfile);
   }
   fclose(amsfile);

   /* For fips array */
   fipscount = fipscount -1;
   /* Sort the value */
   for (i=0; i<fipscount; i++)
   {
       sprintf(minfips, "%s", tmpfips[i]);
       jj = i;
       found = 0;
       for (j=i+1; j<=fipscount; j++)
       {
           if (strcmp(minfips, tmpfips[j]) > 0)
           {
              sprintf(minfips, "%s", tmpfips[j]);
              jj = j;
              found = 1;
           }
       }
       if (found)
       {
           sprintf(tmpfips[jj], "%s", tmpfips[i]);
           sprintf(tmpfips[i], "%s", minfips);
       }
   }
   /* Write out the data */
   for (j=0; j<=fipscount; j++)
   {
       fprintf(fipsfile, "%s\n", tmpfips[j]);
   }
   fclose(fipsfile);

   /* For pod array */
   podcount = podcount -1;
   /* Sort the value */
   for (i=0; i<podcount; i++)
   {
       sprintf(minpod, "%s", tmppod[i]);
       jj = i;
       found = 0;
       for (j=i+1; j<=podcount; j++)
       {
           if (strcmp(minpod, tmppod[j]) > 0)
           {
              sprintf(minpod, "%s", tmppod[j]);
              jj = j;
              found = 1;
           }
       }
       if (found)
       {
           sprintf(tmppod[jj], "%s", tmppod[i]);
           sprintf(tmppod[i], "%s", minpod);
       }
   }
   /* Write out the data */
   for (j=0; j<=podcount; j++)
   {
       fprintf(podfile, "%s\n", tmppod[j]);
   }
   fclose(podfile);

   asccount = asccount -1;
   /* Sort the value */
   for (i=0; i<asccount; i++)
   {
       sprintf(minasc, "%s", tmpasc[i]);
       jj = i;
       found = 0;
       for (j=i+1; j<=asccount; j++)
       {
           if (strcmp(minasc, tmpasc[j]) > 0)
           {
              sprintf(minasc, "%s", tmpasc[j]);
              jj = j;
              found = 1;
           }
       }
       if (found)
       {
           sprintf(tmpasc[jj], "%s", tmpasc[i]);
           sprintf(tmpasc[i], "%s", minasc);
       }
   }
   /* Write out the data */
   for (j=0; j<=asccount; j++)
   {
       fprintf(ascfile, "%s\n", tmpasc[j]);
   }
   fclose(ascfile);
   liststr = (char *)list_file_browser("amsfips.txt");
   AVSmodify_parameter("Select County By FIPS", AVS_MINVAL,
                       "", (char *)liststr, "\n");
   podstr = (char *)list_file_browser("amspod.txt");
   AVSmodify_parameter("Plot By Pollutant Code", AVS_MINVAL,
                       "", (char *)podstr, "\n");
   ascstr = (char *)list_file_browser("amsasc.txt");
   AVSmodify_parameter("Plot By ASC Code", AVS_MINVAL,
                       "", (char *)ascstr, "\n");
  
   /* Draw the County Map */
   fpin1 = fopen(countyfile, "r");
   k = 0; i = 0; bdrSize = 0;

   sprintf(fileName, "work_county.ind\0");
   fpout4 = fopen (fileName, "w");
   while( fgets(line, LINESIZE, fpin1) != NULL )
   {
      if ( strchr(line,DENOMINATOR) != NULL )
      {
         /* reset the state boundary points count */
         bWrite = 0; k = 0; j = 0;
         sscanf( line, "%[^,]%*1s %s", Sname, word2);
         n = atoi(word2);
         strncpy( Wname, Sname, 6 );
         Wname[6] = '\0';
         for(jj=0; jj<6; jj++)
         {
            if (jj > 0) Pname[jj-1] = Wname[jj];
         }
         Pname[5] = '\0';
         bWrite = 0;
         for (jj=0; jj<=fipscount; jj++)
         {
             if (strcmp(Pname, tmpfips[jj]) == NULL)
                bWrite = 1;
         }
         if ( bWrite == 1 )
         {
            /* add the statesize */
            i = i + 1;
            fprintf( fpout4, "'%s' %d\n", Pname, n );
         }
      }
      else
      {
         j = 0;
         sscanf( line, "%[^,]%*1s %s", Sname, word2);
         if ( bWrite == 1 )
         {
            k = k + 1; bdrSize = bdrSize + 1;
            fprintf( fpout4, "%s %s\n", Sname, word2 );
         }
      }
      if (k > maxBdrSize) maxBdrSize = k;
   }
   stateSize = i;
   bdrSize = bdrSize + 1;
   fclose(fpout4);
   fclose(fpin1);
   /* end of the raw data preprocessing */
   printf("End\n");

}

if (AVSparameter_changed("Select County By FIPS"))
{
   sprintf(selected_fips, "%s\0", Select_County_By_FIPS);
}

if (AVSparameter_changed("Plot By Pollutant Code"))
{
   sprintf(selected_pod, "%s\0", Plot_By_Pollutant_Code);
}

if (AVSparameter_changed("Plot By ASC Code"))
{
   sprintf(selected_asc, "%s\0", Plot_By_ASC_Code);
}

if (Print_Records)
{
   FILE *amsfile;

   Print_Records = 0;
   if (strcmp(selected_fips," ") == NULL &&
       strcmp(selected_pod," ") == NULL)
   {
      print_all = 1;
   }
   else
   {
      print_all = 0;
   }
   if ((amsfile = fopen(selected_file, "r"))!=NULL)
   {
      index = 0;
      while (fgets(tmp1, RECLENGTH, amsfile)!= NULL)
      {
         index++;
         sprintf(tmp2, "%s\0", tmp1);
         ams = (AMSrecord *)malloc(1*sizeof(AMSrecord));
         for (i=0; i<NUMBEROFFIELD; i++)
         {
             current_field = i;
             count = 0;
             tmp3 = (char *)malloc(MAXFIELD*sizeof(char));
             for (j=df[i].begin_col-1; 
                  j<=df[i].end_col-1; j++)
             {
                tmp3[count] = tmp2[j];
                count++;
             }
             tmp3[count] = '\0';
             switch (current_field) {
                case 0:
                      sprintf(ams->data_type, "%s", tmp3);
                      break; 
                case 1:
                      ams->prj_year = atoi(tmp3);
                      break;
                case 2:
                      ams->base_year = atoi(tmp3);
                      break;
                case 3:
                      sprintf(ams->emiss_type, "%s", tmp3);
                      break;
                case 4:
                      sprintf(ams->FIPS_code, "%s", tmp3);
                      break;
                case 6:
                      sprintf(ams->SIC_code, "%s", tmp3);
                      break;
                case 7:
                      sprintf(ams->ASC_code, "%s", tmp3);
                      break;
                case 11:
                      sprintf(ams->pollutant_code, "%s", tmp3);
                      break;
                case 12:
                      ams->emission = atof(tmp3);
                      break;
             }
             free((char *)tmp3);
         }
         if (print_all || strcmp(selected_fips, ams->FIPS_code) == NULL )
         {
            fprintf(stderr, "%s\n", tmp2);
/*
            fprintf(stderr, "Data type: %s\n", ams->data_type);
            fprintf(stderr, "Projection year: %d\n", ams->prj_year);
            fprintf(stderr, "Inventory base year: %d\n", ams->base_year);
            fprintf(stderr, "Emission type: %s\n", ams->emiss_type);
*/
            fprintf(stderr, "FIPS code: %s\n", ams->FIPS_code);
            fprintf(stderr, "Pollutant code: %d\n", ams->pollutant_code);
            fprintf(stderr, "Emission: %f(tons)\n", ams->emission);
            fprintf(stderr, "\nThis is the end of record %d.\n", index);
         }
         free((AMSrecord *)ams);
      }
   }
   else 
   {
      fprintf(stderr, "Can't open file %s.\n", amsfile);
   }
   fclose(amsfile);
}

if (View_Data || Auto_View)
{
   FILE *amsfile, *objfile;
   int ivert;
   float base, height;
   int           i, j, ih, n, nn, iwd, icolor, k, *n1, *n2;
   char          line[LINESIZE], dummy;
   WordType      word2, word1, dum1;
   TitleType     word11, word12, word13, word14,
		 word15, word16, word17, word18;
   float         xp, yp, Xmin1, Ymin1, Xmax1, Ymax1;
   int dims0[1];

   View_Data = 0;
/* Free old field data                                                   */
   if (*outfield) AVSfield_free(*outfield);
   /* First open a blunch of temp. files */
   sprintf(fileName, "work_county.ind");
   fpin2  = fopen ( fileName, READONLY  );

   /* Claim The Enough Memory */
   if( (n1 = (int *)calloc(stateSize+1, sizeof(int))
       ) == (int *)NULL )
     { printf("n1: Not Enough Memory.");
       exit(0); }

   if( (n2 = (int *)calloc(stateSize+1, sizeof(int))
       ) == (int *)NULL )
     { printf("n2: Not Enough Memory.");
       exit(0); }

   if( (UsName = (WordType *)calloc(stateSize+1, sizeof(WordType))
       ) == (WordType *)NULL )
     { printf(" UsName: Not Enough Memory.");
       exit(0); }

   if( (State = (GraType *)calloc( bdrSize, sizeof(GraType))
       ) == (GraType *)NULL )
     { printf("State: Not Enough Memory.");
       exit(0); }

   k = 0; i = 0;
   do {
       i = i + 1;
       if( fgets(line, LINESIZE, fpin2) == NULL )
	  n = 9999;
       else
       {
          sscanf( line, "%*1s%[^'\"]%*1s %s\n", word1, word2);
          sprintf( UsName[i], "%s\0", word1 ); n = atoi(word2);
          if ( n != 0 )
          {
             for ( j=1; j<=n; j++ )
             {
                k = k + 1;
                fgets( line, LINESIZE, fpin2 );
                State[k] = ( *get_boundary)( line, k );
                if( j == 1) n1[i] = k;
                if( j == n) n2[i] = k;
             }
          }
          State[n1[i]].Prev = n2[i];
          State[n2[i]].Next = n1[i];
       }
   } while( n != 9999 && i <= stateSize+1 );
   Sno = i - 1;

/* FOLLOWING COMMENTS. THE CODE YOU SUPPLY WILL NOT BE OVERWRITTEN.      */
   if (strcmp(selected_fips," ") == NULL &&
       strcmp(selected_sic," ") == NULL &&
       strcmp(selected_asc," ") == NULL &&
       strcmp(selected_pod," ") == NULL)
   {
      view_all = 1;
      AVSwarning("Please select FIPS, POD or ASC Code!!");
      return(0);
   }
   else
   {
      view_all = 0;
   }

   if ((amsfile = fopen(selected_file, "r"))!=NULL)
   {
      index = 0;
      jj = 0;
      objfile = fopen("tmparea.txt","w");
      while (fgets(tmp1, RECLENGTH, amsfile)!= NULL)
      {
         index++;
         sprintf(tmp2, "%s\0", tmp1);
         ams = (AMSrecord *)malloc(1*sizeof(AMSrecord));
         for (i=0; i<NUMBEROFFIELD; i++)
         {
             current_field = i;
             count = 0;
             tmp3 = (char *)malloc(MAXFIELD*sizeof(char));
             for (j=df[i].begin_col-1; 
                  j<=df[i].end_col-1; j++)
             {
                tmp3[count] = tmp2[j];
                count++;
             }
             tmp3[count] = '\0';
             switch (current_field) {
                case 4:
                      sprintf(ams->FIPS_code, "%s", tmp3);
                      break;
                case 6:
                      sprintf(ams->SIC_code, "%s", tmp3);
                      break;
                case 7:
                      sprintf(ams->ASC_code, "%s", tmp3);
                      break;
                case 11:
                      sprintf(ams->pollutant_code, "%s", tmp3);
                      break;
             }
             free((char *)tmp3);
         }
          
         if (!view_all && ( 
             /* first logical check */
             (strcmp(selected_fips, ams->FIPS_code) == NULL  &&
              strcmp(selected_pod," ") == NULL &&
              strcmp(selected_sic," ") == NULL &&
              strcmp(selected_asc," ") == NULL) ||
             (strcmp(selected_fips, " ") == NULL  &&
              strcmp(selected_pod, ams->pollutant_code) == NULL &&
              strcmp(selected_sic," ") == NULL &&
              strcmp(selected_asc," ") == NULL) ||
             (strcmp(selected_fips, " ") == NULL  &&
              strcmp(selected_pod," ") == NULL &&
              strcmp(selected_sic, ams->SIC_code) == NULL &&
              strcmp(selected_asc," ") == NULL) ||
             (strcmp(selected_fips, " ") == NULL  &&
              strcmp(selected_pod," ") == NULL &&
              strcmp(selected_sic," ") == NULL &&
              strcmp(selected_asc,ams->ASC_code) == NULL) ||
             /* second logical check */
             (strcmp(selected_fips, ams->FIPS_code) == NULL  &&
              strcmp(selected_pod, ams->pollutant_code) == NULL &&
              strcmp(selected_sic," ") == NULL &&
              strcmp(selected_asc," ") == NULL) ||
             (strcmp(selected_fips, ams->FIPS_code) == NULL  &&
              strcmp(selected_pod," ") == NULL &&
              strcmp(selected_sic, ams->SIC_code) == NULL &&
              strcmp(selected_asc," ") == NULL) ||
             (strcmp(selected_fips, ams->FIPS_code) == NULL  &&
              strcmp(selected_pod," ") == NULL &&
              strcmp(selected_sic," ") == NULL &&
              strcmp(selected_asc,ams->ASC_code) == NULL) ||
             (strcmp(selected_fips, " ") == NULL  &&
              strcmp(selected_pod, ams->pollutant_code) == NULL &&
              strcmp(selected_sic, ams->SIC_code) == NULL &&
              strcmp(selected_asc," ") == NULL) ||
             (strcmp(selected_fips, " ") == NULL  &&
              strcmp(selected_pod, ams->pollutant_code) == NULL &&
              strcmp(selected_sic," ") == NULL &&
              strcmp(selected_asc,ams->ASC_code) == NULL) ||
             (strcmp(selected_fips, " ") == NULL  &&
              strcmp(selected_pod," ") == NULL &&
              strcmp(selected_sic, ams->SIC_code) == NULL &&
              strcmp(selected_asc,ams->ASC_code) == NULL) ||
             /* third logical check */
             (strcmp(selected_fips, ams->FIPS_code) == NULL  &&
              strcmp(selected_pod, ams->pollutant_code) == NULL &&
              strcmp(selected_sic, ams->SIC_code) == NULL &&
              strcmp(selected_asc," ") == NULL) ||
             (strcmp(selected_fips, ams->FIPS_code) == NULL  &&
              strcmp(selected_pod, ams->pollutant_code) == NULL &&
              strcmp(selected_sic," ") == NULL &&
              strcmp(selected_asc,ams->ASC_code) == NULL) ||
             (strcmp(selected_fips, ams->FIPS_code) == NULL  &&
              strcmp(selected_pod," ") == NULL &&
              strcmp(selected_sic, ams->SIC_code) == NULL &&
              strcmp(selected_asc,ams->ASC_code) == NULL) ||
             (strcmp(selected_fips, " ") == NULL  &&
              strcmp(selected_pod, ams->pollutant_code) == NULL &&
              strcmp(selected_sic, ams->SIC_code) == NULL &&
              strcmp(selected_asc,ams->ASC_code) == NULL) ||
             /* fourth logical check */
             (strcmp(selected_fips, ams->FIPS_code) == NULL  &&
              strcmp(selected_pod, ams->pollutant_code) == NULL &&
              strcmp(selected_sic, ams->SIC_code) == NULL  &&
              strcmp(selected_asc, ams->ASC_code) == NULL) 
            ) )
         {
            fprintf(objfile,"%s", tmp1);
            jj++;
         }
         free((AMSrecord *)ams);
      }
      fclose(objfile);

      if (jj < 1) return(0);
      /* Free old temp field data                                */
      if (tmpfield) AVSfield_free(tmpfield);

      /* Allocate space for new field output: assume at most 500 lines per */
      /* county            */
      dims0[0] = 300*jj;
      tmpfield = (AVSfield_float *) AVSdata_alloc(
            "field 1D 4-space 1-vector irregular float", dims0);
      if (tmpfield == NULL) {
         AVSerror("Allocation of output field failed.");
         return(0);
      }

      if ((objfile = fopen("tmparea.txt", "r"))!=NULL)
      {
      inumber = 0;
      while (fgets(tmp1, RECLENGTH, objfile)!= NULL)
      {
         sprintf(tmp2, "%s\0", tmp1);
         ams = (AMSrecord *)malloc(1*sizeof(AMSrecord));
         for (i=0; i<NUMBEROFFIELD; i++)
         {
             current_field = i;
             count = 0;
             tmp3 = (char *)malloc(MAXFIELD*sizeof(char));
             for (j=df[i].begin_col-1;
                  j<=df[i].end_col-1; j++)
             {
                tmp3[count] = tmp2[j];
                count++;
             }
             tmp3[count] = '\0';
             switch (current_field) {
                case 4:
                      sprintf(ams->FIPS_code, "%s", tmp3);
                      break;
                case 12:
                      ams->emission = atof(tmp3);
                      break;
             }
             free((char *)tmp3);
         }
         base = ams->emission;
         /* draw out the map */
         for ( i = 1; i <= Sno; i++ )
         {
            if (strcmp(UsName[i], ams->FIPS_code) == NULL)
            {
               put_usmap2(base, map_utm_zone, n1[i], n2[i], UsName[i]);
            }
         }
         free((AMSrecord *)ams);
      }
      fclose(objfile);

      /*  output field data */
      *outfield = tmpfield;
      }
   }
   else 
   {
      fprintf(stderr, "Can't open file %s.\n", amsfile);
   }
   /* Close All the Files */
   fclose(fpin2);
   fclose(amsfile);

/* free any locally allocated data                                       */

   free( (void *)n1 );
   free( (void *)n2 );
   free( (void *)UsName );
   free( (GraType *)State );
}

free((char *)tmp1);
free((char *)tmp2);
free((char *)tmp4);
free((FIPSstring *)tmpfips);
free((FIPSstring *)tmppod);
free((ASCstring *)tmpasc);
/* <---- END OF USER-SUPPLIED CODE SECTION #3                            */
	return(1);
}
 
/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
int ((*mod_list[])()) = {
	AMS_extract_desc,
};
#define NMODS (sizeof(mod_list) / sizeof(char *))

AVSinit_modules()
{
	AVSinit_from_module_list(mod_list, NMODS);
}
 
/* ---. START OF USER-SUPPLIED CODE SECTION #4 (SUBROUTINES, FUNCTIONS, UTILITY ROUTINES)*/

GraType get_boundary( char line[LINESIZE], int j )
{
  float       xx, yy;
  WordType    word1, word2;
  GraType     Token;

  sscanf( line, "%s %s\n",  word1, word2 );
  xx = atof(word1); yy = atof(word2);
  Token.Xw = 10000*xx;
  Token.Yw = 10000*yy;
  Token.Next = j + 1;
  return( Token );
}

float x_cut(x,min,max)
float *x, *min, *max;
{
float xout;

xout = *x;
if (xout < *min) xout = *min;
if (xout > *max) xout = *max;

return (xout);
}

float y_cut(y,min,max)
float *y, *min, *max;
{
float yout;

yout = *y;
if (yout < *min) yout = *min;
if (yout > *max) yout = *max;

return (yout);
}

int put_usmap2(float base, int map_utm, int n1, int n2, 
               WordType Name)
{
  int         i, ii, n, jj, i1, i2, nn, nn1, idvt, idct, j,
	      NextJ, *IdBrk, inindc, same, PrevJ, Pcount;
  int         Xwork1, Ywork1, Xwork2, Ywork2, nidct, Pj2,
              xs0, ys0, xs1, ys1, xs2, ys2, xs3, ys3,
              ins, icode, imode, itype, jvert;
  float       xp, yp, xp1, yp1, xp2, yp2, xp3, yp3;
  float       x1, x2, x3;
  int         ivert, idpt;
  UTMcoordinate temputm;
  GEScoordinate tempges;

  /* Allocate enough memory */
  if( (IdBrk = (int *)calloc( 500, sizeof(int) )
       ) == (int *)NULL )
     { printf("IdBrk: Not Enough Memory.");
       exit(0); }

  xp3 = 10000.;  yp3 = 10000.;
  nn = 0;  ii = 0;
  for ( j=n1; j<=n2; j++ )
  {
     xp = State[j].Xw/xp3; yp = State[j].Yw/yp3;
     if ( j == n1 )
     {
        ivert = 0; 
        if (utmornot)
        {
                  tempges = map_utm_to_latlon(xp, yp,
                      map_utm);
        }
        else
        {
                  tempges.lat = yp;
                  tempges.lon = xp;
                  if (map_utm <= 30 && tempges.lon >0.0)
                      tempges.lon = -tempges.lon;
        }
        temputm = map_latlon_to_utm(tempges.lon,
                         tempges.lat, map_utm);
        xdraw22 = temputm.x;
        ydraw22 = temputm.y;
        verts[ivert++] = xdraw22;
        verts[ivert++] = ydraw22;
        verts[ivert++] = 0.0;
        ii = ii + 1;
        IdBrk[ii] = j;
        idvt = 0;
     }
     else
     {
        if ( idvt == 1 )
        {
           if (utmornot)
           {
                  tempges = map_utm_to_latlon(xp, yp,
                      map_utm);
           }
           else
           {
                  tempges.lat = yp;
                  tempges.lon = xp;
                  if (map_utm <= 30 && tempges.lon >0.0)
                      tempges.lon = -tempges.lon;
           }
           temputm = map_latlon_to_utm(tempges.lon, 
                         tempges.lat, map_utm);
           xdraw22 = temputm.x;
           ydraw22 = temputm.y;
           verts[ivert++] = xdraw22;
           verts[ivert++] = ydraw22;
           verts[ivert++] = 0.0;
           State[j-1].Next = IdBrk[ii];
           State[IdBrk[ii]].Prev = j-1;
           ii = ii + 1;
           IdBrk[ii] = j;
           idvt = 0;
        }
        idct = 0;

        for ( i=n1; i<=j-1; i++ )
        {
           xp1 = State[i].Xw/xp3; yp1 = State[i].Yw/yp3;
           if( xp == xp1 && yp == yp1 )
           {
               idct = 1; nn = nn + 1;
               if (utmornot)
               {
                  tempges = map_utm_to_latlon(xp, yp,
                      map_utm);
               }
               else
               {
                  tempges.lat = yp;
                  tempges.lon = xp;
                  if (map_utm <= 30 && tempges.lon >0.0)
                      tempges.lon = -tempges.lon;
               }
               temputm = map_latlon_to_utm(tempges.lon, 
                         tempges.lat, map_utm);
               xdraw22 = temputm.x;
               ydraw22 = temputm.y;
               verts[ivert++] = xdraw22;
               verts[ivert++] = ydraw22;
               verts[ivert++] = 0.0;
        }  }

        if (idct == 1 && nn >= 1 )
        {
           idvt = 1;
           ivert = ivert/3-1; 
           jvert = ivert;
           for (jj=0; jj <=jvert; jj++)
           {
               tmpfield->points[4*inumber] = verts[jj*3];
               tmpfield->points[4*inumber+1] = verts[jj*3+1];
               tmpfield->points[4*inumber+2] = verts[jj*3+2];
               tmpfield->points[4*inumber+3] = jvert*1.0;
               tmpfield->data[inumber] = base;
               inumber++;
           }
           ivert = 0;
        }
        else
        {
            if (utmornot)
            {
                  tempges = map_utm_to_latlon(xp, yp,
                      map_utm);
            }
            else
            {
                  tempges.lat = yp;
                  tempges.lon = xp;
                  if (map_utm <= 30 && tempges.lon >0.0)
                      tempges.lon = -tempges.lon;
            }
            temputm = map_latlon_to_utm(tempges.lon, 
                         tempges.lat, map_utm);
            xdraw22 = temputm.x;
            ydraw22 = temputm.y;
            verts[ivert++] = xdraw22;
            verts[ivert++] = ydraw22;
            verts[ivert++] = 0.0;
        }
     }   
  }
  /* reset the Breaker */
  if ( ii == 1 )
  {
     ii=2;
     IdBrk[1] = n1;
     IdBrk[2] = n2 + 1;
  }
  free( (void *)IdBrk );
  return( n );
}

