/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

 AUTHOR : Lawrence Berkeley Laboratory
*****************************************************************************

/*   This software is copyright (C) 1991,  Regents  of  the
University  of  California.   Anyone may reproduce color_legend.c,
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  color_legend.c  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  color_legend.c  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     color_legend.c is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
color_legend.c, or any part thereof.

Summer 1991  wes bethel  ewbethel@lbl.gov    
*/

#include <stdio.h>
#include <avs/avs.h>
#include <avs/colormap.h>
#include <avs/geom.h>

#define MIN(a,b) (((a)<(b))?(a):(b))

static char
    scale_name[] = {"color_legend"},
    boundary_name[] = {"color_boundary"},
    labels_name[] = {"legend_labels"},
    label_b_name[] = {"label_bounaries"};

char *parent_name = scale_name;

    
AVSinit_modules()
{
    int color_legend();
    AVSmodule_from_desc(color_legend);
}

int
color_legend()
{
    int color_legend_p(),p;

    AVSset_module_name("color legend",MODULE_MAPPER);
    AVScreate_input_port("Input Color Scale", "colormap", REQUIRED);
    AVScreate_output_port("Output Scale","geom");

    p=AVSadd_parameter("dummy1","string","Boundary Control Parameters","","");
    AVSconnect_widget(p,"text");
    AVSadd_parameter_prop(p,"width","integer",4);

    p=AVSadd_parameter("Boundary on/off","boolean",1,0,1);
    AVSconnect_widget(p,"toggle");
    AVSadd_parameter_prop(p,"width","integer",2);
    p=AVSadd_parameter("Boundary Gray Level","integer",255,0,255);
    AVSconnect_widget(p,"islider");
    
    p=AVSadd_parameter("dummy2","string","Label Control Parameters","","");
    AVSconnect_widget(p,"text");
    AVSadd_parameter_prop(p,"width","integer",4);

    p=AVSadd_parameter("Labels on/off","boolean",1,0,1);
    AVSconnect_widget(p,"toggle");
    AVSadd_parameter_prop(p,"width","integer",2);

    p=AVSadd_parameter("Label Density","integer",2,2,12);
    AVSconnect_widget(p,"islider");
    p=AVSadd_float_parameter("Label Height",0.09,0.001,0.2);
    AVSconnect_widget(p,"slider");
    p=AVSadd_parameter("Decimal Precision","integer",1,0,10);
    AVSconnect_widget(p,"islider");
    p=AVSadd_parameter("Label Gray Level","integer",255,0,255);
    AVSconnect_widget(p,"islider");
    p=AVSadd_parameter("Label Font","integer",0,0,21);
    AVSconnect_widget(p,"islider");
    
    p=AVSadd_parameter("dummy2a","string","Label Boundary Control","","");
    AVSconnect_widget(p,"text");
    AVSadd_parameter_prop(p,"width","integer",4);

    p=AVSadd_parameter("Label Boundaries on/off","boolean",0,0,1);
    AVSconnect_widget(p,"toggle");
    AVSadd_parameter_prop(p,"width","integer",3);

    p=AVSadd_parameter("dummy3","string","Misc. Control Parameters","","");
    AVSconnect_widget(p,"text");
    AVSadd_parameter_prop(p,"width","integer",4);

    p = AVSadd_parameter("Reverse Colors","boolean",0,0,1);
    AVSconnect_widget(p,"toggle");
    
    p=AVSadd_parameter("dummy4","string","Legend Orientation Control","","");
    AVSconnect_widget(p,"text");
    AVSadd_parameter_prop(p,"width","integer",4);

    p=AVSadd_parameter("Orientation","choice","vertical","vertical!horizontal","!");
    AVSconnect_widget(p,"radio_buttons");

    p=AVSadd_float_parameter("x offset",0.0,FLOAT_UNBOUND,FLOAT_UNBOUND);
    AVSconnect_widget(p,"dial");
    p=AVSadd_float_parameter("y offset",0.0,FLOAT_UNBOUND,FLOAT_UNBOUND);
    AVSconnect_widget(p,"dial");
    p=AVSadd_float_parameter("scale",1.0,FLOAT_UNBOUND,FLOAT_UNBOUND);
    AVSconnect_widget(p,"dial");

    AVSset_compute_proc(color_legend_p);
}

#define USIZE 2

color_legend_p(cmap,og,
	       dummy1,do_boundary,boundary_gray,
	       dummy2,do_labels,label_density,label_height,
	       precision,label_gray,font_number,
	       dummy2a,do_lb,
	       dummy3,flip,
	       dummy4,orientation,xoffset,yoffset,scale_geom)
char *dummy1,*dummy2,*dummy3,*orientation,*dummy4,*dummy2a;
AVScolormap *cmap;
GEOMedit_list *og;
int flip,do_boundary,do_labels,precision,label_gray,boundary_gray,font_number;
int do_lb;
float *label_height,*xoffset,*yoffset,*scale_geom;
{
    GEOMobj *scale,*boundary,*labels,*label_boundaries;
    float *normals;
    unsigned long *colors;
    float *vertices;
    float *b_vertices,*b_colors;
    int nblocks;
    int hsv_to_rgb(), make_normals();
    float xsize,ysize;
    static float ref_point[3],offset[3],height,label_color[3];
    static char this_label[128],sprintf_arg[5];
    float labeld;
    float lv,dlv,lp,dlp;
    int i;
    float *extent = NULL;
    int vertical_flag = AVSchoice_number("Orientation",orientation)-1;

    
    *og = GEOMinit_edit_list(*og);
    
    nblocks = cmap->size;
    
    /* first, make the color scale itself. */
   
    vertices = (float *)malloc(sizeof(float)*nblocks*USIZE*3);
    normals = (float *)malloc(sizeof(float)*nblocks*USIZE*3);
    colors = (unsigned long *)malloc(sizeof(unsigned long)*nblocks*USIZE);

    /* the following set the proprotions for the width vs height
       for the color legend. */
    
    xsize = 0.05 * (*scale_geom);
    ysize = 1.0 * (*scale_geom);

    if (vertical_flag == 0)
    {
	make_vertices_vertical(vertices,&xsize,&ysize,cmap->size,USIZE,
			       *xoffset,*yoffset);
    }
    else
    {
	make_vertices_horiz(vertices,&ysize,&xsize,cmap->size,USIZE,
			    *xoffset,*yoffset);
    }
		       
    make_normals(normals,cmap->size,USIZE);
    
    make_colors(colors,cmap,cmap->size,USIZE,flip);

    scale = GEOMcreate_mesh_with_data(GEOM_NULL,vertices,normals, 
	colors,cmap->size,USIZE,GEOM_COPY_DATA);  
    GEOMnormalize_normals(scale);
    
    GEOMedit_geometry(*og,parent_name,scale);
    GEOMdestroy_obj(scale);
    free(vertices);
    free(normals);
    free(colors);
    
    /* create a boundary (if the user requested it) to go around
       the color scale */

    boundary = GEOMcreate_obj(GEOM_POLYTRI,extent);
    if (do_boundary)
    {
	b_vertices = (float *)malloc(sizeof(float)*5*3);
	b_colors = (float *)malloc(sizeof(float)*5*3);
	if (vertical_flag == 0)  /* vertical */
	    make_boundary_vertices(b_vertices,&xsize,&ysize,*xoffset,*yoffset);
	else /* horizontal */
	    make_boundary_vertices(b_vertices,&ysize,&xsize,*xoffset,*yoffset);
	    
	/* set the boundary color to some shade of gray. */
	for (i=0;i<5*3;i++)
	    *(b_colors+i) = (double)boundary_gray/255.0;
	GEOMadd_polyline(boundary,b_vertices,b_colors,5,GEOM_COPY_DATA);
	
	free(b_vertices);
	free(b_colors);
    }
    GEOMedit_geometry(*og,boundary_name,boundary);
    GEOMedit_selection_mode(*og,boundary_name,"ignore",0);
    GEOMedit_parent(*og,boundary_name,parent_name);
    GEOMdestroy_obj(boundary);

    /* ok, now we're done with the color scale part. so, we will
       move onto the labels. */

    labels = GEOMcreate_obj(GEOM_LABEL,extent);

    /**
      * NOTE: if you change the way the label positioning is done,
      * you'll need to make corresponding changes below where the
      * label boundary coordinates are computed.
    **/
    
    if (do_labels)
    {
	/* Set the number of digits to the right of the decimal */
	sprintf_arg[0] = '%';
	sprintf_arg[1] = '.';
	sprintf_arg[2] = precision + 0x30;
	sprintf_arg[3] = 'f';
	sprintf_arg[4] = '\0';

	label_color[0] = label_color[1] = label_color[2] = (double)label_gray / 255.0;
	
	ref_point[0] = 0.0;
	ref_point[1] = 0.0; 
	ref_point[2] = 0.0;
	height = *label_height;
        labeld = (double)(label_density - 1);

	if (flip)
	{
	    lp  = ysize;
	    dlp = -1.0 * (ysize/labeld);
	}
	else
	{
	    lp  = 0.0;
	    dlp = ysize/labeld;
	}
	
	lv = cmap->lower;
	dlv = (cmap->upper - cmap->lower)/labeld;

	ref_point[2] = 0.0;
	for (i=0;i<label_density;i++,lv+=dlv,lp+=dlp)
	{
	    sprintf(this_label,sprintf_arg,lv);
	    if (vertical_flag == 0) /* vertical */
	    {
		ref_point[0] = 0.066 + *xoffset + xsize;
		ref_point[1] = lp - 0.20*height + *yoffset;
		GEOMadd_label(labels,this_label,ref_point,offset,height,
			      label_color,
			      GEOMcreate_label_flags(font_number,0,0,0,GEOM_LABEL_LEFT,0));
	    }
	    else
	    {
		ref_point[1] = -0.066 + *yoffset - 4.0*height;
		ref_point[0] = lp - 0.20*height + *xoffset;
		GEOMadd_label(labels,this_label,ref_point,offset,height,
			      label_color,
			      GEOMcreate_label_flags(font_number,0,0,0,GEOM_LABEL_CENTER,0));
	    }
	    
	}
    }
    GEOMedit_geometry(*og,labels_name,labels);
    GEOMedit_selection_mode(*og,labels_name,"ignore",0);
    GEOMedit_parent(*og,labels_name,parent_name);
    GEOMdestroy_obj(labels);

    /* do the label boundaries, if requested. */
    label_boundaries = GEOMcreate_obj(GEOM_POLYTRI,extent);
    b_vertices = (float *)malloc(sizeof(float)*2*3);
    b_colors = (float *)malloc(sizeof(float)*2*3);
    if (do_lb)
    {
	if (flip)
	{
	    lp = ysize;
	    dlp = -1.0 * ysize/labeld;
	}
	else
	{
	    lp = 0.0;
	    dlp = ysize/labeld;
	}
	
	lv = cmap->lower;
	dlv = (cmap->upper - cmap->lower)/labeld;

        /* z coordinates */
	*(b_vertices+2) = *(b_vertices+5) = 0.0;

	for (i=0;i<6;i++)
	    *(b_colors+i) = (double)label_gray/255.0;
	
	for (i=0;i<label_density;i++,lv+=dlv,lp+=dlp)
	{

	    if (vertical_flag == 0) /* vertical */
	    {
		*(b_vertices) = 0.0 + *xoffset;
		*(b_vertices+1) = lp + *yoffset; /*  - 0.20*height; */
		*(b_vertices+3) = 0.05 + *xoffset + xsize;
		*(b_vertices+4) = lp + *yoffset; /*  - 0.20*height; */
	    }
	    else
	    {
		*(b_vertices) = lp + *xoffset; /* - 0.20*height; */
		*(b_vertices+1) = *yoffset + xsize;
		*(b_vertices+3) = lp + *xoffset; /* - 0.20*height; */
		*(b_vertices+4) = *yoffset - 0.05;
	    }
	    GEOMadd_polyline(label_boundaries,b_vertices,b_colors,2,GEOM_COPY_DATA);
	}
    }
    free(b_vertices);
    free(b_colors);
    GEOMedit_geometry(*og,label_b_name,label_boundaries);
    GEOMedit_selection_mode(*og,label_b_name,"ignore",0);
    GEOMedit_parent(*og,label_b_name,parent_name);
    GEOMdestroy_obj(label_boundaries);

    return(1);
}

make_boundary_vertices(bv,xn,yn,xoffset,yoffset)
float *bv;
float *xn,*yn;
float xoffset,yoffset;
{
    int i;

    *bv       = xoffset;
    *(bv + 1) = yoffset;
    *(bv + 2) = 0.0;

    *(bv + 3) = xoffset + *xn;
    *(bv + 4) = yoffset;
    *(bv + 5) = 0.0;

    *(bv + 6) = xoffset + *xn;
    *(bv + 7) = yoffset + *yn;
    *(bv + 8) = 0.0;

    *(bv + 9)  = xoffset;
    *(bv + 10) = yoffset + *yn;
    *(bv + 11) = 0.0;

    *(bv + 12) = xoffset;
    *(bv + 13) = yoffset;
    *(bv + 14) = 0.0;

/*
    for (i=0;i<5;i++)
	*(bv+(i*3)+2) = 0.; 
    *bv = *(bv+1) = 0.;
    *(bv+3) = *xn;
    *(bv+4) = 0.;
    *(bv+6) = *xn;
    *(bv+7) = *yn;
    *(bv+9) = 0.;
    *(bv+10) = *yn;
    *(bv+12) = *(bv+13) = 0.;
*/
}


static int
make_colors(dest,src,size,usize,flip)
unsigned long *dest;
AVScolormap *src;
int size,flip,usize;
{
    int i,j,index;
    long temp;
    int hsv_to_pixel();

    for (j=0;j<usize;j++)
	for (i=0;i<size;i++)
	{
	    if (flip)
		index = size - 1 - (MIN(i,255));
	    else
		index = i;
	    hsv_to_pixel(&temp,src->hue+index,src->saturation+index,src->value+index,src->alpha+index);
	    *dest++ = temp;
	}
}
static void
make_colors2(dest,src,size,usize,flip)
unsigned long *dest;
AVScolormap *src;
int size,flip,usize;
{
    int i,j,index,index2;
    long temp;
    double index_scale;
    int hsv_to_pixel();
    index_scale = (double)size/(double)usize;

    for (j=0;j<=usize;j++)
    {
	index2 = (int)(index_scale*(double)j);
	for (i=0;i<=size;i++)
	{
	    if (flip)
		index = size-1-(MIN(i,255));
	    else
		index = i;
	    hsv_to_pixel(&temp,src->hue+index,src->saturation+index2,src->value+index,src->alpha+index);
	    *dest++ = temp;
	}
    }
}
    
static void
make_colors3(dest,src,size,usize,flip)
unsigned long *dest;
AVScolormap *src;
int size,flip,usize;
{
    int i,j,index,index2;
    long temp;
    double index_scale;

    index_scale = (double)size/(double)(usize);
    
    for (j=0;j<=usize;j++)
    {
	index2 = (int)(index_scale*(double)j);
	for (i=0;i<=size;i++)
	{
	    if (flip)
		index = size-1-(MIN(i,255));
	    else
		index = i;
	    hsv_to_pixel(&temp,src->hue+index,src->saturation+index,src->value+index2,src->alpha+index);
	    *dest++ = temp;
	}
    }
}

static int
make_vertices_vertical(v,xs,ys,cmapsize,width,xoffset,yoffset)
float *v;
float *xs,*ys;
int cmapsize,width;
float xoffset,yoffset;
{
    int i,j;
    double x,dx,y,dy;

    dx = *xs/(double)(width-1);
    dy = *ys/(double)(cmapsize-1);

    for (j=0,x=0.;j<width;j++,x+=dx)
    {
	for (i=0,y=0;i<cmapsize;i++,y+=dy)
	{
	    *v++ = (float)x + xoffset;
	    *v++ = (float)y + yoffset;
	    *v++ = 0.;
	}
    }
}
static int
make_vertices_horiz(v,xs,ys,cmapsize,width,xoffset,yoffset)
float *v;
float *xs,*ys;
int cmapsize,width;
float xoffset,yoffset;
{
    int i,j;
    double x,dx,y,dy;

    dx = *xs/(double)(cmapsize-1);
    dy = *ys/(double)(width-1);

    for (j=0,y=0.;j<width;j++,y+=dy)
    {
	for (i=0,x=0.;i<cmapsize;i++,x+=dx)
	{
	    *v++ = (float)x + xoffset;
	    *v++ = (float)y + yoffset;
	    *v++ = 0.;
	}
    }
}
static int
make_normals(v,size,usize)
float *v;
int size;
{
    int i,j;

    for (j=0;j<usize;j++)
	for (i=0;i<size;i++)
	{
	    *v++ = 0.;
	    *v++ = 0.;
	    *v++ = 1.;
	}
}

#if 0
static
void hsv_to_rgb_brit(h,s,v,a,rgba,n)
float *h,*s,*v,*a;
unsigned long *rgba;
int n;
{
    static hsv_to_pixel();
    int i;
    float one=1.0;
    
    for (i=0;i<n;i++)
	hsv_to_pixel(rgba+i,h+i,s+i,&one,a+i);
}
static int
hsv_to_rgb_sat(h,s,v,a,rgba,n)
float *h,*s,*v,*a;
unsigned long *rgba;
int n;
{
    static hsv_to_pixel();
    float one=1.0;
    int i;
    
    for (i=0;i<n;i++)
	hsv_to_pixel(rgba+i,h+i,&one,v+i,a+i);
}
#endif
static int
hsv_to_rgb(h,s,v,a,rgba,n)
float *h,*s,*v,*a;
unsigned long *rgba;
int n;
{
    int hsv_to_pixel();
    int i;
    
    for (i=0;i<n;i++)
	hsv_to_pixel(rgba+i,h+i,s+i,v+i,a+i);
}

static int
hsv_to_pixel(rgb,h,s,v,a)
unsigned long *rgb;
float *h,*s,*v,*a;
{
    float f, p, q, t;
    float r, g, b;
    float ht;
    int ir,ig,ib,ia,i;
 
/*  Make sure not to trash the input colormap */
    ht = *h;

    if (*v == 0.)
    {
	r=0.;
	g=0.;
	b=0.;
    }
    else
    {
	if (*s == 0.)
	{
	    r = *v;
	    g = *v;
	    b = *v;
	}
	else
	{
	    ht = ht * 6.0;
	    if (ht >= 6.0)
		ht = 0.0;
      
	    i = ht;
	    f = ht - i;
	    p = *v*(1.0-*s);
	    q = *v*(1.0-*s*f);
	    t = *v*(1.0-*s*(1.0-f));
      
 	    if (i == 0) 
	    {
		r = *v;
		g = t;
		b = p;
	    }
	    else if (i == 1)
	    {
		r = q;
		g = *v;
		b = p;
	    }
	    else if (i == 2)
	    {
		r = p;
		g = *v;
		b = t;
	    }
	    else if (i == 3)
	    {
		r = p;
		g = q;
		b = *v;
	    }
	    else if (i == 4)
	    {
		r = t;
		g = p;
		b = *v;
	    }
	    else if (i == 5)
	    {
		r = *v;
		g = p;
		b = q;
	    }
	}
    }

    ia = *a*255.0;
    ir = r*255.0;
    ig = g*255.0;
    ib = b*255.0;

/* Comment out the next line for SGI; leave in for DEC and SET */
/* #define DEC5000 1 */
#ifdef DEC5000
    *rgb = (ib<<24) | (ig<<16) | (ir<<8) | (ia);
#else
    *rgb = (ia<<24) | (ir<<16) | (ig<<8) | (ib);
#endif
}

