/* line clipping algorithm from Foley & van Dam, p. 149 */

#include <stdio.h>
#define YES 1
#define NO 0


static int out1 = 0;
static int out2 = 0;
static float x1 = 0.;
static float y1 = 0.;
static float x2 = 0.;
static float y2 = 0.;

int clip(fx1, fy1, fx2, fy2, xmin, ymin, xmax, ymax)
float *fx1, *fy1, *fx2, *fy2;
float xmin, ymin, xmax, ymax;
{
char accept, reject, done;

x1 = *fx1;
y1 = *fy1;
x2 = *fx2;
y2 = *fy2;

accept = reject = done = NO;
while (!done)
	{
	outcode(xmin, ymin, xmax, ymax);
	reject = treject();
	if (reject)
		done = YES;
	else
		{
		accept = taccept();
		if (accept)
			done = YES;
		else
			{
			if (!out1)
				swap();
			if (out1 & 010)
				{
				x1 = x1 + (x2 - x1) * (ymax - y1)/(y2 - y1);
				y1 = ymax;
				}
			else if (out1 & 04)
				{
				x1 = x1 + (x2 - x1) * (ymin - y1)/(y2 - y1);
				y1 = ymin;
				}
			else if (out1 & 02)
				{
				y1 = y1 + (y2 - y1) * (xmax - x1)/(x2 - x1);
				x1 = xmax;
				}
			else if (out1 & 01)
				{
				y1 = y1 + (y2 - y1) * (xmin - x1)/(x2 - x1);
				x1 = xmin;
				}
			}
		}
	}
if (accept)
	{
	*fx1 = x1;
	*fy1 = y1;
	*fx2 = x2;
	*fy2 = y2;
	return(1);
	}
return(0);
}

outcode(xmin, ymin, xmax, ymax)
float xmin, ymin, xmax, ymax;
{
out1 = out2 = 0;

if (y1 > ymax)
	out1 |= YES << 3;
if (y1 < ymin)
	out1 |= YES << 2;
if (x1 > xmax)
	out1 |= YES << 1;
if (x1 < xmin)
	out1 |= YES << 0;
if (y2 > ymax)
	out2 |= YES << 3;
if (y2 < ymin)
	out2 |= YES << 2;
if (x2 > xmax)
	out2 |= YES << 1;
if (x2 < xmin)
	out2 |= YES << 0;
return;
}

int treject()
{
if ((out1 & out2) != 0)
	return(YES);
else
	return(NO);
}

int taccept()
{
if ((out1 == 0) && (out2 == 0))
	return(YES);
else
	return(NO);
}

swap()
{
float xtemp, ytemp;
int otemp;

xtemp = x1;
ytemp = y1;
x1 = x2;
y1 = y2;
x2 = xtemp;
y2 = ytemp;
otemp = out1;
out1 = out2;
out2 = otemp;
return;
}
