/****************************************************************************
                          INTERNATIONAL AVS CENTRE
           (This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Centre, University of Manchester, the AVS Consortium and
the individual  submitting the module and files associated with said module
provide absolutely NO WARRANTY OF ANY KIND with respect to this software.  The
entire risk as to the quality and performance of this software is with the
user.  IN NO EVENT WILL The International AVS Centre, University of Manchester,
the AVS Consortium and the individual submitting the module and files
associated with said module BE LIABLE TO ANYONE FOR ANY DAMAGES ARISING FROM
THE USE OF THIS SOFTWARE, INCLUDING, WITHOUT LIMITATION, DAMAGES RESULTING FROM
LOST DATA OR LOST PROFITS, OR ANY SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@iavsc.org.

Please send AVS module bug reports to avs@iavsc.org.

***************************************************************************/
/* mod_gen Version 1                                                     */
/* Module Name: "write BioRad PIC" (Output) (Subroutine)                 */
/* Author: Chris Pudney,1.33a or c,4571,3163027                          */
/* Date Created: Wed Mar 13 12:08:03 1996                                */
/*                                                                       */
/* This file is automatically generated by the Module Generator (mod_gen)*/
/* Please do not modify or move the contents of this comment block as    */
/* mod_gen needs it in order to read module sources back in.             */
/*                                                                       */
/* input 0 "image" field 1-vector byte REQUIRED                          */
/* param 0 "BioRad PIC File" browser "" "" ".PIC.pic"                    */
/* End of Module Description Comments                                    */

#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <avs/avs.h>
#include <avs/port.h>
#include <avs/field.h>

 
/* ----> START OF USER-SUPPLIED CODE SECTION #1 (INCLUDE FILES, GLOBAL VARIABLES)*/
/*------------------------------------------------------------------------------
 *	AUTHOR: Chris Pudney,
 *		Biomedical Confocal Microscopy Research Centre
 *		Dept. Pharmacology, Univ. of Western Australia, Nedlands, 6907.
 *		cpudney@alphapharm.uwa.edu.au
 *
 *	VERSION: DEC Alpha, OSF/1, cc
 *
 *	STARTED: 27/02/96
 *
 *	UPDATED: 12/03/96
 */


#include "pic.h"

/* <---- END OF USER-SUPPLIED CODE SECTION #1                            */
 
/* *****************************************/
/*  Module Description                     */
/* *****************************************/
int write_BioRad_PIC_desc()
{

	int in_port, out_port, param, iresult;
	extern int write_BioRad_PIC_compute();

	AVSset_module_name("write BioRad PIC", MODULE_RENDER);

	/* Input Port Specifications               */
	in_port = AVScreate_input_port("image", "field 1-vector byte", 
		REQUIRED);

	/* Parameter Specifications                */
	param = AVSadd_parameter("BioRad PIC File", "string", "", "", 
		".PIC.pic");
	AVSconnect_widget(param, "browser");

	AVSset_compute_proc(write_BioRad_PIC_compute);
/* ----> START OF USER-SUPPLIED CODE SECTION #2 (ADDITIONAL SPECIFICATION INFO)*/
/* <---- END OF USER-SUPPLIED CODE SECTION #2                            */
	return(1);
}
 
/* *****************************************/
/* Module Compute Routine                  */
/* *****************************************/
int write_BioRad_PIC_compute( image, BioRad_PIC_File)
	AVSfield_char *image;
	char *BioRad_PIC_File;
{

/* ----> START OF USER-SUPPLIED CODE SECTION #3 (COMPUTE ROUTINE BODY)   */

	int	n, ext;
	char	*basename, *filename;
	struct stat    sbuf;
	static PICheader        hdr = {
	{'\0', '\0', '\0', '\0', '\0', '\0', '\0', '\0', '\0', '\0', '\0',
	'\0', '\0', '\0', '\0', '\0', '\0', '\0', '\0', '\0', '\0', '\0',
	'\0', '\0', '\0', '\0', '\0', '\0', '\0', '\0', '\0', '\0'},
	(void *)NULL, (float)1., 1, 1, 1, 0, 255, 0, 255, 1, 1, 0, 7, 7,
	FILE_ID, 0, 1, 0, 0, 0};


	/* Check filename */
	if (!BioRad_PIC_File || BioRad_PIC_File[0] == '\0' ||
		!AVSparameter_changed("BioRad PIC File"))
	{
		return 0;

	} /* end if (!BioRad_PIC_File ... */

 	/* Check for overwrite */
	else if (!stat(BioRad_PIC_File, &sbuf))
	{
		char	*msg;


		msg = AVSmessage("1.0", AVS_Warning, NULL, "write_BioRad_PIC_compute",
			"Overwrite!Cancel",
			"%s\nalready exists.  Do you want to overwrite it?",
			BioRad_PIC_File);
		if (!strcmp(msg, "Cancel"))
		{
			return 0;

		} /* end if (!strcmp ... */
	} /* end else if (!stat ... */


	/* Check/assign dimensions */
	switch (image->ndim)
	{
	case 1:
		hdr.nx = image->dimensions[0];
		hdr.ny = 1;
		hdr.nz = 1;
		break;
	case 2:
		hdr.nx = image->dimensions[0];
		hdr.ny = image->dimensions[1];
		hdr.nz = 1;
		break;
	case 3:
		hdr.nx = image->dimensions[0];
		hdr.ny = image->dimensions[1];
		hdr.nz = image->dimensions[2];
		break;
	default:
		AVSwarning("Can only write 1D, 2D, or 3D images.");
		return 0;
		break;

	} /* end switch (image ... */

	/* Extract filename, add extension if necessary. */
	n = strlen(BioRad_PIC_File);
	ext = (n > 4) ? strcasecmp(&BioRad_PIC_File[n - 4], ".pic") : 1;
	if (ext)
	{
		filename = malloc(sizeof(char) * (n + 5));
		(void)strcpy(filename, BioRad_PIC_File);
		(void)strcat(filename, ".pic");
		
	} /* end if (ext) */

	else
	{
		filename = malloc(sizeof(char) * (n + 1));
		(void)strcpy(filename, BioRad_PIC_File);

	} /* end else */

	/* Copy filename to header */
	basename = strrchr(filename, (int)'/');
	basename = basename ? basename + 1 : filename;
	n = strlen(basename) - 4;
	(void)strncpy(hdr.name, basename, (n > 32) ? 32 : n);


	/* Write header */
	if (!write_PIC_header(filename, &hdr))
	{
		AVSwarning(PICerrStr);
		return 0;

	} /* end if (!write_PIC_header ... */

	/* Write data */
	if (!write_PIC_data(filename, &hdr, ((AVSfield_char *)image)->data))
	{
		AVSwarning(PICerrStr);
		return 0;

	} /* end if (!write_PIC_header ... */

/* <---- END OF USER-SUPPLIED CODE SECTION #3                            */
	return(1);
}
 
/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
static int ((*mod_list[])()) = {
	write_BioRad_PIC_desc
};
#define NMODS (sizeof(mod_list) / sizeof(char *))

AVSinit_modules()
{
	AVSinit_from_module_list(mod_list, NMODS);
}
 
/* ----> START OF USER-SUPPLIED CODE SECTION #4 (SUBROUTINES, FUNCTIONS, UTILITY ROUTINES)*/
/* <---- END OF USER-SUPPLIED CODE SECTION #4                            */
