/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/


/*********************************************************************

Copyright (C) 1995, Lawrence Berkeley Laboratory.  All Rights
Reserved.  Permission to copy and modify this software and its
documentation (if any) is hereby granted, provided that this notice
is retained thereon and on all copies.  

This software is provided as a professional academic contribution
for joint exchange.   Thus it is experimental and scientific
in nature, undergoing development, and is provided "as is" with
no warranties of any kind whatsoever, no support, promise of
updates or printed documentation.

This work is supported by the U. S. Department of Energy under 
contract number DE-AC03-76SF00098 between the U. S. Department 
of Energy and the University of California.


	Author: Wes Bethel, Kevin Campbell
		Lawrence Berkeley Laboratory
                Berkeley, California 

  "this software is 100% hand-crafted by a human being in the USA"

*********************************************************************/

#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>
#include <avs/avs.h>
#include <avs/colormap.h>

#define MAXLEN 100
#define MAXNUMLEN 20

AVSinit_modules()
{
    int read_cmap();
    AVSmodule_from_desc(read_cmap);
}

int
read_cmap()
{
    int read_cmap_p();
    int p;
    
    AVSset_module_name("read colormap",MODULE_DATA);

    p = AVScreate_output_port("The Colormap","colormap");
    p = AVSadd_parameter("Colormap Filename","string","","","");
    AVSconnect_widget(p,"browser");
    AVSset_compute_proc(read_cmap_p);
}

static float *h=NULL,*s=NULL,*v=NULL,*a=NULL;
static AVScolormap *static_cmap=NULL;
    
int
read_cmap_p(cmap,fname)
AVScolormap **cmap;
char *fname;
{
    FILE *f;
    int size, i, com;
    float minvalue, maxvalue;
    char *buf = malloc(sizeof(char) * (MAXLEN + 1));
    char *huebuf, *satbuf, *valbuf, *alphabuf;
    char **floatbuf;
    static int alloc=0;

    if (fname == NULL || *fname == '\0')
	return(0);

    if ( (f = fopen(fname,"r")) == NULL)
	return 0;

    if (static_cmap != NULL)
    {
/*      puts("static_cmap != NULL"); */
        if (!alloc)
	{
	  return 0;
	}
	free(static_cmap);
	free(h);
	free(s);
	free(v);
	free(a);
    }
    static_cmap = (AVScolormap *)malloc(sizeof(AVScolormap));
    alloc = 1;

    /* get size info from file */
    while (1) {
      if (com = fgetsWithComment(buf, MAXLEN, f))
	if (com == -1) {
/*	  puts("failed"); */
	  return 0;
	}
	else 
	  continue;
      else
	break;
    }

    stripws(&buf);
    static_cmap->size = size = atoi(buf);

    h = (float *)malloc(sizeof(float)*size);
    s = (float *)malloc(sizeof(float)*size);
    v = (float *)malloc(sizeof(float)*size);
    a = (float *)malloc(sizeof(float)*size);

    static_cmap->size = size;
    static_cmap->hue = h;
    static_cmap->saturation = s;
    static_cmap->value = v;
    static_cmap->alpha = a;

    /* read in h,s,v from file */

    /* alloc space for the strtod buffer */
    floatbuf = (char **)malloc(sizeof(char *));
  
    for (i = 0; i < size; i++)
    {
      if (com = fgetsWithComment(buf, MAXLEN, f))
	if (com == -1) {
/*	  puts ("failed"); */
	  return 0;
	}
        else {
	  i--;
	  continue;
	}

      huebuf = strtok(buf, " ");
      satbuf = strtok(NULL, " ");
      valbuf = strtok(NULL, " ");
      alphabuf = strtok(NULL, " ");

      static_cmap->hue[i] = strtod(huebuf, floatbuf);
      if (strcmp(huebuf, *floatbuf) == 0)
	return 0;
      static_cmap->saturation[i] = strtod(satbuf, floatbuf);
      if (strcmp(satbuf, *floatbuf) == 0)
	return 0;
      static_cmap->value[i] = strtod(valbuf, floatbuf);
      if (strcmp(valbuf, *floatbuf) == 0)
	return 0;
      static_cmap->alpha[i] = strtod(alphabuf, floatbuf);
      if (strcmp(alphabuf, *floatbuf) == 0)
	return 0;
    }

    /* read in min/max from file */
    if (fgets(buf, MAXLEN, f) == NULL)
      return 0;
    if (strtok(buf, " ") == NULL)
      return 0;
    else
    {
      minvalue = strtod(buf, floatbuf);
      if (strcmp(buf, *floatbuf) == 0)
        return 0;
    }

    strcpy(buf, strtok(NULL, "\n"));
    maxvalue = strtod(buf, floatbuf);
    if (strcmp(buf, *floatbuf) == 0)
      return 0;

    static_cmap->lower = minvalue;
    static_cmap->upper = maxvalue;

    /* free the strtod buffer */
    free(floatbuf);


    *cmap = static_cmap;

    return(1);
}

/*********************************************************************\
* Function: stripws
* 
* Description: removes the white space from the beginning and end of a
*    line. THIS INCLUDES NEWLINES.  
*
* Parameters: str - a double indirected pointer to a string.
*
* Returns: none.
\*********************************************************************/

static 
stripws(strp)
char **strp;
{
  char *aux;

  /* strip the white space from the front */
  while (isspace(**strp) || **strp == '\0')
    (*strp)++;

  /* strip the white space from the end */
  aux = *strp;
  while (*aux != '\0')
    aux++;
  while ( isspace(*(--aux)) )
    ;
  *(++aux) = '\0';
}


/*********************************************************************\
* Function: fgetsWithComment
*
* Description: Reads a line from the stream indicated, but if the 
*    first character in this line after any white space is a `#`,
*    it returns 1.  If there are "trailing comments" of the form:
*   
*         <some data> #this is a comment
*
*    a NULL character is placed where the first '#' is.
*
* Parameters: str - buffer to store the string in.
*             num - number of characters to read into the buffer
*             f - stream to read from
*
* Returns: returns 0 if it read in a line, 1 if it read in a comment,
*    and -1 if there was an error.
\********************************************************************/

fgetsWithComment(str, num, f)
char *str;
int num;
FILE *f;
{
  if(fgets(str,num,f) == NULL)
    return -1;

  /* skip the white space, if any */
  while (isspace(*str) || *str == '\0')
    str++;

  /* if what's left is a comment, return 1 */
  if (str[0] == '#')
    return 1;
  else {
    /* find trailing comment and delete it */
    while (*str != '\0')
    {
	if (*str == '#')
	{
	    *str = '\0';
	    break;
	}
	else
	    str++;
    }
    
    return 0;
  }
}

