/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
#ifndef lint
static char rcsid[] = "$Header: /usr/people/sam/tiff/libtiff/RCS/tif_fax4.c,v 1.12 91/08/22 17:17:11 sam Exp $";
#endif

/*
 * Copyright (c) 1990, 1991 Sam Leffler
 * Copyright (c) 1991 Silicon Graphics, Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the names of
 * Sam Leffler and Silicon Graphics may not be used in any advertising or
 * publicity relating to the software without the specific, prior written
 * permission of Sam Leffler and Silicon Graphics.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 * 
 * IN NO EVENT SHALL SAM LEFFLER OR SILICON GRAPHICS BE LIABLE FOR
 * ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF 
 * LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
 * OF THIS SOFTWARE.
 */

/*
 * TIFF Library.
 *
 * CCITT Group 4 Facsimile-compatible
 * Compression Scheme Support.
 */
#include "tiffioP.h"
#include "tif_fax3.h"

#if USE_PROTOTYPES
static	int Fax4Decode(TIFF*, u_char *, int, u_int);
static	int Fax4Encode(TIFF*, u_char *, int, u_int);
static	int Fax4PostEncode(TIFF*);
#else
static	int Fax4Decode();
static	int Fax4Encode();
static	int Fax4PostEncode();
#endif

TIFFInitCCITTFax4(tif)
	TIFF *tif;
{
	TIFFInitCCITTFax3(tif);		/* reuse G3 compression */
	tif->tif_decoderow = Fax4Decode;
	tif->tif_decodestrip = Fax4Decode;
	tif->tif_decodetile = Fax4Decode;
	tif->tif_encoderow = Fax4Encode;
	tif->tif_encodestrip = Fax4Encode;
	tif->tif_encodetile = Fax4Encode;
	tif->tif_postencode = Fax4PostEncode;
	/*
	 * This magic causes the regular G3 decompression
	 * code to not skip to the EOL mark at the end of
	 * a row (during normal decoding).
	 */
	tif->tif_options = FAX3_NOEOL;
	return (1);
}

/*
 * Decode the requested amount of data.
 */
static int
Fax4Decode(tif, buf, occ, s)
	TIFF *tif;
	u_char *buf;
	int occ;
	u_int s;
{
	Fax3BaseState *sp = (Fax3BaseState *)tif->tif_data;

	bzero(buf, occ);		/* decoding only sets non-zero bits */
	while (occ > 0) {
		if (!Fax3Decode2DRow(tif, buf, sp->rowpixels))
			return (0);
		bcopy(buf, sp->refline, sp->rowbytes);
		buf += sp->rowbytes;
		occ -= sp->rowbytes;
	}
	return (1);
}

/*
 * Encode the requested amount of data.
 */
static int
Fax4Encode(tif, bp, cc, s)
	TIFF *tif;
	u_char *bp;
	int cc;
	u_int s;
{
	Fax3BaseState *sp = (Fax3BaseState *)tif->tif_data;

	while (cc > 0) {
		if (!Fax3Encode2DRow(tif, bp, sp->refline, sp->rowpixels))
			return (0);
		bcopy(bp, sp->refline, sp->rowbytes);
		bp += sp->rowbytes;
		cc -= sp->rowbytes;
	}
	return (1);
}

static
Fax4PostEncode(tif)
	TIFF *tif;
{
	Fax3BaseState *sp = (Fax3BaseState *)tif->tif_data;

	/* terminate strip w/ EOFB */
	Fax3PutEOL(tif);
	Fax3PutEOL(tif);
	if (sp->bit != 8)
		Fax3FlushBits(tif, sp);
	return (1);
}
