/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

*****************************************************************************/
/****************************************************************
 *                                                              *
 *  MapLib: A User Library For GIS                              *
 *                                                              *
 *  Programmer:  Jeff Wang                                      *
 *               North Carolina Supercomputing Center           *
 *               3021 Cornwallis Road                           *
 *               RTP, NC 27709                                  *
 *                                                              *
 *  CopyRight:   Author Retain the CopyRight For This code      *
 *                                                              *
 ****************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
/* IAC CODE CHANGE : #include <math.h> */
#include <avs/avs_math.h>
#include "draw_usmap.h"
 
#define max(a,b) (((a)>(b)) ? (a):(b))
#define min(a,b) (((a)<(b)) ? (a):(b))

#define  R_TO_D  36.0/atan(1.0);
#define  MAXX   100
#define  MAXY   100

/* IAC CODE CHANGE - replace ANSI style argument list */
UTMcoordinate map_latlon_to_utm(LON, LAT, Z0)
float LON; float LAT; int Z0;
/*
*     *** WHERE
*           LON   E LONGITUDE IN DECIMAL DEGREES
*           LAT   N LATITUDE IN DECIMAL DEGREES
*           Z0    UTM ZONE OVERRIDE if NOT ZERO
*           Z     RETURNED UTM ZONE
*           X     RETURNED UTM EASTING IN KILOMETERS
*           Y     RETURNED UTM NORTHING IN KILOMETERS
*/
{
UTMcoordinate temp;
float DL,P,N,T,C,A1,M;
float SINP,TANP,COSP;
float A2,A3,A4,A5,A6,T2;
float K0,A,E2,EP2,FALSE_E,DTR;
float X, Y;
int Z;

K0 = 0.9996;
A = 6378206.4;
E2 = 0.00676866;
EP2 = 0.0068148;
FALSE_E = 500000.0;
DTR = 3.141592654/180.0;

if (Z0 == 0)
{
          Z = (180.0+LON)/6.0 + 1;
}
else
{
          Z = Z0;
}

DL = DTR*(LON - (6.0*Z-183.0));

P = DTR*LAT;

SINP = sin(P);
N = A/sqrt(1.0-E2*SINP*SINP);
TANP = tan(P);
T = TANP*TANP;
COSP = cos(P);
C = EP2*COSP*COSP;
A1 = DL*COSP;
M = 111132.0894*LAT - 16216.94*sin(2.0*P) + 17.21*sin(4.0*P)
        - 0.02*sin(6.0*P);

A2 = A1*A1;
A3 = A2*A1;
A4 = A2*A2;
A5 = A4*A1;
A6 = A4*A2;
T2 = T*T;

X = 0.001*(K0*N*(A1+(1.0-T+C)*A3/6.0
        + (5.0-18.0*T+T2+72.0*C-58.0*EP2)*A5/120.0)
        + FALSE_E);
Y = 0.001*K0*(M+N*TANP * (A2/2.0
        + (5.0-T+9.0*C+4.0*C*C)*A4/24.0
        + (61.0-58.0*T+T2+600.0*C-330.0*EP2)*A6/720.0));

temp.x = X;
temp.y = Y;
temp.zone = Z;
return( temp );
}

/* IAC CODE CHANGE - replace ANSI style argument list */
GEScoordinate map_utm_to_latlon(X, Y, Z)
float X; float Y; int Z;
/*
*     *** WHERE
*           Z     UTM ZONE
*           X     UTM EASTING IN KILOMETERS
*           Y     UTM NORTHING IN KILOMETERS
*           LON   EAST LONGITUDE IN DECIMAL DEGREES
*           LAT   NORTH LATITUDE IN DECIMAL DEGREES
*/
{
GEScoordinate temp;
float XM,YM,M,U,P1,C1,T1,N1,R1,D;
float COSP1,TANP1,SINP1,SIN2P1;
float T2,C2,R0,D2,D3,D4,D5,D6;
float LON0,P,L;
float K0,A,E1,E11,E12,E13,E14,E2,E4,E6,EP2,FALSE_E,RTD;
float LAT, LON;

K0=0.9996;
A=6378206.4;
E1=0.001697916;
E11=3.0*E1/2.0 - 27.0*E1*E1*E1/32.0;
E12=21.0*E1*E1/16.0 - 55.0*E1*E1*E1*E1/32.0;
E13=151.0*E1*E1*E1/96.0;
E14=1097.0*E1*E1*E1*E1/512.0;
E2=0.00676866;
E4=E2*E2;
E6=E2*E4;
EP2=0.0068148;
FALSE_E=500000.0;
RTD=180.0/3.141592654;

LON0 = Z*6.0 - 183.0;

XM = 1000.0*X - FALSE_E;
YM = 1000.0*Y;

M = YM/K0;
U = M/(A*(1.0-E2/4.0 - 3.0*E4/64.0 - 5.0*E6/256.0));
P1 = U + E11*sin(2.0*U) + E12*sin(4.0*U) + E13*sin(6.0*U) +
               E14*sin(8.0*U);
COSP1 = cos(P1);
C1 = EP2*COSP1*COSP1;
C2 = C1*C1;
TANP1 = tan(P1);
T1 = TANP1*TANP1;
T2 = T1*T1;
SINP1 = sin(P1);
SIN2P1 = SINP1*SINP1;
N1 = A/sqrt(1.0-E2*SIN2P1);
R0 = 1.0-E2*SIN2P1;
R1 = A*(1.0-E2)/sqrt(R0*R0*R0);

D = XM/(N1*K0);
D2=D*D;
D3=D*D2;
D4=D*D3;
D5=D*D4;
D6=D*D5;

P = P1 - (N1*TANP1/R1) * (D2/2.0
             - (5.0+3.0*T1+10.0*C1-4.0*C2-9.0*EP2)*D4/24.0
             + (61.0+90.0*T1+298.0*C1+45.0*T2-252*EP2-3.0*C2)*D6/720.0);
LAT = RTD*P;
L = (D - (1.0+2.0*T1+C1)*D3/6.0
             + (5.0-2.0*C1+28*T1-3.0*C2+8.0*EP2+24.0*T2)*D5/120.0)/COSP1;
LON = RTD*L + LON0;

temp.lat = LAT;
temp.lon = LON;
return( temp );
}

/* IAC CODE CHANGE - replace ANSI style argument list */
int stateWrite( iregs, ic, Pname, pWrite )
int iregs; int ic; char *Pname; int pWrite;
{
   int    bWrite, ictid, ctid;
   long   tmpid;

   bWrite = pWrite;
   if ( iregs < 0 )
   {
      tmpid = atoi( Pname );
      ctid = tmpid/1000.;
      ictid = tmpid - ctid*1000;
      if (ic > 0 && ic == ictid || ic <= 0) bWrite = 1;
   }

   if ( iregs == 11 && strcmp( Pname, "CT" ) != 0 &&
        strcmp( Pname, "ME" ) != 0 && strcmp( Pname, "MA" ) != 0 &&
        strcmp( Pname, "NH" ) != 0 && strcmp( Pname, "RI" ) != 0 &&
        strcmp( Pname, "VT" ) != 0 ) bWrite = 0;
   if ( iregs == 12 && strcmp( Pname, "NJ" ) != 0 &&
        strcmp( Pname, "PR" ) != 0 && strcmp( Pname, "VI" ) != 0 &&
        strcmp( Pname, "NY" ) != 0 ) bWrite = 0;
   if ( iregs == 13 && strcmp( Pname, "DE" ) != 0 &&
        strcmp( Pname, "DC" ) != 0 && strcmp( Pname, "MD" ) != 0 &&
        strcmp( Pname, "PA" ) != 0 && strcmp( Pname, "WV" ) != 0 &&
        strcmp( Pname, "VA" ) != 0 ) bWrite = 0;
   if ( iregs == 14 && strcmp( Pname, "AL" ) != 0 &&
	strcmp( Pname, "GA" ) != 0 && strcmp( Pname, "FL" ) != 0 &&
        strcmp( Pname, "KY" ) != 0 && strcmp( Pname, "MS" ) != 0 &&
        strcmp( Pname, "NC" ) != 0 && strcmp( Pname, "SC" ) != 0 &&
        strcmp( Pname, "TN" ) != 0 ) bWrite = 0;
   if ( iregs == 15 && strcmp( Pname, "IL" ) != 0 &&
        strcmp( Pname, "IN" ) != 0 && strcmp( Pname, "MI" ) != 0 &&
        strcmp( Pname, "MN" ) != 0 && strcmp( Pname, "OH" ) != 0 &&
        strcmp( Pname, "WI" ) != 0 ) bWrite = 0;
   if ( iregs == 16 && strcmp( Pname, "AR" ) != 0 &&
        strcmp( Pname, "LA" ) != 0 && strcmp( Pname, "NM" ) != 0 &&
        strcmp( Pname, "OK" ) != 0 &&
        strcmp( Pname, "TX" ) != 0 ) bWrite = 0;
   if ( iregs == 17 && strcmp( Pname, "IA" ) != 0 &&
	strcmp( Pname, "KS" ) != 0 && strcmp( Pname, "MO" ) != 0 &&
        strcmp( Pname, "NE" ) != 0 ) bWrite = 0;
   if ( iregs == 18 && strcmp( Pname, "CO" ) != 0 &&
        strcmp( Pname, "MT" ) != 0 && strcmp( Pname, "ND" ) != 0 &&
        strcmp( Pname, "SD" ) != 0 && strcmp( Pname, "UT" ) != 0 &&
        strcmp( Pname, "WY" ) != 0 ) bWrite = 0;
   if ( iregs == 19 && strcmp( Pname, "AZ" ) != 0 &&
        strcmp( Pname, "GU" ) != 0 && strcmp( Pname, "AS" ) != 0 &&
        strcmp( Pname, "CA" ) != 0 && strcmp( Pname, "NV" ) != 0 &&
        strcmp( Pname, "HI" ) != 0 ) bWrite = 0;
   if ( iregs == 20 && strcmp( Pname, "WA" ) != 0 &&
        strcmp( Pname, "OR" ) != 0 && strcmp( Pname, "ID" ) != 0 &&
        strcmp( Pname, "AK" ) != 0 ) bWrite = 0;

   return( bWrite );
}

/* IAC CODE CHANGE - replace ANSI style argument list */
char *list_file_browser(name)
char *name;
{
   FILE *fp;
   int  size;
   char ch;
   char *content;

   if ( (fp = fopen(name,"r")) != NULL) {
      /* determine the siae of the file */
      for (size=0; !feof(fp); size++) ch = fgetc(fp);
      fclose(fp);

      /* Allocate memory for buffer */
      if ((content = (char *) malloc(sizeof(char)*size))==NULL)
      {
         fprintf(stderr,"No Enough Space For File %s.\n", name);
      }

      fp = fopen(name, "r");
      for (size=0; !feof(fp); size++)
      {
          content[size]=fgetc(fp);
      }
      content[size-1] = '\0';
      fclose(fp);
   }
   else
   {
      fprintf(stderr, "Input List File Not Found.\n");
   }
   return (content);
}
