/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/* Module Name: "geom2iv" (Output) (Subroutine)                          */

static char	sccsid[] = "@(#)geom2iv.c	1.2 08 Aug 1995 FUJITSU NAGANO SYSTEMS ENGINEERING LTD";

#include <stdio.h>
#include <avs/avs.h>
#include <avs/port.h>
#include <avs/geom.h>

#define		LDMN	"geom2iv"

static char	*geom_type_list[] = {"0",
				     "GEOM_MESH",
				     "GEOM_POLYHEDRON",
				     "GEOM_POLYTRI",
				     "GEOM_SPHERE",
				     "GEOM_LABEL"};

#define	POLYLINE_WIDTH		1.0
#define	DISJOINTLINE_WIDTH	2.0

#undef	BIDIRECTIONAL_LIGHT

#define	LABEL_SCALE	300.0
static char	label_font[] = "Helvetica";


/*
 *	DESCRIPTION FUNCTION
 */
int geom2iv_desc()
{
	int in_port, out_port, param, iresult;
	extern int geom2iv_compute();

	AVSset_module_name(LDMN, MODULE_RENDER);

	/* Input Port Specifications               */
	in_port = AVScreate_input_port("in", "geom", REQUIRED);

	/* Parameter Specifications                */
	param = AVSadd_parameter("ivfile", "string", "", "", ":");
	AVSconnect_widget(param, "browser");

	AVSset_compute_proc(geom2iv_compute);

	return(1);
}


FILE	*fp;

/*
 *	COMPUTATIONAL FUNCTION
 */
int
geom2iv_compute(in, ivfile)
GEOMedit_list	in;
char		*ivfile;
{
    int		output_iv();


    /***********	BODY	**************/
    if ( *ivfile == '\0' )
	return(0);

    /*	Inventor file open	*/
    fp = fopen(ivfile, "w");
    if ( !fp ) {
	AVSerror("Can't open file:\n %s", ivfile);
	return(0);
    }

    /*	Write header	*/
    fprintf(fp, "#Inventor V2.0 ascii\n");
    fprintf(fp, "Group {\n");

#   ifdef BIDIRECTIONAL_LIGHT
    fprintf(fp, " DirectionalLight { direction 0  1 0 }\n");
    fprintf(fp, " DirectionalLight { direction 0 -1 0 }\n");
#   endif

    /*	Set / Call Geometry edit function	*/
    GEOMset_new_geometry_func(output_iv);
    GEOMprocess_edit_list(in);

    fprintf(fp, "}\n");
    fclose(fp);

    return(1);
}
 

static int ((*mod_list[])()) = {
	geom2iv_desc
};
#define NMODS (sizeof(mod_list) / sizeof(char *))

AVSinit_modules()
{
	AVSinit_from_module_list(mod_list, NMODS);
}


/*
 *	GEOMETRY EDIT FUNCTION
 */
int
output_iv(name, input)
char	*name;
GEOMobj	*input;
{
    int		output_mesh();
    int		output_sphere();
    int		output_polyh();
    int		output_polytri();
    int		output_polyline();
    int		output_djline();
    int		output_label();


    switch ( input->type ) {

      case GEOM_MESH:
	if ( input->d.m.m < 1 || input->d.m.n < 1 )
	    break;
	output_mesh(name, input);
	break;
	
      case GEOM_POLYHEDRON:
	output_polyh(name, input);
	break;
	
      case GEOM_POLYTRI:
	if ( input->d.pt.npts > 0 )
	    output_polytri(name, input);	/* triangle strips */
	if ( input->d.pt.npls > 0 && input->d.pt.npts < 1 )
	    output_polyline(name, input);	/* polylines */
	if ( input->d.pt.dlverts.n > 1 && input->d.pt.npts < 1 )
	    output_djline(name, input);		/* disjoint lines */
	break;

      case GEOM_SPHERE:
	output_sphere(name, input);
	break;

      case GEOM_LABEL:
	output_label(name, input);
	break;

      default:
	fprintf(stderr, "%s: %s includes %s object. ignore.\n",
		LDMN, name, geom_type_list[input->type]);
	fflush(stderr);
	break;
    }

    return(1);
}

/*
 * OUTPUT POLYTRIANGLES to INVENTOR TRIANGLE STRIPS
 */
int
output_polytri(name, input)
char	*name;
GEOMobj	*input;
{
    int		i, j;

    fprintf(fp, " Separator {\n");
    fprintf(fp, "\tInfo {\n");
    fprintf(fp, "\t\tstring \"Object Name: %s\"\n", name);
    fprintf(fp, "\t}\n");

    for ( j = 0; j < input->d.pt.npts; j++ ) {
	fprintf(fp, "\tCoordinate3 {\n");
	fprintf(fp, "\t point [ ");
	for ( i = 0; i < input->d.pt.ptverts[j].n; i++ ) {
	    fprintf(fp, "\t\t%f %f %f", input->d.pt.ptverts[j].l[i*3],
		    input->d.pt.ptverts[j].l[i*3+1],
		    input->d.pt.ptverts[j].l[i*3+2]);
	    if ( i == input->d.pt.ptverts[j].n -1 )
		fprintf(fp, " ]\n");
	    else
		fprintf(fp, ",\n");
	}
	fprintf(fp, "\t}\n");

	if ( input->data & GEOM_NORMALS ) {
	    fprintf(fp, "\tNormal {\n");
	    fprintf(fp, "\t vector [");
	    for ( i = 0; i < input->d.pt.ptnormals[j].n; i++ ) {
		fprintf(fp, "\t\t%f %f %f", input->d.pt.ptnormals[j].l[i*3],
			input->d.pt.ptnormals[j].l[i*3+1],
			input->d.pt.ptnormals[j].l[i*3+2]);
		if ( i == input->d.pt.ptnormals[j].n -1 )
		    fprintf(fp, " ]\n");
		else
		    fprintf(fp, ",\n");
	    }
	    fprintf(fp, "\t}\n");
	    fprintf(fp, "\tNormalBinding {\n");
	    fprintf(fp, "\t\tvalue PER_VERTEX\n");
	    fprintf(fp, "\t}\n");
	}

	if ( input->data & GEOM_VCOLORS ) {
	    fprintf(fp, "\tBaseColor {\n");
	    fprintf(fp, "\t rgb [");
	    for ( i = 0; i < input->d.pt.ptverts[j].n; i++ ) {
		fprintf(fp, "\t\t%f %f %f", input->d.pt.ptcolors[j].l[i*3],
			input->d.pt.ptcolors[j].l[i*3+1],
			input->d.pt.ptcolors[j].l[i*3+2]);
		if ( i == input->d.pt.ptcolors[j].n -1 )
		    fprintf(fp, " ]\n");
		else
		    fprintf(fp, ",\n");
	    }
	    fprintf(fp, "\t}\n");
	    fprintf(fp, "\tMaterialBinding {\n");
	    fprintf(fp, "\t\tvalue PER_VERTEX\n");
	    fprintf(fp, "\t}\n");
	} else {
	    fprintf(fp, "\tBaseColor {\n");
	    fprintf(fp, "\t\trgb  1 1 1\n");
	    fprintf(fp, "\t}\n");
	}

	fprintf(fp, "\tDEF strip+0 TriangleStripSet {\n");
	fprintf(fp, "\t\tnumVertices [ %d ]\n", input->d.pt.ptverts[j].n);
	fprintf(fp, "\t}\n");

	fprintf(fp, "\tDrawStyle {\n");
	fprintf(fp, "\t\tstyle FILLED\n");
	fprintf(fp, "\t}\n");

	fprintf(fp, "\tUSE strip+0\n");
    }

    fprintf(fp, " }\n");

    return(1);
}

/*
 * OUTPUT MESH
 */
int
output_mesh(name, input)
char	*name;
GEOMobj	*input;
{
    int		i;

    fprintf(fp, " Separator {\n");
    fprintf(fp, "\tInfo {\n");
    fprintf(fp, "\t\tstring \"Object Name: %s\"\n", name);
    fprintf(fp, "\t}\n");

    fprintf(fp, "\tCoordinate3 {\n");
    fprintf(fp, "\t point [ ");
    for ( i = 0; i < input->d.m.verts.n; i++ ) {
	fprintf(fp, "\t\t%f %f %f", input->d.m.verts.l[i*3],
		input->d.m.verts.l[i*3+1],
		input->d.m.verts.l[i*3+2]);
	if ( i == input->d.m.verts.n -1 )
	    fprintf(fp, " ]\n");
	else
	    fprintf(fp, ",\n");
    }
    fprintf(fp, "\t}\n");

    if ( input->data & GEOM_NORMALS ) {
	fprintf(fp, "\tNormal {\n");
	fprintf(fp, "\t vector [");
	for ( i = 0; i < input->d.m.normals.n; i++ ) {
	    fprintf(fp, "\t\t%f %f %f", input->d.m.normals.l[i*3],
		    input->d.m.normals.l[i*3+1],
		    input->d.m.normals.l[i*3+2]);
	    if ( i == input->d.m.normals.n -1 )
		fprintf(fp, " ]\n");
	    else
		fprintf(fp, ",\n");
	}
	fprintf(fp, "\t}\n");
	fprintf(fp, "\tNormalBinding {\n");
	fprintf(fp, "\t\tvalue PER_VERTEX\n");
	fprintf(fp, "\t}\n");
    }

    if ( input->data & GEOM_VCOLORS ) {
	fprintf(fp, "\tBaseColor {\n");
	fprintf(fp, "\t rgb [");
	for ( i = 0; i < input->d.m.colors.n; i++ ) {
	    fprintf(fp, "\t\t%f %f %f", input->d.m.colors.l[i*3],
		    input->d.m.colors.l[i*3+1],
		    input->d.m.colors.l[i*3+2]);
	    if ( i == input->d.m.colors.n -1 )
		fprintf(fp, " ]\n");
	    else
		fprintf(fp, ",\n");
	}
	fprintf(fp, "\t}\n");
	fprintf(fp, "\tMaterialBinding {\n");
	fprintf(fp, "\t\tvalue PER_VERTEX\n");
	fprintf(fp, "\t}\n");
    } else {
	fprintf(fp, "\tBaseColor {\n");
	fprintf(fp, "\t\trgb  1 1 1\n");
	fprintf(fp, "\t}\n");
    }

    fprintf(fp, "\tDEF mesh+0 QuadMesh {\n");
    fprintf(fp, "\t\tverticesPerColumn %d\n", input->d.m.m);
    fprintf(fp, "\t\tverticesPerRow %d\n", input->d.m.n);
    fprintf(fp, "\t}\n");

    fprintf(fp, "\tDrawStyle {\n");
    fprintf(fp, "\t\tstyle FILLED\n");
    fprintf(fp, "\t}\n");

    fprintf(fp, "\tUSE mesh+0\n");

    fprintf(fp, " }\n");

    return(1);
}

/*
 * OUTPUT SPHERES
 */
int
output_sphere(name, input)
char	*name;
GEOMobj	*input;
{
    int		i;

    fprintf(fp, " Separator {\n");
    fprintf(fp, "\tInfo {\n");
    fprintf(fp, "\t\tstring \"Object Name: %s\"\n", name);
    fprintf(fp, "\t}\n");

    for ( i = 0; i < input->d.sp.verts.n; i++ ) {
	fprintf(fp, "  Separator {\n");

	fprintf(fp, "\tTransform { translation %f %f %f }\n",
		input->d.sp.verts.l[i*3],
		input->d.sp.verts.l[i*3+1],
		input->d.sp.verts.l[i*3+2]);

	if ( input->data & GEOM_VCOLORS ) {
	    fprintf(fp, "\tBaseColor { rgb %f %f %f }\n",
		    input->d.sp.colors.l[i*3],
		    input->d.sp.colors.l[i*3+1],
		    input->d.sp.colors.l[i*3+2]);
	}

	fprintf(fp, "\tSphere { radius %f }\n", input->d.sp.radii.l[i]);

	fprintf(fp, "  }\n");
    }

    fprintf(fp, " }\n");
    return(1);
}

/*
 * OUTPUT POLYHEDRON
 */
int
output_polyh(name, input)
char	*name;
GEOMobj	*input;
{
    int		i, j, *pp;

    fprintf(fp, " Separator {\n");
    fprintf(fp, "\tInfo {\n");
    fprintf(fp, "\t\tstring \"Object Name: %s\"\n", name);
    fprintf(fp, "\t}\n");

    fprintf(fp, "\tCoordinate3 {\n");
    fprintf(fp, "\t point [ ");
    for ( i = 0; i < input->d.ph.verts.n; i++ ) {
	fprintf(fp, "\t\t%f %f %f", input->d.ph.verts.l[i*3],
		input->d.ph.verts.l[i*3+1],
		input->d.ph.verts.l[i*3+2]);
	if ( i == input->d.ph.verts.n -1 )
	    fprintf(fp, " ]\n");
	else
	    fprintf(fp, ",\n");
    }
    fprintf(fp, "\t}\n");

    if ( input->data & GEOM_NORMALS ) {
	fprintf(fp, "\tNormal {\n");
	fprintf(fp, "\t vector [");
	for ( i = 0; i < input->d.ph.normals.n; i++ ) {
	    fprintf(fp, "\t\t%f %f %f", input->d.ph.normals.l[i*3],
		    input->d.ph.normals.l[i*3+1],
		    input->d.ph.normals.l[i*3+2]);
	    if ( i == input->d.ph.normals.n -1 )
		fprintf(fp, " ]\n");
	    else
		fprintf(fp, ",\n");
	}
	fprintf(fp, "\t}\n");
	fprintf(fp, "\tNormalBinding {\n");
	fprintf(fp, "\t\tvalue PER_VERTEX\n");
	fprintf(fp, "\t}\n");
    }

    if ( input->data & GEOM_VCOLORS ) {
	fprintf(fp, "\tBaseColor {\n");
	fprintf(fp, "\t rgb [");
	for ( i = 0; i < input->d.ph.colors.n; i++ ) {
	    fprintf(fp, "\t\t%f %f %f", input->d.ph.colors.l[i*3],
		    input->d.ph.colors.l[i*3+1],
		    input->d.ph.colors.l[i*3+2]);
	    if ( i == input->d.ph.colors.n -1 )
		fprintf(fp, " ]\n");
	    else
		fprintf(fp, ",\n");
	}
	fprintf(fp, "\t}\n");
	fprintf(fp, "\tMaterialBinding {\n");
	fprintf(fp, "\t\tvalue PER_VERTEX\n");
	fprintf(fp, "\t}\n");
    } else {
	fprintf(fp, "\tBaseColor {\n");
	fprintf(fp, "\t\trgb  1 1 1\n");
	fprintf(fp, "\t}\n");
    }


    fprintf(fp, "\tIndexedFaceSet {\n");
    fprintf(fp, "\t coordIndex [ ");

    pp = input->d.ph.ptlist.l;
    for ( i = 0; i < input->d.ph.ptlist.nps; i++ ) {
	int	verts;
	verts = *pp; pp++;
	for ( j = 0; j < verts; j++, pp++ )
	    fprintf(fp, "%d, ", *pp -1);
	if ( i == input->d.ph.ptlist.nps -1 )
	    fprintf(fp, "-1 ]\n");
	else
	    fprintf(fp, "-1,\n\t\t");
    }

    fprintf(fp, "\t}\n");

    fprintf(fp, " }\n");

    return(1);
}

/*
 * OUTPUT POLYLINES
 */
int
output_polyline(name, input)
char	*name;
GEOMobj	*input;
{
    int		i, j;

    fprintf(fp, " Separator {\n");
    fprintf(fp, "\tInfo {\n");
    fprintf(fp, "\t\tstring \"Object Name: %s\"\n", name);
    fprintf(fp, "\t}\n");

    for ( j = 0; j < input->d.pt.npls; j++ ) {
	fprintf(fp, "\tCoordinate3 {\n");
	fprintf(fp, "\t point [ ");
	for ( i = 0; i < input->d.pt.plverts[j].n; i++ ) {
	    fprintf(fp, "\t\t%f %f %f", input->d.pt.plverts[j].l[i*3],
		    input->d.pt.plverts[j].l[i*3+1],
		    input->d.pt.plverts[j].l[i*3+2]);
	    if ( i == input->d.pt.plverts[j].n -1 )
		fprintf(fp, " ]\n");
	    else
		fprintf(fp, ",\n");
	}
	fprintf(fp, "\t}\n");

	if ( input->data & GEOM_VCOLORS ) {
	    fprintf(fp, "\tBaseColor {\n");
	    fprintf(fp, "\t rgb [");
	    for ( i = 0; i < input->d.pt.plverts[j].n; i++ ) {
		fprintf(fp, "\t\t%f %f %f", input->d.pt.plcolors[j].l[i*3],
			input->d.pt.plcolors[j].l[i*3+1],
			input->d.pt.plcolors[j].l[i*3+2]);
		if ( i == input->d.pt.plcolors[j].n -1 )
		    fprintf(fp, " ]\n");
		else
		    fprintf(fp, ",\n");
	    }
	    fprintf(fp, "\t}\n");
	    fprintf(fp, "\tMaterialBinding {\n");
	    fprintf(fp, "\t\tvalue PER_VERTEX\n");
	    fprintf(fp, "\t}\n");
	} else {
	    fprintf(fp, "\tBaseColor {\n");
	    fprintf(fp, "\t\trgb  1 1 1\n");
	    fprintf(fp, "\t}\n");
	}

	fprintf(fp, "\tDEF pline+0 LineSet {\n");
	fprintf(fp, "\t\tnumVertices [ %d ]\n", input->d.pt.plverts[j].n);
	fprintf(fp, "\t}\n");

	fprintf(fp, "\tDrawStyle {\n");
	fprintf(fp, "\t\tlineWidth %f\n", POLYLINE_WIDTH);
	fprintf(fp, "\t}\n");

	fprintf(fp, "\tUSE pline+0\n");
    }

    fprintf(fp, " }\n");

    return(1);
}

/*
 * OUTPUT DISJOINT LINES
 */
int
output_djline(name, input)
char	*name;
GEOMobj	*input;
{
    int		i;

    fprintf(fp, " Separator {\n");
    fprintf(fp, "\tInfo {\n");
    fprintf(fp, "\t\tstring \"Object Name: %s\"\n", name);
    fprintf(fp, "\t}\n");

    fprintf(fp, "\tCoordinate3 {\n");
    fprintf(fp, "\t point [ ");
    for ( i = 0; i < input->d.pt.dlverts.n; i++ ) {
	fprintf(fp, "\t\t%f %f %f",
		input->d.pt.dlverts.l[i*3],
		input->d.pt.dlverts.l[i*3+1],
		input->d.pt.dlverts.l[i*3+2]);

	if ( i == input->d.pt.dlverts.n -1 )
	    fprintf(fp, " ]\n");
	else
	    fprintf(fp, ",\n");
    }
    fprintf(fp, "\t}\n");

    if ( input->data & GEOM_VCOLORS ) {
	fprintf(fp, "\tBaseColor {\n");
	fprintf(fp, "\t rgb [");
	for ( i = 0; i < input->d.pt.dlcolors.n; i++ ) {
	    fprintf(fp, "\t\t%f %f %f",
		    input->d.pt.dlcolors.l[i*3],
		    input->d.pt.dlcolors.l[i*3+1],
		    input->d.pt.dlcolors.l[i*3+2]);
	    if ( i == input->d.pt.dlcolors.n -1 )
		fprintf(fp, " ]\n");
	    else
		fprintf(fp, ",\n");
	}
	fprintf(fp, "\t}\n");
	fprintf(fp, "\tMaterialBinding {\n");
	fprintf(fp, "\t\tvalue PER_VERTEX\n");
	fprintf(fp, "\t}\n");
    } else {
	fprintf(fp, "\tBaseColor {\n");
	fprintf(fp, "\t\trgb  1 1 1\n");
	fprintf(fp, "\t}\n");
    }

    fprintf(fp, "\tDrawStyle {\n");
    fprintf(fp, "\t\tlineWidth %f\n", DISJOINTLINE_WIDTH);
    fprintf(fp, "\t}\n");

    fprintf(fp, "\tIndexedLineSet {\n");
    fprintf(fp, "\t\tcoordIndex [ ");
    for ( i = 0; i < input->d.pt.dlverts.n / 2; i++ ) {
	fprintf(fp, "%d, %d", i*2, i*2 +1);
	if ( i == input->d.pt.dlverts.n / 2 -1 )
	    fprintf(fp, " ]\n");
	else
	    fprintf(fp, ", -1,\n\t\t\t");
    }
    fprintf(fp, "\t}\n");

    fprintf(fp, " }\n");
    return(1);
}

/*
 * OUTPUT LABELS
 */
int
output_label(name, input)
char	*name;
GEOMobj	*input;
{
    int		i;
    int		flag;
    static char	*label_just[] = { "LEFT", "RIGHT", "CENTER" };

    fprintf(fp, " Separator {\n");
    fprintf(fp, "\tInfo {\n");
    fprintf(fp, "\t\tstring \"Object Name: %s\"\n", name);
    fprintf(fp, "\t}\n");

    for ( i = 0; i < input->d.la.labels.n; i++ ) {
	flag = GEOMget_label_flags(input, i);

	/** Ignore Title Labels **/
	if ( flag & GEOM_LABEL_ABSOLUTE )
	    continue;

	fprintf(fp, "  Separator {\n");

	fprintf(fp, "\tFont {\n");
	fprintf(fp, "\t\tname \"%s\"\n", label_font);
	fprintf(fp, "\t\tsize %f\n", input->d.la.heights.l[i]* LABEL_SCALE);
	fprintf(fp, "\t}\n");

	fprintf(fp, "\tTransform { translation %f %f %f }\n",
		input->d.la.verts.l[i*3] + input->d.la.offsets.l[i*3],
		input->d.la.verts.l[i*3+1] + input->d.la.offsets.l[i*3+1],
		input->d.la.verts.l[i*3+2] + input->d.la.offsets.l[i*3+2]);

	if ( input->data & GEOM_VCOLORS ) {
	    fprintf(fp, "\tMaterial { diffuseColor %f %f %f }\n",
		    input->d.la.colors.l[i*3],
		    input->d.la.colors.l[i*3+1],
		    input->d.la.colors.l[i*3+2]);
	}

	fprintf(fp, "\tText2 {\n");
	fprintf(fp, "\t\tstring \"%s\"\n", input->d.la.labels.l[i]);

	if ( flag & GEOM_LABEL_CENTER )
	    fprintf(fp, "\t\tjustification  %s\n", label_just[2]);
	else if ( flag & GEOM_LABEL_RIGHT )
	    fprintf(fp, "\t\tjustification  %s\n", label_just[1]);
	else
	    fprintf(fp, "\t\tjustification  %s\n", label_just[0]);

	fprintf(fp, "\t}\n");

	fprintf(fp, "  }\n");
    }

    fprintf(fp, " }\n");
    return(1);
}

/*** EOF ***/
