/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/*************************************************************************/
/* Module Name: "WRITE_TIMESTAMP" (Output) (Subroutine)                  */
/* Author: Kathy Pearson, NCSC, kathyp@ncsc.org, 248-9240                */
/* Date Created: June 25, 1993                                           */
/*************************************************************************/

/* SYSTEMS INFORMATION 

Development Platform
--------------------
	Sun Sparcstation-2	SunOS Release 4.1.3		AVS 5.0

Tested Platforms
----------------
	Sun Sparcstation2	SunOS Release 4.1.3		AVS 5.0
	DECstation 5000		ULTRIX V4.1.A (Rev. 44)		AVS 4.0

Known Restrictions
------------------
	None
*/
		
/* This routine writes the input time stamp string into the file
   specified by file name input

   Inputs:
	(1) file name, likely from an AVS file browser, into which
		the time stamp string will be written
	(2) time stamp string, issued from an AVS reader
		containing a character time stamp for each
		time step that is output by the reader,each 
		separated by a carriage return character 

   Outputs:
	NONE

*/

#include <stdio.h>
#include <avs/avs.h>
#include <avs/port.h>
#include "separate.h"
 
/* *****************************************/
/*  Module Description                     */
/* *****************************************/
int WRITE_TIMESTAMP_desc()
{
int in_port, out_port, param;		/* AVS inputs, outputs, parameters */
extern int WRITE_TIMESTAMP_compute();	/* AVS compute function */

AVSset_module_name("WRITE TIMESTAMP", MODULE_RENDER);
AVSset_module_flags(COOPERATIVE);


/* Input Port Specifications               */

in_port = AVScreate_input_port("filename", "string", REQUIRED);
in_port = AVScreate_input_port("timestamp", "string", REQUIRED);

AVSset_compute_proc(WRITE_TIMESTAMP_compute);
return(1);
}
 
/* *****************************************/
/* Module Compute Routine                  */
/* *****************************************/
int WRITE_TIMESTAMP_compute(filename, timestamp)
char *filename;
char *timestamp;
{
FILE *f;			/* output file */
char *answer;			/* user selection of choices on warning
				   in the event the file already exists
				 */

/* check to see if the file already exists; if so, cancel effects an early
   return while overwrite causes the file to be rewritten with the current
   timestamp string
*/

if ((f = fopen(filename, "r")) != NULL)
	{
	answer = AVSmessage("Version 1", AVS_Warning, NULL,
		"WRITE_TIMESTAMP", "Cancel!Overwrite",
		 "Time stamp file %s already exists.\nOverwrite?", filename);
	if (!strcmp(answer, "Cancel"))
		{
		fclose(f);
		return(0);
		}
	}
 
/* create the timestamp output file and write the timestamp string into it */

if ((f = fopen(filename, "w")) != NULL)
	{
	fprintf(f, "%s", timestamp);
	fclose(f);
	return(1);
	}
else
	AVSerror("Cannot create time stamp file.");
return(0); 
}

#ifdef SEPARATE_MODULES
 
/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
static int ((*mod_list[])()) = { WRITE_TIMESTAMP_desc };
#define NMODS (sizeof(mod_list) / sizeof(char *))

AVSinit_modules()
{
AVSinit_from_module_list(mod_list, NMODS);
}

#endif
 
