/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
#include "wr_ucd.h"
/*-----------------------------------------------------*
 *                                                     *
 *               ****  read_ucd  ****                  *
 *                                                     *
 * read a file (ascii or binary) in the ucd format.    *
 * if the file is binary then it is assumed it was     *
 * created using the ucd_write module.                 *
 *                                                     *
 *-----------------------------------------------------*/

/*--------------------------------------------------------------------
 *      Read UCD module
 *--------------------------------------------------------------------*/
get_ucd (input)
     UCD_structure *input;
{

  char model_name[100];
  int sum,i;
  
#ifdef DEBUG
  printf("Get ucd %x\n",input);
#endif

  model_stats.node_data_labels = (char *) malloc(UCD_LABEL_LEN * sizeof(char));
  model_stats.cell_data_labels = (char *) malloc(UCD_LABEL_LEN * sizeof(char));
  model_stats.model_data_labels = (char *) malloc(UCD_LABEL_LEN * sizeof(char));

  model_stats.node_data_units = (char *) malloc(UCD_LABEL_LEN * sizeof(char));
  model_stats.cell_data_units = (char *) malloc(UCD_LABEL_LEN * sizeof(char));
  model_stats.model_data_units = (char *) malloc(UCD_LABEL_LEN * sizeof(char));


  UCDstructure_get_header(input,model_name,&model_stats.num_model_data,
     &model_stats.name_flag,&model_stats.num_cells,&model_stats.num_cell_data,
     &model_stats.num_nodes,&model_stats.num_node_data,
     &model_stats.util_flag);

  model_stats.xc = (float *)malloc(sizeof(float) * model_stats.num_nodes);
  model_stats.yc = (float *)malloc(sizeof(float) * model_stats.num_nodes);
  model_stats.zc = (float *)malloc(sizeof(float) * model_stats.num_nodes);

  if(model_stats.num_node_data) {
    model_stats.min_node_data = 
      (float *)malloc(sizeof(float) * model_stats.num_node_data);
    model_stats.max_node_data =
      (float *)malloc(sizeof(float) * model_stats.num_node_data);
    model_stats.node_active_list =
       (int *) malloc(model_stats.num_node_data *sizeof(int));
    model_stats.node_comp_list =
       (int *) malloc(model_stats.num_node_data *sizeof(int));
  }
  else {
    model_stats.min_node_data=NULL;
    model_stats.max_node_data=NULL;
    model_stats.node_active_list=NULL;
    model_stats.node_comp_list=NULL;
  }

  i=UCDstructure_get_node_labels
    (input,model_stats.node_data_labels,model_stats.nd_delim);
  CheckLabel(i, model_stats.nd_delim,"node labels");
  i=UCDstructure_get_node_units
    (input,model_stats.node_data_units,model_stats.nu_delim);
  CheckLabel(i, model_stats.nu_delim,"node units");
  UCDstructure_get_node_components(input,&model_stats.node_comp_list);
  UCDstructure_get_node_active(input,&model_stats.node_active_list);

  UCDstructure_get_node_positions(input,
     &model_stats.xc,&model_stats.yc,&model_stats.zc);

  if(model_stats.num_cell_data) {
    model_stats.min_cell_data = 
      (float *)malloc(sizeof(float) * model_stats.num_cell_data);
    model_stats.max_cell_data =
      (float *)malloc(sizeof(float) * model_stats.num_cell_data);
    model_stats.cell_active_list =
       (int *) malloc(model_stats.num_cell_data *sizeof(int));
    model_stats.cell_comp_list =
       (int *) malloc(model_stats.num_cell_data *sizeof(int));
  }
  else {
    model_stats.min_cell_data=NULL;
    model_stats.max_cell_data=NULL;
    model_stats.cell_active_list=NULL;
    model_stats.cell_comp_list=NULL;
  }

  i=UCDstructure_get_cell_labels
    (input,model_stats.cell_data_labels,model_stats.cd_delim);
  CheckLabel(i, model_stats.cd_delim,"cell labels");
  i=UCDstructure_get_cell_units
    (input,model_stats.cell_data_units,model_stats.cu_delim);
  CheckLabel(i, model_stats.cu_delim,"cell units");
  UCDstructure_get_cell_components(input,&model_stats.cell_comp_list);
  UCDstructure_get_cell_active(input,&model_stats.cell_active_list);
  UCDstructure_get_node_data(input,&model_stats.node_data);
  UCDstructure_get_node_minmax(input,
     model_stats.min_node_data,model_stats.max_node_data);
  UCDstructure_get_cell_minmax(input,
     model_stats.min_cell_data,model_stats.max_cell_data);
  UCDstructure_get_cell_data(input,&model_stats.cell_data);
  
  sum=0;
  for(i=0;i<model_stats.num_node_data;i++) {
    sum += model_stats.node_comp_list[i];
    if(sum == model_stats.num_node_data) {
      model_stats.num_node_comp = i+1;
      break;
    }
  }

  sum=0;
  for(i=0;i<model_stats.num_cell_data;i++) {
    sum += model_stats.cell_comp_list[i];
    if(sum == model_stats.num_cell_data) {
      model_stats.num_cell_comp = i+1;
      break;
    }
  }

#ifdef DEBUG
  printf("Get ucd : done %d %d\n",model_stats.num_nodes,model_stats.num_cells,
  model_stats.num_node_comp,model_stats.num_cell_comp);
#endif

}
int CheckLabel(i,delim,str)
char *delim,*str;
int i;
{
  if(i) return;
#ifdef DEBUG
  printf("No %s\n",str);
#endif
  delim[0]='\0';
}
