/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
#include <stdio.h>
#include "wr_ucd.h"
long int cur_pos;

int MAGIC=0x12321;

put_header()
{

  int i;

  if(!anim_desc) {
    return;
  }
#ifdef DEBUG
    printf("Put_header %s : %d %d %x\n",prog_version,file_version,max_step,anim_desc);
#endif

  switch(file_version) {
    case UCD_ASCII_FILE: 
      rewind(anim_desc);
      fprintf(anim_desc,
"# File created by WrUcdAnim %s\n\
%5.5d %5.5d %5.5d %5.5d %5.5d %5.5d %1.1d %1.1d %1.1d %1.1d\n",prog_version,
        model_stats.num_nodes,model_stats.num_cells,model_stats.num_node_data,
        model_stats.num_cell_data,model_stats.num_model_data,max_step,
        StoreNodePos,StoreNodeData,StoreCellData,StoreModelData);
      break;
    default:

      if(prev_step == -1) {
        cur_pos=ftell(anim_desc); 
        if(cur_pos == -1) {
 	  perror("Ftell");
	  return(-1);
        }
      }
      else {
        i=fseek(anim_desc,cur_pos,SEEK_SET);
        if(i) {
  	  perror("File seek");
        }
      }

      fwrite ((char *)&MAGIC, sizeof(int),
         1, anim_desc);
      fwrite ((char *)&max_step, sizeof(int),
         1, anim_desc);
#ifdef DEBUG
  printf("CurPos,PrevStep : %d %d %d\n",cur_pos,prev_step,max_step);
#endif
      fwrite ((char *)&StoreNodePos, sizeof(int),
         1, anim_desc);
      fwrite ((char *)&StoreNodeData, sizeof(int),
         1, anim_desc);
      fwrite ((char *)&StoreCellData, sizeof(int),
         1, anim_desc);
      fwrite ((char *)&StoreModelData, sizeof(int),
         1, anim_desc);
  }
}



