#define MODULE_NAME "WrUcdAnim"
#ifdef DEBUG
#define sep_exe
#endif
#ifdef SCCS
	static char sccsid[]="%W% Stardent %E%";
#endif

#define MAX_STEP 256
#define prog_version "V1.1.3"
#define RwMode "w+"

/*
  Copyright (c) 1989 by
  Stardent Computer Inc.
  All Rights Reserved
  
  This software comprises unpublished confidential information of
  Stardent Computer Inc. and may not be used, copied or made
  available to anyone, except in accordance with the license
  under which it is furnished.
  
  This file is under sccs control at Stardent in:
  %P%
  
  */
/*-----------------------------------------------------*
 *                                                     *
 *               ****  read_ucd  ****                  *
 *                                                     *
 * read a file (ascii or binary) in the ucd format.    *
 * if the file is binary then it is assumed it was     *
 * created using the ucd_write module.                 *
 *                                                     *
 *-----------------------------------------------------*/

#include <stdio.h>
#include <avs/flow.h>
#include <avs/ui.h>
#include <avs/geom.h>
#include <avs/ucd_defs.h>

#define buffer_size  200
#define UCD_ASCII_FILE 3
#define UCD_BINARY_3_0 1
#define UCD_BINARY_3_5 2
#define NO_FILE -1
#define SAME_FILE 0
#define SEQ_NUM 1
#define FILE_LIST 2

#ifndef UCD_MAX_NODE_PER_CELL
#define UCD_MAX_NODE_PER_CELL 20
#define UCD_NUM_CELL_TYPES 8
#endif
#ifndef SEEK_SET
#define SEEK_SET 0
#define SEEK_CUR 1
#endif
extern char *AVSstatic;

typedef struct _ucd_stats {
  int size;
} Ucd_Stats_Type;

typedef struct _ctype_struct {
  int id, mat, n, cell_type;
} Ctype;

typedef struct _ntype_struct {
  int n, node_list[UCD_MAX_NODE_PER_CELL];
} Ntype;


typedef struct _model_stats {
  char *node_data_labels,*cell_data_labels,*model_data_labels,
  *node_data_units, *cell_data_units, *model_data_units;
  
  float *min_node_data,*max_node_data,*node_data;
  float *min_cell_data,*max_cell_data,*cell_data;
  float *min_model_data,*max_model_data,*model_data;
  float *xc,*yc,*zc;

  int num_nodes, num_cells, num_node_data, num_cell_data, num_model_data,
  *node_active_list, *cell_active_list, *model_active_list,
  num_node_comp, *node_comp_list, num_cell_comp, *cell_comp_list,
  num_model_comp, *model_comp_list, num_nlist_nodes,name_flag,util_flag;

  char nd_delim[5],cd_delim[5],nu_delim[5],cu_delim[5],md_delim[5],mu_delim[5];

} Mtype;

int do_preload();
int get_step_by_name();

#ifdef STORAGE
#define EXTERN
#else
#define EXTERN extern
#endif

EXTERN   Mtype model_stats;

EXTERN FILE *anim_desc;

EXTERN long int *FilePos;
EXTERN int StoreNodePos;
EXTERN int StoreNodeData;
EXTERN int StoreCellData;
EXTERN int StoreModelData;
EXTERN int mode;
EXTERN int file_version;
EXTERN int prev_step;
EXTERN int max_step;
