/****************************************************************************
                          INTERNATIONAL AVS CENTRE
           (This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Centre, University of Manchester, the AVS Consortium and
the individual  submitting the module and files associated with said module
provide absolutely NO WARRANTY OF ANY KIND with respect to this software.  The
entire risk as to the quality and performance of this software is with the
user.  IN NO EVENT WILL The International AVS Centre, University of Manchester,
the AVS Consortium and the individual submitting the module and files
associated with said module BE LIABLE TO ANYONE FOR ANY DAMAGES ARISING FROM
THE USE OF THIS SOFTWARE, INCLUDING, WITHOUT LIMITATION, DAMAGES RESULTING FROM
LOST DATA OR LOST PROFITS, OR ANY SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@iavsc.org.

Please send AVS module bug reports to avs@iavsc.org.

***************************************************************************/
/************************************************
 *
 * 	vrmlcat
 *
 *      Reads *.wrl files and concatenates them 
 *      all into one.
 *
 *	usage:
 *      vrmlcat infile1.wrl infile2.wrl ... -o outfile.wrl
 *	
 *	Output is the file outfile.wrl to the same directory
 *
 *	Written by John Evans
 *	for the U.S. Geological Survey
 *	Branch of Atlantic Marine Geology
 *	Woods Hole, MA
 *    
 */

#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

void usage();


#define MAX_BUFFER 512


main(int argc, char *argv[])
{
   extern char   *optarg;   /* Used by getopt to process        */
   extern int     optind;   /* command line arguments.          */

   int arg_index,           /* Indexes into list of input *.wrl
			       files.                           */
       c,                   /* Command line option.             */
       stdin_done=0,        /* Flag, is there any input to be
			       taken from stdin?                */
       cl_done=0,           /* Flag, is there any input to be
			       taken from the command line?     */
       more_input = 1;      /* Boolean flag, loop until no more */


   FILE *outfile,		/* file handle for output file	*/
        *infile;                /* points to input *.wrl file 
				   to be folded into outfile    */

   char buffer[MAX_BUFFER];
   
   


   /* first process input from command line */
   if (argc == 1) usage();
   
   /* get the switches						 */
   while ((c = getopt(argc, argv, "ho:u")) != -1)
       switch (c) {

       /*
	* Open output *.wrl file.
        */
       case 'o':
	  if ( (outfile = fopen(optarg, "w")) == NULL) {  
	      fprintf(stderr, "Can't open file %s\n", optarg);
	      exit (EXIT_FAILURE);
	   }
	  break;

       /*
	* Usage.
	*/
       case 'h':
       case 'u':
	  usage();
	  break;

       /*
	* Bad option chosen.
	*/
       default:
	  fprintf ( stderr, "Illegal option:  %c\n", c);
	  usage ();
	  
       }


   
   argc -= optind;	
   argv += optind; /* now pointing to the input file names */
   

   

   /*
    * write outfile header
    */
   fprintf ( outfile, "#VRML V1.0 ascii\n\n" );
   

   /*
    * Now loop through the input *.wrl files, feeding their
    * contents into the output *.wrl file.
    */
   while ( more_input ) {

      /* 
       * now open an input file 
       */
      if (argc > 0) {  /* there's command line input left */

	 /* 
	  * take input file names from the command line 
	  */
	 stdin_done = 1;	             /* ignore stdin */

	 if ( arg_index < argc ) {  /* until all files are processed */


	    /*
	     * Open the input *.wrl file pointed to by command line
	     * argument.
	     */
	    if ( (infile = fopen( argv[arg_index], "r")) == NULL) {  
	       fprintf(stderr, "Can't open file %s\n", argv[arg_index] );
	       exit (EXIT_FAILURE);
	    }
	    
	    
	    /*
	     * Point towards next command line argument.
	     */
	    arg_index++;
	 } 
	 else 
	     cl_done = 1;	/* no more input from command line */
      }



      /*
       * Open the input *.wrl file given by stdin.
       */
      else {	                /* take input from stdin	*/
	 cl_done = 1;	        /* ignore command line */

	 if (gets(buffer) != NULL) {
	    if ( (infile = fopen( buffer, "r")) == NULL) {  
	       fprintf(stderr, "Can't open file %s\n", buffer );
	       exit (EXIT_FAILURE);
	    }
	    
	    
	 } 
	 else 
	     stdin_done = 1;
      }
      

      /* printf("cl = %i, std = %i, %s\n",cldone,stdindone,buffer);  */
      if (cl_done && stdin_done) 
	  more_input = 0;
      

      /*
       * read past input file header
       */
      fgets ( buffer, MAX_BUFFER, infile );
      fgets ( buffer, MAX_BUFFER, infile );

      
      /*
       * Copy lines from input file to output file.
       */
      while ( fgets ( buffer, MAX_BUFFER, infile ) != (char *)NULL )
	  fputs ( buffer, outfile );

      
      fclose ( infile );


      /*
       * Add some spacing to separate nodes.
       */
      fprintf ( outfile, "\n\n\n" );

      
   }


      
}



void usage()
{
   printf("\nUsage: \n");
   printf("vrmlcat -o outfile.wrl infile1.wrl infile2.wrl ...\n");
   printf("or ----\n");
   printf ("ls *.wrl | vrmlcat -o outfile.wrl\n\n");
   printf ("If you choose the 2nd method, you might want to\n");
   printf ("make sure you delete your output file before \n");
   printf ( "trying again.  Otherwise you will get bigger and\n");
   printf ( "bigger *.wrl output files, and you won't be able\n");
   printf ("to see why.\n");

   printf(" -h or -u for this message\n");
   printf("If input files are given on the command line,\n");
   printf("   stdin is ignored.\n");
   printf("Errors output to stderror.\n");
   exit( EXIT_SUCCESS );
}








