/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/*****************************************************/
/*                   D2A_FILE.C                      */
/*****************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
/* IAC CODE CHANGE : #include <math.h> */
#include <avs/avs_math.h>


#include "d2aconst.h"
#include "d2atypes.h"
#include "d2a_pars.h"
#include "d2a_util.h"
#include "d2a_msg.h"
#include "d2a_ucd.h"


/*
 * Close input file.
 * parameter:
 *	(i) fp: file pointer
 *
 */
void
closeFile(fp)
FILE *fp;
{
	fclose(fp);
} /* closeFile */




/*
 * Open input file, return FALSE for non existing file.
 * parameters:
 *	(o) file pointer
 *	(i) str: filename
 *
 */
int
openFile(fp, str)
FILE **fp;
char *str;
{
	char namefile[MAX_CHAR_NAME_FILE];

	strcpy(namefile, str);
	
	/* 
	 * return false for non existing file
	 */
	if ((*fp = fopen(namefile, "r")) != NULL)
		return(TRUE);
	return(FALSE);
} /* openFile */






/*
 * Open and create output file, change filename extention
 * parameters:
 *	(i) in_file1: input filename
 *	(o) out_name: output filename
 *	(i) tip_out_file1: file type: UCD, (FIELD future development)
 *	(o) fp1: pointer directed to created file                             
 */
int
createFileOut(in_file1, out_name, tip_out_file1, fp1)
char *in_file1;
char *out_name;
avs_type_file tip_out_file1;
FILE **fp1;
{
	char *pos, *tmp_pos, *name_tmp;
	int points;
	
	
	/*
	 * copy input filename into output filename
	 */
	strcpy(out_name, in_file1);
	name_tmp = out_name;
	
	/*
	 * detect point position
	 */
	for(points = 0; *name_tmp != '\0'; name_tmp++) {
		if (*name_tmp == '.')
			points++;
	}
	
	
	if (points == 1) {

		pos = strstr(out_name, ".");

		/*
		 * truncate rest of the string
		 */
		if (pos != NULL)
			strtok(out_name, ".");

		/*
		 * append desired extention
		 */
		switch (tip_out_file1){
			
			case FIELD: strcat(out_name, ".fld");
				break;
			
			case UCD: strcat(out_name, ".inp");
				break;
		} /* switch*/


		/*
		 * open output file
		 */
		*fp1 = fopen(out_name, "w");
	}
	else errors2(ILLEGAL_FILENAME, 0);

	return(TRUE);
} /* createFileOut */





/*
 * write general comments into output file
 * parameters:
 *  (i) fp_out1: output file pointer
 *  (i) nome_out_f: input filename
 *  (i) tipo_f1: kind of desired output file
 *  (o) num_line_head1: line numbers
 */
int
infoFileOut(fp_out1, nome_out_f, tipo_f1, num_line_head1)
FILE *fp_out1;
char *nome_out_f;
avs_type_file tipo_f1;
int *num_line_head1;
{
	char stringa[LINEA];

	
	/*
	 * detect kind of file
	 */
	if (tipo_f1 == FIELD) 
        	sprintf(stringa, "%s%s%s", 
        		"# AVS FIELD INPUT FILE : ", 
        		nome_out_f, "\n");
	
	else if (tipo_f1 == UCD) 
                sprintf(stringa, "%s%s%s", 
                	"# AVS UCD (Unstructured Cell Data) INPUT FILE : ", 
                	nome_out_f, "\n");
	
	
	fputs(stringa, fp_out1);
	(*num_line_head1)++;
	fputs("#  \n", fp_out1);
	(*num_line_head1)++;
	fputs("#  \n", fp_out1);
	(*num_line_head1)++;
	if (tipo_f1 == FIELD) {
        	
        	/*
        	 * write general comments for Field
        	 */
        	fputs("#  In this file are stored the three starting parameters (max) \n", 
        		fp_out1);
		(*num_line_head1)++;
        	fputs("#  from source file\n", 
        		fp_out1);
		(*num_line_head1)++;
        	fputs("#  every parameter is stored as a coordinate inside 3D space.\n", 
        		fp_out1);
		(*num_line_head1)++;
        	fputs("#  to represent scattered point list inside 3D space:\n", 
        		fp_out1);
		(*num_line_head1)++;
        	fputs("#     SCATTERED DATA   \n", fp_out1);
		(*num_line_head1)++;
        	fputs("#  \n", fp_out1);
		(*num_line_head1)++;
        	fputs("# --------------------------------------------------------------- \n", 
        		fp_out1);
		(*num_line_head1)++;
        	fputs("#  \n", fp_out1);
		(*num_line_head1)++;
	
	
	} else if (tipo_f1 == UCD) {
        	
        	/*
        	 * write general comments with UCD
        	 */
        	fputs("#  In this file are stored: object spatial coordinates \n", 
        		fp_out1);
        	(*num_line_head1)++;
        	fputs("#  extracted from input file \n", 
        		fp_out1);
        	(*num_line_head1)++;
        	fputs("#  and data stored into UCD  Cells and Nodes.\n", 
        		fp_out1);
        	(*num_line_head1)++;
        	fputs("#  To represent scattered point list inside 3D space\n", 
        		fp_out1);
        	(*num_line_head1)++;
        	fputs("#   \n", fp_out1);
        	(*num_line_head1)++;
        	fputs("# --------------------------------------------------------------------- \n", 
        		fp_out1);
        	(*num_line_head1)++;
        	fputs("#   \n", fp_out1);
        	(*num_line_head1)++;
	
	}
	
	return(TRUE);
} /* infoFileOut */






/*
 * write into output file the header information 
 * necessary for UCD structure or (Field)
 * parameters:
 *	(i/o) fp_out2: output file pointer
 *	(i) name_f_out: output filename
 *	(i) name_crd_f: output filename with coordinate data
 *		for Field file
 *	(i) typ_f1: kind of AVS output file
 *	(i) n_par1: parameter number
 *	(i) n_obj1: object number
 *	(i) n_coord1: coordinate number
 *	(i) flag_nam_coord: boolean flag for coordinate label
 *	(i) num_vert1: vertex number
 *	(i) dup_crd_as_data: boolean flags to duplicate 
 *		coordinates into data area
 *	
 */
int
headFileOut(fp_out2, name_f_out, name_crd_f, 
	typ_f1, n_par1, n_obj1, n_coord1, 
	flag_nam_coord, num_vert1, dup_crd_as_data)
FILE *fp_out2;
char *name_f_out;
char *name_crd_f;
avs_type_file typ_f1;
int n_par1;
int n_obj1;
int n_coord1;
bool flag_nam_coord;
int num_vert1;
bool dup_crd_as_data;
{
	int i, n_fputs = 0;
	char *pos;
	char name_mom[MAX_CHAR_NAME_FILE];
	char tmp_str[MAX_NUM_CHAR];

	
	/*
	 * check number parameter validation
	 */
	if (n_par1 < n_coord1) 
		/*
		 * Error, terminate program
		 */
		error1(NUM_COORD_ILLEGALE, name_f_out, name_crd_f);

	
	
	/*
	 * test AVS structure type
	 */
	if (typ_f1 == FIELD) {

         	/* future development */

    	} else if (typ_f1 == UCD)
		/*
		 * write hedear information into 
		 * UCD output file (inp)
		 */
		headUcd(fp_out2, n_obj1, n_par1, n_coord1, 
			num_vert1, dup_crd_as_data);

	
	return(TRUE);
} /* headFileOut */









/*
 * Write coordinates into output file
 * parameters:
 *	(i) fp_out: output file pointer
 *	(i) name_f_out1: output file name 
 *	(i) typ_f1: kind of output file, UCD (Field)
 *	(i) n_par1: parameter number
 *	(i) flag_nam_coord: boolean flag for label
 *		coordinates
 *	(i) n_coord1: coordinate number
 *	(i) name: array of label
 *	(i) item1: array of data (objects)
 *	(i) line1: number of line (object number)
 *	(i) type_cell: UCD type of cell
 *	(i) num_vert: vertex number
 *	
 */
int
wrtCoordFileOut(fp_out1, name_f_out1, typ_f1, 
	n_par1, flag_nam_coord, n_coord1, name,
	item1, line1, type_cell, num_vert)
FILE *fp_out1;
char *name_f_out1;
avs_type_file typ_f1;
int n_par1;
bool flag_nam_coord;
int n_coord1;
char name[MAX_ITEM_LINE][NUM_CHAR_NAME];
char item1[MAX_ITEM_LINE][MAX_NUM_CHAR];
int line1;
avs_tipo_cella type_cell;
int num_vert;
{
	int i = 0;
	char strin1[LINEA];
	char tmp_str[MAX_NUM_CHAR];

	
	/*
	 * check validation number of coordinates
	 */
	if (NOT(n_coord1 > n_par1)) {

		/*
		 * check type of file 
		 */
		if (typ_f1 == FIELD) {

			/* future development */

        	} else if (typ_f1 == UCD) {

            		/*
            		 * write coordinates of UCD cell into
            		 * output file
            		 */
            		wrtVertexCell2(fp_out1, item1, line1, 
            			type_cell, num_vert);
        	}

	} else 
		/*
		 * display error message
		 */
		error(NUM_COORD_ILLEGALE, name_f_out1);

	return(TRUE);
} /* wrtCoordFileOut */









/*
 * Test sign of coordinates, count parameters from file,
 * create temporary file, read data from file and
 * shift RA coordinate of ra_midrange value, 
 * shift DEC coordinate of dec_midrange value, 
 * convert coordinates from Equatorial (Spherical)
 * system into Cartesian system, write data into 
 * temporary output file.
 * parameters: 
 *	(i) input_file: input filename
 *	(i) name_swap_file: swap input filename
 *	(i/o) item_to_norm: parameter map of item
 *		to normalize
 *	(i/o) range: parameter range
 *	(i) highest_range_val: highest value of all
 *		coordinates
 *	(i) ra_mid: coordinate RA midrange value
 *	(i) dec_mid: coordinate DEC midrange value
 *	(i) lowest_dec: lowest DEC value
 *	(i) highest_dec: highest DEC value
 *	(i) positive_dec: boolean flag to test
 *		positive sign of DEC coordinate
 *	(i) negative_dec: boolean flag to test
 *		negative sign of DEC coordinate
 *	(i) spher_crd_to_xyz: boolean flag to 
 *		convert from Spherical (Equatorial)
 *		coodinates into Cartesian coordinates	
 *
 */
int
secondCheckFile(input_file, name_swap_file, 
	item_to_norm, range, highest_range_val, 
	ra_mid, dec_mid, lowest_dec, highest_dec,
	positive_dec, negative_dec, 
	spher_crd_to_xyz)
char *input_file;
char *name_swap_file;
bool *item_to_norm;
par_range_t *range;
double highest_range_val;
double ra_mid;
double dec_mid;
double lowest_dec;
double highest_dec;
bool positive_dec;
bool negative_dec;
bool spher_crd_to_xyz;
{
	int n_par, i;
	int temp_n_par, num_item;
	char buffer[FILE_BUFFER_SIZE];
	char strin[LINEA];
	char highest_coord[MAX_NUM_CHAR];
	char lowest_coord[MAX_NUM_CHAR];
	char debug[256];
	char item[MAX_ITEM_LINE][MAX_NUM_CHAR];
	char new_swap_file[MAX_CHAR_NAME_FILE];
	double tmp_crd;
	bool only_negative_dec, only_positive_dec;
	bool exist_file;
	FILE *fp, *fp_swap;

	
	
	/*
	 * initial setting
	 */
	only_positive_dec = FALSE;
	only_negative_dec = FALSE;
	
	
	/*
	 * reset variables
	 */
	n_par = 0;
	temp_n_par = 0;
	tmp_crd = 0.0;
	i = 0;

	
	
	/*
	 * test sign of DEC coordinates
	 */
	if (positive_dec AND (NOT(negative_dec)))
		only_positive_dec = TRUE;
	
	if (negative_dec AND (NOT(positive_dec)))
		only_negative_dec = TRUE;
  
	
	/*
	 * Test file presence, then count 
	 * parameter number
	 */
	exist_file = openFile(&fp, input_file);
	if (exist_file) {
		initItem(item);

		fgets(buffer, FILE_BUFFER_SIZE, fp);
		n_par = sscanf(buffer, "%s%s%s%s%s%s%s%s%s%s", 
				item[0], item[1], item[2], 
				item[3], item[4], item[5], 
				item[6], item[7], item[8], 
				item[9]);

		closeFile(fp);
	}

	
	/*
	 * reset parameter range
	 */
	initParRange(n_par, range);


	
	/*
	 * display process status
	 */
	fprintf(stderr, "\n Second Check File  ... \n ");

	
	
	/*
	 * Test input file presence, then create
	 * temporary output file
	 */
	exist_file = openFile(&fp, input_file);
	if (exist_file) {
		
		/*
		 * create temporary output file
		 */
		newNameFile(name_swap_file, input_file, TMP1_EXT);
		fp_swap = fopen(name_swap_file, "w");
	}


	
	/*
	 * Read data from file, count parameters,
	 * shift all coordinate of relative midrange value,
	 * convert coordinates from Spherical (Equatoria) to
	 * Cartesian system, write into output swap file
	 */
	while((fgets(buffer, FILE_BUFFER_SIZE, fp) != NULL)) {
		
		/*
		 * reset item
		 */
		initItem(item);



        	/*
        	 * check data presence
        	 */
        	if (buffer[0] != '\n') {
			initItem(item);

			/*
			 * read data, count parameters
			 */
			n_par = sscanf(buffer, "%s%s%s%s%s%s%s%s%s%s", 
					item[0], item[1], item[2], 
					item[3], item[4], item[5], 
					item[6], item[7], item[8], 
					item[9]);
			i++;

			temp_n_par = n_par;
			
            
			
			/*
			 * shift all coordinates with
			 * midrange value
			 */
			subtractRaMid(item, ra_mid); 
			subtractDecMid(item, dec_mid); 

			/*
			 * convert Spherical (Equatorial)
			 * into Cartesian coordinates
			 */
			if (spher_crd_to_xyz) 
				convRaDecToXYZ(item);
		
            

			/*
			 * write data into swap output file
			 */
			sprintf(strin, "%s %s %s %s %s %s %s %s %s %s %s", 
				item[0], item[1], item[2], 
				item[3], item[4], item[5], 
				item[6], item[7], item[8], item[9], 
				" \n");
			fputs(strin, fp_swap);
		}
	}

	
	/*
	 * close input and swap output file
	 */
	if (exist_file) {
		closeFile(fp);
		closeFile(fp_swap);
	}


	/*
	 * display process status
	 */
	fprintf(stderr, "   OK \n");

    

	/*
	 * free memory space
	 */

/* IAC CODE CHANGE : 	free(item_to_norm); */
	 free(item_to_norm);

/* IAC CODE CHANGE : 	free(range); */
	 free(range);

	return(TRUE);
} /*secondCheckFile*/











/*
 * Read data (string) from input file, perform
 * parsing control, and eventually append data to 
 * relative sign, find max and min coordinate range
 * and mid range value of RA and DEC, 
 * call secondCheckFile() procedure,
 * then rewrite processed data into
 * output temporary file.
 * parameters:
 *	(i) input_file: input filename
 *	(i) name_swap_file: swap output filename
 *	(o) line: line number (object)
 *	(o) num_coord: coordinate number
 *	(i) spher_crd_to_xyz: boolean flag to convert
 *		Spherical (Equatorial) coordinates into
 *		Cartesian system
 *
 */
int
preCheckFile(input_file, name_swap_file, 
	line, num_coord, spher_crd_to_xyz)
char *input_file;
char *name_swap_file;
int *line;
int *num_coord;
bool spher_crd_to_xyz;
{
	int i, n_par, n_old_par, temp_n_par;
	int num_parameter_not_ok;
	int num_vert, num_item;
	char buffer[FILE_BUFFER_SIZE];
	char item[MAX_ITEM_LINE][MAX_NUM_CHAR];
	char name_param[MAX_ITEM_LINE][NUM_CHAR_NAME];
	char new_swap_file[MAX_CHAR_NAME_FILE];
	char highest_coord[MAX_NUM_CHAR];
	char lowest_coord[MAX_NUM_CHAR];
	char strin[LINEA];
	bool param_ok[MAX_ITEM_LINE];
	bool exist_file;
	bool must_imp_sign, error_param;
	bool *item_to_norm;
	bool positive_dec, negative_dec;
	double tmp_crd;
	double ra_mid, dec_mid; 
	double *lowest_dec, *lowest_ra;
	double *highest_ra, *highest_dec;
	double highest_range_val;
	double ra_1st_pt, ra_last_pt;
	double swap_ra;
	par_range_t *range, *spher_range;
	FILE *fp, *fp_swap;


	/*
	 * reset variables
	 */
	n_par = 0; 
	n_old_par = 0; 
	temp_n_par = 0;
	(*line) = 0;
	
	tmp_crd = 0.0;
	highest_range_val = 0.0;
	
	num_item = MAX_ITEM_LINE;
	error_param = FALSE;
	must_imp_sign = FALSE;
	num_parameter_not_ok = 0;
	
	
	/*
	 * reset midrange value of coordinates
	 */
	ra_mid = dec_mid = 0.0;
	
	/*
	 * reset coordinates sign
	 */
	positive_dec = negative_dec = FALSE;

	
	/*
	 * allocate space
	 */
	lowest_ra = (double *) malloc(sizeof(float));
	lowest_dec = (double *) malloc(sizeof(float));
	highest_ra = (double *) malloc(sizeof(float));
	highest_dec = (double *) malloc(sizeof(float));
	
	
	
	/* 
	 * reset coordinate value
	 */
	(*lowest_ra) = 2.0 * M_PI;
	(*lowest_dec) = M_PI_2;
	(*highest_ra) = 0.0;
	(*highest_dec) = -M_PI_2;

	
	/* 
	 * reset coordinate string value 
	 */
	strcpy(highest_coord, "0.0");
	strcpy(lowest_coord, "0.0");

	/*
	 * allocate space for normalizing mapping,
	 * parameter range (cartesian and Spherical)
	 */
	item_to_norm = (int *) malloc(sizeof(bool) * MAX_ITEM_LINE);
	range = (par_range_t *) malloc(sizeof(par_range_t));
	spher_range = (par_range_t *) malloc(sizeof(par_range_t));



	/* 
	 * read 1st data from file, detect 
	 * alone sign, then append data 
	 * inizialize parameter range
	 */
	exist_file = openFile(&fp, input_file);
	if (exist_file) {
		/*
		 * reset item
		 */
		initItem(item);

		/*
		 * read from file
		 */
		fgets(buffer, FILE_BUFFER_SIZE, fp);
		n_par = sscanf(buffer, "%s%s%s%s%s%s%s%s%s%s", 
				item[0], item[1], item[2], 
				item[3], item[4], item[5], 
				item[6], item[7], item[8],
				item[9]);
		
		/*
		 * Check all data
		 */
		for(i=0; i<n_par; i++) {
			/*
			 * detect sign
			 */  
			if (NOT(isData(item[i]))) {
				if ( (isAloneSign(item[i]) AND (isUnsigned(item[i+1]))) )
					must_imp_sign = TRUE;
			}
		}
		
		/*
		 * store parameter number
		 */
		temp_n_par = n_par;
		
		if (must_imp_sign)	{

			/*
			 * append data to sign
			 */
			for(i=0; i<n_par; i++)
				if (isAloneSign(item[i])) 
					prePutSign(item, param_ok, 
						i, &temp_n_par);
		}

		/*
		 * delete zero numbers before
		 * all parameters
		 */
		for(i=0; i<temp_n_par; i++) {
			if (isZero(item[i])) {
				compactZero(item, i);
			}
		}
	
		closeFile(fp);
		
		/*
		 * reset parameter range
		 */
		initParRange(temp_n_par, range);
		initParRange(temp_n_par, spher_range);

        
	}
	else errors2(NON_ESISTE_FILE, *line);





	/*
	 * display process status
	 */
	fprintf(stderr, "\n Parsing Input File ... \n ");

	/*
	 * Test file presence then create
	 * swap output file
	 */
	exist_file = openFile(&fp, input_file);
	if (exist_file) {
        	newNameFile(name_swap_file, input_file, TMP_EXT);
        	fp_swap = fopen(name_swap_file, "w");
	} else 
		errors2(NON_ESISTE_FILE, *line);

	/*
	 * initialize parameter label array
	 */
	initParName(name_param);



	/*
	 * test file presence, read data, 
	 * perform parsing, append data to sign,
	 * inizialize parameter range,
	 * rewrite data into swap output file
	 */
	while((fgets(buffer, FILE_BUFFER_SIZE, fp) != NULL) AND
				(num_parameter_not_ok == 0) AND 
				NOT(error_param)) {
		/*
		 * initialize
		 */
		initParMusk(&param_ok[0], num_item);
		initItem(item);



		/*
		 * Test data presence
		 */
		if (buffer[0] != '\n') {
			(*line)++;

			initItem(item);

			/*
			 * extract data from buffer and store them 
			 * into item
			 */
			n_par = sscanf(buffer, "%s%s%s%s%s%s%s%s%s%s", 
				item[0], item[1], item[2], 
				item[3], item[4], item[5], 
				item[6], item[7], item[8], 
				item[9]);
			
			/*
			 * test number parameter validation
			 */
			num_parameter_not_ok = paramNotOk(n_old_par, 
							n_par, *line);
			/*
			 * store current and 
			 * old number parameter
			 */
			n_old_par = n_par;
			temp_n_par = n_par;

			
			/*
			 * perform parameter parsing, then
			 * test alone sign
			 */
			for(i=0;i<n_par;i++) {
				if (NOT(isData(item[i]))) {
					
					/*
					 * invalid data, test 
					 * alone sign
					 */
					if ( (isAloneSign(item[i]) AND (isUnsigned(item[i+1]))) )
						/*
						 * find alone sign
						 */
						must_imp_sign = TRUE;
					else {
						/*
						 * invalid data
						 * parameter error
						 */
						param_ok[i] = FALSE;
						error_param = TRUE;
					}
				}
			}
			
			temp_n_par = n_par;
			
			
			/*
			 * test flag to append data 
			 * to sign
			 */
			if (must_imp_sign)	{

				/*
				 * look for sign then
				 * append data
				 */
				for(i=0; i<n_par; i++)
					if (isAloneSign(item[i]))
						prePutSign(item, param_ok, 
							i, &temp_n_par);

				must_imp_sign = FALSE;
			}

			
			/*
			 * delete zero before numbers
			 */
			for(i=0; i<temp_n_par; i++) {
				if (isZero(item[i])) {
					compactZero(item, i);
				}
			}

			
			/*
			 * Store first RA coordinate 
			 * read from input file
			 */
			if ((*line) == 1) { 
				/* 
				 * convert string into double
				 * in order to store 1st RA 
				 * coordinate value 
				 */
				sscanf(item[RA_CRD], "%lf", &ra_1st_pt);
			}
			
			/*
			 * store actual RA coordinate
			 */
			sscanf(item[RA_CRD], "%lf", &ra_last_pt); 
			
			
			/*
			 * calculate range for Spherical 
			 * (Equatorial) coordinates
			 */
			rangePar(item, temp_n_par, spher_range);
			
			/*
			 * calculate lowest and highest 
			 * RA and DEC coordinates value 
			 * value, also detect the sign of DEC
			 */
			raMin(item, lowest_ra);
			decMin(item, lowest_dec, 
				&positive_dec, &negative_dec);
			raMax(item, highest_ra);
			decMax(item, highest_dec);

            

			/*
			 * write precessed data into swap
			 * output file
			 */
			sprintf(strin, "%s %s %s %s %s %s %s %s %s %s %s", 
				item[0], item[1], item[2], 
				item[3], item[4], item[5], 
				item[6], item[7], item[8], 
				item[9], " \n");
			fputs(strin, fp_swap);
		}
	}

	/*
	 * close input and swap output file
	 */
	if (exist_file) {
		closeFile(fp);
		closeFile(fp_swap);
	}

	
	/* 
	 * Detect presence of (RA = 0) value between
	 * the first and last object, then set 
	 * lowest RA values as first range object and
	 * highest RA value as last range object
	 */
	if ((ra_1st_pt > ra_last_pt) AND (ra_1st_pt > M_PI)) {
		*lowest_ra = ra_1st_pt - (2.0 * M_PI);
		*highest_ra = ra_last_pt;
	}
	
	/*
	 * set RA and DEC midrange value
	 */
	ra_mid = (*lowest_ra) + ( ((*highest_ra) - (*lowest_ra)) / 2.0 );
	dec_mid = (*lowest_dec) + ( ((*highest_dec) - (*lowest_dec)) / 2.0 );

	
	/*
	 * send message to user of parsing error
	 */
	if (error_param)
		msgErrPar(*line, temp_n_par, item, param_ok);

	/*
	 * send message to user and stop
	 * execution with parameters not
	 * costant in the input file
	 */
	if (num_parameter_not_ok != 0)
		errors2(NUMERO_PARAM_ILLEGALE, *line);

	/*
	 * send message to user with
	 * data invalid, and stop execution
	 */
	if (error_param)
		errors2(INVALID_DATA, *line);

	/*
	 * display process status
	 */
	fprintf(stderr, "   OK \n");

	/*
	 * reset new swap filename
	 */
	strcpy(new_swap_file, " \0");
	
	
	/*
	 * call 2nd check of input file
	 */ 
	secondCheckFile(name_swap_file, new_swap_file, 
			item_to_norm, spher_range, 
			highest_range_val, ra_mid, dec_mid,
			(*lowest_dec), (*highest_dec), 
			positive_dec, negative_dec,
			spher_crd_to_xyz);

	/*
	 * delete swap file
	 */
	remove(name_swap_file);
	strcpy(name_swap_file, new_swap_file);


	/*
	 * free memory space
	 */

/* IAC CODE CHANGE : 	free(item_to_norm); */
	 free(item_to_norm);

/* IAC CODE CHANGE : 	free(range); */
	 free(range);

/* IAC CODE CHANGE : 	free(spher_range); */
	 free(spher_range);

	return(TRUE);
} /*preCheckFile*/

