/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/*********************************************************/
/*                       D2A_MSG.C                       */
/*********************************************************/

#include <stdio.h>
#include <stdlib.h>

#include "d2aconst.h"





/* 
 * array of error messages, cause of program termination
 */
static char *msgs_error[]=
{
	"FILE NOT FOUND",
	"PARAMETER NUMBER NOT CONSTANT",
	"VALUE IS NOT A DATA",
	"UNKNOWN READ DATA",
	"ILLEGAL PARAMETER NUMBER",
	"ILLEGAL COORDINATE NUMBER",
	"TMP (NORMALIZE) FILE NOT EXIST",
	"ILLEGAL COORDINATE NUMBER OF GEOMETRY SPHERE",
	"ILLEGAL FILENAME"
};








/*
 * Communicate kind of error, display line of error
 * cause program termination
 * parameters:
 * 	(i) err: index of kind of error
 * 	(i) line: line of error number
 *
 */
int
errors2(err, line)
int err;
int line;
{
	/*
	 * display messages
	 */
	fprintf(stderr, "\n\nERROR : %s \n", msgs_error[err]);
	fprintf(stderr, "\n\nFiltering    DIRA ---> AVS  NOT OK    ");
	fprintf(stderr, "    Break in line: %d\n\n\n",line);
	

	/* AVSwarning  **************/
	
	return(STOP);
} /* errors2 */









/*
 * Communicate kind of error, display line of error,
 * delete output files, cause program termination
 * parameters:
 * 	(i) err: index of kind of error
 * 	(i) line: error line number
 * 	(i) f_out: filename to delete
 * 	(i) f_out_crd: filename to delete
 *
 */
int
errors(err, line, f_out, f_out_crd)
int err;
int line;
char *f_out;
char *f_out_crd;
{
	/*
	 * display messages
	 */
	fprintf(stderr, "\n\nERROR : %s \n", msgs_error[err]);
	fprintf(stderr, "\n\nFiltering    DIRA ---> AVS  NOT OK    ");
	fprintf(stderr, "    Break in line: %d\n\n\n",line);
	
	/*
	 * delete output file
	 */
	remove(f_out);
	if (f_out_crd != "") remove(f_out_crd);

	
	/* AVSwarnig()  ***********************/
	
	return(STOP);
} /* errors */










/*
 * Communicate kind of error, delete output files
 * cause program termination.
 * parameters: 
 * 	(i) err: index of kind of error 
 * 	(i) f_out1: filename to delete
 * 	(i) f_out_crd1: filename to delete
 *
 */
int
error1(err, f_out1, f_out_crd1)
int err;
char *f_out1;
char *f_out_crd1;
{

	/*
	 * display messages
	 */
	fprintf(stderr, "\n\nERROR : %s \n", msgs_error[err]);
	fprintf(stderr, "\n\nFiltering    DIRA ---> AVS  NOT OK    ");
	fprintf(stderr, "\n\n\n");
	
	/* 
	 * delete output file 
	 */
	remove(f_out1);
	if (f_out_crd1 != "") remove(f_out_crd1);



	/* AVSwarning()  ************************/
    
	return(STOP);
} /* error1 */










/*
 * Communicate kind of error, remove output file, 
 * cause program termination.
 * parameters:
 * 	(i) err: index of kind of error
 * 	(i) f_out1: filename to delete
 *
 */
int
error(err, f_out1)
int err;
char *f_out1;
{

	/*
	 * display messages
	 */
	fprintf(stderr, "\n\nERROR : %s \n", msgs_error[err]);
	fprintf(stderr, "\n\nFiltering    DIRA ---> AVS  NOT OK    ");
	fprintf(stderr, "\n\n\n");
	
	/*
	 * delete output file
	 */
	remove(f_out1);


	
	/* AVSwarnig() *******************/
	
	return(STOP);
} /* error */









/*
 * Communicate error parameter
 * parameters:
 * 	(i) line1 : actual line number
 * 	(i) n_par1 : parameter numbers read from file
 * 	(i) item1  : actual object
 * 	(i) param_ok1 : boolean map of corrected parameters
 *
 */
void
msgErrPar(line1, n_par1, item1, param_ok1)
int line1;
int n_par1;
char item1[MAX_ITEM_LINE][MAX_NUM_CHAR];
bool	param_ok1[MAX_ITEM_LINE];
{
	int i;

	/*
	 * display messages
	 */
	fprintf(stderr, "\n\n\n");
	fprintf(stderr, "\nIn Line n. %d found %d parameters:", 
		line1, n_par1);
	fprintf(stderr, "\n");
	fprintf(stderr, "\n %s %s %s %s %s", item1[0], item1[1], 
		item1[2], item1[3], item1[4]);
	fprintf(stderr, " %s %s %s %s %s", item1[5], item1[6], 
		item1[7], item1[8], item1[9]);
	fprintf(stderr, "\n");
	
	/*
	 * display invalid parameter
	 */
	for(i=0; i<n_par1; i++) {
		if (NOT(param_ok1[i])) {
			fprintf(stderr, 
				"\n      %d. parameter:  %s    invalid ", 
            			i+1, item1[i]);
		}
	}
    
	/* AVSwarning() ********/

} /* msgErrPar */











/*
 * Comunicate program normal termination
 * parameters:
 * 	(i) line: number of lines performed
 * 	(i) nome_out_f: type of AVS structure
 * 	(i) name_out_f1: output filename
 * 	(i) name_out_crd: output filename containing 
 * 				coordinates
 *
 */
void
msgEndOk(line, tipo_f1, name_out_f, name_out_crd)
int line;
avs_type_file tipo_f1;
char *name_out_f;
char *name_out_crd;
{
 	/*
 	 * display messages
 	 */
 	fprintf(stderr, "\r     FILTERING         PROCESS ");
 	fprintf(stderr, "\n\n       DIRA ---> AVS  OK !");
 	fprintf(stderr, "\n\n     Number processed objects : %d", 
 		line);
 	fprintf(stderr, "\n\n    Created File: %s ", name_out_f);
	
	/*
	 * information about output filename containing
	 * coordinates
	 */
	if (tipo_f1 == FIELD) {
		fprintf(stderr, 
			"\n               and File: %s ", 
			name_out_crd);
	}
	
	fprintf(stderr, "\n\n\n");

} /* msgEndOk */










/*
 * Show number of object in progress
 * parameter:
 *	 (i) line1 : execution line number
 *
 */
void
msgElab(line1)
int line1;
{
	if ((line1 % NUM_ELEM_ELAB) == 0)
		fprintf(stderr, "\r Line in progress:  %d",
			line1);

} /* msgElab */










/*
 * Communicate number of objects and parameters
 * parameters:
 * 	(i) n_obj: object numbers
 * 	(i) n_par: parameter numbers
 *
 */
void
msgStatusInputFile(n_obj, n_par)
int n_obj;
int n_par;
{
	/*
	 * display messages
	 */
	fprintf(stderr, "\nSTATUS OF DIRA INPUT FILE  ");
	fprintf(stderr, "\n\n  N. Objects : %d ", n_obj);
	fprintf(stderr, "\n  Number parameters found : %d \n\n", 
		n_par);

} /* msgStatusInputFile */










/*
 * Display parameter information
 * parameters:
 * 	(i) n_par: object number
 *
 */
void
msgStatusInputFile1(n_par)
int n_par;
{
	/*
	 * display messages
	 */
	fprintf(stderr, "\nSTATUS OF DIRA INPUT FILE  ");
	fprintf(stderr, 
		"\n\n  Number of parameters found : %d \n\n", 
		n_par);

} /* msgStatusInputFile1 */









/*
 * Display filtering information, objects, parameters,
 * and coordinates
 * parameters:
 *  (i) n_obj: object numbers
 *  (i) n_par: parameter numbers
 *  (i) n_coord: data numbers
 *
 */
void
msgStatus(n_obj, n_par, n_coord)
int n_obj;
int n_par;
int n_coord;
{
	/*
	 * display messages
	 */
	fprintf(stderr, "\nFILTERING STATUS ");
 	fprintf(stderr, "\n\n  N. Objects : %d ", n_obj);
	fprintf(stderr, 
		"\n  N. Parameters %d  ->  N. Coordinates : %d ", 
		n_par, n_coord);
	fprintf(stderr, "  N. Data : %d   \n\n",n_par-n_coord);

} /* msgStatus */









/*
 * Display filtering information, parameters and coordinates
 * parameters:
 * 	(i) n_par: parameter number
 * 	(i) n_coord: coordinate number
 *
 */
void
msgStatus1(n_par, n_coord)
int n_par;
int n_coord;
{
	/*
	 * display messages
	 */
	fprintf(stderr, "\nFILTERING STATUS ");
	fprintf(stderr, 
		"\n\n  N. Parameters %d  ->  N. Coordinates : %d ",
		n_par, n_coord);
	fprintf(stderr, "  N. Data : %d   \n\n", n_par-n_coord);

} /* msgStatus1 */

