/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/***************************************************/
/*                 D2A_ UTIL.C                     */
/***************************************************/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
/* IAC CODE CHANGE : #include <math.h> */
#include <avs/avs_math.h>


#include "d2atypes.h"
#include "d2aconst.h"







/*
 * check the number of parameters, which must be constant
 * return the difference abs value between old and new 
 * parameter value
 * parameters:
 * 	(i) n_par_old1: parameter numbers of the old line
 * 	(i) n_par1: actual parameter numbers
 * 	(i) line1: actual process line
 */
int
paramNotOk(n_par_old1, n_par1, line1)
int n_par_old1;
int n_par1;
int line1;
{
	int diff1;

	/* 
	 * Do not check the first line
	 */
	if ((n_par_old1 != n_par1) AND (line1 != 1))
		diff1 = abs(n_par_old1 - n_par1);
	else 
		diff1 = 0;

    return(diff1);
} /* paramNotOk */









/*
 * Reset items (vector string)
 * parameter:
 * 	(o) item1: objects are read from data file
 */
int
initItem(item1)
char item1[MAX_ITEM_LINE][MAX_NUM_CHAR];
{
	int i;

	for(i=0;i<MAX_ITEM_LINE;i++)
		item1[i][0] = '\0';

    return(TRUE);
} /* initItem */









/*
 * Reset vector string containing label about
 * coordinates and data
 * parameters: 
 * 	(o) name_par: array of label related to
 *			objects read from data file
 */
int
initParName(name_par)
char name_par[MAX_ITEM_LINE][NUM_CHAR_NAME];
{
	int i;

	for(i=0; i<MAX_ITEM_LINE; i++)
		name_par[i][0] = '\0';

	return(TRUE);
} /* initParName */








/*
 * Reset boolean vector in order to test
 * correct parameters. 
 * corrected parameters are TRUE.
 * parameters :
 * 	(o) par_ok1: boolean vector 
 * 	(i) max_pos1: parameters numbers to reset
 */
int
initParMusk(par_ok1, max_pos1)
bool *par_ok1;
int max_pos1;
{
	int i;

	for(i=0; i<max_pos1; par_ok1[i++] = TRUE);

	return(TRUE);
} /* initParMusk */








/*
 * Reset all positions of min and max parameter range
 * parameters:
 * 	(i) n_par1: parameter numbers
 *	(o) range: min and max range
 */
int
initParRange(n_par1, range1)
int n_par1;
par_range_t *range1;
{
	int i;

	for(i=0; i<n_par1; i++) {
		strcpy(range1->par[i].min, "0.0");
		strcpy(range1->par[i].max, "0.0");
	}

	return(TRUE);
} /* initParRange */







/*
 * Place alone sign ('+' or '-'), before data string  
 * parameters:
 * 	(i/o) item1: object array read from file
 * 	(i/o) par_ok : map, boolean vector
 * 	(i)   y : starting position to join sign
 *			and data
 * 	(i/o) n_par1 : parameters numbers
 */
int prePutSign(item1, par_ok, y, n_par1)
char item1[MAX_ITEM_LINE][MAX_NUM_CHAR];
bool par_ok[MAX_ITEM_LINE];
int y; 
int *n_par1;
{
	/* 
	 * append data
	 */
	strcat(item1[y],item1[y+1]);

	/* 
	 * all data following sign position are 
	 * shifted from left to right 
	 */
	for(++y; y<*n_par1; y++) {
        	strcpy(item1[y], item1[y+1]);
		par_ok[y] = par_ok[y+1];
	}

	/* 
	 * decrement parameter numbers
	 */
	*n_par1 -= 1;


	return(TRUE);
} /* prePutSign */









/*
 * Delete zero located before numbers
 * paremeters:
 * 	(i) item1: array of objects
 * 	(i) pos: show starting position to delete zero
 */
int compactZero(item1, pos)
char item1[MAX_ITEM_LINE][MAX_NUM_CHAR];
int pos;
{
	char sign;
    	int i, j, pos_sign;

	sign = ' ';
	
	/* 
	 * temporary swap of sign
	 */
    	if ((item1[pos][0] == '+') OR (item1[pos][0] == '-'))
        	sign = item1[pos][0];

	/*
	 * scan string looking for numbers not equal zero
	 */
    	for(i=0; ((item1[pos][i] == sign) OR (item1[pos][i] == '0')); i++);

	/* 
	 * set starting position
	 */
    	if ((sign == '+') OR (sign == '-'))
        	pos_sign = 1;
    	else 
    		pos_sign = 0;

	/*
	 * copy rest of string
	 */
    	for(j=pos_sign; item1[pos][i] != '\0'; j++)
		item1[pos][j] = item1[pos][i++];


	item1[pos][j] = '\0';
	return(TRUE);
} /* compactZero */









/*
 * Count object number, (line), from file of data. 
 * Do not check data validation.
 * Return object number
 * parameters:
 * 	(i) nome1: input catalogue filepointer
 *
 */
int
countLine(filename)
char *filename;
{
	FILE *fp1;
	char mom_buffer[FILE_BUFFER_SIZE];
	int count;

	
	count = 0;
	fp1 = fopen(filename, "r");
	
	/* 
	 * read line from file if data are numbers 
	 * or sign
	 */
	while (fgets(mom_buffer, FILE_BUFFER_SIZE, fp1) != NULL) {
		
		if (((mom_buffer[0] >= '0') AND (mom_buffer[0] <= '9'))
			OR
		((mom_buffer[0] == '-') OR (mom_buffer[0] == '+')))
			++count;
	
	}

	return(count);
} /* countLine */









/*
 * Return vertex number related to the type of UCD cell
 * paramteres:
 *  (i) tp_cell: UCD cell type selected
 */
int
numVertCell(tp_cell)
avs_tipo_cella tp_cell;
{
	int num_vert;

	switch (tp_cell) {
		case 1: num_vert = POINT;
			break;
		case 2:	num_vert = LINE;
			break;
		case 3: num_vert = TRIANGLE;
			break;
		case 4: num_vert = QUADRILATERAL;
			break;
		case 5: num_vert = TETRAHEDRON;
			break;
		case 6: num_vert = PYRAMID;
			break;
		case 7: num_vert = PRISM;
			break;
		case 8: num_vert = HEXAHEDRON;
			break;
	}

	return(num_vert);
} /* numVertCell */







/*
 * Return number related to cell type
 * parameter:
 * 	(i) cell_t: type of UCD cell 
 *
 */
avs_tipo_cella 
cellType(cell_t)
char *cell_t;
{
	avs_tipo_cella cell_type;

	
	if (strcmp(cell_t, "point") == EQUAL) 	
		cell_type = PUNTO;
	
	if (strcmp(cell_t, "line") == EQUAL) 	
		cell_type = LINEA_CELL;
	
	if (strcmp(cell_t, "triangle") == EQUAL) 
		cell_type = TRIANGOLO;
	
	if (strcmp(cell_t, "quadrilateral") == EQUAL)
		cell_type = QUADRILATERO;
	
	if (strcmp(cell_t, "tetrahedron") == EQUAL)
		cell_type = TETRAEDRO;
	
	if (strcmp(cell_t, "pyramid") == EQUAL)
		cell_type = PIRAMIDE;
	
	if (strcmp(cell_t, "prism") == EQUAL)
		cell_type = PRISMA;
	
	if (strcmp(cell_t, "exahedron") == EQUAL)
		cell_type = EXAEDRO;

	return(cell_type);
} /* cellType */










/*
 * Change extention of old filename
 * parameters:
 * 	(o) new: new filename
 * 	(i) old: old filename
 * 	(i) ext: file extention
 *
 */
int
newNameFile(new_name, old_name, ext)
char *new_name;
char *old_name;
char *ext;
{
	char *pos;

	/*
	 * create new filename
	 */
	strcpy(new_name, old_name);
	pos = strstr(new_name, ".");

	/* 
	 * truncate extention
	 */
	if (pos != NULL)
        	strtok(new_name, ".");

	/* 
	 * add new extention
	 */
	strcat(new_name, ext);

	return(TRUE);
} /* newNameFile */










/*
 * Return radius related to highest value of coordinates
 * and fraction of radius
 * parameters:
 * 	(i) higst_crd: highest value of coordinates
 * 	(i) fract_of_radius: fraction of radius
 *
 */
double
calcRadius(highst_crd, fract_of_radius)
char *highst_crd;
double fract_of_radius;
{
    return( (double) atof(highst_crd) / fract_of_radius);
} /* calcRadius */









/*
 * Return max value of all coordinates
 * parameters:
 * 	(i) item1: actual object
 * 	(i/o) old_highes_crd: max value of coordinates
 * 	(i) n_coord1: coordinate numbers
 *
 */
double
highestCoord(item1, old_highest_crd, n_coord1)
char item1[MAX_ITEM_LINE][MAX_NUM_CHAR];
char *old_highest_crd;
int n_coord1;
{
	int i;
	double tmp_value;

	for(i=0;i<n_coord1;i++) {
		tmp_value = atof(item1[i]);
		if (tmp_value > atof(old_highest_crd))
			sprintf(old_highest_crd, "%.9f", 
				tmp_value);
	}
	tmp_value = atof(old_highest_crd);

	return(tmp_value);
} /* highestCoord */









/*
 * Return min value of all coordinates 
 * parameters:
 * 	(i) item1: actual object
 * 	(i/o) old_lowest_crd: min value of coordinates
 * 	(i) n_coord1: coordinate numbers
 */
double
lowestCoord(item1, old_lowest_crd, n_coord1)
char item1[MAX_ITEM_LINE][MAX_NUM_CHAR];
char *old_lowest_crd;
int n_coord1;
{
	int i;
	double tmp_value;

	for(i=0; i<n_coord1; i++) {
		tmp_value = atof(item1[i]);
		if (tmp_value < atof(old_lowest_crd))
			sprintf(old_lowest_crd, "%.9f", 
				tmp_value);
	}
	tmp_value = atof(old_lowest_crd);

	return(tmp_value);
} /* lowestCoord */







/*
 * Calculate the absolute extention between range of RA
 * and DEC coordinates. The shift may be positive or
 * negative
 * parameters:
 * 	(i) range: array of max and min range
 * 	(i/o) high_range: max range of all coordinates
 *
 */
int
highestRangeRaDec(range, high_range)
par_range_t *range;
double *high_range;
{
	int i;
	double mom_max, mom_min;

	/*
	 * scan ra and dec coordinates
	 */
	for (i=0; i<DEC_CRD+1; i++) {
		
		/*
		 * obtain max and min range
		 */
		mom_max = atof(range->par[i].max);
		mom_min = atof(range->par[i].min);
		
		/*
		 * absolute value of negative shift
		 */
		if (mom_min < 0.0)
			mom_min = mom_min*(-1.0);
		/*
		 * select max range
		 */
		if (mom_max >= mom_min) {
			if (mom_max > (*high_range))
				(*high_range) = mom_max;
		}
		else {
			if (mom_min > (*high_range))
				(*high_range) = mom_min;
		}
	}

	return(TRUE);
} /* highestRangeRaDec */










/*
 * Calculate max and min value of all parameters
 * between old value and parameters of actual object
 * parameters:
 * 	(i) item1: actual object
 * 	(i) n_par1: parameter numbers
 * 	(i/o) range: min and max range of all parameters
 *
 */
int
rangePar(item1, n_par1, range)
char item1[MAX_ITEM_LINE][MAX_NUM_CHAR];
int n_par1;
par_range_t *range;
{
	int i;

	for(i=0; i<n_par1; i++) {
		
		if (atof(item1[i]) > atof(range->par[i].max))
			strcpy(range->par[i].max,item1[i]);
		
		if (atof(item1[i]) < atof(range->par[i].min))
			strcpy(range->par[i].min,item1[i]);
	}


	return(TRUE);
} /* rangePar */









/*
 * return delta coordinate value reduced by the 
 * SHIFT_DELTA factor
 * parameter:
 * 	(i) item_value: coordinate value
 *
 */
double
shiftDeltaCrdVertex2(item_value)
double item_value;
{
    return(item_value / SHIFT_DELTA);
} /* shiftDeltaCrdVertex2 */











/*
 * return delta coordinate value reduced by the 
 * SHIFT_DELTA factor
 * parameters:
 * 	(i) item_value: coordinate value
 * 	(i/o) shift_val: shifting value
 *
 */
double
shiftDeltaCrdVertex(item_value, shift_val)
double item_value;
double *shift_val;
{
	double delta;


	/*
	 * select positive or negative shift
	 */
	if (item_value < 0.0) 
		(*shift_val) = -item_value / SHIFT_DELTA;
	else 
		(*shift_val) = item_value / SHIFT_DELTA;

    return(TRUE);
} /* shiftDeltaCrdVertex */










/*
 * Convert x,y into polar notation ro, teta.
 * parameters:
 * 	(i) x: x coordinate
 * 	(i) y: y coordinate
 * 	(o) ro: ro coordinate
 * 	(o) teta: teta coordinate
 *
 */
int
polar(x, y, ro, teta)
double x;
double y;
double *ro;
double *teta;
{

	(*ro) = sqrt(pow(x,2.0)+pow(y,2.0));
	
	/*
	 * calculate teta
	 */
	if (x == 0.0) {
		if (y < 0.0) 
			(*teta) = 90.0;
		else if (y > 0.0) 
			(*teta) = -90.0;
		else 
			(*teta) = 0.0;
	}
	else 
		(*teta) = (atan(y/x)*DUEPIGRECO_DEG)/M_PI;

	return(TRUE);
} /* polar */











/*
 * Compute conversion from Cartesian coordinates to 
 * Equatorial (Spherical) coordinates
 * parameter:
 * 	(i/o) item: actual object
 *
 */
int
convRaDecToXYZ(item1)
char item1[MAX_ITEM_LINE][MAX_NUM_CHAR];
{
	double x, y, z;
	double ra, dec, mom_z;
	double mom1, mom2, mom3;
	char temp_value[MAX_NUM_CHAR];

	ra = atof(item1[RA_CRD]);
	dec = atof(item1[DEC_CRD]);
	mom_z = atof(item1[Z_CRD]);

	/*
	 * convert double to string
	 */
	x = mom_z*cos(dec)*cos(ra);
	y = mom_z*cos(dec)*sin(ra);
	z = mom_z*sin(dec);

	sprintf(temp_value, "%.9f",x);
	strcpy(item1[RA_CRD], temp_value);
	
	sprintf(temp_value, "%.9f",y);
	strcpy(item1[DEC_CRD], temp_value);
	
	sprintf(temp_value, "%.9f",z);
	strcpy(item1[Z_CRD], temp_value);

	return(TRUE);
} /* convRaDecToXYZ */









/*
 * Compute conversion from Equatorial (Spherical) 
 * coordinates to Cartesian coordinates
 * parameter:
 * 	(i/o) item: actual object
 *
 */
int
convXYZToRaDec(item)
char item[MAX_ITEM_LINE][MAX_NUM_CHAR];
{
	double x, y, z;
	double pos_y;
	double ra, dec, r;
	char temp_value[MAX_NUM_CHAR];

	x = 0.0;
	y = 0.0;
	z = 0.0;
	
	x = atof(item[COORD_X]);
	y = atof(item[COORD_Y]);
	z = atof(item[COORD_Z]);
	
	r = sqrt(x*x + y*y + z*z);
	sprintf(temp_value, "%.9f", r);
	strcpy(item[Z_CRD], temp_value);
	
	/*
	 * Calculate ra
	 */
	if (x>= 0.0) {
		if ( y >= 0.0) {
			ra = atan(y/x);
				
		}
		else {
			ra = (2.0 * M_PI) + atan(y/x);	
		}
	}
	else {
		ra = M_PI + atan(y/x);

	}	
	if ( ra > M_PI )
		ra = -(( 2.0 * M_PI) - ra);

	sprintf(temp_value,"%.9f",ra);
	strcpy(item[RA_CRD],temp_value);

	/*
	 * Calculate dec
	 */
	if ( z > 0.0)
		dec = M_PI_2 - atan(sqrt( x*x + y*y ) / z);
	else
		if ( z < 0.0 )
			dec = -M_PI_2 - atan(sqrt( x*x + y*y) / z);
		else 
			dec = 0.0;

	sprintf(temp_value,"%.9f",dec);
	strcpy(item[DEC_CRD],temp_value);
	

	return(TRUE);
} /* convXYZToRaDec */










/*
 * Calculate Min value of RA coordinate, value may be
 * positive or negative
 * parameters:
 * 	(i) item: actual object
 * 	(i/o) lowest: min value of ra 
 *
 */
int
raMin(item, lowest)
char item[MAX_ITEM_LINE][MAX_NUM_CHAR];
double *lowest;
{
	double tmp_val;

	tmp_val = atof(item[RA_CRD]);
	
	if ((*lowest) >= 0.0) {
		
		/*
		 * positive min value
		 */
		if (tmp_val >= 0.0) {
			
			/*
			 * positive actual coordinate
			 */
			if (tmp_val < (*lowest))
				(*lowest) = tmp_val;
		}
		else
			/*
			 * negative actual coordinate
			 */
			(*lowest) = tmp_val;
	}
	else {
		
		/*
		 * negative min value
		 */
		if (tmp_val < 0.0) {
			
			/*
			 * negative actual coordinate
			 */
			if (tmp_val < (*lowest))
				(*lowest) = tmp_val;
		}

	}

	return(TRUE);
} /* raMin */










/*
 * Calculate min value of DEC coordinate and relative
 * sign. Value may be positive or negative
 * parameters:
 * 	(i) item: actual object
 * 	(i/o) lowest: min value of dec
 * 	(o) positive: sign of actual object
 * 	(o) negative: sign of actual object
 *
 */
int
decMin(item, lowest, positive, negative)
char item[MAX_ITEM_LINE][MAX_NUM_CHAR];
double *lowest;
bool *positive;
bool *negative;
{
	double tmp_val;

	tmp_val = atof(item[DEC_CRD]);
	
	if (tmp_val >= 0.0)
		(*positive) = TRUE;
	else
		(*negative) = TRUE;
		
	if ((*lowest) >= 0.0) {
		
		/*
		 * positive min value
		 */
		if (tmp_val >= 0.0) {
			
			/*
			 * positive actual coordinate
			 */
			if (tmp_val < (*lowest))
				(*lowest) = tmp_val;
		}
		else
			
			/*
			 * negative actual coordinate
			 */
			(*lowest) = tmp_val;
	}
	else {
		
		/*
		 * negative min value
		 */
		if (tmp_val < 0.0) {
			
			/*
			 * negative actual coordinate
			 */
			if (tmp_val < (*lowest))
				(*lowest) = tmp_val;
		}

	}

	return(TRUE);
} /* decMin */










/*
 * Calculate Max value of DEC coordinate, value may be
 * positive of negative
 * parameters:
 * 	(i) item: actual object
 * 	(i/o) highest: max value of dec
 *
 */
int
raMax(item, highest)
char item[MAX_ITEM_LINE][MAX_NUM_CHAR];
double *highest;
{
	double tmp_val;
	
	
	tmp_val = atof(item[RA_CRD]);
	
	if ((*highest) >= 0.0) {
		
		/*
		 * positive max value
		 */
		if (tmp_val >= 0.0) {
			
			/*
			 * positive actual coordinate
			 */
			if (tmp_val > (*highest))
				(*highest) = tmp_val;
		}
	}
	else {
		
		/*
		 * negative max value
		 */
		if (tmp_val < 0.0) {
			
			/*
			 * negative actual coordinate
			 */
			if (tmp_val > (*highest))
				(*highest) = tmp_val;
		}
		else
			(*highest) = tmp_val;
	}

    
	return(TRUE);
} /* raMax */










/*
 * Calculate Max value of DEC coordinate, value may be
 * positive or negative
 * parameters:
 * 	(i) item: actual object
 * 	(i/o) highest: max value of dec
 *
 */
int
decMax(item, highest)
char item[MAX_ITEM_LINE][MAX_NUM_CHAR];
double *highest;
{
	double tmp_val;
	
	
	tmp_val = atof(item[DEC_CRD]);
	
	if ((*highest) >= 0.0) {
		
		/*
		 * positive max value
		 */
		if (tmp_val >= 0.0) {
			
			/*
			 * positive actual coordinate
			 */
			if (tmp_val > (*highest))
				(*highest) = tmp_val;
		}
	}
	else {
		
		/*
		 * negative max value
		 */
		if (tmp_val < 0.0) {
			
			/*
			 * negative actual value
			 */ 
			if (tmp_val > (*highest))
				(*highest) = tmp_val;
		}
		else
			(*highest) = tmp_val;
	}
	
	return(TRUE);
} /* decMax */











/*
 * Subtract min value of DEC
 * parameters:
 * 	(i/o) item: actual object
 * 	(i) lowest_dec: min value of dec
 *
 */
int
subtractDecMin(item, lowest_dec)
char item[MAX_ITEM_LINE][MAX_NUM_CHAR];
double lowest_dec;
{
	double tmp_val;

	tmp_val = atof(item[DEC_CRD]);
	tmp_val = tmp_val - lowest_dec;
	sprintf(item[DEC_CRD],"%f", tmp_val);

	return(TRUE);
} /* subtractDecMin */











/*
 * Add max value of DEC
 * parameters:
 * 	(i/o) item: actual object
 * 	(i) highest_dec: max value of dec
 *
 */
int
addDecMax(item, highest_dec)
char item[MAX_ITEM_LINE][MAX_NUM_CHAR];
double	highest_dec;
{
	double tmp_val;
	
	tmp_val = atof(item[DEC_CRD]);
	tmp_val = tmp_val - highest_dec;
	sprintf(item[DEC_CRD], "%f", tmp_val);

	return(TRUE);
} /* addDecMax */










/*
 * Subtract midrange value of DEC in order to set midrange
 * value of DEC equal to zero
 * parameters:
 * 	(i/o) item: actual object
 * 	(i) dec_mid: middle range value of dec
 *
 */
int
subtractDecMid(item, dec_mid)
char item[MAX_ITEM_LINE][MAX_NUM_CHAR];
double dec_mid;
{
	double tmp_val;
	
	tmp_val = atof(item[DEC_CRD]);
	tmp_val = tmp_val - dec_mid;
	sprintf(item[DEC_CRD], "%f", tmp_val);
	 
	return(TRUE);
} /* subtractDecMid */











/*
 * Subtract midrange value of RA in order to set midrange
 * value or RA equal to zero.
 * parameters:
 * 	(i/o) item: actual object
 * 	(i) ra_mid: middle range value of ra
 */
int
subtractRaMid(item, ra_mid)
char item[MAX_ITEM_LINE][MAX_NUM_CHAR];
double ra_mid;
{
	double tmp_val;
	
	tmp_val = atof(item[RA_CRD]);
	tmp_val = tmp_val - ra_mid;
	sprintf(item[RA_CRD], "%f", tmp_val);
	 
	return(TRUE);
} /* subtractRaMid */

