/*******************************
 *          D2ACONST.H         *
 *******************************/


#ifndef D2ACONST_H
#define D2ACONST_H


/*
 * PROGRAM
 */
#define DEBUG                           1
#define STOP                            0
#define EQUAL				0

#define HIDDEN                          static
#define FALSE                           0
#define TRUE                            1
#define AND                             &&
#define OR                              ||
#define NOT                             !
#define bool                            int
#define avs_type_file                   int
#define avs_tipo_cella                  int


/*
 * MATH
 */
#define PIGRECO				3.141592654
#define DUEPIGRECO_DEG			180.0
#define X0				0.0
#define Y0				0.0
#define Z0				0.0




/* 
 * ASTRONOMY COORDINATES 
 */
#define RA_CRD				0
#define DEC_CRD				1
#define Z_CRD				2



/*
 * UTIL
 */
#define FILE_BUFFER_SIZE                256
#define MAX_ITEM_LINE                   10
#define MAX_NUM_CHAR                    30
#define MAX_CHAR_NAME_FILE              512
#define NUM_CHAR_NAME                   30
#define SCELTA                          3
#define LINEA                           256
#define NUM_ELEM_ELAB                   50
#define SKIP_LINE                       3
#define UNKNOWN                         "unknown"
#define UNIT_UNKNOWN                    "unit_unknown"
#define SHIFT_DELTA                     1000.0
#define TMP_EXT				".tmp"
#define TM0_EXT				".tm0"
#define TMP1_EXT			".tm1"
#define GEOM_EXT			".geom"



/*
 *  ERRORS
 */
#define NON_ESISTE_FILE                 0
#define NUMERO_PARAM_ILLEGALE           1
#define VAL_NON_RICONSCIUTO             2
#define INVALID_DATA                    3
#define FIELD_PARAM_NON_SUFF            4
#define NUM_COORD_ILLEGALE              5
#define NON_EXIST_FILE_TO_NORM	        6
#define ILLEGAL_NUM_SPHERE_COORD        7
#define ILLEGAL_FILENAME                8



/*
 * AVS UTIL CONSTANT
 */
#define FIELD                           1
#define UCD                             2
#define GEOMETRY			3
#define SCATTER_DATA                    1
#define VECLEN_SCATTER_DATA             0
#define DATA_FIELD                      "float"  /* byte, integer, float, double */
#define TIPO_FIELD                      "irregular" /* uniform, rectilinear, irregular */
#define TIPO_FILE_FLD                   "ascii"  /* ascii, binary */
#define CELLE_IN_NODE                   1
#define MIN_COORD                       1
#define MAX_COORD                       3
#define NUM_CDATA                       0
#define NUM_MDATA                       0
#define CELL_ID                         1
#define MATERIAL_ID                     1
#define SIZE_COMPONENT                  1
#define DATA_FIELD_FITTIZIO             100.0
#define FIRST_DATA                      1




/*
 * AVS GEOMETRY SPHERE CONSTANT
 */
#define COLOR_R				1
#define COLOR_G				1
#define COLOR_B				1
#define FRACT_RADIUS_SPHERE		1000.0
#define NUM_EXTENT			6
#define NUM_GEOM_CRD			3




/*
 * AVS, NUMBER OF VERTEX OF UCD CELL TYPE
 */
#define POINT                           1
#define LINE                            2
#define TRIANGLE                        3
#define QUADRILATERAL                   4
#define TETRAHEDRON                     4
#define PYRAMID                         5
#define PRISM                           6
#define HEXAHEDRON                      8




/*
 * AVS UCD CELL
 */
#define PUNTO                           1
#define LINEA_CELL                      2
#define TRIANGOLO                       3
#define QUADRILATERO                    4
#define TETRAEDRO                       5
#define PIRAMIDE                        6
#define PRISMA                          7
#define EXAEDRO                         8




/*
 * CARTESIAN COORDINATES
 */
#define COORD_X                         0
#define COORD_Y                         1
#define COORD_Z                         2




/*
 * VERTEX IDENTIFIER OF UCD CELL
 */
#define VERT_0                          0
#define VERT_1                          1
#define VERT_2                          2
#define VERT_3                          3
#define VERT_4                          4
#define VERT_5                          5
#define VERT_6                          6
#define VERT_7                          7


#endif
