/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/* mod_gen Version 1                                                     */
/* Module Name: "display_mopac" (Input) (Subroutine)                     */
/* Author: Mark Reed, NCSC, 919-248-1185                                 */
/*         Ken Flurchick, NCSC, 919-248-1121                             */
/*         Lee Bartolotti, NCSC, 919-248-1185                            */
/* Date Created: Wed Nov 10 18:03:04 1993                                */
/*                                                                       */
/* This file is automatically generated by the Module Generator (mod_gen)*/
/* Please do not modify or move the contents of this comment block as    */
/* mod_gen needs it in order to read module sources back in.             */
/*                                                                       */
/* output 0 "out3d_fld" field 3D 3-space 3-vector rectilinear float      */
/* output 1 "out_geom" geom Polyhedron                                   */
/* param 0 "gpt file" browser "0" "" "0"                                 */
/* param 1 "Representation" radio_buttons "ball & stick"                 */
/*	     "ball and stick:cpk:colored stick" ":"                      */
/* param 3 "Sphere Scale" typein_real 1.000000 0.00000 5.000000          */
/* param 4 "MO selected" typein_integer homo 1 norbs                     */
/* param 5 "Compute Choice" radio_buttons "None"                         */
/*           "MO:Density:Pt Q Esp:Esp:None" ":"                          */
/* param 6 "Grid Spacing" typein_real 0.400000 0.00000 100.000           */
/* param 7 "Extent" typein_real 4.00000 0.00000 50.000                   */
/* End of Module Description Comments                                    */

#include <stdio.h>
#include <avs/avs.h>
#include <avs/port.h>
#include <avs/field.h>
#include <avs/geom.h>


/* ----> START OF USER-SUPPLIED CODE SECTION #1 (INCLUDE FILES, GLOBAL VARIABLES)*/
#include "string.h"
#include "math.h"
#include <stdlib.h>
#include <ctype.h>
#include <avs/flow.h>



#define MAXHEV 80
#define MAXLIT 80
#define MAXATOMS (MAXLIT+MAXHEV)
#define NUMORBS (4*MAXHEV+MAXLIT)
#define MAXPTS 100
#define AU 0.5291670E+0          /* units are angstrom/bohr */
#define AUINV 1.0/ 0.5291670E+0  /* units are bohr/angstrom */
#define NATOM_TYPE 	12
#define MAXBONDS 	8196
#define BONDLENGTH	1.65
#define BALL 		0
#define BALL_AND_STICK 	1
#define STICK 		2
#define COLORED_STICK 	3
#define C_rad 	1.85
#define H_rad 	1.20 
#define O_rad 	1.40
#define N_rad 	1.54
#define S_rad 	1.85
#define I_rad 	2.15
#define P_rad 	1.90      
#define Cl_rad 	1.81      
#define F_rad 	1.35
#define B_rad 	2.08
#define Zn_rad 	1.40
#define Other_rad  1.50
#define STICKSANDSPHERES_RADFACTOR   0.25   /* spheres for ball-and-stick */


/* ************************************************************************* */
/* ************************************************************************* */

                  /* ---------------------------------------- */
                  /*  Module Description                      */
                  /* ---------------------------------------- */


int display_mopac_desc()
{
  
  int in_port, out_port, param;
  extern int display_mopac_compute();

  
  AVSset_module_name("display_mopac", MODULE_DATA);
  


  /* Output Port Specifications              */
  out_port = AVScreate_output_port("out3d_fld", 
				   "field 3D scalar rectilinear float");
  
  out_port = AVScreate_output_port("out_geom", "geom");




  /* Parameter Specifications                */
  param = AVSadd_parameter("gpt file", "string", "", "", "");
  AVSconnect_widget(param, "browser");

  param = AVSadd_parameter("Representation", "choice", "ball and stick",
		   "ball and stick:cpk:colored stick", ":"); 
  AVSconnect_widget(param, "radio_buttons");

  param = AVSadd_float_parameter("Sphere Scale", 1.00000, 0.00000, 5.00000);
  AVSconnect_widget(param, "typein_real");

  param = AVSadd_parameter("MO selected", "integer", 0, 0, 0);
  AVSconnect_widget(param, "typein_integer");

  param = AVSadd_parameter("Compute Choice", "choice", "None",
		   "MO:Density:Pt Q Esp:Esp:None", ":"); 
  AVSconnect_widget(param, "radio_buttons");

  param = AVSadd_float_parameter("Grid Spacing", 0.400000, 0.00000, 
				 100.000);
  AVSconnect_widget(param, "typein_real");

  param = AVSadd_float_parameter("Extent", 4.00000, 0.00000, 50.00000);
  AVSconnect_widget(param, "typein_real");



  AVSset_compute_proc(display_mopac_compute);

  return(1);
}



/* ************************************************************************* */
/* ************************************************************************* */

        /* --------------------------------------------------------- */
        /* Initialization for modules contained in this file.        */
        /* --------------------------------------------------------- */


static int ((*mod_list[])()) = {
       display_mopac_desc
     };
#define NMODS (sizeof(mod_list) / sizeof(char *))
       
     AVSinit_modules()
{
  AVSinit_from_module_list(mod_list, NMODS);
}




/* revised July 17, 1993 */
/* these are some global definitions */

char	type[MAXATOMS][4];
float   bond_colors[MAXATOMS][3];
float	r_lst[MAXATOMS];
float	rgb_lst[MAXATOMS][3];
float	a_lst[MAXATOMS][3];
float	b_lst[4*MAXBONDS][3];
float   b_rgb_lst[4*MAXBONDS][3];
int	num_bonds;


/* table of Van der Waals radii per each of (NATOM_TYPE) atom types */
/* Note: the order is keyed to the values set in the host "makeatomtype" */

static float radius[NATOM_TYPE] =
{C_rad, O_rad, N_rad, H_rad, S_rad, P_rad, Cl_rad, I_rad, F_rad, B_rad,
Zn_rad, Other_rad};

static float atomcolors[][3] = {
	{0.0,1.0,0.0}, {1.0,0.0,0.0}, {0.0,0.0,1.0}, {1.0,1.0,1.0},
	{1.0,1.0,0.0}, {1.0,0.5,0.5}, {1.0,1.0,0.5}, {0.5,1.0,0.5},
	{0.0,1.0,1.0}, {0.5,0.0,0.5}, {1.0,0.0,1.0}, {1.0,0.0,1.0}
	};

  static   char  *atom_names[104] = { 
      "H ","HE","LI","BE","B ","C ","N ","O ","F ","NE","NA",
      "MG","AL","SI","P ","S ","CL","AR","K ","CA","SC","TI","V ",
      "CR","MN","FE","CO","NI","CU","ZN","GA","GE","AS","SE","BR",
      "KR","RB","SR","Y ","ZR","NB","MO","TC","RU","RH","PD","AG",
      "CD","IN","SN","SB","TE","I ","XE","CS","BA","LA","CE","PR",
      "ND","PM","SM","EU","GD","TB","DY","HO","ER","TM","YB","LU",
      "HF","TA","W ","RE","OS","IR","PT","AU","HG","TL","PB","BI",
      "PO","AT","RN","FR","RA","AC","TH","PA","U ","NP","PU","AM",
      "CM","BK","CF","ES","FM","MD","NO","LR","  "} ;



/* ************************************************************************* */
/* ************************************************************************* */

                 /* ---------------------------------------- */
                 /* Module Compute Routine                   */
                 /* ---------------------------------------- */


int display_mopac_compute(out3d_fld, out_geom, gptname, 
			  Geom_Representation,scale,mo,compute_choice,
			  gridspacing, extent)
     AVSfield_float **out3d_fld;
     GEOMedit_list *out_geom;
     char *gptname;
     int mo;
     char *compute_choice;
     char *Geom_Representation;
     float *gridspacing;
     float *extent;
     float *scale;

{

  int dims1[3];
  static FILE *ifp = NULL;     /* pointer to the input gpt file */ 
  static int natoms = 0;       /* number of atoms read in from .gpt file */
  static int norbs = 0;        /* number of orbitals read in from .gpt file */
  static int nelecs = 0;       /* num valence electrons read from .gpt file */
  static int numgridptsx = MAXPTS;
  static int numgridptsy = MAXPTS;
  static int numgridptsz = MAXPTS;
  int nlast[MAXATOMS],nfirst[MAXATOMS], /* values read in from .gpt file */
      nat[MAXATOMS];                /* atomic number of the atom */
  int numfullmo,halffullmo,homo;    /* occupation of mo's */
  double xyz[MAXATOMS][3],     /* location of atoms  */
        x[MAXPTS],        /* location of x,y,z grid coordinate pts */
        y[MAXPTS],
        z[MAXPTS],
        cij[NUMORBS][NUMORBS],      /* unormalized eigenvectors */
        zs[MAXATOMS],               /* zeta values s orbital */
        zp[MAXATOMS],               /* zeta values p orbital */
        zd[MAXATOMS],               /* zeta values d orbital */
	halfs[NUMORBS][NUMORBS],    /* inverse of the sqrt of the */
                                    /* overlap matrix */
        psi[MAXPTS][MAXPTS][MAXPTS],
                                    /* wave function for a molecular orbital */
        evectors[NUMORBS][NUMORBS], /* normalized eigenvectors */
        density[MAXPTS][MAXPTS][MAXPTS]; 
                                    /* density matrix defined on grid */
  float location[MAXATOMS][3];      /* float equiv of xyz to pass to */
				    /* coord_to_geom */


  int i,j,k,imo;                    /* counters */
  int moflag,densityflag,espflag;   /* display compute flags */
  int pt_q_espflag,nocomputeflag;

  int maxo, maxatm, maxgrid, iq;
  double elesp[MAXPTS*MAXPTS*MAXPTS];
  double sc;




  /* ********************************************************************** */
   sc = *scale;
   if(sc == 0.0) sc=1.0;


  if (AVSparameter_changed ("gpt file")) {

    /* open input file */
    if ((ifp = fopen(gptname,"rb")) == NULL) {
      AVSwarning("Error opening input gpt file.");
      return(0);
    }
    
    /* call function to read in data */
    readingpt(ifp,
	      &natoms,&norbs,&nelecs,
	      xyz,
	      nat,
	      cij,
	      zs,zp,zd,
	      nlast,nfirst,
	      halfs);

    /* compute number of filled mo's and set num of half filled = 0 or 1 */
    /* set mo and modify widget to reflect default value of homo */
    numfullmo = nelecs/2;  /* must be integer division */
    halffullmo = nelecs % 2;
    homo = numfullmo + halffullmo ;
    mo = homo;
    AVSmodify_parameter("MO selected",AVS_MAXVAL | AVS_MINVAL | AVS_VALUE,
                 homo,1,norbs);


    /* copy the new atom names into type */
    for (i=0;i<natoms;i++){
      strcpy(type[i],atom_names[nat[i]-1]);
    }



  } /* end of if gpt file changed */
    

  /* ----------------------------------------------------------------------- */

  if (ifp==NULL) {
    printf("NO GPT FILE SELECTED\n");
    return(1);
  }



  /* ----------------------------------------------------------------------- */
  if (
      AVSparameter_changed ("gpt file") || 
      AVSparameter_changed ("Grid Spacing") ||
      AVSparameter_changed ("Extent")
      ) {
    

    /* call function to compute the grid */
    compute_gridpoints(natoms,
		       norbs,
		       xyz,
		       cij,
		       evectors,
		       halfs,
		       gridspacing,
		       extent,
		       x,y,z,
		       &numgridptsx,&numgridptsy,&numgridptsz);




    /* call function to plot the geometry */

    /* convert double to float then pass to coord_to_geom */
    for (i=0;i<natoms;i++){
      for (j=0;j<3;j++){
	location[i][j] = xyz[i][j];
      }
    }

    coord_to_geom(out_geom,Geom_Representation,
		  1,natoms,location,sc); 

    /* set the flags s.t. proper choice will be computed */
    nocomputeflag = 0;
    if (!strcmp(compute_choice,"MO")) moflag = 1;
    else if (!strcmp(compute_choice,"Density")) densityflag = 1;
    else if (!strcmp(compute_choice,"Pt Q Esp")) pt_q_espflag = 1;
    else if (!strcmp(compute_choice,"Esp")) espflag = 1;
    else nocomputeflag = 1;

    

  }   /* end of if gpt file or extent or spacing parms changed */


  /* ----------------------------------------------------------------------- */
  /* redo geom if new button is selected */
  if ( AVSparameter_changed("Representation")
	|| AVSparameter_changed("Sphere Scale") ) {
              coord_to_geom(out_geom,Geom_Representation,0,natoms,location,sc);
  }


  /* ----------------------------------------------------------------------- */
  if (AVSparameter_changed("MO selected") && !strcmp(compute_choice,"MO")) {
    moflag = 1;
    nocomputeflag = 0;
  }


  /* ----------------------------------------------------------------------- */
  /* set flag for the compute function selected */
  if (AVSparameter_changed("Compute Choice")) {  
    moflag = 0;
    densityflag = 0;
    pt_q_espflag = 0;
    espflag = 0;
    nocomputeflag = 0;
    if (!strcmp(compute_choice,"MO")) moflag = 1;
    else if (!strcmp(compute_choice,"Density")) densityflag = 1;
    else if (!strcmp(compute_choice,"Pt Q Esp")) pt_q_espflag = 1;
    else if (!strcmp(compute_choice,"Esp")) espflag = 1;
    else nocomputeflag = 1;
  }



  /* ----------------------------------------------------------------------- */
  /* check to see if any flag is set, if so alloc space and at end fill grid */
  if (!nocomputeflag) {

    /* Free old field data    */
    if (*out3d_fld) AVSfield_free(*out3d_fld);
    /* Allocate space for new field output   */
    dims1[0] = numgridptsx;   
    dims1[1] = numgridptsy;   
    dims1[2] = numgridptsz;   
    *out3d_fld = (AVSfield_float *) 
      AVSdata_alloc("field 3D scalar rectilinear float",dims1);
    if (*out3d_fld == NULL) {
      AVSerror("Allocation of output field failed.");
      return(0);
    }
    
    
    /* compute specified molecular orbital wave function if flag is set */
    if (moflag) {
      compute_wavefnct (natoms,mo,
			numgridptsx,numgridptsy,numgridptsz,
			nat,
			psi,
			evectors,
			xyz,
			zs,zp,zd,
			x,y,z);
      
      
      /* stuff the psi into the output field */
      /* the I3D macro computes the location of the i,j,k'th element for you */
      /* expects as its first argument a pointer to an avs field structure */
      for (i=0;i<numgridptsx;i++){
	for (j=0;j<numgridptsy;j++){
	  for (k=0;k<numgridptsz;k++){
	    I3D(*out3d_fld,i,j,k) = psi[i][j][k];
	  }
	}
      }
      
      
    } /* end of if mo flag */
    
    
    
    /* --------------------------------------------------------------------- */
    /* compute density if flag is set */  
    if (densityflag) {
      
      /* zero the density array */
      for (i=0;i<numgridptsx;i++){
	for (j=0;j<numgridptsy;j++){
	  for (k=0;k<numgridptsz;k++){
	    density[i][j][k] = 0.000000;
	  }
	}
      }
      
      
      /* loop over all the OCCUPIED mo's */
      /* first compute the number of full mo's */
      /* then check if nelecs is odd and thus if a half full mo exists */
      for (imo=1;imo<=numfullmo;imo++){
	compute_wavefnct (natoms,imo,
			  numgridptsx,numgridptsy,numgridptsz,
			  nat,
			  psi,
			  evectors,
			  xyz,
			  zs,zp,zd,
			  x,y,z);
	
	for (i=0;i<numgridptsx;i++){
	  for (j=0;j<numgridptsy;j++){
	    for (k=0;k<numgridptsz;k++){
	      density[i][j][k] = density[i][j][k] 
		+ 2*psi[i][j][k]*psi[i][j][k];
	    }
	  }
	}
      }
      /* now if a half full mo exists include it in the sum */
      if (halffullmo) {
	compute_wavefnct (natoms,imo,
			  numgridptsx,numgridptsy,numgridptsz,
			  nat,
			  psi,
			  evectors,
			  xyz,
			  zs,zp,zd,
			  x,y,z);
	
	for (i=0;i<numgridptsx;i++){
	  for (j=0;j<numgridptsy;j++){
	    for (k=0;k<numgridptsz;k++){
	      density[i][j][k] = density[i][j][k] + psi[i][j][k]*psi[i][j][k];
	    }
	  }
	}
      }
      
      /* stuff the density into the output field */
      /* the I3D macro computes the location of the i,j,k'th element for you */
      /* expects as its first argument a pointer to an avs field structure */
      for (i=0;i<numgridptsx;i++){
	for (j=0;j<numgridptsy;j++){
	  for (k=0;k<numgridptsz;k++){
	    I3D(*out3d_fld,i,j,k) = density[i][j][k];
	  }
	}
      }
      
      
    }  /* end of if density flag */
    
    
    /* --------------------------------------------------------------------- */
    /* compute esp if flag is set */  
    
    if (espflag || pt_q_espflag) {
      
      maxo = NUMORBS;
      maxatm = MAXATOMS;
      maxgrid = MAXPTS*MAXPTS*MAXPTS;
      

      espwrapper_(&natoms,&norbs,&nelecs,&numgridptsx,&numgridptsy,
		  &numgridptsz,nat,xyz,x,y,z,cij,zs,zp,zd,&maxo,&maxatm,
		  &maxgrid,elesp,&pt_q_espflag,nlast,nfirst);
      

      /* stuff the esp into the output field */
      /* the I3D macro computes the location of the i,j,k'th element for you */
      /* expects as its first argument a pointer to an avs field structure */
      
      
      iq=0;
      for (i=0;i<numgridptsx;i++){
	for (j=0;j<numgridptsy;j++){
	  for (k=0;k<numgridptsz;k++){
	    I3D(*out3d_fld,i,j,k) = elesp[iq];
	    iq++;
	  }
	}
      }
      
      
    } /* end of if esp or pt_q_esp flag set */
    
    
    /* now stuff the grid points into the output field */
    /* since the field is rectilinear we need to specify one row of x's and */
    /* one column of y's and one of z's */
    for (i=0;i<numgridptsx;i++){
      RECT_X(*out3d_fld)[i] = x[i];
    }
    for (i=0;i<numgridptsy;i++){
      RECT_Y(*out3d_fld)[i] = y[i];
    }
    for (i=0;i<numgridptsz;i++){
      RECT_Z(*out3d_fld)[i] = z[i];
    }
  }  /* end of if a compute choice was selected */


  /* ----------------------------------------------------------------------- */
  moflag = 0;
  densityflag = 0;
  espflag = 0;
  pt_q_espflag = 0;
  nocomputeflag = 1;


  return(1);
}


/* ************************************************************************* */
/* ************************************************************************* */
compute_gridpoints(int natoms,
		   int norbs,
		   double xyz[][3],
		   double cij[NUMORBS][NUMORBS],
		   double evectors[NUMORBS][NUMORBS],
		   double halfs[][NUMORBS],
		   float *gridspacing,
		   float *extent,
		   double x[],double y[],double z[],
		   int *numgridptsxptr,
		   int *numgridptsyptr,
		   int *numgridptszptr)
     
     
{
  double xyzmin[3],                 /* min value of xyz respectively */
        xyzmax[3],                  /* max value of xyz respectively */
        xmin,ymin,zmin,
        xmax,ymax,zmax;
  int i,j,k;
  float extentau,gridau;            /* converted values of extent & spacing */
  
  
  /* multiply the un-back-transformed evectors by inverse sqrt of overlap   */
  /* matrix and store the result in vecs, the back-transformed evectors     */
  /* this is the Lowden transform and is based on the mopac routine MULT    */
  /* ********************************************************************** */
  /*   									  */
  /*   THIS ROUTINE TAKEN FROM MOPAC BY J.S. STEWART 			  */
  /*									  */
  /*   MULT IS USED IN THE MULLIKEN ANALYSIS ONLY. IT PERFORMS THE	  */
  /*        OPERATION:-							  */
  /*                                   VECS=BACK-TRANSFORMED EIGENVECTORS   */
  /*        VECS  =  C*S               C   =UN-BACK-TRANSFORMED VECTORS	  */
  /*                                   S   =1/SQRT(OVERLAP MATRIX)	  */
  /*									  */
  /* ********************************************************************** */
  for (i=0;i<norbs;i++){
    for (j=0;j<norbs;j++){
      evectors[j][i] = cij[0][i]*halfs[j][0];
      for (k=1;k<norbs;k++){
	evectors[j][i] = evectors[j][i]+cij[k][i]*halfs[j][k];
      }
    }
  }
  
  
  /* ***************************  */
  /* compute grid values for cube */
  /* call function to find min and max values of xyz */
  minmax (natoms,xyz,xyzmin,xyzmax);
  
  
  


  /* note that extent and gridspacing are in angstroms */  
  /* convert them to atomic units (bohr) */
  extentau = *extent * AUINV;
  gridau = *gridspacing * AUINV;

  /* compute min and max values based on the min and max atom locations -/+ */
  /* the extent values, respectively */
  xmin = xyzmin[0]-extentau;
  xmax = xyzmax[0]+extentau;
  ymin = xyzmin[1]-extentau;
  ymax = xyzmax[1]+extentau;
  zmin = xyzmin[2]-extentau;
  zmax = xyzmax[2]+extentau;
  *numgridptsxptr = ceil((xmax-xmin)/(gridau));
  *numgridptsyptr = ceil((ymax-ymin)/(gridau));
  *numgridptszptr = ceil((zmax-zmin)/(gridau));
  
  


  x[0] = xmin;
  y[0] = ymin;
  z[0] = zmin;
  for (i=1;i<*numgridptsxptr;i++){
    x[i] = gridau+x[i-1];
  }
  for (i=1;i<*numgridptsyptr;i++){
    y[i] = gridau+y[i-1];
  }
  for (i=1;i<*numgridptszptr;i++){
    z[i] = gridau+z[i-1];
  }

  
  return;
}

/* ************************************************************************* */
/* ************************************************************************* */
double gexp (double x)
{
  double expofx;
  
  if (x>=-19.0) 
    expofx = exp(x);
  else
    expofx = 0.0e+0;
  return(expofx);
}


/* ************************************************************************* */
/* ************************************************************************* */
minmax (int natoms,double xyz[][3],double xyzmin[],
	     double xyzmax[])
     /* find out the dimensions of the grid that density will be computed on */
     /* this is done before the coords are converted to a.u. */
     
{
  int i,j;
  double minval,maxval;
  
  for (i=0;i<3;i++){  
    minval = 100.0e0;
    maxval = -100.0e0;
    for (j=0;j<natoms;j++){
      if(minval>xyz[j][i]) minval = xyz[j][i];
      if(maxval<xyz[j][i]) maxval = xyz[j][i];
    }
    xyzmin[i] = minval;
    xyzmax[i] = maxval;
  }
  
  return;
}


/* ********************************************************************** */
/* ********************************************************************** */
readingpt(FILE *ifp,
	       int *natomsptr,int *norbsptr,int *nelecsptr,
	       double xyz[][3],
	       int nat[],
	       double cij[NUMORBS][NUMORBS],
	       double zs[],double zp[],double zd[],
	       int nlast[],int nfirst[],
	       double halfs[][NUMORBS])
     

{
  /* this function reads in the data from the .gpt file and returns it to  */
  /* the calling routine */
  int i,j,k,linear;            /* counters and temp vars */
  int dummy = 0;
  int natoms,nelecs,norbs;           /* read in here and returned to calling */
  double temp[NUMORBS*NUMORBS];
  
  /* read in first record */
  /* note we must read a dummy value before each record in the unf file */
  fread (&dummy,sizeof(dummy),1,ifp);
  fread (&natoms,sizeof(natoms),1,ifp);
  fread (&norbs,sizeof(norbs),1,ifp);
  fread (&nelecs,sizeof(nelecs),1,ifp);

  /* read the coordinates into a temp array and then rearrange into a 2d array */
  /* the data is formatted as all x coords, then natoms of y coords, etc. */
  /* also convert coordinates to atomic units so xyz is in bohr*/
  fread (temp,sizeof(temp[0]),3*natoms,ifp);
  k=0;
  for (i=0;i<3;i++){
    for (j=0;j<natoms;j++){
      xyz[j][i] = temp[k]*AUINV;
      k++;
    }
  }
  


  /* read in second record */
  fread (&dummy,sizeof(dummy),1,ifp);
  fread (&dummy,sizeof(dummy),1,ifp);
  for (i=0;i<natoms;i++){
    fread (&nlast[i],sizeof(nlast[0]),1,ifp);
    fread (&nfirst[i],sizeof(nfirst[0]),1,ifp);
  }

  
  /* read in third record */
  fread (&dummy,sizeof(dummy),1,ifp);
  fread (&dummy,sizeof(dummy),1,ifp);
  fread (zs,sizeof(zs[0]),natoms,ifp);
  fread (zp,sizeof(zp[0]),natoms,ifp);
  fread (zd,sizeof(zd[0]),natoms,ifp);
  fread (nat,sizeof(nat[0]),natoms,ifp);
  
  
  /* read in fourth record */
  /* the eigenvectors, cij, are read into a temp array and then rearranged */
  /* into a 2D array by varying the rows first, then the cols */
  linear = norbs*norbs;
  fread (&dummy,sizeof(dummy),1,ifp);
  fread (&dummy,sizeof(dummy),1,ifp);
  fread (temp,sizeof(temp[0]),linear,ifp);
  k=0;
  for (i=0;i<norbs;i++){
    for (j=0;j<norbs;j++){
      cij[j][i] = temp[k];
      k++;
    }
  }
  
  
  
  /* read in fifth record */
  /* the normalizing factors are read into a temp array and then rearranged */
  /* into a 2D array by varying the rows first, then the cols */
  fread (&dummy,sizeof(dummy),1,ifp);
  fread (&dummy,sizeof(dummy),1,ifp);
  fread (temp,sizeof(temp[0]),linear,ifp);
  k=0;
  for (i=0;i<norbs;i++){
    for (j=0;j<norbs;j++){
      halfs[j][i] = temp[k];
      k++;
    }
  }


  /* FINISHED READING IN DATA FROM .GPT FILE */
  
  
  /* point pointers to addresses of vars so they will be returned */
  *natomsptr = natoms;
  *norbsptr = norbs;
  *nelecsptr = nelecs;
  
  return;
}



/* ********************************************************************** */
/* ********************************************************************** */
coord_to_geom(output,rep,file_changed,natoms,location,scale)

GEOMedit_list *output; 
char *rep;
/* char atype[][4]; */
int file_changed;
int natoms;
float location[][3];
double scale;
{ 
  int	i;
  int rep_type;
  float bondlength;
  int	atom_count, bond_count;
  GEOMobj 	*atoms_obj, *bonds_obj;
  GEOMobj	*objs[2];
  float ballscale = STICKSANDSPHERES_RADFACTOR;
  int vcolors, a, b;
  float *lcols;
  int	atomtype[MAXATOMS];
  int	bonds[MAXBONDS][2];




/* **********    start of routine    ************* */

  *output = GEOMinit_edit_list(*output); 


  if (!strcmp(rep,"cpk")) rep_type = BALL;
  else if (!strcmp(rep,"stick")) rep_type = STICK;
  else if (!strcmp(rep,"colored stick")) rep_type = COLORED_STICK;
  else rep_type = BALL_AND_STICK;
  
  if (rep_type == BALL) ballscale = 1.0;
  ballscale = ballscale*scale*AUINV;
  bondlength  = BONDLENGTH*AUINV;
  


  if (file_changed) {
     makeatomtype(type,natoms,atomtype);
     num_bonds = makebonds(location,type,natoms,MAXBONDS,bondlength,bonds);
  }



  if (rep_type == COLORED_STICK) {
     for (i = 0; i < natoms; i++) {
	bond_colors[i][0] = atomcolors[atomtype[i]][0];
	bond_colors[i][1] = atomcolors[atomtype[i]][1];
	bond_colors[i][2] = atomcolors[atomtype[i]][2];
     } 
     vcolors = 1;
  }
  else vcolors = 0;

  bond_count = 0;
  for(i=0;i<num_bonds;i++)
  {
	  a = bonds[i][0]; 
	  b = bonds[i][1];

	  b_lst[2*bond_count][0] = location[a][0];
	  b_lst[2*bond_count][1] = location[a][1];
	  b_lst[2*bond_count][2] = location[a][2];

	  if (vcolors) {
	     b_rgb_lst[2*bond_count][0] = bond_colors[a][0];
	     b_rgb_lst[2*bond_count][1] = bond_colors[a][1];
	     b_rgb_lst[2*bond_count][2] = bond_colors[a][2];

	     b_rgb_lst[2*bond_count+1][0] = bond_colors[a][0];
	     b_rgb_lst[2*bond_count+1][1] = bond_colors[a][1];
	     b_rgb_lst[2*bond_count+1][2] = bond_colors[a][2];
	  }

	  if (vcolors && (bond_colors[a][0] != bond_colors[b][0] ||
	      bond_colors[a][1] != bond_colors[b][1] ||
	      bond_colors[a][2] != bond_colors[b][2])) {

	     b_lst[2*bond_count+2][0] = b_lst[2*bond_count+1][0] = 
				(location[a][0] + location[b][0])/2.;
	     b_lst[2*bond_count+2][1] = b_lst[2*bond_count+1][1] = 
				(location[a][1] + location[b][1])/2.;
	     b_lst[2*bond_count+2][2] = b_lst[2*bond_count+1][2] = 
				(location[a][2] + location[b][2])/2.;

	     b_rgb_lst[2*bond_count+2][0] = bond_colors[b][0];
	     b_rgb_lst[2*bond_count+2][1] = bond_colors[b][1];
	     b_rgb_lst[2*bond_count+2][2] = bond_colors[b][2];

	     b_rgb_lst[2*bond_count+3][0] = bond_colors[b][0];
	     b_rgb_lst[2*bond_count+3][1] = bond_colors[b][1];
	     b_rgb_lst[2*bond_count+3][2] = bond_colors[b][2];

	     bond_count++;
	  }
	     
	  b_lst[2*bond_count+1][0] = location[b][0];
	  b_lst[2*bond_count+1][1] = location[b][1];
	  b_lst[2*bond_count+1][2] = location[b][2];
	  bond_count++;
  }
  
  atom_count = 0;
  for(i=0;i<natoms;i++)
  {   
      {   a_lst[atom_count][0]   = location[i][0];
	  a_lst[atom_count][1]   = location[i][1];
	  a_lst[atom_count][2]   = location[i][2];
	  rgb_lst[atom_count][0] = atomcolors[atomtype[i]][0];
	  rgb_lst[atom_count][1] = atomcolors[atomtype[i]][1];
	  rgb_lst[atom_count][2] = atomcolors[atomtype[i]][2];
	  r_lst[atom_count] = radius[atomtype[i]] * ballscale;
	  atom_count++;
      }
  }

  if ((rep_type == BALL || rep_type == BALL_AND_STICK) && atom_count) {
     atoms_obj = GEOMcreate_sphere(NULL,a_lst,r_lst,NULL,NULL,atom_count,0);  
     GEOMadd_float_colors(atoms_obj,rgb_lst,atom_count,0);
  }
  else atoms_obj = GEOMcreate_obj(GEOM_SPHERE,NULL);
  bonds_obj = GEOMcreate_obj(GEOM_POLYTRI,NULL);

  if (rep_type != BALL && bond_count) {
     if (vcolors) lcols = &b_rgb_lst[0][0];
     else lcols = NULL;
     GEOMadd_disjoint_line(bonds_obj,b_lst,lcols,2*bond_count,0);
  }

  objs[0] = atoms_obj;
  objs[1] = bonds_obj;




  GEOMset_extent(atoms_obj);
  GEOMset_extent(bonds_obj);
  GEOMunion_extents(atoms_obj,bonds_obj);

  GEOMedit_geometry(*output,"molecule",atoms_obj);
  GEOMedit_geometry(*output,"molecule",bonds_obj);
  /* Set the window -- this will transform the top so that stuff is visible 
  GEOMedit_window(*output,"molecule",atoms_obj->extent); */

  GEOMdestroy_obj(atoms_obj);
  GEOMdestroy_obj(bonds_obj);

  return(1);
}



/* ********************************************************************** */
/* ********************************************************************** */
/* makebonds and makeatomtype */


makebonds(apos, atype, natoms, maxnbonds, threshold, bonds)
    register float apos[][3];
    char      atype[][4];
    int       natoms;
    int       maxnbonds;
    float     threshold;
    int       bonds[][2];
{
    /*
     * Generate into bonds the indices into apos of neighbors. Returns number
     * of bonds. 
     *
     * This version is a simple-minded distance check with special case code to
     * prevent hydrogen over-connectivity. Mike Pique 
     */

    register int i, j;
    register int nbonds;
    register float dx, dy, dxy, dz;
    float     h_len = 1.4;

    h_len = h_len*AUINV;

    nbonds = 0;
    for (i = natoms - 1; i > 0; i--) {
	for (j = i - 1; j >= 0 && nbonds < maxnbonds; j--) {
	    /*
	     * The outer loop index 'i' is AFTER the inner loop 'j': 'i'
	     * leads 'j' in the list: since hydrogens traditionally follow
	     * the heavy atom they're bonded to, this makes it easy to quit
	     * bonding to hydrogens after one bond is made by breaking out of
	     * the 'j' loop when 'i' is a hydrogen and we make a bond to it.
	     * Working backwards like this makes it easy to find the heavy
	     * atom that came 'just before' the Hydrogen. mp 
	     */

	    /* never bond hydrogens to each other... */
	    if (atype[i][0] == 'H' && atype[j][0] == 'H')
		continue;

	    dx = apos[i][0] - apos[j][0];
	    if (dx < 0)
		dx = -dx;
	    if (dx > threshold)
		continue;
	    dy = apos[i][1] - apos[j][1];
	    if (dy < 0)
		dy = -dy;
	    if (dy > threshold)
		continue;
	    if ((dxy = hypot(dx, dy)) > threshold)
		continue;

	    dz = apos[i][2] - apos[j][2];
	    if (dz < 0)
		dz = -dz;
	    if (dz > threshold)
		continue;
	    if (hypot(dxy, dz) > threshold)
		continue;
            if (atype[i][0] == 'H' || atype[j][0] == 'H')
	      if(hypot(dxy,dz) > h_len )
		 continue;
	    bonds[nbonds][0] = j;
	    bonds[nbonds][1] = i;
	    nbonds++;
	    if (atype[i][0] == 'H')
		break;		/* only one bond per hydrogen */
	    if (atype[i][0] == 'h')
		break;		/* only one bond per hydrogen */
	}
    }

    return nbonds;
}

int
makeatomtype(atype, natoms, atomtype)
    char      atype[][4];
int       natoms;
int       atomtype[];

{

    /*
     * Generate into atomtype the integer 0..7 atom type Returns number of
     * atoms	
     *
     */

    register int i;
    char      a, b;
    int       anum;

    for (i = 0; i < natoms; i++) {
	a = atype[i][0];
	if (islower(a))
	    a = toupper(a);
	switch (a) {
	  case 'H':
	    anum = 3;
	    break;
	  case 'C':
	    b = atype[i][1];
	    if (islower(b))
	       b = toupper(b);
	    if (b == 'L')
	       anum = 6;
            else
	       anum = 0;
	    break;
	  case 'O':
	    anum = 1;
	    break;
	  case 'N':
	    anum = 2;
	    break;
	  case 'S':
	    anum = 4;
	    break;
	  case 'P':
	    anum = 5;
	    break;
	  case 'I':
	    anum = 7;
	    break;
	  case 'F':
	    anum = 8;
	    break;
	  case 'B':
	    anum = 9;
	    break;
	  case 'Z':
	    anum = 10;
	    break;
	  default:
	    anum = 11;
	    break;
	}
	atomtype[i] = anum;
    }
    return natoms;
}

/* ************************************************************************* */
/* ************************************************************************* */
compute_wavefnct(int natoms,int mo,
		     int numgridptsx,int numgridptsy,int numgridptsz,
		     int nat[],
		     double density[MAXPTS][MAXPTS][MAXPTS],
		     double evectors[NUMORBS][NUMORBS],
		     double xyz[][3],
		     double zs[],double zp[],double zd[],
		     double x[],double y[],double z[])

{
  double a[3][3],d[3][3],d2p[3],d3p[3],
  cnstns[3][3],cnstnp[3][3],
  cnstx[MAXPTS][3],cnsty[MAXPTS][3],cnstz[MAXPTS][3],
  xdel[MAXPTS],ydel[MAXPTS],zdel[MAXPTS],
  xdelsq[MAXPTS],ydelsq[MAXPTS],zdelsq[MAXPTS],
  zsq[3],
  vnorm[12],
  aneg[6],
  exps[MAXPTS][9],expp[MAXPTS][9];
  int i,j,ix,iy,iz,ixyz,ig,iatoms,
  nao,iat,m;
  double zn,zsqrt,rnorm,aop1,aop2,aop3;

  
  /* define some data constants */
  a[0][0] = 1.098180E-1;
  a[0][1] = 4.057710E-1;
  a[0][2] = 2.227660E+0;
  a[1][0] = 7.513860E-2;
  a[1][1] = 2.310310E-1;
  a[1][2] = 9.942030E-1;
  a[2][0] = 5.272660E-2;
  a[2][1] = 1.347150E-1;
  a[2][2] = 4.828540E-1;
  d[0][0] = 4.446350E-1;
  d[0][1] = 5.353280E-1;
  d[0][2] = 1.543290E-1;
  d[1][0] = 7.001150E-1;
  d[1][1] = 3.995130E-1;
  d[1][2] = -9.996720E-2;
  d[2][0] = 9.003980E-1;
  d[2][1] = 2.255950E-1;
  d[2][2] = -2.196200E-1;
  d2p[0] = 3.919570E-1;
  d2p[1] = 6.076840E-1;
  d2p[2] = 1.559160E-1;
  d3p[0] = 4.620010E-1;
  d3p[1] = 5.951670E-1;
  d3p[2] = 1.058760E-2;
  
  /*
    C       NOW INITIALIZE ALL OF THE NON-"R" DEPENDANT VALUES RATHER THAN
    C       RECOMPUTING THEM MAXPTS**3 TIMES IN THE Z,Y,X LOOP OVER THE
    C       ORBITAL VALUE MATRIX (DENSIT)
    C
    C       THESE VALUES ARE ALSO INDEPENDANT OF ATOM TYPE, ONLY DEPENDANT
    C       ON THE ROW OF THE PERIODIC TABLE AND WHETHER IT IS "S" OR "P"
    C       INITIALIZE THEM HERE AND ACCESS THEM WITHIN THE NAT LOOP, BEFORE
    C       ENTERING THE LOOP OVER THE GRID (CUBE) POINTS.
    
    WRITE (ILST,*) ' EVALUATING THE SEMIEMPIRICAL WAVEFUNCTION'
    */
  
  nao = 0;
  for (i=0;i<natoms;i++){
    nao++;
    if (nat[i]>1) {
      nao = nao+3;
      if (nat[i]>18) AVSinformation 
	("atomic numbers above 18 not yet implemented\n");
    }
  }
  /*      WRITE (ILST,*) NAO,' WAVEFUNCTIONS TO BE PROCESSED ' */
  
  
  /*
    C       READ IN EIGENVECTORS
    C       IT IS ASSUMED THAT THE EIGENVECTORS HAVE BEEN NORMALIZED TO 1
    C       ELECTRON WITH THE OVERLAP MATRIX INCLUDED. FOR SEMI-EMPIRICAL
    C       WAVEFUNCTIONS, THIS REQUIRES THE LOWDIN TRANSFORMATION AS
    C       IMPLEMENTED IN THE MOPAC ROUTINE MULT.
    C
    C       THE ZETA VALUES ARE ASSUMED TO BE AT THE END OF THE DATA, ONE
    C       FOR EACH ATOM NUMBER. (8F10.6)
    */
  

  
  
  /*  mo = mone; */
  /* decrement mo by one since it is used as an array index */
  /* note this change will not be passed back to the calling function */
  mo--;
  /*
    C       THESE ARE THE FIRST PART OF THE EQUATIONS FOR 1S->3P, CALCULATE
    C       THEM ONCE AND ONCE ONLY, REAL POWERS (**X.XX) ARE VERY SLOW
    C       COMPUTATIONS.  THESE "CONTANTS" NS AND NP WILL BE MULTIPLIED
    C       BY THE ATOM DEPENDANT - R INDEPENDANT VALUES TO FORM ONE SINGLE
    C       CONSTANT FOR MULTIPLICATION WITHIN THE CUBE LOOP.  THIS WILL
    C       SPEED COMPUTATION CONSIDERABLY RATHER THAN DOING ALL OF THIS IN
    C       THE LOOP.
    C
    C       FIRST THE "NS" ORBITAL "CONSTANTS"
    */
  cnstns[0][0] = pow(a[0][0],0.750e+0)*d[0][0];
  cnstns[1][0] = pow(a[0][1],0.750e+0)*d[0][1];
  cnstns[2][0] = pow(a[0][2],0.750e+0)*d[0][2];
  cnstns[0][1] = pow(a[1][0],0.750e+0)*d[1][0];
  cnstns[1][1] = pow(a[1][1],0.750e+0)*d[1][1];
  cnstns[2][1] = pow(a[1][2],0.750e+0)*d[1][2];
  cnstns[0][2] = pow(a[2][0],0.750e+0)*d[2][0];
  cnstns[1][2] = pow(a[2][1],0.750e+0)*d[2][1];
  cnstns[2][2] = pow(a[2][2],0.750e+0)*d[2][2];
  /*
    C       NOW FOR THE "NP" ORBITALS (THE SECOND ARG IS THE QUANTUM NUMBER)
    C       THE QUANTUM NUMBER RANGES FROM 2,3 SINCE THERE IS NO 1P ORBITAL
    */
  cnstnp[0][1] = pow(a[1][0],1.250e+0)*d2p[0];
  cnstnp[1][1] = pow(a[1][1],1.250e+0)*d2p[1];
  cnstnp[2][1] = pow(a[1][2],1.250e+0)*d2p[2];
  cnstnp[0][2] = pow(a[2][0],1.250e+0)*d3p[0];
  cnstnp[1][2] = pow(a[2][1],1.250e+0)*d3p[1];
  cnstnp[2][2] = pow(a[2][2],1.250e+0)*d3p[2];
  /*
    C       ZERO THE ORBITAL VALUE ARRAY
    */
  for (iz=0;iz<numgridptsz;iz++){
    for (iy=0;iy<numgridptsy;iy++){
      for (ix=0;ix<numgridptsx;ix++){
	density[ix][iy][iz] = 0.0e+0;
      }
    }
  }
  /*
    C       INITIALIZE THE AO COUNTER AND LOOP OVER ATOMS, IAT IS THE ATOMIC
    C       NUMBER
    */
  /* major loop : goes till end of function */  
  m = 0;
  for (iatoms=0;iatoms<natoms;iatoms++){ 
    /*    for (iatoms=0;iatoms<1;iatoms++){ */
    iat = nat[iatoms];


    /*
      C       COMPUTE XDEL,YDEL,AND ZDEL (I.E. DELTA X,Y, AND Z FROM THE ATOM
      C       TO EACH POINT ON THE GRID.  ONLY MAXPTS VALUES FOR EACH SINCE,
      C       FOR INSTANCE, EVERY POINT ON A PARTICULAR XY PLANE IS THE SAME
      C       DELTA Z VALUE FROM THE POINT.  THEREFORE YOU HAVE ONLY ONE VALUE
      C       FOR THE ENTIRE PLANE FOR DELTA Z, INSTEAD OF (FOR MAXPTS=51)
      C       2601.  AGAIN, BY COMPUTING THIS HERE, RATHER THAN INSIDE THE
      C       LOOP WE CUT DOWN THESE SUBTRACTIONS AND MULTIPLICATIONS BY
      C       A FACTOR OF 2601 TO 1. THIS HAS A SUBSTANTIAL EFFECT ON THE
      C       SPEED OF THE COMPUTATIONS.
      */
    for (j=0;j<numgridptsx;j++){
      xdel[j] = x[j]-xyz[iatoms][0];
      xdelsq[j] = xdel[j]*xdel[j];
    }
    for (j=0;j<numgridptsy;j++){
      ydel[j] = y[j]-xyz[iatoms][1];
      ydelsq[j] = ydel[j]*ydel[j];
    }
    for (j=0;j<numgridptsz;j++){
      zdel[j] = z[j]-xyz[iatoms][2];
      zdelsq[j] = zdel[j]*zdel[j];
    }

    /*
      C       FIRST THE H, HE ATOMS
      
      WRITE (ILST,'(2(A,I5))') 
      *       'PROCESSING ATOM NUMBER ',Iatoms,' ATOMIC NUMBER ',IAT
      */
    
    if (iat<=2) {
      /*
	C       NOW CALCULATE THE NORMALIZATION FACTORS WHICH ARE ATOM TYPE AND
	C       QUANTUM NUMBER DEPENDANT.  MULTIPLY BY THE "CONSTANTS" FOR THE
	C       PARTICULAR A.O. AND THE EIGENVECTOR FOR THAT A.O. IN THE M.O.
	C       SINCE IT IS ALSO POSITION INDEPENDANT.  THE R*COS(THETA) (XDEL,
	C       YDEL,AND ZDEL) WILL HAVE TO BE DONE INSIDE THE X,Y,AND Z LOOPS
	C       RESPECTIVELY FOR ATOMS WHICH HAVE "P" ORBITALS, HERE WE DON'T
	C       NEED TO WORRY.
	*/
      zn = zs[iatoms];
      zsqrt = sqrt(zn);
      zsq[0] = zn*zn;
      /*
	C       ZN * SQRT(ZN) * (2.0E+0/PI)**0.750E+0
	*/
      rnorm = zn*zsqrt*0.712705470e+0;
      vnorm[0] = rnorm*evectors[m][mo]*cnstns[0][0];
      vnorm[1] = rnorm*evectors[m][mo]*cnstns[1][0];
      vnorm[2] = rnorm*evectors[m][mo]*cnstns[2][0];
      /*
	C       THERE IS ONLY THE 1S TO EVALUATE
	*/
      aneg[0] = -a[0][0]*zsq[0];
      aneg[1] = -a[0][1]*zsq[0];
      aneg[2] = -a[0][2]*zsq[0];
      /*
	C       THE EXPONENTIATIONS RELATED TO XDEL,YDEL,AND ZDEL
	C       THEY WILL BE MULTIPLIED IN THE LOOP, RATHER THAN
	C       MAXPTS**3 SEPARATE EXPONENTIATIONS OVER R.  THESE
	C       9*MAXPTS MAKE THE UNIQUE ONES FOR 1S. (3 GAUSSIANS*
	C       3 CARTESIAN COORDS * MAXPTS PLANES )
	*/
      for (ixyz=0;ixyz<numgridptsx;ixyz++){
	exps[ixyz][0] = gexp(xdelsq[ixyz]*aneg[0])*vnorm[0];
	exps[ixyz][1] = gexp(xdelsq[ixyz]*aneg[1])*vnorm[1];
	exps[ixyz][2] = gexp(xdelsq[ixyz]*aneg[2])*vnorm[2];
      }
      for (ixyz=0;ixyz<numgridptsy;ixyz++){
	exps[ixyz][3] = gexp(ydelsq[ixyz]*aneg[0]);
	exps[ixyz][4] = gexp(ydelsq[ixyz]*aneg[1]);
	exps[ixyz][5] = gexp(ydelsq[ixyz]*aneg[2]);
      }
      for (ixyz=0;ixyz<numgridptsz;ixyz++){
	exps[ixyz][6] = gexp(zdelsq[ixyz]*aneg[0]);
	exps[ixyz][7] = gexp(zdelsq[ixyz]*aneg[1]);
	exps[ixyz][8] = gexp(zdelsq[ixyz]*aneg[2]);
      }
      
      /*
	C       CONTR IS THE SUM OF CONTRIBUTIONS OVER THIS YZ PLANE FOR THIS
	C       ATOM.   WHEN FINISHED, SUM INTO THE ORBITAL VALUE ARRAY.
	*/
      
      for (iz=0;iz<numgridptsz;iz++){
	for (iy=0;iy<numgridptsy;iy++){
	  for (ig=0;ig<2;ig++){
	    for (ix=0;ix<numgridptsx;ix++){
	      density[ix][iy][iz] = density[ix][iy][iz]
		+exps[iy][ig+3]*exps[iz][ig+6]*exps[ix][ig];
	    }
	  }
	}
      }
      
      m = m+1;
    }
    
    /* ************************************  */
    else if (iat<=10) {
      /*
	C       CALC ZETA(2S) SQUARED AND SQRT FOR CONSTANTS.
	*/
      zn = zs[iatoms];
      zsqrt = sqrt(zn);
      zsq[0] = zn*zn;
      /*
	C       ZN * SQRT(ZN) * (2.0E+0/PI)**0.750E+0
	C
	C       VNORM(1-3) THE THE THREE GAUSSION "CONSTANTS" FOR THE 2S
	C       ORBITAL, EVERYTHING THAT IS INDEPENDANT OF R IS IN THERE.
	*/
      rnorm = zn*zsqrt*0.712705470e+0;
      vnorm[0] = rnorm*evectors[m][mo]*cnstns[0][1];
      vnorm[1] = rnorm*evectors[m][mo]*cnstns[1][1];
      vnorm[2] = rnorm*evectors[m][mo]*cnstns[2][1];
      /*
	C       CALC ZETA(2P) SQUARED AND SQRT FOR CONSTANTS.
	*/
      zn = zp[iatoms];
      zsqrt = sqrt(zn);
      zsq[1] = zn*zn;
      /*
	C       ZN*ZN * SQRT(ZN) * ((128.0E+0/PI**3)**0.250E+0)
	C
	C       VNORM(1-3) CORRESPONDS TO THE 3 GAUSSIANS FOR THE 2S ORBITAL
	C       VNORM(4-6) "                            " FOR THE 2PX ""
	C       VNORM(7-9) "" FOR THE 2PY ""
	C       VNORM(10-12) "" FOR THE 2PZ ""
	C       YOU NEED DIFFERENT "CONSTANTS" FOR EACH DUE TO THE DIFFERENT
	C       VALUE OF THE WAVEFUNCTION FOR EACH ORBITAL. AT THE END WE WILL
	C       HAVE A 3 SETS OF NUMBERS ALL MULTIPLIED BY THE EXPONENTIAL,
	C       WE CAN ADD THEM FIRST, THEN CALC. AND MULT. BY THE EXP.
	*/
      rnorm = zsq[1]*zsqrt*1.425410940e+0;
      aop1 = rnorm*cnstnp[0][1];
      aop2 = rnorm*cnstnp[1][1];
      aop3 = rnorm*cnstnp[2][1];
      vnorm[3] = aop1*evectors[m+1][mo];
      vnorm[4] = aop2*evectors[m+1][mo];
      vnorm[5] = aop3*evectors[m+1][mo];
      vnorm[6] = aop1*evectors[m+2][mo];
      vnorm[7] = aop2*evectors[m+2][mo];
      vnorm[8] = aop3*evectors[m+2][mo];
      vnorm[9] = aop1*evectors[m+3][mo];
      vnorm[10] = aop2*evectors[m+3][mo];
      vnorm[11] = aop3*evectors[m+3][mo];
      for (ixyz=0;ixyz<numgridptsx;ixyz++){
	cnstx[ixyz][0] = vnorm[3]*xdel[ixyz];
	cnstx[ixyz][1] = vnorm[4]*xdel[ixyz];
	cnstx[ixyz][2] = vnorm[5]*xdel[ixyz];
      }
      for (ixyz=0;ixyz<numgridptsy;ixyz++){
	cnsty[ixyz][0] = vnorm[6]*ydel[ixyz];
	cnsty[ixyz][1] = vnorm[7]*ydel[ixyz];
	cnsty[ixyz][2] = vnorm[8]*ydel[ixyz];
      }
      for (ixyz=0;ixyz<numgridptsz;ixyz++){
	cnstz[ixyz][0] = vnorm[9]*zdel[ixyz];
	cnstz[ixyz][1] = vnorm[10]*zdel[ixyz];
	cnstz[ixyz][2] = vnorm[11]*zdel[ixyz];
      }
      /*
	C       EVALUATE 2S AND 2P
	C
	C       MINUS ALPHA FOR 2S:
	*/
      aneg[0] = -a[1][0]*zsq[0];
      aneg[1] = -a[1][1]*zsq[0];
      aneg[2] = -a[1][2]*zsq[0];
      /*
	C       MINUS ALPHA FOR 2P:
	*/
      aneg[3] = -a[1][0]*zsq[1];
      aneg[4] = -a[1][1]*zsq[1];
      aneg[5] = -a[1][2]*zsq[1];
      /*
	C       PRECOMPUTE EXP(-A*Z**2*DELO**2) WHERE DELO**2 IS
	C       DELTA-X**2, DELTA-Y**2, AND DELTA-Z**2
	*/
      for (ixyz=0;ixyz<numgridptsx;ixyz++){
	exps[ixyz][0] = gexp(xdelsq[ixyz]*aneg[0])*vnorm[0];
	exps[ixyz][1] = gexp(xdelsq[ixyz]*aneg[1])*vnorm[1];
	exps[ixyz][2] = gexp(xdelsq[ixyz]*aneg[2])*vnorm[2];
      }
      for (ixyz=0;ixyz<numgridptsy;ixyz++){
	exps[ixyz][3] = gexp(ydelsq[ixyz]*aneg[0]);
	exps[ixyz][4] = gexp(ydelsq[ixyz]*aneg[1]);
	exps[ixyz][5] = gexp(ydelsq[ixyz]*aneg[2]);
      }
      for (ixyz=0;ixyz<numgridptsz;ixyz++){
	exps[ixyz][6] = gexp(zdelsq[ixyz]*aneg[0]);
	exps[ixyz][7] = gexp(zdelsq[ixyz]*aneg[1]);
	exps[ixyz][8] = gexp(zdelsq[ixyz]*aneg[2]);
      }

      for (ixyz=0;ixyz<numgridptsx;ixyz++){
	expp[ixyz][0] = gexp(xdelsq[ixyz]*aneg[3]);
	expp[ixyz][1] = gexp(xdelsq[ixyz]*aneg[4]);
	expp[ixyz][2] = gexp(xdelsq[ixyz]*aneg[5]);
      }
      for (ixyz=0;ixyz<numgridptsy;ixyz++){
	expp[ixyz][3] = gexp(ydelsq[ixyz]*aneg[3]);
	expp[ixyz][4] = gexp(ydelsq[ixyz]*aneg[4]);
	expp[ixyz][5] = gexp(ydelsq[ixyz]*aneg[5]);
      }
      for (ixyz=0;ixyz<numgridptsz;ixyz++){
	expp[ixyz][6] = gexp(zdelsq[ixyz]*aneg[3]);
	expp[ixyz][7] = gexp(zdelsq[ixyz]*aneg[4]);
	expp[ixyz][8] = gexp(zdelsq[ixyz]*aneg[5]);
      }
      
      
      /*
	C       LOOP OVER THE "CUBE" Z,Y, AND X
	*/
      /*
	C       SUM THE ORBITAL CONTRIBUTIONS INTO THE ORBITAL VALUE ARRAY
	C
	C       FIRST THE 3 GAUSSIANS FOR THE 2S:
	*/
      
      for (iz=0;iz<numgridptsz;iz++){
	for (iy=0;iy<numgridptsy;iy++){
	  for (ig=0;ig<2;ig++){
	    for (ix=0;ix<numgridptsx;ix++){
	      density[ix][iy][iz] = density[ix][iy][iz]
		+exps[iy][ig+3]*exps[iz][ig+6]*exps[ix][ig];
	      
	      /*       NEXT, THE 3 FOR THE 2P: */
	      
	      density[ix][iy][iz] = density[ix][iy][iz]
		+(cnsty[iy][ig]+cnstz[iz][ig]+cnstx[ix][ig])
		  *expp[ix][ig]*expp[iy][ig+3]*expp[iz][ig+6];
	    }
	  }
	}
      }
      m = m+4;
    }
    
    /* ************************************  */
    else if (iat<=18) {
      
      
      /*
	C       CALC ZETA(3S) SQUARED AND SQRT FOR CONSTANTS.
	*/
      zn = zs[iatoms];
      zsqrt = sqrt(zn);
      zsq[0] = zn*zn;
      /*
	C       ZN * SQRT(ZN) * (2.0E+0/PI)**0.750E+0
	C
	C       VNORM(1-3) THE THE THREE GAUSSION "CONSTANTS" FOR THE 3S
	C       ORBITAL, EVERYTHING THAT IS INDEPENDANT OF R IS IN THERE.
	*/
      rnorm = zn*zsqrt*0.712705470e+0;
      vnorm[0] = rnorm*evectors[m][mo]*cnstns[0][2];
      vnorm[1] = rnorm*evectors[m][mo]*cnstns[1][2];
      vnorm[2] = rnorm*evectors[m][mo]*cnstns[2][2];
      /*
	C       CALC ZETA(2P) SQUARED AND SQRT FOR CONSTANTS.
	*/
      zn = zp[iatoms];
      zsqrt = sqrt(zn);
      zsq[1] = zn*zn;
      /*
	C       ZN*ZN * SQRT(ZN) * ((128.0E+0/PI**3)**0.250E+0)
	C
	C       VNORM(1-3) CORRESPONDS TO THE 3 GAUSSIANS FOR THE 3S ORBITAL
	C       VNORM(4-6) "                            " FOR THE 3PX ""
	C       VNORM(7-9) "" FOR THE 3PY ""
	C       VNORM(10-12) "" FOR THE 3PZ ""
	C       YOU NEED DIFFERENT "CONSTANTS" FOR EACH DUE TO THE DIFFERENT
	C       VALUE OF THE WAVEFUNCTION FOR EACH ORBITAL. AT THE END WE WILL
	C       HAVE A 3 SETS OF NUMBERS ALL MULTIPLIED BY THE EXPONENTIAL,
	C       WE CAN ADD THEM FIRST, THEN CALC. AND MULT. BY THE EXP.
	*/
      rnorm = zsq[2]*zsqrt*1.425410940e+0;
      aop1 = rnorm*cnstnp[0][2];
      aop2 = rnorm*cnstnp[1][2];
      aop3 = rnorm*cnstnp[2][2];
      vnorm[3] = aop1*evectors[m+1][mo];
      vnorm[4] = aop2*evectors[m+1][mo];
      vnorm[5] = aop3*evectors[m+1][mo];
      vnorm[6] = aop1*evectors[m+2][mo];
      vnorm[7] = aop2*evectors[m+2][mo];
      vnorm[8] = aop3*evectors[m+2][mo];
      vnorm[9] = aop1*evectors[m+3][mo];
      vnorm[10] = aop2*evectors[m+3][mo];
      vnorm[11] = aop3*evectors[m+3][mo];
      for(ixyz=0;ixyz<numgridptsx;ixyz++){
	cnstx[ixyz][0] = vnorm[3]*xdel[ixyz];
	cnstx[ixyz][1] = vnorm[4]*xdel[ixyz];
	cnstx[ixyz][2] = vnorm[5]*xdel[ixyz];
      }
      for(ixyz=0;ixyz<numgridptsy;ixyz++){
	cnsty[ixyz][0] = vnorm[6]*ydel[ixyz];
	cnsty[ixyz][1] = vnorm[7]*ydel[ixyz];
	cnsty[ixyz][2] = vnorm[8]*ydel[ixyz];
      }
      for(ixyz=0;ixyz<numgridptsz;ixyz++){
	cnstz[ixyz][0] = vnorm[9]*zdel[ixyz];
	cnstz[ixyz][1] = vnorm[10]*zdel[ixyz];
	cnstz[ixyz][2] = vnorm[11]*zdel[ixyz];
      }
      /*
	C       EVALUATE 3S AND 3P
	C
	C       MINUS ALPHA FOR 3S:
	*/
      aneg[0] = -a[2][0]*zsq[0];
      aneg[1] = -a[2][1]*zsq[0];
      aneg[2] = -a[2][2]*zsq[0];
      /*
	C       MINUS ALPHA FOR 3P:
	*/
      aneg[3] = -a[2][0]*zsq[1];
      aneg[4] = -a[2][1]*zsq[1];
      aneg[5] = -a[2][2]*zsq[1];
      /*
	C       PRECOMPUTE EXP(-A*Z**2*DELO**2) WHERE DELO**2 IS
	C       DELTA-X**2, DELTA-Y**2, AND DELTA-Z**2
	*/
      for(ixyz=0;ixyz<numgridptsx;ixyz++){
	exps[ixyz][0] = gexp(xdelsq[ixyz]*aneg[0])*vnorm[0];
	exps[ixyz][1] = gexp(xdelsq[ixyz]*aneg[1])*vnorm[1];
	exps[ixyz][2] = gexp(xdelsq[ixyz]*aneg[2])*vnorm[2];
	expp[ixyz][0] = gexp(xdelsq[ixyz]*aneg[3]);
	expp[ixyz][1] = gexp(xdelsq[ixyz]*aneg[4]);
	expp[ixyz][2] = gexp(xdelsq[ixyz]*aneg[5]);
      }
      for(ixyz=0;ixyz<numgridptsy;ixyz++){
	exps[ixyz][3] = gexp(ydelsq[ixyz]*aneg[0]);
	exps[ixyz][4] = gexp(ydelsq[ixyz]*aneg[1]);
	exps[ixyz][5] = gexp(ydelsq[ixyz]*aneg[2]);
	expp[ixyz][3] = gexp(ydelsq[ixyz]*aneg[3]);
	expp[ixyz][4] = gexp(ydelsq[ixyz]*aneg[4]);
	expp[ixyz][5] = gexp(ydelsq[ixyz]*aneg[5]);
      }
      for(ixyz=0;ixyz<numgridptsz;ixyz++){
	exps[ixyz][6] = gexp(zdelsq[ixyz]*aneg[0]);
	exps[ixyz][7] = gexp(zdelsq[ixyz]*aneg[1]);
	exps[ixyz][8] = gexp(zdelsq[ixyz]*aneg[2]);
	expp[ixyz][6] = gexp(zdelsq[ixyz]*aneg[3]);
	expp[ixyz][7] = gexp(zdelsq[ixyz]*aneg[4]);
	expp[ixyz][8] = gexp(zdelsq[ixyz]*aneg[5]);
      }
      /*
	C       LOOP OVER THE "CUBE" Z,Y, AND X
	*/
      for (iz=0;iz<numgridptsz;iz++){
	for (iy=0;iy<numgridptsy;iy++){
	  for (ig=0;ig<2;ig++){
	    for (ix=0;ix<numgridptsx;ix++){
	      /*
		C       SUM THE ORBITAL CONTRIBUTIONS INTO THE ORBITAL VALUE ARRAY
		C
		C       FIRST THE 3 GAUSSIANS FOR THE 3S:
		*/
	      density[ix][iy][iz] = density[ix][iy][iz]
		+exps[iy][ig+3]*exps[iz][ig+6]*exps[ix][ig];
	      /*
		C       NEXT, THE 3 FOR THE 3P:
		*/
	      density[ix][iy][iz] = density[ix][iy][iz]
		+(cnsty[iy][ig]+cnstz[iz][ig]+cnstx[ix][ig])
		  *expp[ix][ig]*expp[iy][ig+3]*expp[iz][ig+6];
	    }
	  }
	}
      }
      m = m+4;
    } /* end of major if */
    
  }       /* END OF LOOP OVER ATOMS  */
  
  
  
  return;
} /* END OF FUNCTION compute_wavefnct */




