typedef struct
{
    int magic_number;
    int header_length;
    int vitec_hardware_version;
    int vitec_software_version;
    char create_date[8];
    char update_date[8];
    char user_name[16];
    char filler[16];
} gen_hdr;

typedef struct
{
    int subfile_header_length;
    int subfile_length;
    char subfile_name[16];
    int subfile_type;
    int img_x_model,img_y_model;
    int img_x_device,img_y_device;
    int tile_x,tile_y;
    int color_space;
    int plane_count;
    int data_precision;
    int compression_algorithm;
    char filler[60];
} image_hdr;

#define MAGIC_NUMBER 0x5b0720
#define IMAGE_TYPE 7

static gen_hdr *get_gen_hdr()
{
    gen_hdr *t;
    char zero=0;

    t = (gen_hdr *)malloc(sizeof(gen_hdr));
    if (t==NULL)
    {
	fprintf(stderr," malloc error in get_gen_hdr. \n");
	return(NULL);
    }
    memset((char *)t,zero,sizeof(gen_hdr));
    t->magic_number = MAGIC_NUMBER;
    t->header_length = sizeof(gen_hdr) - sizeof(int);
    return(t);
}

static write_gen_hdr(f,h)
FILE *f;
gen_hdr *h;
{
    int items_written;
    items_written = fwrite((char *)h,sizeof(gen_hdr),1,f);
    if (items_written != 1)
	fprintf(stderr," error writing gen_hdr. \n");
    fflush(f);
}

static gen_hdr *read_gen_hdr(f)
FILE *f;
{
    gen_hdr *g;
    g = (gen_hdr *)malloc(sizeof(gen_hdr));
    fread((char *)g,sizeof(gen_hdr),1,f);
    return(g);
}

static image_hdr *read_image_hdr(f)
FILE *f;
{
    image_hdr *t;
    t = (image_hdr *)malloc(sizeof(image_hdr));
    fread((char *)t,sizeof(image_hdr),1,f);
    return(t);
}

static image_hdr *get_image_hdr(w,h)
int w,h;
{
    image_hdr *t;
    int modified_w;
    char zero=0;

    if (w & 0x7)  /* width not an even multiple of eight */
	modified_w = (w & (~0x7)) + 0x8;
    else
	modified_w = w;
    
    t = (image_hdr *)malloc(sizeof(image_hdr));
    memset((char *)t,zero,sizeof(image_hdr));
    t->subfile_header_length = sizeof(image_hdr);
    t->subfile_type = IMAGE_TYPE;
    t->img_x_model = t->img_y_model = 0;
    t->img_x_device = modified_w;
    t->img_y_device = h;
    t->tile_x = t->tile_y = 0;
    t->compression_algorithm = 0;
    t->plane_count = 3;  /* default to rgb: 1 plane for each of r,g,b  */
    t->data_precision = 0; /* unimplemented */
    t->color_space = 0; /* default to rgb */
    t->subfile_length = modified_w*h*(t->plane_count) +
	sizeof(image_hdr);
    return(t);
}

static write_image_hdr(f,h)
FILE *f;
image_hdr *h;
{
    int items_written;
    items_written = fwrite((char *)h,sizeof(image_hdr),1,f);
    if (items_written != 1)
	fprintf(stderr," error writing gen_hdr. \n");
    fflush(f);
}
