/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

AUTHOR :  Wes Bethel Lawrence Berkely Laboratory
******************************************************************************/
#ifdef SCCS
static char sccsid[]="@(#)postscript.c	1.16 Stellar 89/12/18";
#endif
/*
			Copyright 1989 by
			Stellar Computer Inc.
			All Rights Reserved
	
	This software comprises unpublished confidential information of
	Stellar Computer Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.
	
 A routine to output a postscript file given an X image

MODIFIED BY: Jeff Jortner
             Sandia National Laboratories
	     Div. 1424
	     Albequerque, NM 87185
	     505-846-2613
	     jnjortn@cs.sandia.gov

* Fixed to work on 1500 and 3000 systems (AVS development group)


Rewritten:
      Wes Bethel, Lawrence Berkeley Lab   9 Sep 1991
      
      Cleaned up X interface: previous incarnations of this module
      used a test of the "IsViewable" field in one of the structures
      to test whether or not the window was really on the screen.
      this definition is not restrictive enought -- we really want to
      know if the window is viewable AND whether or not it is
      obscured by other windows.  this latter test has not yet been
      implemented.

      added support for 8bit X servers.  Note; there is not suitable
      definition for 8bit color postscript files.  All images created
      with the "colorimage" operator assume either RGB or CMYK tuples.
      A neat extension for this module would be to write a postscript
      code snippet which would create R,G,B arrays containing the
      colormap associated with the pixmap being dumped, then do an
      in-line expansion from scalar to rgb vector via table lookup.
      
*/


#include <stdio.h>

#include <avs/vex.h>
#include <avs/flow.h>
#include <avs/field.h>
#include "X11/Xlib.h"
#include <avs/avs_pixdata.h>
#include "no_sprintf.h"

AVSinit_modules()
{
    int output_postscript();
    AVSmodule_from_desc(output_postscript);
}

int
output_postscript()
{
    int postscript_compute(),postscript_finish();
    int param;
    
    AVSset_module_name("dump ps", MODULE_RENDER);
    AVScreate_input_port("Input Field", "pixmap", REQUIRED);
    param = AVSadd_parameter("filename", "string", "", 0, 0);
    AVSadd_parameter_prop(param, "width", "integer", 4);
    AVSadd_parameter("mode","choice","Laserwriter",
		     "Laserwriter Colorscript"," ");
    AVSset_compute_proc(postscript_compute);
    AVSset_destroy_proc(postscript_finish);
}

static char last_fname[128]={"Zippy-the-pinhead"};
static Display *display = NULL;

int
postscript_finish()
{
    XCloseDisplay(display);
    display = NULL;
}

postscript_compute(input,fname,mode)
AVSpixdata *input;
char *fname;
char *mode;
{
    XWindowAttributes wa;
    XImage *the_image;
    int status;
    unsigned long plane_mask;
    FILE *f;

    if (fname == NULL || *fname == '\0')
	return(0);

    if (strcmp(fname,last_fname) == 0)
	return(0);  /* don't overwrite last file. */
    else
	strcpy(last_fname,fname);

    /* open the display....*/
    if (display == NULL)
    {
	if ((display = (Display *)XOpenDisplay((char *)NULL)) == NULL)
	{
	    AVSwarning("Unable to open display.");
	    return(0);
	}
    }

    if (status = XGetWindowAttributes(display,input->window,&wa) == 0)
    {
	AVSwarning("Unable to get window attributes.");
	return(0);
    }

    if (wa.depth == 8)
	plane_mask = 0x0ff;
    else if (wa.depth == 24)
	plane_mask = 0x0ffffff;

    the_image = NULL;
    if ((the_image = (XImage *)XGetImage(display,input->window,0,0,wa.width,
					 wa.height,plane_mask,ZPixmap)) == NULL)
    {
	AVSwarning("Unable to get the image from the window.");
	return(0);
    }

    /* need to do something about checking for other windows which
       occlude this one.  there's something about checking for a
       "BadMatch" error.... this check should occur here, and the
       module should return(0) if any other window occludes the
       one we're interested in...  */

    /* do file manipulation...*/

    f = fopen(fname,"w");
    if (f == NULL)
    {
	AVSwarning("Unable to open output file..");
	return(0);
    }

    status = 1;
    if (wa.depth == 8)
    {
	Dump8bitPixmap(display,&wa,
		       !strcmp(mode,"Laserwriter"),1,1,the_image,f);
    }
    else
	DumpPixmap(!strcmp(mode,"Laserwriter"),1,1,the_image,f);


    fclose(f);
    XFree(the_image);
    
    return(status);
}


static char *program = "postscript";

static void ImageToPs83();


static 
DumpPixmap(laserwriter,autoscale, center, the_image,fp)
int laserwriter;
int autoscale, center;
XImage *the_image;
FILE *fp;
{
    char tmp_str[512];

    if (laserwriter)
	ConvertLaserWriter(fp,the_image,autoscale,center);
    else
	ConvertColorScript(fp,the_image,autoscale,center);

    fclose(fp);
}


short ByteToAscii[] = {
    030060, 030061, 030062, 030063, 030064, 030065, 030066, 030067,
    030070, 030071, 030141, 030142, 030143, 030144, 030145, 030146,
    030460, 030461, 030462, 030463, 030464, 030465, 030466, 030467,
    030470, 030471, 030541, 030542, 030543, 030544, 030545, 030546,
    031060, 031061, 031062, 031063, 031064, 031065, 031066, 031067,
    031070, 031071, 031141, 031142, 031143, 031144, 031145, 031146,
    031460, 031461, 031462, 031463, 031464, 031465, 031466, 031467,
    031470, 031471, 031541, 031542, 031543, 031544, 031545, 031546,
    032060, 032061, 032062, 032063, 032064, 032065, 032066, 032067,
    032070, 032071, 032141, 032142, 032143, 032144, 032145, 032146,
    032460, 032461, 032462, 032463, 032464, 032465, 032466, 032467,
    032470, 032471, 032541, 032542, 032543, 032544, 032545, 032546,
    033060, 033061, 033062, 033063, 033064, 033065, 033066, 033067,
    033070, 033071, 033141, 033142, 033143, 033144, 033145, 033146,
    033460, 033461, 033462, 033463, 033464, 033465, 033466, 033467,
    033470, 033471, 033541, 033542, 033543, 033544, 033545, 033546,
    034060, 034061, 034062, 034063, 034064, 034065, 034066, 034067,
    034070, 034071, 034141, 034142, 034143, 034144, 034145, 034146,
    034460, 034461, 034462, 034463, 034464, 034465, 034466, 034467,
    034470, 034471, 034541, 034542, 034543, 034544, 034545, 034546,
    060460, 060461, 060462, 060463, 060464, 060465, 060466, 060467,
    060470, 060471, 060541, 060542, 060543, 060544, 060545, 060546,
    061060, 061061, 061062, 061063, 061064, 061065, 061066, 061067,
    061070, 061071, 061141, 061142, 061143, 061144, 061145, 061146,
    061460, 061461, 061462, 061463, 061464, 061465, 061466, 061467,
    061470, 061471, 061541, 061542, 061543, 061544, 061545, 061546,
    062060, 062061, 062062, 062063, 062064, 062065, 062066, 062067,
    062070, 062071, 062141, 062142, 062143, 062144, 062145, 062146,
    062460, 062461, 062462, 062463, 062464, 062465, 062466, 062467,
    062470, 062471, 062541, 062542, 062543, 062544, 062545, 062546,
    063060, 063061, 063062, 063063, 063064, 063065, 063066, 063067,
    063070, 063071, 063141, 063142, 063143, 063144, 063145, 063146,
    /* extra entries are to guard against overflow */
    063146, 063146, 063146, 063146, 063146, 063146, 063146, 063146,
    063146, 063146, 063146, 063146, 063146, 063146, 063146, 063146,
    063146, 063146, 063146, 063146, 063146, 063146, 063146, 063146,
    063146, 063146, 063146, 063146, 063146, 063146, 063146, 063146,
    063146, 063146, 063146, 063146, 063146, 063146, 063146, 063146,
    063146, 063146, 063146, 063146, 063146, 063146, 063146, 063146,
    063146, 063146, 063146, 063146, 063146, 063146, 063146, 063146,
    063146, 063146, 063146, 063146, 063146, 063146, 063146, 063146,
};

/*
 * Regular Postscript image generation routines and associated macros.
 */

#define AddColorToBuffer(pixel, buffer, index, lineLength, wrapVal, blen) {\
    buffer[index++] = pixel; \
    if (index == lineLength) { \
	buffer[lineLength] = wrapVal; \
	buffer += lineLength+1; \
	blen += lineLength+1; \
	index = 0; \
    } \
}
#define AddLineTerminator(buffer, index, wrapVal, blen) \
    if (index != 0) { \
	buffer[index++] = wrapVal; \
	buffer += index; \
	blen += index; \
	index = 0; \
    }

#define NBITS 8
#define LINELENGTH 39
#define BTYPE short
#define CONVARRAY ByteToAscii
#define LINEWRAP ((' '<<8) + '\n')
#define COLOR(pixel, shift) \
    ((pixel & (0xff<<shift)) >> (shift+8-NBITS))

static void
ImageToPs83(image, fd)
XImage *image;
int fd;
{

    int i, width, j, height;
    int line_offset;
    int *data;
    BTYPE *buffer, *bdata;
    int k, blen;

    width = image->width;
    height = image->height;

    if ((bdata = (BTYPE *) malloc(sizeof(BTYPE)*(3*width +
	    3*width/LINELENGTH + 1))) == NULL)
	{
	AVSerror("malloc failure\n");
	return;
	}

    line_offset = image->bytes_per_line/sizeof(int);

/*    data = (int *) image->data + (line_offset*(height-1)); */
    data = (int *) image->data;

    for (k = 0, j = 0; j < height; j++, data += line_offset)
    {
	for (buffer = bdata, blen = i = 0; i < width; i++)
	{
	    AddColorToBuffer(CONVARRAY[COLOR(data[i], 16)],
		buffer, k, LINELENGTH, LINEWRAP, blen);
	    AddColorToBuffer(CONVARRAY[COLOR(data[i],  8)],
		buffer, k, LINELENGTH, LINEWRAP, blen);
	    AddColorToBuffer(CONVARRAY[COLOR(data[i],  0)],
		buffer, k, LINELENGTH, LINEWRAP, blen);
	}
	
	AddLineTerminator(buffer, k, LINEWRAP, blen);

	write(fd, bdata, blen<<(NBITS/8));
    }
    free(bdata);
}

#include <pwd.h>
#define COMMENTVERSION "PS-Adobe-1.0"


#define PAGE_WIDTH 8.5
#define PAGE_HEIGHT 11.0
#define PTS_PER_INCH 72

#define DPI_LASERWRITER 200.0
#define PIXELS_WIDE (8.0*DPI_LASERWRITER)
#define PIXELS_HIGH (10.5*DPI_LASERWRITER)

#define DPI_COLORSCRIPT 300.0
#define C_PIXELS_WIDE (8.0*DPI_COLORSCRIPT)
#define C_PIXELS_HIGH (10.5*DPI_COLORSCRIPT)

ConvertLaserWriter(fp,image,autoscale,center)
FILE *fp;
XImage *image;
int 	autoscale, center;
{
    int	width, height, i, j, k;
    unsigned int	*inbuf;
    unsigned char	*outbuf;
    float	red, green, blue, tmp;
    char    hostname[256];
    struct passwd  *pswd;
    long    clock;
    float img_ptsize_x,img_ptsize_y,img_ptsize;
    float moveto_x,moveto_y;

    width = image->width; height = image->height;
    inbuf = (unsigned int *)image->data;

    /* Split into components and re-assemble */

    outbuf = (unsigned char *)malloc(width*height*sizeof(unsigned char));
    for(i = k=0;k<height;k++) {
       for (j = 0; j < width; j++, i++) {
	   red   = ( *(inbuf+j) >> 16 ) & 0xff;
	   green = ( *(inbuf+j) >> 8  ) & 0xff;
	   blue  = ( *(inbuf+j)       ) & 0xff;

	   tmp = 0.3*red + 0.6*green + 0.1*blue;
	   if(tmp < 0.0)
	     tmp = 0.0;
	   else if(tmp > 255.0)
	     tmp = 255.0;

	   *(outbuf+i) = tmp;
       }
       inbuf += image->bytes_per_line/sizeof(int);
    }

       /* Print header */

    fprintf (fp,"%%!%s\n", COMMENTVERSION);
    pswd = getpwuid (getuid ());
    (void) gethostname (hostname, sizeof hostname);
    fprintf (fp,"%%%%Creator: %s:%s (%s)\n", 
		hostname,pswd->pw_name, pswd->pw_gecos);
    fprintf (fp,"%%%%Title: %s (%s)\n","x_to_ps","stdin");
    fprintf (fp,"%%%%CreationDate: %s",(time (&clock), ctime (&clock)));
    fprintf (fp,"%%%%EndComments\n");

/*    dump_prolog(fp);*/

    img_ptsize_x = 7.5 * 72.0 / (float) width;
    img_ptsize_y = 10.0 * 72.0 / (float) height;
    img_ptsize = img_ptsize_x;
    if (img_ptsize > img_ptsize_y)
	img_ptsize = img_ptsize_y;
    
    moveto_x = 0.5 * ( (8.5 * 72.0) - (width*img_ptsize));
    moveto_y = 0.5 * ( (11.0 * 72.0) - (height*img_ptsize));

    img_ptsize_x = img_ptsize * width;
    img_ptsize_y = img_ptsize * height;
    
    fprintf(fp,"/rgbstr %d string def \n",width*2);
    fprintf(fp,"%g %g translate\n",moveto_x,moveto_y);
    fprintf(fp,"%g %g scale\n",img_ptsize_x,img_ptsize_y);
    fprintf(fp,"%d %d 8 \n",width,height);
    fprintf(fp,"[%d 0 0 -%d 0 %d]\n",width,height,height);
    fprintf(fp,"{currentfile rgbstr readhexstring pop}\n");
    fprintf(fp,"image \n");
    fflush(fp);

    for(i=0;i<height;i++)
    {
	for(j=0;j<width;j++)
	   fprintf(fp,"%02x",*(outbuf+i*width+j));
	fprintf(fp,"\n");
    }
    ps_finish(fp);
    
}

char *ps_prolog[] =
    {
    "%%Pages: 1",
    "%%EndProlog",
    "%%Page: 1 1",
    "",
    "/bitdump % stk: width, height, iscale",
    "% dump a bit image with lower left corner at current origin,",
    "% scaling by iscale (iscale=1 means 1/300 inch per pixel)",
    "{",
    "	% read arguments",
    "	/iscale exch def",
    "	/height exch def",
    "	/width exch def",
    "",
    "	% scale appropriately",
    "	width iscale mul height iscale mul scale",
    "",
    "	% allocate space for one scanline of input",
    "	/picstr % picstr holds one scan line",
    "		width  % width of image in bytes ",
    "		string",
    "		def",
    "",
    "	% read and dump the image",
    "	width height 8 [width 0 0 height neg 0 height]",
    "	{ currentfile picstr readhexstring pop }",
    "	image",
    "} def",
    0
    };

dump_prolog(fp)
FILE *fp;
{ 
	char **p =  ps_prolog;

	while (*p)    fprintf(fp,"%s\n",*p++);
}

char *ps_epilog[] =
	{
	"",
	"showpage",
	"%%Trailer",
	0
	};

ps_finish(fp)
FILE *fp;
{
	char **p = ps_epilog;

	while (*p)    fprintf(fp,"%s\n",*p++);
}

ConvertColorScript(fp,image,autoscale,center)
FILE *fp;
XImage *image;
int 	autoscale, center;
{
    int fd;
    char    hostname[256];
    struct passwd  *pswd;
    long    clock;
    char buffer[128];
    int width,height;

    float moveto_x,moveto_y;
    float img_ptsize_x,img_ptsize_y,img_ptsize;
    
    fd = fileno(fp);
    
    width = image->width;
    height = image->height;

    fprintf (fp,"%%!%s\n", COMMENTVERSION);
    pswd = getpwuid (getuid ());
    (void) gethostname (hostname, sizeof hostname);
    fprintf (fp,"%%%%Creator: %s:%s (%s)\n", 
		hostname,pswd->pw_name, pswd->pw_gecos);
    fprintf (fp,"%%%%Title: %s (%s)\n","x_to_ps","stdin");
    fprintf (fp,"%%%%CreationDate: %s",(time (&clock), ctime (&clock)));
    fprintf (fp,"%%%%EndComments\n");
/*    dump_prolog2(fd); */

    /* Set scale */
    /**
      * image scaling, etc. completely overhauled due to some
      * problems in the previous methods, use of KISS principle.
      * autoscaling and center are *always* performed, regardless
      * of parameter settings.
      * 5 sep 91   w.bethel
    **/

    img_ptsize_x = 7.5 * 72.0 / (float) width;
    img_ptsize_y = 10.0 * 72.0 / (float) height;
    img_ptsize = img_ptsize_x;
    if (img_ptsize > img_ptsize_y)
	img_ptsize = img_ptsize_y;
    
    moveto_x = 0.5 * ( (8.5 * 72.0) - (width*img_ptsize));
    moveto_y = 0.5 * ( (11.0 * 72.0) - (height*img_ptsize));

    img_ptsize_x = img_ptsize * width;
    img_ptsize_y = img_ptsize * height;
    
    fprintf(fp,"%g %g translate\n",moveto_x,moveto_y);
    fprintf(fp,"%g %g scale\n",img_ptsize_x,img_ptsize_y);
    fprintf(fp,"/rgbstr %d string def \n",width*3*2);
    fprintf(fp,"%d %d 8 \n",width,height);
    fprintf(fp,"[%d 0 0 -%d 0 %d]\n",width,height,height);
    fprintf(fp,"{currentfile rgbstr readhexstring pop}\n");
    fprintf(fp,"false 3 \n");
    fprintf(fp,"colorimage \n");
    fflush(fp);
    
    ImageToPs83(image,fd);
    ps_finish2(fd);
}


static char *top1[] =
    {
    "%%Pages: 1\n",
    "%%EndProlog\n",
    "%%Page: 1 1\n",
    "\n",
    "/bitdump % stk: width, height, iscale\n",
    "% dump a bit image with lower left corner at current origin,\n",
    "% scaling by iscale (iscale=1 means 1/300 inch per pixel)\n",
    "{\n",
    "	% read arguments\n",
    "	/iscale exch def\n",
    "	/height exch def\n",
    "	/width exch def\n",
    "\n",
    "	% scale appropriately\n",
    "	width iscale mul height iscale mul scale\n",
    "\n",
    "	% allocate space for one scanline of input(3 bytes/per pixel)\n",
    "	/picstr % picstr holds one scan line\n",
    "		width 3 mul % width of image in bytes \n",
    "		string\n",
    "		def\n",
    "\n",
    "	% read and dump the image\n",
    "	width height 8 [width 0 0 height 0 0]\n",
    "	{ currentfile picstr readhexstring pop }\n",
    "	false 3 colorimage\n",
    "} def\n"
    };


dump_prolog2(fd)
int fd;
{

    int i;

	for( i=0;i<sizeof(top1)/sizeof(top1[0]);i++ )
		write(fd,top1[i],strlen(top1[i]));
}


static char *bot[] =
	{
	"",
	"showpage\n",
	"%%Trailer\n"
	};

ps_finish2(fd)
int fd;
{
    int i;
	for( i=0;i<sizeof(bot)/sizeof(bot[0]);i++ )
		write(fd,bot[i],strlen(bot[i]));

}



x_to_byte_colors(xt,bt,n)
XColor *xt;
unsigned char *bt;
int n;
{
    /**
      * this routine will create a table of byte-length rgb values
      * given an input table consisting of a number of XColor
      * entries.  In the X world, color entries are composed of
      * 16-bit wide values.  We will scale appropriately into 8 bits.
    **/
    int roff,goff,boff,i;

    roff = 0;
    goff = n;
    boff = 2*n;
    for (i=0;i<n;i++,roff++,boff++,goff++)
    {
	*(bt+roff) = (xt[i].red) >> 8;
	*(bt+goff) = (xt[i].green) >> 8;
	*(bt+boff) = (xt[i].blue) >> 8;
    }
}
static 
Dump8bitPixmap(dpy,wa,laserwriter,autoscale,center,the_image,fp)
Display *dpy;
int laserwriter; /* if == 0, then it's a color output device */
int autoscale, center;
XImage *the_image;
FILE *fp;
XWindowAttributes *wa;
{
    int i,j;
    XColor table[256];
    unsigned char byte_table[256*3];
    float t;
    char *line_buffer;
    unsigned char *image_ptr,pix_data,rdat,gdat,bdat;
    int width,height;
    float img_ptsize_x,img_ptsize_y,img_ptsize,moveto_x,moveto_y;
    struct passwd *pswd;
    char hostname[256];
    long clock;

    width = wa->width;
    height = wa->height;
    
    fprintf (fp,"%%!%s\n", COMMENTVERSION);
    pswd = getpwuid (getuid ());
    (void) gethostname (hostname, sizeof hostname);
    fprintf (fp,"%%%%Creator: %s:%s (%s)\n", 
		hostname,pswd->pw_name, pswd->pw_gecos);
    fprintf (fp,"%%%%Title: %s (%s)\n","avs_to_ps","stdin");
    fprintf (fp,"%%%%CreationDate: %s",(time (&clock), ctime (&clock)));
    fprintf (fp,"%%%%EndComments\n");

    img_ptsize_x = 7.5 * 72.0 / (float) width;
    img_ptsize_y = 10.0 * 72.0 / (float) height;
    img_ptsize = img_ptsize_x;
    if (img_ptsize > img_ptsize_y)
	img_ptsize = img_ptsize_y;
    
    moveto_x = 0.5 * ( (8.5 * 72.0) - (width*img_ptsize));
    moveto_y = 0.5 * ( (11.0 * 72.0) - (height*img_ptsize));

    img_ptsize_x = img_ptsize * width;
    img_ptsize_y = img_ptsize * height;

    /* obtain the colormap */
    for (i=0;i<256;i++)
	table[i].pixel = i;
    XQueryColors(dpy,wa->colormap,table,256);

    /* convert to byte */
    x_to_byte_colors(table,byte_table,256);

    if (laserwriter)  /* convert from rgb space to gray */
    {
	for (i=0;i<256;i++)
	{
	    t = (float)byte_table[i] * 0.3 +
		(float)byte_table[i+256] * 0.6 +
		(float)byte_table[i+512] *0.1;

	    if (t < 0.0)
		t = 0.0;
	    else if (t > 255.0)
		t = 255.0;
	    byte_table[i] = (unsigned char)t;
	}
	line_buffer = (char *)malloc(sizeof(char)*width*2);

	fprintf(fp,"/rgbstr %d string def \n",width*2);
	fprintf(fp,"%g %g translate\n",moveto_x,moveto_y);
	fprintf(fp,"%g %g scale\n",img_ptsize_x,img_ptsize_y);
	fprintf(fp,"%d %d 8 \n",width,height);
	fprintf(fp,"[%d 0 0 -%d 0 %d]\n",width,height,height);
	fprintf(fp,"{currentfile rgbstr readhexstring pop}\n");
	fprintf(fp,"image \n");
	fflush(fp);

	image_ptr = (unsigned char *)the_image->data;
	for (i=0;i<height;i++,image_ptr += the_image->bytes_per_line)
	{
	    for (j=0;j<width;j++)
	    {
		pix_data = byte_table[*(image_ptr+j)];
		strcpy(line_buffer+(j<<1),no_sprintf[pix_data]);
	    }
	    
	    fwrite((char *)line_buffer,sizeof(char),width*2,fp);
	    fprintf(fp,"\n");
	}
    }
    else /* color file */
    {
	line_buffer = (char *)malloc(sizeof(char)*width*2*3);

	fprintf(fp,"/rgbstr %d string def \n",width*2*3);
	fprintf(fp,"%g %g translate\n",moveto_x,moveto_y);
	fprintf(fp,"%g %g scale\n",img_ptsize_x,img_ptsize_y);
	fprintf(fp,"%d %d 8 \n",width,height);
	fprintf(fp,"[%d 0 0 -%d 0 %d]\n",width,height,height);
	fprintf(fp,"{currentfile rgbstr readhexstring pop}\n");
	fprintf(fp,"false 3 \n");
	fprintf(fp,"colorimage \n");
	fflush(fp);

	image_ptr = (unsigned char *)the_image->data;
	for(i=0;i<height;i++,image_ptr += the_image->bytes_per_line)
	{
	    for (j=0;j<width;j++)
	    {
		pix_data = *(image_ptr+j);
		rdat = byte_table[pix_data];
		gdat = byte_table[pix_data+256];
		bdat = byte_table[pix_data+512];
		
		strcpy(line_buffer+j*6,no_sprintf[rdat]);
		strcpy(line_buffer+j*6+2,no_sprintf[gdat]);
		strcpy(line_buffer+j*6+4,no_sprintf[bdat]);
	    }
	    fwrite((char *)line_buffer,sizeof(char),width*2*3,fp);
	    fprintf(fp,"\n");
	}
    }

    ps_finish(fp);
    fflush(fp);
    fclose(fp);
    free((char *)line_buffer);
}
