/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

Author:  "insert name" (if users state on release form that they wish to
remain anonymous, a control number will be placed at this location)
Modifications:  Who modified, date modified ( so donor does not receive blame
if modifications made and passed on to others do not work as described)
******************************************************************************/
/*
################################################################################

                               DISCLAIMER
                             
This source was prepared as an account of work sponsored by an agency of the
United States Government. Neither the United States Government nor the 
University of California nor any of their employees, makes any warrenty,
expressed or implied, or assumes any liability or responsibility for the
accuracy, completeness, or usefulness of any information, apparatus, product,
or process disclosed, or represents that its specific commercial products,
process, or service by trade name, trademark, manufacturer, or otherwise, does
not necessarily constitute or imply its endorsement, recommendation, or favoring
by the United States Government or the University of California, and shall not
be used for advertising or product endorsement purposes.


################################################################################
*/

/*  
Module name: field info 

  Author:  Kathleen M. Dyer, Lawrence Livermore National Laboratory
  
This file contains the source for the module "field info".
The module produces GEOM text containing information about a field, such as
the minima and maxima of the grids and data.
  
*/

#include <stdio.h>
#include <string.h>
#include "avs.h"
#include "field.h"
#include "geom.h"

#define MAXDIM 64
#define MIN(a,b)  (((a) < (b)) ? (a) : (b))
#define MAX(a,b)  (((a) > (b)) ? (a) : (b))

/**********************************************************************/

AVSinit_modules()
{
  int field_info();

  AVSmodule_from_desc(field_info);
	
}

/**********************************************************************/

field_info()
{
  int field_info_compute();
  int in_port, out_port;
  int iparm1, iparm2, iparm3, iparm4, iparm5, iparm6, iparm7, iparm8, iparm9;

  /* Set the module name and type */
  AVSset_module_name("field info",MODULE_RENDER);
	
  /* Create input and output ports */
  in_port = AVScreate_input_port("Input Field","field scalar", REQUIRED);
  out_port = AVScreate_output_port("geometry","geom");

  /* Add parameter */
  iparm1 = AVSadd_parameter("I Min","boolean",1,0,1);
  iparm2 = AVSadd_parameter("I Max","boolean",1,0,1);
  iparm3 = AVSadd_parameter("J Min","boolean",1,0,1);
  iparm4 = AVSadd_parameter("J Max","boolean",1,0,1);
  iparm5 = AVSadd_parameter("K Min","boolean",1,0,1);
  iparm6 = AVSadd_parameter("K Max","boolean",1,0,1);
  iparm7 = AVSadd_parameter("Data Min","boolean",1,0,1);
  iparm8 = AVSadd_parameter("Data Max","boolean",1,0,1);
  iparm9 = AVSadd_float_parameter("Text Height",0.055,0.0,0.5);

  /* Call this subroutine to do the computation */
  AVSset_compute_proc(field_info_compute);
}

/**********************************************************************/

field_info_compute(input,output,mini,maxi,minj,maxj,mink,maxk,mindata,maxdata,text_height)
  AVSfield *input;
  GEOMedit_list **output;
  int *mini, *maxi, *minj, *maxj, *mink, *maxk, *mindata, *maxdata;
  float *text_height;

{
  char label[256];
  float vert[3], off[3], height;
  float xmin, xmax, ymin, ymax, zmin, zmax;
  int font, absolute, background, dropshadow, align, flag;
  int i, ndims, dims[MAXDIM], nspaces, size;
  GEOMobj *obj;
  
  int    datamin_int,    datamax_int;
  float  datamin_float,  datamax_float;
  double datamin_double, datamax_double;
  char   datamin_byte,   datamax_byte;


  /* Error checking */
  if (input->veclen != 1) {
    AVSerror("field info: must be scalar field.");
    return(0);
  }
  if (input->ndim != input->nspace) {
    if (input->uniform != IRREGULAR) {
      AVSerror("field info: if ndim doesn't equal nspace, field type must be irregular.");
      return(0);
    }
  }
  if (input->ndim > MAXDIM) {
    AVSerror("field info: too many dimensions in field.");
    return(0);
  }

  *output = (GEOMedit_list *)GEOMinit_edit_list(*output);

  /* Set label characteristics */
  font       = 0;
  absolute   = 1;
  background = 0;
  dropshadow = 1;
  align      = GEOM_LABEL_LEFT;
  flag = GEOMcreate_label_flags(font,absolute,background,dropshadow,align,0);
  
  obj = GEOMcreate_label(GEOM_NULL,flag);
	
  /* Set label location and height */
  height  = *text_height;
  vert[0] = -0.95;
  vert[1] = 1.0 - 1.25 * height;
  vert[2] = 1.0;
  off[0]  = 0.0;
  off[1]  = 0.0;
  off[2]  = 0.0;
  
  /* Get field size information */
  ndims   = input->ndim;
  nspaces = input->nspace;
  dims[0] = MAXX(input);
  dims[1] = ndims >=2 ? MAXY(input) : 0;
  dims[2] = ndims >=3 ? MAXZ(input) : 0;
  size = 1;
  for (i = 0; i < ndims; i++) {
    size = size * dims[i];
  }
  
  /* Get field data information */
  switch(input->uniform) {
  case UNIFORM:
    if (mini || maxi) {
      xmin = 0.0;
      xmax = dims[0] - 1.0;
    }
    if (ndims>=2 && (minj || maxj)) {
      ymin = 0.0;
      ymax = dims[1] - 1.0;
    }
    if (ndims>=3 && (mink || maxk)) {
      zmin = 0.0;
      zmax = dims[2] - 1.0;
    }
    break;
    
  case RECTILINEAR:
    if (mini || maxi) {
      xmin = input->points[0];
      xmax = input->points[dims[0]-1];
    }
    if (ndims>=2 && (minj || maxj)) {
      ymin = input->points[dims[0]];
      ymax = input->points[dims[0]+dims[1]-1];
    }
    if (ndims>=3 && (mink || maxk)) {
      zmin = input->points[dims[0]+dims[1]];
      zmax = input->points[dims[0]+dims[1]+dims[2]-1];
    }
    break;
    
  case IRREGULAR:
    if (mini || maxi) {
      xmin = input->points[0];
      xmax = input->points[0];
      for (i = 1; i < size; i++){
        xmin = MIN(xmin,input->points[i]);
        xmax = MAX(xmax,input->points[i]);
      }
    }
    if (nspaces >= 2 && (minj || maxj)) {
      ymin = input->points[size];
      ymax = input->points[size];
      for (i = size + 1; i < (2*size); i++){
        ymin = MIN(ymin,input->points[i]);
        ymax = MAX(ymax,input->points[i]);
      }
    }
    if (nspaces >= 3 && (mink || maxk)) {
      zmin = input->points[2*size];
      zmax = input->points[2*size];
      for (i = 2*size+1; i < (3 * size); i++){
        zmin = MIN(zmin,input->points[i]);
        zmax = MAX(zmax,input->points[i]);
      }
    }
    break;
  }

  if (mindata || mindata) {
    switch (input->type) {
    case AVS_TYPE_BYTE:
      {
        unsigned char *iptr = input->field_data;
        datamin_byte = iptr[0];
        datamax_byte = iptr[0];
        for (i = 1; i < size; i++){
          datamin_byte = MIN(datamin_byte,iptr[i]);
          datamax_byte = MAX(datamax_byte,iptr[i]);
        }
      }
      break;

    case AVS_TYPE_REAL:
      {
        float *iptr = input->field_data_float;
        datamin_float = iptr[0];
        datamax_float = iptr[0];
        for (i = 1; i < size; i++){
          datamin_float = MIN(datamin_float,iptr[i]);
          datamax_float = MAX(datamax_float,iptr[i]);
        }
      }
      break;

    case AVS_TYPE_DOUBLE:
      {
        double *iptr = input->field_data_double;
        datamin_double = iptr[0];
        datamax_double = iptr[0];
        for (i = 1; i < size; i++){
          datamin_double = MIN(datamin_double,iptr[i]);
          datamax_double = MAX(datamax_double,iptr[i]);
        }
      }
      break;

    case AVS_TYPE_INTEGER:
      {
        int *iptr = input->field_data_int;
        datamin_int = iptr[0];
        datamax_int = iptr[0];
        for (i = 1; i < size; i++){
          datamin_int = MIN(datamin_int,iptr[i]);
          datamax_int = MAX(datamax_int,iptr[i]);
        }
      }
      break;
    }
  }

  /* Assemble the label */
  strcpy(label,"FIELD INFORMATION:");
  GEOMadd_label(obj,label,vert,off,height,GEOM_NULL,-1);
  vert[1] = vert[1] - height;
  
  if (mini) {
    sprintf(label,"I Min    = %e",xmin);
    GEOMadd_label(obj,label,vert,off,height,GEOM_NULL,-1);
    vert[1] = vert[1] - height;
  }

  if (maxi) {
    sprintf(label,"I Max    = %e",xmax);
    GEOMadd_label(obj,label,vert,off,height,GEOM_NULL,-1);
    vert[1] = vert[1] - height;
  }

  if (minj && (nspaces >=2)) {
    sprintf(label,"J Min    = %e",ymin);
    GEOMadd_label(obj,label,vert,off,height,GEOM_NULL,-1);
    vert[1] = vert[1] - height;
  }

  if (maxj && (nspaces >=2)) {
    sprintf(label,"J Max    = %e",ymax);
    GEOMadd_label(obj,label,vert,off,height,GEOM_NULL,-1);
    vert[1] = vert[1] - height;
  }

  if (mink && (nspaces >=3)) {
    sprintf(label,"K Min    = %e",zmin);
    GEOMadd_label(obj,label,vert,off,height,GEOM_NULL,-1);
    vert[1] = vert[1] - height;
  }

  if (maxk && (nspaces >=3)) {
    sprintf(label,"K Max    = %e",zmax);
    GEOMadd_label(obj,label,vert,off,height,GEOM_NULL,-1);
    vert[1] = vert[1] - height;
  }

  if (mindata) {
    switch (input->type){
    case AVS_TYPE_BYTE:
      sprintf(label,"Data Min = %d",datamin_byte);
      break;

    case AVS_TYPE_REAL:
      sprintf(label,"Data Min = %e",datamin_float);
      break;

    case AVS_TYPE_DOUBLE:
      sprintf(label,"Data Min = %le",datamin_double);
      break;

    case AVS_TYPE_INTEGER:
      sprintf(label,"Data Min = %d",datamin_int);
      break;
    }
    
    GEOMadd_label(obj,label,vert,off,height,GEOM_NULL,-1);
    vert[1] = vert[1] - height;
  }

  if (maxdata) {
    switch (input->type){
    case AVS_TYPE_BYTE:
      sprintf(label,"Data Max = %d",datamax_byte);
      break;

    case AVS_TYPE_REAL:
      sprintf(label,"Data Max = %e",datamax_float);
      break;

    case AVS_TYPE_DOUBLE:
      sprintf(label,"Data Max = %le",datamax_double);
      break;

    case AVS_TYPE_INTEGER:
      sprintf(label,"Data Max = %d",datamax_int);
      break;
    }
    
    GEOMadd_label(obj,label,vert,off,height,GEOM_NULL,-1);
    vert[1] = vert[1] - height;
  }

  GEOMedit_geometry(*output,"label",obj);
  GEOMdestroy_obj(obj); 
  return(1);
}
