/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

Author:  "insert name" (if users state on release form that they wish to
remain anonymous, a control number will be placed at this location)
Modifications:  Who modified, date modified ( so donor does not receive blame
if modifications made and passed on to others do not work as described)
******************************************************************************/
/*
################################################################################

                               DISCLAIMER
                             
This source was prepared as an account of work sponsored by an agency of the
United States Government. Neither the United States Government nor the 
University of California nor any of their employees, makes any warrenty,
expressed or implied, or assumes any liability or responsibility for the
accuracy, completeness, or usefulness of any information, apparatus, product,
or process disclosed, or represents that its specific commercial products,
process, or service by trade name, trademark, manufacturer, or otherwise, does
not necessarily constitute or imply its endorsement, recommendation, or favoring
by the United States Government or the University of California, and shall not
be used for advertising or product endorsement purposes.


################################################################################
*/

/*  
Module name: object_operations 

  Author:  Kathleen M. Dyer, Lawrence Livermore National Laboratory
  
This file contains the source for the module "object operations".
*/

#include <stdio.h>
#include <string.h>
#include "avs.h"

/**********************************************************************/

AVSinit_modules()
{
  int object_operations();

  AVSmodule_from_desc(object_operations);
	 
}

/**********************************************************************/

object_operations()
{
  int object_operations_compute();
  int parm1, parm2;

  /* Set the module name and type */
  AVSset_module_name("object operations",MODULE_RENDER);
	 
  /* Add parameter */
  parm1 = AVSadd_parameter("Normalize Picture","boolean", 0, 0, 1);
  parm2 = AVSadd_parameter("Reset Picture","boolean", 0, 0, 1);

  /* Call this subroutine to do the computation */
  AVSset_compute_proc(object_operations_compute);
}

/**********************************************************************/

object_operations_compute(do_normalize, do_reset)
int do_normalize, do_reset;
{
  char  destination[7], command_buffer[80], o_buffer[80], e_buffer[80];
  char  *output_buffer, *error_buffer;
  
  output_buffer = o_buffer;
  error_buffer = e_buffer;
  
  strcpy(destination,"kernel");
  
  if (do_normalize) {
    strcpy(command_buffer,"geom_normalize");
    AVScommand(destination,command_buffer,output_buffer,error_buffer);
    AVSmodify_parameter("Normalize Picture",AVS_VALUE,0,NULL,NULL);
  }
   
  if (do_reset) {
    strcpy(command_buffer,"geom_reset");
    AVScommand(destination,command_buffer,output_buffer,error_buffer);
    AVSmodify_parameter("Reset Picture",AVS_VALUE,0,NULL,NULL);
  }
   
  
  return(1);
}
