/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/* NOTE:  THIS MODULE AND SOURCE CODE IS FOR USE 
   WITH THE AVS SOFTWARE ENVIRONMENT ONLY */
/* mod_gen Version 1                                                     */
/* Module Name: "object properties" (Output) (Subroutine)                */
/* Author: John Stephen (Tessella) 0235-555511                           */
/* Date Created: Thu Mar  4 11:58:45 1993                                */
/*                                                                       */
/* This file is automatically generated by the Module Generator (mod_gen)*/
/* Please do not modify or move the contents of this comment block as    */
/* mod_gen needs it in order to read module sources back in.             */
/*                                                                       */
/* output 0 "object properties" geom Polyhedron                          */
/* param 0 "object name file" browser "" "" ":objnam"                    */
/* param 1 "object " radio_buttons "ALL OBJECTS" "ALL OBJECTS" ":"       */
/* param 2 "effect" radio_buttons "immediate" "immediate:delay" ":"      */
/* param 3 "update" oneshot 0 0 1                                        */
/* param 4 "red" dial 0.00000 0.00000 1.00000                            */
/* param 5 "green" dial 0.00000 0.00000 1.00000                          */
/* param 6 "blue" dial 0.00000 0.00000 1.00000                           */
/* param 7 "method" radio_buttons "infill" "infill:dots:invisible" ":"   */
/* param 8 "transparency" dial 0.00000 0.00000 1.00000                   */
/* End of Module Description Comments                                    */

#include <stdio.h>
#include <avs/avs.h>
#include <avs/port.h>
#include <avs/geom.h>
 
/* ----> START OF USER-SUPPLIED CODE SECTION #1 (INCLUDE FILES, GLOBAL VARIABLES)*/

/* structures */
struct prop{
	char name[100];
	float red, green, blue, opacity;
	char method[20];
};

/* global static */
static int first;

/* <---- END OF USER-SUPPLIED CODE SECTION #1                            */
 
/* *****************************************/
/*  Module Description                     */
/* *****************************************/
int object_properties_desc()
{

	int in_port, out_port, param, iresult;
	extern int object_properties_compute();
	extern int object_properties_init();

	AVSset_module_name("object properties", MODULE_RENDER);

	/* Output Port Specifications              */
	out_port = AVScreate_output_port("object properties", "geom");

	/* Parameter Specifications                */
/*--------------------------------------------------------*/
/* use this file to supply a list of objects and defaults */
/* the file will set the length of the prop{} structure   */
/* array and will load values into it.			  */
/*--------------------------------------------------------*/
	param = AVSadd_parameter("object name file", "string", "", "", 
		":objnam");
	AVSconnect_widget(param, "browser");
/*-------------------------------------------*/
/* elements are loaded manualy at the moment */
/*-------------------------------------------*/
/*
	param = AVSadd_parameter("object choice", "choice", "ALL OBJECTS", 
		"ALL OBJECTS", ":");
*/
	param = AVSadd_parameter("object choice", "choice", "ALL",
		"ALL:cap:can:downpipe:runner_1:runner_2:runner_3:runner_4",
		":");
	AVSconnect_widget(param, "radio_buttons");
	param = AVSadd_parameter("effect", "choice", "delay", 
		"immediate:delay", ":");
	AVSconnect_widget(param, "radio_buttons");
	param = AVSadd_parameter("update", "oneshot", 0, 0, 1);
	AVSconnect_widget(param, "oneshot");
	param = AVSadd_float_parameter("red", 1.00000, 0.00000, 1.00000);
	AVSconnect_widget(param, "dial");
	param = AVSadd_float_parameter("green", 1.00000, 0.00000, 1.00000);
	AVSconnect_widget(param, "dial");
	param = AVSadd_float_parameter("blue", 1.00000, 0.00000, 1.00000);
	AVSconnect_widget(param, "dial");
	param = AVSadd_parameter("method", "choice", "solid", 
		"solid:lines:invisible", ":");
	AVSconnect_widget(param, "radio_buttons");
	param = AVSadd_float_parameter("opacity", 1.00000, 0.00000, 1.00000);
	AVSconnect_widget(param, "dial");

	AVSset_compute_proc(object_properties_compute);
	AVSset_init_proc(object_properties_init);
/* ----> START OF USER-SUPPLIED CODE SECTION #2 (ADDITIONAL SPECIFICATION INFO)*/
/* <---- END OF USER-SUPPLIED CODE SECTION #2                            */
	return(1);
}

/***********************/
/* Module Init Routine */
/***********************/
int object_properties_init()
{
	first = 1;
	return(1);
}
 
/* *****************************************/
/* Module Compute Routine                  */
/* *****************************************/
int object_properties_compute( object_pr, object_na, 
object_ch, effect, update, red, green, blue, method, opacity)
	GEOMedit_list *object_pr;
	char *object_na;
	char *object_ch;
	char *effect;
	int update;
	float *red;
	float *green;
	float *blue;
	char *method;
	float *opacity;
{
	struct prop *properties, *p;
	int nprop, i;
	int everything;
	float rgb[3];
	char absName[80];
	if(first) {
		first = 0;
/*--------------------------------------*/
/* manual malloc; usually get from file */
/*--------------------------------------*/
		nprop = 8;
		properties = (struct prop *)malloc(nprop*sizeof(struct prop));
/*----------------------------------------*/
/* manual load of data; usually from file */
/*----------------------------------------*/
		p=properties;
		strcpy(p->name, "ALL");p++;
		strcpy(p->name, "cap");p++;
		strcpy(p->name, "can");p++;
		strcpy(p->name, "downpipe");p++;
		strcpy(p->name, "runner_1");p++;
		strcpy(p->name, "runner_2");p++;
		strcpy(p->name, "runner_3");p++;
		strcpy(p->name, "runner_4");p++;
		for(i=0, p=properties; i<nprop; i++, p++) {
			p->red = 1.; p->green = 1.; p->blue = 1.; p->opacity = 0.; strcpy(p->method,"solid");
		}
	}
	else {
		GEOMdestroy_edit_list(*object_pr);
	}

	*object_pr = GEOMinit_edit_list(GEOM_NULL);


	/* reset parameters */
	if(AVSparameter_changed("object choice") ) {
		for(i=0, p=properties;  i<nprop; i++, p++) {
			if( ! strcmp(p->name, object_ch) ) {
				/* reset the parameters */
				AVSmodify_parameter("red",AVS_VALUE, &(p->red), NULL, NULL);
				AVSmodify_parameter("green",AVS_VALUE, &(p->green), NULL, NULL);
				AVSmodify_parameter("blue",AVS_VALUE, &(p->blue), NULL, NULL);
				AVSmodify_parameter("opacity",AVS_VALUE, &(p->opacity), NULL, NULL);
				AVSmodify_parameter("method",AVS_VALUE,p->method, NULL, NULL);
			}
		}
		return(0);
	}

	/* copy data into parameters; perhaps also onto screen */
	else {
		everything = ! strcmp(object_ch, "ALL");

		/* load data into ALL property locations OR just the chosen one */
		for(i=0, p=properties;  i<nprop; i++, p++) {
			if( everything || ! strcmp(p->name, object_ch) ) {
				/* load the new data */
				p->red = *red;
				p->green = *green;
				p->blue = *blue;
				p->opacity = *opacity;
				strcpy(p->method,method);
			}
		}
		/* change chosen object OR all objects if "ALL OBJECTS" was chosen */
		if(AVSparameter_changed("update") || ! strcmp(effect,"immediate")) {
			p=properties; p++;
			for(i=1;  i<nprop; i++, p++) {
				if( everything || ! strcmp(p->name, object_ch) ) {
					/* if necessary add % to the front of the name */
					if(p->name == '%' ) {
						strcpy(absName, p->name);
					}
					else {
						strcpy(absName, "%");
						strcat(absName, p->name);
					}
					rgb[0] = p->red; rgb[1] = p->green; rgb[2] = p->blue;
					GEOMedit_color(*object_pr, absName,rgb);
					rgb[0] = -1.; rgb[1] = -1.; rgb[2] = -1.;
					GEOMedit_properties(*object_pr, absName,
						-1., -1., -1., -1., p->opacity, rgb);
					if( ! strcmp(p->method, "invisible") ) {
						GEOMedit_visibility(*object_pr, absName, 0);
					}
					else {
						GEOMedit_visibility(*object_pr, absName, 1);
						if( ! strcmp(p->method, "solid") ) {
							GEOMedit_render_mode(*object_pr, 
									absName, "gouraud");
						}
						else if( ! strcmp(p->method, "lines") ) {
							GEOMedit_render_mode(*object_pr, 
									absName, "lines");
						}
					}
				}
			}
		}
	}

	return(1);
}
 
/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
static int ((*mod_list[])()) = {
	object_properties_desc
};
#define NMODS (sizeof(mod_list) / sizeof(char *))

AVSinit_modules()
{
	AVSinit_from_module_list(mod_list, NMODS);
}
 
/* ----> START OF USER-SUPPLIED CODE SECTION #4 (SUBROUTINES, FUNCTIONS, UTILITY ROUTINES)*/
/* <---- END OF USER-SUPPLIED CODE SECTION #4                            */
