/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

AUTHOR : Stardent Computer, Inc.
******************************************************************************/
/*
 * print_xgeo = Print Upstream Geometry Port Data
 *
 * An AVS3 module to print the current contents of an
 * upstream geom port connection
 *
 * Author: I. Curington
 *         Stardent Computer Ltd.
 *         Guildford, Surrey, UK
 *
 * Input Port: upstream geom
 *
 * Revision:  20 February 91  Original (ianc)
 *
 */

#include <stdio.h>
#include <avs/flow.h>
#include <avs/udata.h>

/******************************************************************************/
AVSinit_modules()
{
        int print_xgeo_desc();
        AVSmodule_from_desc(print_xgeo_desc);
}

/******************************************************************************/
print_xgeo_desc()
{
    int param, print_xgeo_compute();

    AVSset_module_name  ("print xgeom", MODULE_RENDER);
/*
    AVSset_module_name  ("print upstream geom", MODULE_RENDER);
*/
    AVScreate_input_port("Input Transform",
                         "struct upstream_geom", REQUIRED);
    param=
    AVSadd_parameter("Transform","string_block",
                     " === Upstream Geometry ===\n","","");
    AVSadd_parameter_prop(param,"height","integer",20);
    AVSadd_parameter_prop(param,"width","integer",4);
    AVSset_compute_proc (print_xgeo_compute);
}

/******************************************************************************/
#define SCAT  strcat ( str, strt );

print_xgeo_compute(input,string)
upstream_geom *input;
char *string;
{
  int i;
  char str[800], strt[80];

  sprintf(str, " === Upstream Geometry ===\n");
  sprintf(strt," current object =\n %s\n",  input->current_obj );         SCAT
  sprintf(strt," object picked  =\n %s\n",  input->picked_obj );          SCAT
  sprintf(strt," window size = %d %d\n",    input->width, input->height); SCAT
  sprintf(strt," mouse (x y) = %d %d\n",    input->x,     input->y);      SCAT
  sprintf(strt," camera index = %d\n",      input->camera_index );        SCAT

  if ((input->flags & BUTTON_UP) != 0 )
  {
      sprintf(strt," button state = BUTTON_UP\n"); SCAT
  }
  if ((input->flags & BUTTON_DOWN) != 0 )
  {
      sprintf(strt," button state = BUTTON_DOWN\n"); SCAT
  }
  if ((input->flags & BUTTON_MOVING) != 0 )
  {
      sprintf(strt," button state = BUTTON_MOVING\n"); SCAT
  }

  sprintf(strt," Object's Coordinate Matrix:\n"); SCAT
  for (i=0; i<4; i++)
  {
    sprintf (strt,"%9.3f %9.3f %9.3f %9.3f\n",
              input->objxform[i][0],
              input->objxform[i][1],
              input->objxform[i][2],
              input->objxform[i][3] ); SCAT
  }
  sprintf(strt," Modelling to World Matrix:\n"); SCAT
  for (i=0; i<4; i++)
  {
    sprintf (strt,"%9.3f %9.3f %9.3f %9.3f\n",
              input->worldxform[i][0],
              input->worldxform[i][1],
              input->worldxform[i][2],
              input->worldxform[i][3] ); SCAT
  }
  sprintf(strt," World to Screen Matrix:\n"); SCAT
  for (i=0; i<4; i++)
  {
    sprintf (strt,"%9.3f %9.3f %9.3f %9.3f\n",
              input->viewxform[i][0],
              input->viewxform[i][1],
              input->viewxform[i][2],
              input->viewxform[i][3] ); SCAT
  }

  AVSmodify_parameter("Transform",AVS_VALUE,str,NULL,NULL);
}

