/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/**********************************************************************
 *
 *	file name: 	w_kswad_img.c
 *
 *	description:	write an image file in the form of KSWAD image.
 *
 *     			Copyright (c) 1991 by 
 *			KUBOTA COMPUTER INC.
 *			All Rights Reserved
 *
 **********************************************************************/

#include <stdio.h>
#include <avs/avs.h>
#include <avs/field.h>
#include <avs/flow.h>
#include <math.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/XWDFile.h>

/* Used for AVSmessage() */
static char file_version[] = "@(#)w_kswad_img.c	KCI 91/08/21";


/**********************************************************************
 *
 *	function name: 	AVSinit_modules
 *
 *	description:	initialize
 *
 **********************************************************************/

AVSinit_modules()
{
    int 	write_kswad();

    AVSmodule_from_desc(write_kswad);
}



/**********************************************************************
 *
 *	function name: 	write_kswad
 *
 *	description:	description function
 *
 **********************************************************************/

static
write_kswad()
{
    int 	write_kswad_compute();
    int 	param;
    
    /* Set the module name */
    AVSset_module_name("write KSWAD image", MODULE_RENDER);

    /* Create the input port */
    AVScreate_input_port("Field Byte Input", "field 2D 4-vector byte",
					REQUIRED);

    /* Add parameter */
    param = AVSadd_parameter("Write KSWAD Image Browser", "string", 0, 0,
				NULL);
    AVSconnect_widget(param, "browser");

    /* Set the compute procedure */
    AVSset_compute_proc(write_kswad_compute);
}



/**********************************************************************
 *
 *	function name: 	write_kswad_compute
 *
 *	description:	computation function
 *
 *	input:		input_data
 *			in_filename
 *
 *	output:		
 *
 *	return:		0/1
 *
 **********************************************************************/

static
write_kswad_compute(input_data, in_filename)
    AVSfield_char *input_data;
    char 	*in_filename;
{
    int 	width, height, header[10];
    FILE 	*fp;
    int 	i, j;
    static int 	dot = '.';
    char 	*suffix;
    unsigned char *pt;
    char 	filename[100];


    if (!in_filename || !input_data){
	return(1);
    }

    /* Make a local copy */
    strcpy(filename, in_filename);

    /* Append a suffix if it doesn't have one already */
    if ((suffix = strrchr(in_filename, dot)) == NULL) {
        strcat(filename, ".img");
    } else if (strcmp(suffix+1, "img")){
        strcat(filename, ".img");
    }

    /*Open*/
    if (( fp = fopen(filename,"w")) == NULL){
	AVSmessage(file_version, AVS_Warning, AVSmodule, 
		"write_kswad_compute", "Ok", "Can't open data file %s", 
		filename);
	return(1);
    }
    width = MAXX(input_data);
    height = MAXY(input_data);

    /* set Header */
    header[0] = 0xc2e696d67;
    header[1] = 1;
    header[2] = width;
    header[3] = height;
    for(i=4; i<10; i++)
	header[i] = 0;
    fwrite(header,4,10,fp);

    /*Save*/
    pt = input_data->data;
    for (i = 0;i < height; i++){
    	for (j = 0; j < width; j++){
    		fwrite(pt+1, sizeof(unsigned char), 3, fp);
    		fwrite(pt, sizeof(unsigned char), 1, fp);
		pt = pt + 4;
 	}
    }
    fclose(fp);
    AVSmodify_parameter("Write KSWAD Image Browser", AVS_VALUE, NULL, 
				NULL, NULL);
    return(1);
}



